/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class GiftCardGeneratorView
extends POSDialog {
    private IntegerTextField txtNumberOfCard;
    private DoubleTextField txtFaceValue;
    private IntegerTextField txtValidity;
    private JComboBox<String> cbDuration;
    private List<GiftCard> giftCardList;
    private FixedLengthTextField tfBatchNumber;
    private boolean isManual;
    private POSTextField txtCardNumber;
    private JLabel lblGiftCardNumber;
    private JLabel lblNumberOfCard;

    public GiftCardGeneratorView() {
        this(false);
    }

    public GiftCardGeneratorView(boolean isManual) {
        super((Frame)POSUtil.getBackOfficeWindow(), "");
        this.isManual = isManual;
        this.init();
    }

    public GiftCardGeneratorView(JFrame parent) {
        this.init();
    }

    private void init() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Gift Card Generation");
        this.add((Component)titlePanel, "North");
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3,aligny center", "[][]", ""));
        this.lblGiftCardNumber = new JLabel(Messages.getString("GiftCardGeneratorView.0"));
        this.txtCardNumber = new POSTextField();
        this.lblNumberOfCard = new JLabel(Messages.getString("GiftCardGeneratorView.4"));
        this.txtNumberOfCard = new IntegerTextField();
        JLabel lblFaceValue = new JLabel(Messages.getString("GiftCardGeneratorView.5"));
        this.txtFaceValue = new DoubleTextField();
        JLabel lblValidity = new JLabel(Messages.getString("GiftCardGeneratorView.6"));
        this.txtValidity = new IntegerTextField(0, 3);
        this.cbDuration = new JComboBox();
        this.cbDuration.addItem("DAY");
        this.cbDuration.addItem("MONTH");
        this.cbDuration.addItem("YEAR");
        this.cbDuration.setSelectedItem("YEAR");
        this.tfBatchNumber = new FixedLengthTextField();
        this.tfBatchNumber.setLength(32);
        this.txtValidity.setText("5");
        this.txtFaceValue.setText("0.00");
        String randomBatchNumber = GiftCardGeneratorView.generateBatchNumber();
        this.tfBatchNumber.setText("" + randomBatchNumber);
        centerPanel.add((Component)this.lblGiftCardNumber, "alignx right");
        centerPanel.add((Component)this.txtCardNumber, "growx,wrap");
        centerPanel.add((Component)this.lblNumberOfCard, "alignx right");
        centerPanel.add((Component)this.txtNumberOfCard, "growx,wrap");
        centerPanel.add((Component)lblFaceValue, "alignx right");
        centerPanel.add((Component)this.txtFaceValue, "growx,wrap");
        centerPanel.add((Component)new JLabel(Messages.getString("BatchNumber")), "alignx right");
        centerPanel.add((Component)this.tfBatchNumber, "growx,wrap");
        centerPanel.add((Component)lblValidity, "alignx right");
        centerPanel.add((Component)this.txtValidity, "growx");
        centerPanel.add(this.cbDuration, ",wrap");
        this.add((Component)centerPanel, "Center");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        PosButton btnGenerate = new PosButton(Messages.getString("Generate"));
        buttonPanel.add((Component)btnGenerate, "grow");
        btnGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardGeneratorView.this.doGenerate();
            }
        });
        buttonPanel.add(new PosButton(new CloseDialogAction(this)));
        this.add((Component)buttonPanel, "South");
        this.updateVisibility();
    }

    private void updateVisibility() {
        this.lblGiftCardNumber.setVisible(this.isManual);
        this.txtCardNumber.setVisible(this.isManual);
        this.lblNumberOfCard.setVisible(!this.isManual);
        this.txtNumberOfCard.setVisible(!this.isManual);
    }

    public static String generateBatchNumber() {
        String randomBatchNumber = String.valueOf((long)(Math.random() * 1.0E8));
        String pinPad = "00000000";
        randomBatchNumber = pinPad.substring(randomBatchNumber.length()) + randomBatchNumber;
        if (GiftCardDAO.getInstance().hasBatchNo(randomBatchNumber)) {
            return GiftCardGeneratorView.generateBatchNumber();
        }
        return randomBatchNumber;
    }

    public void doGenerate() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.save()) {
                GiftCardDAO.getInstance().saveAsList(this.giftCardList);
                POSMessageDialog.showMessage(this, Messages.getString("GiftCardGeneratorView.29"));
                this.dispose();
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private boolean save() throws Exception {
        int numberOfCard = this.txtNumberOfCard.getInteger();
        if (!(this.isManual || this.txtNumberOfCard.getText() != null && numberOfCard != 0)) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.30"));
            return false;
        }
        if (!this.isManual && numberOfCard > 100000) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.303"));
            return false;
        }
        if (this.isManual) {
            String cardNumber = this.txtCardNumber.getText();
            if (cardNumber == null || cardNumber.isEmpty()) {
                POSMessageDialog.showError(this, Messages.getString("EnterCardNumber"));
                return false;
            }
            if (cardNumber.length() > 16) {
                POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.2"));
                return false;
            }
            GiftCard giftCard = GiftCardDAO.getInstance().get(cardNumber);
            if (giftCard != null) {
                POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.3"));
                return false;
            }
        }
        if (StringUtils.isEmpty((String)this.txtFaceValue.getText())) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.31"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtValidity.getText())) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.32"));
            return false;
        }
        int validity = this.txtValidity.getInteger();
        if (validity == 0) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.33"));
            return false;
        }
        String durationType = (String)this.cbDuration.getSelectedItem();
        if (StringUtils.isEmpty((String)durationType)) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.34"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.tfBatchNumber.getText())) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.36"));
            return false;
        }
        this.giftCardList = new ArrayList<GiftCard>();
        if (!this.isManual) {
            this.doGenerateRandomCard();
        } else {
            this.doGenerateManualCard();
        }
        return true;
    }

    private void doGenerateManualCard() throws Exception {
        GiftCard giftCard = new GiftCard();
        giftCard.setCardNumber(this.txtCardNumber.getText());
        giftCard.setBalance(this.txtFaceValue.getDouble());
        giftCard.setIssueDate(new Date());
        giftCard.setDuration(this.txtValidity.getInteger());
        giftCard.setDurationType((String)this.cbDuration.getSelectedItem());
        giftCard.setBatchNo(this.tfBatchNumber.getText());
        giftCard.setExpiryDate(giftCard.prepareExpireDate(null));
        this.giftCardList.add(giftCard);
    }

    private void doGenerateRandomCard() throws Exception {
        int cardNumber = this.txtNumberOfCard.getInteger();
        for (int i = 0; i < cardNumber; ++i) {
            GiftCard giftCard = new GiftCard();
            String randomNumber = String.valueOf((long)(Math.random() * 1.0E16));
            String pad = "0000000000000000";
            randomNumber = pad.substring(randomNumber.length()) + randomNumber;
            giftCard.setCardNumber(randomNumber);
            giftCard.setBalance(this.txtFaceValue.getDouble());
            giftCard.setIssueDate(new Date());
            giftCard.setDuration(this.txtValidity.getInteger());
            giftCard.setDurationType((String)this.cbDuration.getSelectedItem());
            giftCard.setBatchNo(this.tfBatchNumber.getText());
            giftCard.setExpiryDate(giftCard.prepareExpireDate(null));
            this.giftCardList.add(giftCard);
        }
    }
}

