/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.actions.PosAction;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.GiftCardExplorer;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.LargeComboBoxRenderer;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.GiftCardInfo;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.GiftCardActivateView;
import com.floreantpos.ui.views.GiftCardAddBalanceView;
import com.floreantpos.ui.views.GiftCardTransactionInfoView;
import com.floreantpos.ui.views.payment.CardInputListener;
import com.floreantpos.ui.views.payment.CardInputProcessor;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXTable;

public class GiftCardManagementView
extends POSDialog
implements CardInputProcessor {
    private PosButton btnActivate;
    private PosButton btnDeActivate;
    private PosButton btnBalance;
    private PosButton btnDisable;
    private PosButton btnCardInfo;
    private PosButton btnTransaction;
    private GiftCardProcessor giftCardProcessor;
    private BeanTableModel<GiftCard> tableModel;
    private JXTable table;
    private PosButton btnBack;
    private PosButton btnForward;
    private JLabel lblNumberOfItem;
    private JComboBox<GiftCardExplorer.GiftCardStatus> giftCardStatusCombo;
    private JTextField tfSearchCardOrOwnerName;
    private CardInputListener cardInputListener;
    private PaymentType paymentType;
    private boolean isVissibleButton;
    private PosButton btnSubmitGiftcard;
    private GiftCard selectedGiftCard;

    public GiftCardManagementView() {
        super((Frame)POSUtil.getBackOfficeWindow(), "");
        this.init();
        this.pluginChecking();
    }

    public GiftCardManagementView(JFrame parent) {
        this(parent, (boolean)Boolean.TRUE);
    }

    public GiftCardManagementView(JFrame parent, boolean isVissibleButton) {
        this(parent, isVissibleButton, null, null);
    }

    public GiftCardManagementView(JFrame parent, boolean isVissibleButton, CardInputListener cardInputListener, PaymentType paymentType) {
        this.isVissibleButton = isVissibleButton;
        this.cardInputListener = cardInputListener;
        this.paymentType = paymentType;
        this.init();
        this.pluginChecking();
        this.searchItem(0);
        this.updateView();
    }

    private void pluginChecking() {
        GiftCardPaymentPlugin paymentGateway = GiftCardConfig.getPaymentGateway();
        this.giftCardProcessor = paymentGateway.getProcessor();
        if (paymentGateway != null) {
            if (!this.giftCardProcessor.supportActivation()) {
                this.btnActivate.setEnabled(false);
            }
            if (!this.giftCardProcessor.supportDeActivation()) {
                this.btnDeActivate.setEnabled(false);
            }
            if (!this.giftCardProcessor.supportDisable()) {
                this.btnDisable.setEnabled(false);
            }
            if (!this.giftCardProcessor.supportShowTransaction()) {
                this.btnTransaction.setEnabled(false);
            }
        }
    }

    private void updateView() {
        this.btnActivate.setVisible(this.isVissibleButton);
        this.btnDeActivate.setVisible(this.isVissibleButton);
        this.btnBalance.setVisible(this.isVissibleButton);
        this.btnDisable.setVisible(this.isVissibleButton);
        this.btnCardInfo.setVisible(this.isVissibleButton);
        this.btnTransaction.setVisible(this.isVissibleButton);
        this.btnSubmitGiftcard.setVisible(!this.isVissibleButton);
        if (!this.isVissibleButton) {
            this.giftCardStatusCombo.setSelectedItem((Object)GiftCardExplorer.GiftCardStatus.ACTIVE);
            this.giftCardStatusCombo.setEnabled(Boolean.FALSE);
        }
    }

    private void init() {
        JPanel mainContentPanel = new JPanel();
        mainContentPanel.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(mainContentPanel);
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("GiftCardManagementView.0"));
        mainContentPanel.add((Component)titlePanel, "North");
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "[grow]15[grow]", ""));
        centerPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        GiftCardProcessAction action = new GiftCardProcessAction();
        this.btnActivate = new PosButton(Messages.getString("Activate"), action);
        this.btnDeActivate = new PosButton(Messages.getString("GiftCardManagementView.5"), action);
        this.btnBalance = new PosButton(Messages.getString("AddBalance"), action);
        this.btnDisable = new PosButton(Messages.getString("Disable"), action);
        this.btnCardInfo = new PosButton(Messages.getString("CardInfo"), action);
        this.btnTransaction = new PosButton(Messages.getString("Transactions"), action);
        centerPanel.add((Component)this.btnActivate, "grow");
        centerPanel.add((Component)this.btnDeActivate, "grow, wrap");
        centerPanel.add((Component)this.btnBalance, "grow");
        centerPanel.add((Component)this.btnDisable, "grow, wrap");
        centerPanel.add((Component)this.btnCardInfo, "grow");
        centerPanel.add((Component)this.btnTransaction, "grow, wrap");
        centerPanel.add((Component)this.buildTablePannel(), "span 2, grow");
        mainContentPanel.add((Component)centerPanel, "Center");
        PosButton closeButton = new PosButton(new CloseDialogAction(this, Messages.getString("Close")));
        this.btnSubmitGiftcard = new PosButton(Messages.getString("SwipeCardDialog.3"));
        this.btnSubmitGiftcard.addActionListener(e -> this.doSubmitGiftcard());
        JPanel buttonsPanel = new JPanel((LayoutManager)new MigLayout("fill, hidemode 3, center"));
        buttonsPanel.add((Component)this.btnSubmitGiftcard, "growx");
        buttonsPanel.add((Component)closeButton, "growx");
        this.btnActivate.setAction(action);
        this.btnBalance.setAction(action);
        this.btnDeActivate.setAction(action);
        this.btnDisable.setAction(action);
        this.btnCardInfo.setAction(action);
        this.btnTransaction.setAction(action);
        this.add((Component)scrollPane, "Center");
        this.add((Component)buttonsPanel, "South");
    }

    private void doSubmitGiftcard() {
        this.selectedGiftCard = this.getGiftCardFromTable(Boolean.FALSE);
        if (this.selectedGiftCard == null) {
            MessageDialog.showError(Messages.getString("GiftCardManagementView.3"));
            return;
        }
        this.setCanceled(false);
        this.dispose();
        if (this.cardInputListener != null) {
            this.cardInputListener.cardInputted(this, this.paymentType, null);
        }
    }

    private JPanel buildTablePannel() {
        this.tableModel = new BeanTableModel(GiftCard.class);
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.42"), "customCardNumber");
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.44"), "ownerName");
        this.tableModel.addColumn(Messages.getString("GiftCardExplorer.50"), "balance", 11, BeanTableModel.DataType.MONEY);
        this.table = new JXTable(this.tableModel);
        this.tableModel.initTableRenderer((JTable)this.table);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.btnBack = new PosButton(Messages.getString("GiftCardExplorer.51"));
        this.btnForward = new PosButton(Messages.getString("GiftCardExplorer.53"));
        this.lblNumberOfItem = new JLabel();
        this.btnBack.addActionListener(e -> this.searchItem(this.tableModel.getPreviousRowIndex()));
        this.btnForward.addActionListener(e -> this.searchItem(this.tableModel.getNextRowIndex()));
        JPanel tablePanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        PosButton btnClearSelection = new PosButton(Messages.getString("GiftCardManagementView.11"));
        btnClearSelection.addActionListener(e -> this.clearSelection());
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        bottomPanel.add((Component)btnClearSelection, "left");
        bottomPanel.add((Component)this.lblNumberOfItem, "right, split 3");
        bottomPanel.add(this.btnBack);
        bottomPanel.add((Component)this.btnForward, "wrap");
        QwertyKeyPad qwertyKeyPad = new QwertyKeyPad();
        bottomPanel.add((Component)((Object)qwertyKeyPad), "growx, gaptop 10, span 2");
        PosScrollPane scrollPane = new PosScrollPane();
        scrollPane.setFocusable(false);
        scrollPane.setViewportView((Component)this.table);
        tablePanel.add((Component)this.buildSearchForm(), "wrap, growx");
        tablePanel.add((Component)scrollPane, "wrap, h 170!, growx");
        tablePanel.add((Component)bottomPanel, "growx");
        return tablePanel;
    }

    private void clearSelection() {
        this.tableModel.fireTableDataChanged();
    }

    private void searchItem(int i) {
        this.tableModel.setCurrentRowIndex(i);
        String txNumber = this.tfSearchCardOrOwnerName.getText();
        GiftCardExplorer.GiftCardStatus selectedItem = (GiftCardExplorer.GiftCardStatus)((Object)this.giftCardStatusCombo.getSelectedItem());
        GiftCardDAO.getInstance().searchByCardNoOrOwnerName(txNumber, selectedItem.name(), this.tableModel);
        int startNumber = this.tableModel.getCurrentRowIndex() + 1;
        int endNumber = this.tableModel.getNextRowIndex();
        int totalNumber = this.tableModel.getNumRows();
        if (endNumber > totalNumber) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format(Messages.getString("GiftCardExplorer.69"), startNumber, endNumber, totalNumber));
        this.btnBack.setEnabled(this.tableModel.hasPrevious());
        this.btnForward.setEnabled(this.tableModel.hasNext());
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("fillx", "[][]5[]15[]", ""));
        JLabel lblSearch = new JLabel(Messages.getString("GiftCardManagementView.12"));
        this.tfSearchCardOrOwnerName = new JTextField(40);
        this.tfSearchCardOrOwnerName.addActionListener(e -> this.searchItem(0));
        PosButton searchBttn = new PosButton(Messages.getString("Search"));
        searchBttn.addActionListener(e -> this.searchItem(0));
        JLabel lblStatus = new JLabel(Messages.getString("Status"));
        this.giftCardStatusCombo = new JComboBox();
        this.giftCardStatusCombo.setRenderer(new LargeComboBoxRenderer(50));
        this.giftCardStatusCombo.setModel(new DefaultComboBoxModel<GiftCardExplorer.GiftCardStatus>(GiftCardExplorer.GiftCardStatus.values()));
        panel.add((Component)lblSearch, "");
        panel.add((Component)this.tfSearchCardOrOwnerName, "grow");
        panel.add(searchBttn);
        panel.add((Component)lblStatus, "split 2");
        panel.add(this.giftCardStatusCombo, "grow");
        this.giftCardStatusCombo.addActionListener(e -> this.searchItem(0));
        return panel;
    }

    private void doActivateGiftCard() {
        GiftCard selectedGiftCard = this.getGiftCardFromTable(Boolean.FALSE);
        if (selectedGiftCard != null) {
            if (selectedGiftCard.isActive().booleanValue()) {
                POSMessageDialog.showMessage(this, Messages.getString("GiftCardActivateView.25"));
                return;
            }
        } else {
            String cardNo = this.getGiftCardNumber();
            if (StringUtils.isEmpty((String)cardNo)) {
                return;
            }
            selectedGiftCard = this.giftCardProcessor.getCard(cardNo);
            if (selectedGiftCard.isActive().booleanValue() && selectedGiftCard.isExpried()) {
                POSMessageDialog.showError(Messages.getString("GiftCardAddBalanceView.0"));
                return;
            }
        }
        GiftCardActivateView dialog = new GiftCardActivateView(this.giftCardProcessor, selectedGiftCard);
        dialog.setTitle(Messages.getString("Activate"));
        dialog.setDefaultCloseOperation(2);
        dialog.setSize(PosUIManager.getSize(900, 450));
        dialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
        dialog.setVisible(true);
    }

    private void doShowCardInfo() {
        try {
            GiftCard giftCard = this.getGiftCardFromTable();
            if (giftCard == null) {
                return;
            }
            GiftCardInfo dialog = new GiftCardInfo(giftCard);
            dialog.setDefaultCloseOperation(2);
            dialog.setSize(PosUIManager.getSize(550, 500));
            dialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
            dialog.setVisible(true);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doDisableGiftCard() {
        try {
            GiftCard giftCard = this.getGiftCardFromTable();
            if (giftCard == null) {
                return;
            }
            int value = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("DisableCard"), Messages.getString("Disable"));
            if (value == 0) {
                if (giftCard.isDisable().booleanValue()) {
                    POSMessageDialog.showMessage(this, Messages.getString("GiftCardDisableView.15"));
                    return;
                }
                giftCard.setDisable(true);
                giftCard.setActive(false);
                giftCard.setDeActivationDate(new Date());
                this.giftCardProcessor.disable(giftCard);
                POSMessageDialog.showMessage(this, Messages.getString("DisabledSuccessfully"));
                this.dispose();
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doAddBalanceGiftCard() {
        GiftCardAddBalanceView dialog = new GiftCardAddBalanceView(this.giftCardProcessor, this.getGiftCardFromTable(Boolean.FALSE));
        dialog.setTitle(Messages.getString("AddBalance"));
        dialog.setDefaultCloseOperation(2);
        dialog.setSize(PosUIManager.getSize(850, 500));
        dialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
        dialog.setVisible(true);
    }

    private void doDeActivate() {
        try {
            GiftCard giftCard = this.getGiftCardFromTable();
            if (giftCard == null) {
                return;
            }
            int value = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("DeactivateCard"), Messages.getString("Deactivation"));
            if (value == 0) {
                if (!giftCard.isActive().booleanValue()) {
                    POSMessageDialog.showMessage(this, Messages.getString("GiftCardDeActiveView.16"));
                    return;
                }
                giftCard.setActive(false);
                giftCard.setDeActivationDate(new Date());
                this.giftCardProcessor.deactivate(giftCard);
                POSMessageDialog.showMessage(this, Messages.getString("CardDeactivatedSuccessfully"));
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private GiftCard getGiftCard() {
        String cardNo = this.getGiftCardNumber();
        if (StringUtils.isEmpty((String)cardNo)) {
            return null;
        }
        GiftCard giftCard = this.giftCardProcessor.getCard(cardNo);
        if (giftCard == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CardNotFound"));
            return null;
        }
        if (StringUtils.isEmpty((String)cardNo)) {
            MessageDialog.showError(Messages.getString("EnterCardNumber"));
            return null;
        }
        return giftCard;
    }

    private GiftCard getGiftCardFromTable() {
        return this.getGiftCardFromTable(Boolean.TRUE);
    }

    private GiftCard getGiftCardFromTable(boolean openGlobalInput) {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow < 0) {
            if (openGlobalInput) {
                return this.getGiftCard();
            }
            return null;
        }
        int index = this.table.convertRowIndexToModel(selectedRow);
        return this.tableModel.getRow(index);
    }

    private void doShowTransactionInfo() {
        try {
            GiftCard giftCard = this.getGiftCardFromTable();
            if (giftCard == null) {
                return;
            }
            GiftCardTransactionInfoView dialog = new GiftCardTransactionInfoView(giftCard, this.giftCardProcessor);
            dialog.setTitle(Messages.getString("GiftCardTransactionDialog.16"));
            dialog.setDefaultCloseOperation(2);
            dialog.setSize(PosUIManager.getSize(900, 600));
            dialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
            dialog.setVisible(true);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private String getGiftCardNumber() {
        GlobalInputDialog inputDialog = new GlobalInputDialog();
        inputDialog.setCaption(Messages.getString("GiftCardManagementView.1"));
        inputDialog.setBlankErrorMessage(Messages.getString("GiftCardAddBalanceAction.4"));
        inputDialog.open();
        if (inputDialog.isCanceled()) {
            return null;
        }
        String giftCardNumber = inputDialog.getInput();
        return giftCardNumber;
    }

    public GiftCard getSelectedGiftCard() {
        return this.selectedGiftCard;
    }

    public void setSelectedGiftCard(GiftCard selectedGiftCard) {
        this.selectedGiftCard = selectedGiftCard;
    }

    private class GiftCardProcessAction
    extends PosAction {
        public GiftCardProcessAction() {
            super.setRequiredPermission(UserPermission.MANAGE_GIFT_CARD);
        }

        @Override
        public void execute() {
            ActionEvent e = super.getActionEvent();
            String actionCommand = e.getActionCommand();
            if (actionCommand.equals(Messages.getString("Activate"))) {
                GiftCardManagementView.this.doActivateGiftCard();
            } else if (actionCommand.equals(Messages.getString("GiftCardManagementView.5"))) {
                GiftCardManagementView.this.doDeActivate();
            } else if (actionCommand.equals(Messages.getString("AddBalance"))) {
                if (!POSUtil.checkDrawerAssignment()) {
                    return;
                }
                GiftCardManagementView.this.doAddBalanceGiftCard();
            } else if (actionCommand.equals(Messages.getString("Disable"))) {
                GiftCardManagementView.this.doDisableGiftCard();
            } else if (actionCommand.equals(Messages.getString("CardInfo"))) {
                GiftCardManagementView.this.doShowCardInfo();
            } else if (actionCommand.equals(Messages.getString("Transactions"))) {
                GiftCardManagementView.this.doShowTransactionInfo();
            }
        }
    }
}

