/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.ClockInOutAction;
import com.floreantpos.bo.actions.BackofficeWindowCloseListener;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.DatabaseConfigurationDialog;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.main.PosWindow;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Store;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.swing.OrderTypeLoginButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.views.ClockInOutDialog;
import com.floreantpos.ui.views.IView;
import com.floreantpos.ui.views.SwitchboardView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.ViewPanel;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftException;
import com.floreantpos.util.UserNotFoundException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class LoginView
extends ViewPanel {
    public static final String VIEW_NAME = "LOGIN_VIEW";
    private PosButton btnDriverView;
    private PosButton btnSwitchBoard;
    private PosButton btnKitchenDisplay;
    private PosButton btnConfigureDatabase;
    private PosButton btnBackOffice;
    private PosButton btnShutdown;
    private PosButton btnClockOUt;
    private JLabel lblTerminalId;
    private JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("al center center, hidemode 3", "sg", "100"));
    private static LoginView instance;
    private JPanel mainPanel;
    private JPanel panel1 = new JPanel((LayoutManager)new MigLayout("fill, ins 0, hidemode 3", "sg, fill", ""));
    private JPanel panel2 = new JPanel((LayoutManager)new MigLayout("fill, ins 0, hidemode 3", "sg, fill", ""));
    private JPanel panel3 = new JPanel((LayoutManager)new MigLayout("fill, ins 0, hidemode 3", "sg, fill", ""));
    private JLabel titleLabel;
    private String storeName;
    private int width;
    private int height;
    private JPanel panel4;
    private JPanel panel5;

    private LoginView() {
        this.setLayout(new BorderLayout());
        this.width = PosUIManager.getSize(600);
        this.height = PosUIManager.getSize(100);
        this.storeName = "";
        this.titleLabel = new JLabel(this.storeName);
        this.titleLabel.setOpaque(true);
        this.titleLabel.setBackground(Color.WHITE);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(56.0f));
        this.titleLabel.setHorizontalAlignment(0);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(0, 100));
        panel.add((Component)this.titleLabel, "Center");
        panel.add((Component)new JSeparator(0), "South");
        this.add((Component)panel, "North");
        this.add((Component)this.createCenterPanel(), "Center");
    }

    private JPanel createCenterPanel() {
        this.lblTerminalId = new JLabel(Messages.getString("LoginView.0"));
        this.lblTerminalId.setForeground(Color.BLACK);
        this.lblTerminalId.setFont(new Font(Messages.getString("LoginView.1"), 1, 18));
        this.lblTerminalId.setHorizontalAlignment(0);
        this.mainPanel = new JPanel(new BorderLayout());
        this.lblTerminalId.setBackground(new Color(0, 0, 0, 0));
        this.btnSwitchBoard = new PosButton(POSConstants.ORDERS);
        this.btnKitchenDisplay = new PosButton(POSConstants.KITCHEN_DISPLAY_BUTTON_TEXT);
        this.btnDriverView = new PosButton("DRIVER VIEW");
        this.btnConfigureDatabase = new PosButton(POSConstants.CONFIGURE_DATABASE);
        this.btnBackOffice = new PosButton(POSConstants.BACK_OFFICE_BUTTON_TEXT);
        this.btnShutdown = new PosButton(POSConstants.SHUTDOWN);
        this.btnClockOUt = new PosButton(new ClockInOutAction(false, true));
        this.btnBackOffice.setVisible(false);
        this.btnSwitchBoard.setVisible(false);
        this.btnKitchenDisplay.setVisible(false);
        this.btnClockOUt.setVisible(false);
        this.panel4 = new JPanel(new GridLayout(1, 0, 5, 5));
        this.panel5 = new JPanel((LayoutManager)new MigLayout("fill, ins 0, hidemode 3", "sg, fill", ""));
        this.centerPanel.add((Component)this.panel1, "cell 0 0, wrap, w " + this.width + "px, h " + this.height + "px, grow");
        this.panel4.add(this.btnSwitchBoard);
        this.panel4.add(this.btnBackOffice);
        this.centerPanel.add((Component)this.panel4, "cell 0 2, wrap, w " + this.width + "px, h " + this.height + "px, grow");
        this.centerPanel.setOpaque(false);
        this.panel5.add((Component)this.btnClockOUt, "grow");
        this.panel5.add((Component)this.btnConfigureDatabase, "grow");
        this.panel5.add((Component)this.btnShutdown, "grow");
        this.panel1.setOpaque(false);
        this.panel2.setOpaque(false);
        this.panel3.setOpaque(false);
        this.panel4.setOpaque(false);
        this.panel5.setOpaque(false);
        this.centerPanel.add((Component)this.panel5, "cell 0 3, wrap, w " + this.width + "px, h " + this.height + "px, grow");
        if (TerminalConfig.isKioskMode()) {
            if (this.btnConfigureDatabase != null) {
                this.btnConfigureDatabase.setVisible(false);
            }
            if (this.btnShutdown != null) {
                this.btnShutdown.setVisible(false);
            }
        } else if (!TerminalConfig.isShowDbConfigureButton()) {
            this.btnConfigureDatabase.setVisible(false);
        }
        this.initActionHandlers();
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.mainPanel.setOpaque(false);
        return this.mainPanel;
    }

    public void initializeOrderButtonPanel() {
        this.panel1.removeAll();
        this.panel2.removeAll();
        this.panel3.removeAll();
        Store store = Application.getInstance().getStore();
        if (store != null) {
            if (!StringUtils.isEmpty((String)store.getName())) {
                this.storeName = store.getName();
            }
            this.titleLabel.setText(this.storeName);
        }
        List<OrderType> orderTypes = Application.getInstance().getOrderTypes();
        int buttonCount = 0;
        int orderTypesSize = (orderTypes = orderTypes.stream().filter(line -> line.isShowInLoginScreen() != false && line.isEnabled() != false && line.isDeleted() == false).collect(Collectors.toList())).size();
        int columnCount = orderTypesSize < 10 ? 3 : 5;
        buttonCount = this.doAddOrderTypeInPanel(orderTypes, buttonCount, columnCount);
        int row = 1;
        this.centerPanel.add((Component)this.panel1, "cell 0 " + row++ + ", wrap, w " + this.width + "px, h " + this.height + "px, grow");
        if (buttonCount > columnCount) {
            this.centerPanel.add((Component)this.panel2, "cell 0 " + row++ + ", wrap,w " + this.width + "px, h " + this.height + "px, grow");
        }
        if (buttonCount > columnCount * 2) {
            this.centerPanel.add((Component)this.panel3, "cell 0 " + row++ + ", wrap,w " + this.width + "px, h " + this.height + "px, grow");
        }
        this.btnSwitchBoard.setVisible(true);
        this.btnBackOffice.setVisible(true);
        this.btnClockOUt.setVisible(true);
        this.centerPanel.add((Component)this.panel4, "cell 0 " + row++ + ", wrap, w " + this.width + "px, h " + this.height + "px, grow");
        this.centerPanel.add((Component)this.panel5, "cell 0 " + row++ + ", wrap, w " + this.width + "px, h " + this.height + "px, grow");
        this.centerPanel.repaint();
    }

    private int doAddOrderTypeInPanel(List<OrderType> orderTypes, int buttonCount, int columnCount) {
        for (OrderType orderType : orderTypes) {
            if (!orderType.isShowInLoginScreen().booleanValue() || !orderType.isEnabled().booleanValue()) continue;
            if (buttonCount < columnCount) {
                this.panel1.add((Component)new OrderTypeLoginButton(orderType), "grow");
            } else if (buttonCount < columnCount * 2) {
                this.panel2.add((Component)new OrderTypeLoginButton(orderType), "grow");
            } else {
                this.panel3.add((Component)new OrderTypeLoginButton(orderType), "grow");
            }
            ++buttonCount;
        }
        return buttonCount;
    }

    public void updateView() {
        this.mainPanel.repaint();
    }

    void initActionHandlers() {
        this.btnConfigureDatabase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseConfigurationDialog.show(Application.getPosWindow());
            }
        });
        this.btnBackOffice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TerminalConfig.setDefaultView(SwitchboardView.VIEW_NAME);
                LoginView.this.doBackofficeLogin();
            }
        });
        this.btnKitchenDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TerminalConfig.setDefaultView("KD");
                LoginView.this.doLogin();
            }
        });
        this.btnDriverView.addActionListener(e -> this.showDriverView());
        this.btnShutdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Application.getInstance().shutdownPOS();
            }
        });
        this.btnSwitchBoard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TerminalConfig.setDefaultView(SwitchboardView.VIEW_NAME);
                LoginView.this.doLogin();
            }
        });
    }

    public synchronized void doLogin() {
        try {
            User user = PasswordEntryDialog.getUser(Application.getPosWindow(), Messages.getString("LoginView.1"), Messages.getString("EnterSecretKey"));
            if (user == null) {
                return;
            }
            if (!user.isClockedIn().booleanValue()) {
                ClockInOutDialog dialog = ClockInOutDialog.getInstance(user, true);
                dialog.openUndecoratedFullScreen();
                if (!user.isClockedIn().booleanValue()) {
                    return;
                }
            }
            Application.getInstance().doLogin(user);
        }
        catch (UserNotFoundException e) {
            POSMessageDialog.showError(Messages.getString("LoginView.3"));
        }
        catch (ShiftException e) {
            POSMessageDialog.showError(e.getMessage());
        }
        catch (Exception e1) {
            String message = e1.getMessage();
            if (message != null && message.contains("Cannot open connection")) {
                POSMessageDialog.showError(Messages.getString("LoginView.4"), e1);
                DatabaseConfigurationDialog.show(Application.getPosWindow());
            }
            POSMessageDialog.showError(Messages.getString("LoginView.5"), e1);
        }
    }

    public synchronized void doBackofficeLogin() {
        User user = PasswordEntryDialog.getUser(Application.getPosWindow(), Messages.getString("LoginView.1"), Messages.getString("LoginView.2"));
        if (user == null) {
            return;
        }
        User backOfficeUser = user.getUserRoleWithPermission(UserPermission.VIEW_BACK_OFFICE);
        if (backOfficeUser == null) {
            POSMessageDialog.showError(Messages.getString("PasswordEntryDialog.4"));
            return;
        }
        Application.getInstance().setCurrentUser(backOfficeUser);
        PosWindow posWindow = Application.getPosWindow();
        BackOfficeWindow window = POSUtil.getBackOfficeWindow();
        if (window == null) {
            window = new BackOfficeWindow(backOfficeUser, true);
        }
        window.addWindowListener(new BackofficeWindowCloseListener(window));
        posWindow.setVisible(false);
        window.setVisible(true);
        window.toFront();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Store store = Application.getInstance().getStore();
        if (store == null) {
            return;
        }
        ImageIcon icon = store.getLoginScreenBackground();
        if (icon == null) {
            return;
        }
        Image bgImage = icon.getImage();
        Dimension dimension = this.getSize();
        g.drawImage(bgImage, 0, 0, dimension.width, dimension.height, null);
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    public static LoginView getInstance() {
        if (instance == null) {
            instance = new LoginView();
        }
        return instance;
    }

    public JPanel getCenterPanel() {
        return this.centerPanel;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    private void showDriverView() {
        IView view = OrderServiceFactory.getOrderService().getDriverView();
        if (view == null) {
            return;
        }
        if (!RootView.getInstance().hasView(view)) {
            RootView.getInstance().addView(view);
        }
        TerminalConfig.setDefaultView(view.getViewName());
        this.doLogin();
    }
}

