/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.main.Application;
import com.floreantpos.model.GuestCheckPrint;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.GuestCheckPrintDAO;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosScrollPane;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class OrderInfoView
extends JPanel {
    private List<Ticket> tickets;
    private JPanel reportPanel;

    public OrderInfoView(List<Ticket> tickets) throws Exception {
        this.tickets = tickets;
        this.createUI();
    }

    public void setTickets(List<Ticket> tickets) {
        this.tickets = tickets;
    }

    public void createUI() throws Exception {
        this.reportPanel = new JPanel((LayoutManager)new MigLayout("wrap 1, ax 50%", "", ""));
        PosScrollPane scrollPane = new PosScrollPane(this.reportPanel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.createReport();
        this.setLayout(new BorderLayout());
        this.add(scrollPane);
    }

    public void createReport() throws Exception {
        for (int i = 0; i < this.tickets.size(); ++i) {
            Ticket ticket = this.tickets.get(i);
            ReceiptPrintService.getMainReceiptPrintPreviewService().rendererTicketReceipt(ticket, this.reportPanel);
        }
    }

    public void createReport(PosTransaction transaction) throws Exception {
        ReceiptPrintService.getMainReceiptPrintPreviewService().rendererPosTransactionReceipt(transaction, this.reportPanel);
    }

    public void print() throws Exception {
        for (Ticket ticket : this.tickets) {
            ReceiptPrintService.printTicket(ticket);
        }
    }

    public void printCopy(String copyType) throws Exception {
        for (Ticket ticket : this.tickets) {
            this.doCreateGuestCheck(ticket);
            ReceiptPrintService.printTicket(ticket, copyType);
        }
    }

    public List<Ticket> getTickets() {
        return this.tickets;
    }

    public JPanel getReportPanel() {
        return this.reportPanel;
    }

    private void doCreateGuestCheck(Ticket ticket) {
        GuestCheckPrint guestCheckPrint = new GuestCheckPrint();
        guestCheckPrint.setTicketId(ticket.getId());
        guestCheckPrint.setPrintTime(new Date());
        guestCheckPrint.setTicketTotal(ticket.getTotalAmountWithTips());
        guestCheckPrint.setUser(Application.getCurrentUser());
        guestCheckPrint.setTableNo(ticket.getTableNameDisplay());
        GuestCheckPrintDAO.getInstance().saveOrUpdate(guestCheckPrint);
    }
}

