/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.IconFactory;
import com.floreantpos.actions.GroupSettleTicketAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.actions.ShowOrderInfoAction;
import com.floreantpos.actions.VoidTicketAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.ReservationDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.reservation.ReservationDetailsDialog;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.POSComboBox;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosSmallButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.ViewPanel;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXDatePicker;

public class ReservationView
extends ViewPanel
implements ActionListener {
    public static final String MEMBER_SF_ID = "sfId";
    public static final String MEMBER_NAME = "name";
    public static final String MEMBER_ID = "id";
    public static final String VIEW_NAME = "RESERVATION_VIEW";
    private static ReservationView instance;
    private ReservationListTableModel reservationModel;
    private QwertyKeyPad qwertyKeyPad;
    private PosButton btnNext;
    private PosButton btnPrevious;
    private JXDatePicker datePicker;
    private JTextField tfMember;
    private JTable tableReservation;
    private POSToggleButton btnOpenTickets;
    private POSToggleButton btnCloseTickets;
    private POSComboBox cbSalesArea;
    private JLabel lblNumberOfItem;

    private ReservationView() {
        TitledBorder titledBorder = new TitledBorder("RESERVATIONS");
        titledBorder.setTitleJustification(2);
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        this.setBorder(new CompoundBorder(emptyBorder, titledBorder));
        this.initComponents();
        this.initData();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
    }

    public static ReservationView getInstance() {
        if (instance == null) {
            instance = new ReservationView();
        }
        return instance;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(10, 10));
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5));
        this.reservationModel = new ReservationListTableModel();
        this.reservationModel.setPageSize(20);
        this.tableReservation = new JTable();
        this.tableReservation.setSelectionMode(0);
        this.tableReservation.setModel(this.reservationModel);
        this.tableReservation.setRowHeight(PosUIManager.getSize(60));
        this.tableReservation.setAutoResizeMode(3);
        this.tableReservation.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.tableReservation.setGridColor(Color.LIGHT_GRAY);
        PosScrollPane scrollPane = new PosScrollPane(this.tableReservation);
        centerPanel.add((Component)scrollPane, "Center");
        this.qwertyKeyPad = new QwertyKeyPad();
        this.qwertyKeyPad.setCollapsed(true);
        centerPanel.add((Component)((Object)this.qwertyKeyPad), "South");
        this.lblNumberOfItem = new JLabel();
        JPanel btnPanel = new JPanel((LayoutManager)new MigLayout("fill, ins 0 0 0 0", "[][center, grow][]", ""));
        PosButton btnImport = new PosButton("IMPORT");
        btnImport.addActionListener(this);
        PosButton btnShowDetails = new PosButton("DETAILS");
        btnShowDetails.addActionListener(this);
        PosButton btnKeyboard = new PosButton(IconFactory.getIcon("/images/", "keyboard.png"));
        btnKeyboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReservationView.this.qwertyKeyPad.setCollapsed(!ReservationView.this.qwertyKeyPad.isCollapsed());
            }
        });
        PosButton btnReservationInfo = new PosButton("RESERVATION INFO");
        btnReservationInfo.addActionListener(this);
        PosButton btnEdit = new PosButton("EDIT");
        btnEdit.addActionListener(this);
        PosButton btnSettle = new PosButton("SETTLE");
        btnSettle.addActionListener(this);
        PosButton btnVoid = new PosButton("VOID");
        btnVoid.addActionListener(this);
        PosButton btnGroupSettle = new PosButton("GROUP SETTLE");
        btnGroupSettle.addActionListener(this);
        this.btnNext = new PosButton("NEXT");
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ReservationView.this.reservationModel.hasNext()) {
                    ReservationView.this.reservationModel.setCurrentRowIndex(ReservationView.this.reservationModel.getNextRowIndex());
                    ReservationView.this.doSearchReservation();
                }
                ReservationView.this.updateButtonStatus();
            }
        });
        this.btnPrevious = new PosButton("PREVIOUS");
        this.btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ReservationView.this.reservationModel.hasPrevious()) {
                    ReservationView.this.reservationModel.setCurrentRowIndex(ReservationView.this.reservationModel.getPreviousRowIndex());
                    ReservationView.this.doSearchReservation();
                }
                ReservationView.this.updateButtonStatus();
            }
        });
        btnPanel.add(btnKeyboard);
        btnPanel.add((Component)btnImport, "split 7");
        btnPanel.add(btnReservationInfo);
        btnPanel.add(btnShowDetails);
        btnPanel.add(btnEdit);
        btnPanel.add(btnSettle);
        btnPanel.add(btnVoid);
        btnPanel.add(btnGroupSettle);
        btnPanel.add(this.lblNumberOfItem);
        btnPanel.add(this.btnPrevious);
        btnPanel.add(this.btnNext);
        centerPanel.add((Component)this.getSearchPanel(), "North");
        this.add((Component)centerPanel, "Center");
        this.add((Component)btnPanel, "South");
        this.updateButtonStatus();
    }

    private void initData() {
        this.reservationModel.setCurrentRowIndex(0);
        ReservationDAO.getInstance().findReservations(this.reservationModel, null, null, null, null, false);
        this.updateItemNumber();
        this.updateButtonStatus();
        List<SalesArea> salesAreas = SalesAreaDAO.getInstance().findAll();
        ListComboBoxModel listComboBoxModel = new ListComboBoxModel();
        listComboBoxModel.addElement((Object)null);
        for (SalesArea salesArea : salesAreas) {
            listComboBoxModel.addElement(salesArea);
        }
        this.cbSalesArea.setModel(listComboBoxModel);
    }

    public void updateButtonStatus() {
        this.btnNext.setEnabled(this.reservationModel.hasNext());
        this.btnPrevious.setEnabled(this.reservationModel.hasPrevious());
    }

    private JPanel getSearchPanel() {
        JPanel searchPanel = new JPanel((LayoutManager)new MigLayout("fill", "[][][]", ""));
        JLabel lblSearch = new JLabel("Search reservation");
        JLabel lblDate = new JLabel("Date: ");
        this.datePicker = new JXDatePicker();
        Calendar calendar = this.datePicker.getMonthView().getCalendar();
        calendar.setTime(new Date());
        this.datePicker.getEditor().setEditable(false);
        PosSmallButton btnToday = new PosSmallButton("Today");
        btnToday.addActionListener(this);
        JLabel lblMember = new JLabel("Member:");
        this.tfMember = new JTextField(15);
        this.tfMember.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReservationView.this.reservationModel.setCurrentRowIndex(0);
                ReservationView.this.doSearchReservation();
            }
        });
        this.cbSalesArea = new POSComboBox();
        this.cbSalesArea.setHeight(28);
        this.cbSalesArea.setPreferredSize(PosUIManager.getSize(100, 0));
        PosSmallButton btnSearch = new PosSmallButton("Search");
        btnSearch.addActionListener(this);
        PosSmallButton btnReset = new PosSmallButton("Reset");
        btnReset.addActionListener(this);
        PosSmallButton btnRefresh = new PosSmallButton("Refresh");
        btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReservationView.this.doSearchReservation();
            }
        });
        this.btnOpenTickets = new POSToggleButton("Open");
        this.btnOpenTickets.addActionListener(this);
        this.btnCloseTickets = new POSToggleButton("Close");
        this.btnCloseTickets.addActionListener(this);
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.btnOpenTickets);
        btnGroup.add(this.btnCloseTickets);
        this.btnOpenTickets.setSelected(true);
        searchPanel.add((Component)lblSearch, "wrap");
        searchPanel.add((Component)lblDate, ", split 9 ");
        searchPanel.add((Component)this.datePicker, "grow");
        searchPanel.add((Component)btnToday, "grow");
        searchPanel.add((Component)lblMember, "gapleft 20");
        searchPanel.add((Component)this.tfMember, "grow");
        searchPanel.add((Component)new JLabel("Sales area: "), "grow, gapleft 20");
        searchPanel.add((Component)this.cbSalesArea, "grow");
        searchPanel.add((Component)btnSearch, "grow");
        searchPanel.add((Component)btnReset, "grow");
        searchPanel.add((Component)btnRefresh, "growy");
        searchPanel.add((Component)this.btnOpenTickets, "split 2, span, right");
        searchPanel.add((Component)this.btnCloseTickets, "");
        return searchPanel;
    }

    private void doSearchReservation() {
        Date date = this.datePicker.getDate();
        String customerId = this.tfMember.getText();
        boolean closeTicket = this.btnCloseTickets.isSelected();
        SalesArea salesArea = (SalesArea)this.cbSalesArea.getSelectedItem();
        ReservationDAO.getInstance().findReservations(this.reservationModel, date, date, customerId, salesArea, closeTicket);
        this.updateItemNumber();
        this.updateButtonStatus();
    }

    private void updateItemNumber() {
        int totalNumber;
        int startNumber = this.reservationModel.getCurrentRowIndex() + 1;
        int endNumber = this.reservationModel.getNextRowIndex();
        if (endNumber > (totalNumber = this.reservationModel.getNumRows())) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format("Showing %s to %s of %s", startNumber, endNumber, totalNumber));
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.reservationModel.setCurrentRowIndex(0);
            this.doSearchReservation();
        }
        super.setVisible(visible);
    }

    public void updateView() {
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("IMPORT")) {
            this.doImportFile();
        } else if (actionCommand.equals("RESERVATION INFO")) {
            this.doShowReservationInfo();
        } else if (actionCommand.equals("DETAILS")) {
            this.doShowReservationDetails();
        } else if (actionCommand.equals("EDIT")) {
            this.doEditReservation();
        } else if (actionCommand.equals("SETTLE")) {
            this.doSettleReservation();
        } else if (actionCommand.equals("Today")) {
            this.doSearchByToday();
        } else if (actionCommand.equals("Reset")) {
            this.doReset();
        } else if (actionCommand.equals("Search") || actionCommand.equals("Open") || actionCommand.equals("Close")) {
            this.doSearchReservation();
        } else if (actionCommand.equals("VOID")) {
            this.doVoid();
        } else if (actionCommand.equals("GROUP SETTLE")) {
            this.doGroupSettleReservation();
        }
    }

    private void doVoid() {
        int index = this.tableReservation.getSelectedRow();
        if (index < 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select reservation.");
            return;
        }
        index = this.tableReservation.convertRowIndexToModel(index);
        Ticket ticket = (Ticket)this.reservationModel.getRowData(index);
        ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        try {
            new VoidTicketAction(ticket).actionPerformed(null);
            this.doSearchReservation();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doGroupSettleReservation() {
        new GroupSettleTicketAction(Application.getCurrentUser()).actionPerformed(null);
        this.doSearchReservation();
    }

    private void doShowReservationDetails() {
        int index = this.tableReservation.getSelectedRow();
        if (index < 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select reservation.");
            return;
        }
        index = this.tableReservation.convertRowIndexToModel(index);
        Ticket ticket = (Ticket)this.reservationModel.getRowData(index);
        ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        ReservationDetailsDialog dialog = new ReservationDetailsDialog(ticket);
        dialog.setTitle("Reservation details");
        dialog.openFullScreen();
        this.tableReservation.repaint();
    }

    private void doShowReservationInfo() {
        int index = this.tableReservation.getSelectedRow();
        if (index < 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select reservation.");
            return;
        }
        index = this.tableReservation.convertRowIndexToModel(index);
        Ticket ticket = (Ticket)this.reservationModel.getRowData(index);
        ticket.calculatePrice();
        ticket.setOwner(Application.getCurrentUser());
        ShowOrderInfoAction showOrderInfoAction = new ShowOrderInfoAction(ticket);
        showOrderInfoAction.execute();
    }

    private void doSettleReservation() {
        int index = this.tableReservation.getSelectedRow();
        if (index < 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select reservation.");
            return;
        }
        index = this.tableReservation.convertRowIndexToModel(index);
        Ticket ticket = (Ticket)this.reservationModel.getRowData(index);
        ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        ticket.calculatePrice();
        ticket.setOwner(Application.getCurrentUser());
        SettleTicketAction settleTicketAction = new SettleTicketAction(ticket);
        settleTicketAction.actionPerformed(null);
        this.reservationModel.setCurrentRowIndex(0);
        this.doSearchReservation();
    }

    private String doShowService(Ticket ticket) {
        String items = "";
        List<TicketItem> ticketItems = ticket.getTicketItems();
        Iterator<TicketItem> iterator = ticketItems.iterator();
        while (iterator.hasNext()) {
            TicketItem ticketItem = iterator.next();
            items = items + ticketItem.getName() + " * " + NumberUtil.trimDecilamIfNotNeeded(ticketItem.getQuantity());
            if (!iterator.hasNext()) continue;
            items = items + ", ";
        }
        return items;
    }

    private void doEditReservation() {
        int index = this.tableReservation.getSelectedRow();
        if (index < 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select reservation.");
            return;
        }
        index = this.tableReservation.convertRowIndexToModel(index);
        Ticket ticket = (Ticket)this.reservationModel.getRowData(index);
        ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        ticket.setOwner(Application.getCurrentUser());
        OrderView.getInstance().setCurrentTicket(ticket);
        RootView.getInstance().showView("ORDER_VIEW");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doImportFile() {
        JFileChooser fileChooser = new JFileChooser();
        int option = fileChooser.showOpenDialog(this);
        if (option != 0) {
            return;
        }
        File selectedFile = fileChooser.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        InputStream in = null;
        try {
            in = selectedFile.toURI().toURL().openStream();
            BufferedReader streamReader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String string = IOUtils.toString((Reader)streamReader);
            int importData = ReservationDAO.getInstance().addFromJSON(string);
            this.initData();
            String strReservation = importData > 1 ? "reservations" : "reservation";
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), importData + " " + strReservation + " has successfully imported.");
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void doSearchByToday() {
        this.datePicker.setDate(new Date());
        this.reservationModel.setCurrentRowIndex(0);
        this.doSearchReservation();
    }

    private void doReset() {
        this.datePicker.setDate(null);
        this.datePicker.getEditor().setText("");
        this.tfMember.setText("");
        this.cbSalesArea.setSelectedItem(null);
        this.reservationModel.setCurrentRowIndex(0);
        this.doSearchReservation();
    }

    private class ReservationListTableModel
    extends PaginatedTableModel<Ticket> {
        public ReservationListTableModel() {
            super(new String[]{"RESERVATION DATE", "MEMBER", "SALES AREA", "SERVICE REQUESTED"});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Ticket ticket = (Ticket)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    Date deliveryDate = ticket.getDeliveryDate();
                    if (deliveryDate != null) {
                        return DateUtil.formatReportDateAsString(deliveryDate);
                    }
                    return null;
                }
                case 1: {
                    Customer customer = ticket.getCustomer();
                    if (customer != null) {
                        String memberId = StringUtils.isNotEmpty((String)customer.getMemberId()) ? customer.getMemberId() + ", " : "";
                        return memberId + customer.getName();
                    }
                    return "";
                }
                case 2: {
                    SalesArea salesArea = ticket.getSalesArea();
                    return salesArea != null ? salesArea.getName() : "";
                }
                case 3: {
                    return ReservationView.this.doShowService(ticket);
                }
            }
            return null;
        }
    }
}

