/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.actions.DrawerAssignmentAction;
import com.floreantpos.actions.ManageTableLayoutAction;
import com.floreantpos.actions.PosAction;
import com.floreantpos.actions.ShowGiftCardAction;
import com.floreantpos.actions.ShowKitchenDisplayAction;
import com.floreantpos.actions.ShowLineDisplayAction;
import com.floreantpos.actions.ShowOnlineTicketManagementAction;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.ViewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class SwitchboardOtherFunctionsView
extends ViewPanel {
    public static final String VIEW_NAME = "ALL FUNCTIONS";
    private static SwitchboardOtherFunctionsView instance;
    private JPanel contentPanel;
    private DrawerAssignmentAction drawerAssignAction;

    public SwitchboardOtherFunctionsView() {
        this.setLayout(new BorderLayout(5, 5));
        PosButton btnBack = new PosButton(Messages.getString("SwitchboardOtherFunctionsView.1"));
        btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RootView.getInstance().showDefaultView();
            }
        });
        this.add((Component)btnBack, "South");
        this.contentPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3,align 50% 50%, wrap 3", "sg fill", ""));
        ArrayList<Object> actions = new ArrayList<Object>();
        this.drawerAssignAction = new DrawerAssignmentAction(Application.getInstance().getTerminal(), Application.getCurrentUser());
        if (DataProvider.get().getStore().isKDSenabled()) {
            actions.add(new ShowKitchenDisplayAction());
        }
        actions.add(new ManageTableLayoutAction());
        actions.add(new ShowOnlineTicketManagementAction());
        actions.add(new ShowLineDisplayAction());
        actions.add(new ShowGiftCardAction());
        List plugins = ExtensionManager.getPlugins();
        if (plugins != null) {
            for (FloreantPlugin plugin : plugins) {
                List list = plugin.getSpecialFunctionActions();
                if (list == null) continue;
                for (AbstractAction action : list) {
                    actions.add((PosAction)action);
                }
            }
        }
        Dimension size = PosUIManager.getSize(150, 150);
        for (PosAction posAction : actions) {
            if (posAction instanceof DrawerAssignmentAction && !Application.getInstance().getTerminal().isHasCashDrawer().booleanValue()) continue;
            PosButton button = new PosButton(posAction);
            this.contentPanel.add((Component)button, "w " + size.width + "!, h " + size.height + "!");
        }
        JScrollPane scrollPane = new JScrollPane(this.contentPanel);
        scrollPane.setBorder(null);
        this.add(scrollPane);
    }

    public static SwitchboardOtherFunctionsView getInstance() {
        if (instance == null) {
            instance = new SwitchboardOtherFunctionsView();
        }
        instance.updateView();
        return instance;
    }

    private void updateView() {
        this.drawerAssignAction.updateActionText();
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }
}

