/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.VoidReason;
import com.floreantpos.model.dao.VoidReasonDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleDocument;
import com.floreantpos.swing.IntegerDocument;
import com.floreantpos.swing.POSComboBox;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.NotesDialog;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class VoidItemFormDialog
extends OkCancelOptionDialog {
    private POSTextField txtVoidItemUnit = new POSTextField(10);
    private TicketItem ticketItem;
    private VoidItem voidItem;
    private POSComboBox cbVoidItemReason;
    private POSToggleButton tbItemWasted;
    private VoidReason voidReason;
    private PosButton addBtn;
    private PosButton decBtn;
    private ComboBoxModel comboBoxModel;

    public VoidItemFormDialog(TicketItem ticketItem) {
        super(POSUtil.getFocusedWindow(), Messages.getString("VoidItemFormDialog.0"));
        this.ticketItem = ticketItem;
        this.voidItem = new VoidItem();
        this.inItComponents();
        this.updateView();
    }

    public void inItComponents() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("VOID_TICKET_BUTTON_TEXT") + " " + this.ticketItem.getName());
        this.add((Component)titlePanel, "North");
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fillx,center", "[][]", ""));
        JPanel unitPanel = new JPanel(new BorderLayout(7, 0));
        JLabel lblNumberOfCard = new JLabel("How Many Unit :");
        this.addBtn = new PosButton("+");
        this.decBtn = new PosButton("-");
        if (this.ticketItem.isFractionalUnit().booleanValue()) {
            this.txtVoidItemUnit.setDocument(new DoubleDocument());
        } else {
            this.txtVoidItemUnit.setDocument(new IntegerDocument());
        }
        unitPanel.add((Component)this.decBtn, "West");
        unitPanel.add((Component)this.txtVoidItemUnit, "Center");
        unitPanel.add((Component)this.addBtn, "East");
        JLabel lblHolder = new JLabel(Messages.getString("VoidItemViewerTableModel.1"));
        JPanel reasonPanel = new JPanel(new BorderLayout(5, 0));
        this.comboBoxModel = new ComboBoxModel();
        this.cbVoidItemReason = new POSComboBox();
        this.cbVoidItemReason.setModel(this.comboBoxModel);
        this.cbVoidItemReason.setSelectedIndex(-1);
        PosButton addReasonBtn = new PosButton("+");
        reasonPanel.add((Component)this.cbVoidItemReason, "Center");
        reasonPanel.add((Component)addReasonBtn, "East");
        addReasonBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VoidItemFormDialog.this.doAddNewVoidReason();
            }
        });
        centerPanel.add((Component)lblNumberOfCard, "");
        centerPanel.add(unitPanel);
        this.tbItemWasted = new POSToggleButton(Messages.getString("VoidItemFormDialog.5"));
        centerPanel.add((Component)this.tbItemWasted, "right, wrap");
        centerPanel.add((Component)lblHolder, "alignx right");
        centerPanel.add((Component)reasonPanel, "growx,span");
        this.add((Component)centerPanel, "Center");
        QwertyKeyPad keyBoard = new QwertyKeyPad();
        centerPanel.add((Component)((Object)keyBoard), "gaptop 50, newline,span");
        this.buttonAction();
    }

    private void updateView() {
        this.comboBoxModel.setDataList(VoidReasonDAO.getInstance().findAll());
        if (this.cbVoidItemReason.getMaximumRowCount() > 5) {
            this.cbVoidItemReason.setMaximumRowCount(5);
        }
        this.txtVoidItemUnit.setText(this.ticketItem.getItemQuantityDisplay());
    }

    private boolean updateModel() {
        double quantity = 0.0;
        try {
            quantity = Double.parseDouble(this.txtVoidItemUnit.getText());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        boolean reason = this.tbItemWasted.isSelected();
        this.voidReason = (VoidReason)this.cbVoidItemReason.getSelectedItem();
        if (this.voidReason != null) {
            this.voidItem.setVoidReason(this.voidReason.getReasonText());
        }
        this.voidItem.setMenuItemId(this.ticketItem.getMenuItemId());
        this.voidItem.setMenuItemName(this.ticketItem.getName());
        this.voidItem.setUnitPrice(this.ticketItem.getUnitPrice());
        this.voidItem.setQuantity(quantity);
        this.voidItem.setItemWasted(reason);
        this.voidItem.setVoidDate(new Date());
        this.voidItem.setModifier(false);
        this.voidItem.setPrinterGroup(this.ticketItem.getPrinterGroup());
        this.voidItem.setVoidByUser(Application.getCurrentUser());
        this.voidItem.setTerminal(Application.getInstance().getTerminal());
        double subtotal = this.ticketItem.getUnitPrice() * this.voidItem.getQuantity();
        double taxAmount = subtotal * (this.ticketItem.getTotalTaxRate() / 100.0);
        this.voidItem.setTaxAmount(taxAmount);
        this.voidItem.setTotalPrice(subtotal + taxAmount);
        return true;
    }

    public VoidItem getVoidItem() {
        return this.voidItem;
    }

    @Override
    public void doOk() {
        this.updateModel();
        this.setCanceled(false);
        this.dispose();
    }

    private void doAddNewVoidReason() {
        try {
            NotesDialog noteDialogue = new NotesDialog();
            noteDialogue.setTitle(Messages.getString("VoidItemFormDialog.7"));
            noteDialogue.open();
            if (noteDialogue.isCanceled()) {
                return;
            }
            String note = noteDialogue.getNote();
            for (VoidReason voidReason : this.comboBoxModel.getDataList()) {
                if (!voidReason.getReasonText().equalsIgnoreCase(note)) continue;
                this.comboBoxModel.setSelectedItem(voidReason);
                return;
            }
            this.voidReason = new VoidReason();
            this.voidReason.setReasonText(note);
            VoidReasonDAO.getInstance().saveOrUpdate(this.voidReason);
            this.comboBoxModel.addElement(this.voidReason);
            this.comboBoxModel.setSelectedItem(this.voidReason);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, Messages.getString("VoidItemFormDialog.8"), e);
        }
    }

    public void buttonAction() {
        try {
            this.decBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double value = 0.0;
                    try {
                        value = Double.parseDouble(VoidItemFormDialog.this.txtVoidItemUnit.getText());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    value -= 1.0;
                    if (value < 0.0) {
                        POSMessageDialog.showMessage(Messages.getString("VoidItemFormDialog.9"));
                    } else {
                        VoidItemFormDialog.this.txtVoidItemUnit.setText(NumberUtil.trimDecilamIfNotNeeded(value));
                    }
                }
            });
            this.addBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    double value = 0.0;
                    try {
                        value = Double.parseDouble(VoidItemFormDialog.this.txtVoidItemUnit.getText());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    VoidItemFormDialog.this.txtVoidItemUnit.setText(NumberUtil.trimDecilamIfNotNeeded(value += 1.0));
                }
            });
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }
}

