/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.customer.CustomerSelector;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.main.Application;
import com.floreantpos.main.PosWindow;
import com.floreantpos.model.Customer;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.IView;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import com.floreantpos.util.TicketAlreadyExistsException;
import java.awt.Component;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JOptionPane;

public class DefaultOrderServiceExtension
extends OrderServiceExtension {
    public boolean requireLicense() {
        return false;
    }

    public String getProductName() {
        return Messages.getString("DefaultOrderServiceExtension.0");
    }

    public String getDescription() {
        return Messages.getString("DefaultOrderServiceExtension.1");
    }

    public void createNewTicket(OrderType ticketType, List<ShopTable> selectedTables, Customer customer) throws TicketAlreadyExistsException {
        this.createNewTicket(ticketType, selectedTables, customer, 0);
    }

    public void setCustomerToTicket(String ticketId) {
    }

    public void setDeliveryDate(String ticketId) {
    }

    public void assignDriver(String ticketId) {
    }

    public boolean finishOrder(String ticketId) {
        Ticket ticket = TicketDAO.getInstance().get(ticketId);
        int due = (int)POSUtil.getDouble(ticket.getDueAmount());
        if (due != 0) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("DefaultOrderServiceExtension.2"));
            return false;
        }
        int option = JOptionPane.showOptionDialog(Application.getPosWindow(), Messages.getString("DefaultOrderServiceExtension.3") + ticket.getId() + Messages.getString("DefaultOrderServiceExtension.4"), Messages.getString("CONFIRM"), 2, 1, null, null, null);
        if (option != 0) {
            return false;
        }
        OrderController.closeOrder(ticket);
        return true;
    }

    public void createCustomerMenu(JMenu menu) {
    }

    public void initBackoffice(BackOfficeWindow backOfficeWindow) {
    }

    public void initConfigurationView(JDialog dialog) {
    }

    public String getId() {
        return "default-floorplan";
    }

    public IView getDeliveryDispatchView(OrderType orderType) {
        return null;
    }

    public CustomerSelector createNewCustomerSelector() {
        return null;
    }

    public CustomerSelector createCustomerSelectorView() {
        return null;
    }

    public void openDeliveryDispatchDialog(OrderType orderType) {
    }

    public IView getDriverView() {
        return null;
    }

    public List<AbstractAction> getSpecialFunctionActions() {
        return null;
    }

    public boolean hasValidLicense() {
        return true;
    }

    public void initUI(PosWindow posWindow) {
    }

    public String getProductVersion() {
        return null;
    }

    public Component getParent() {
        return null;
    }

    public void createNewTicket(OrderType orderType, List<ShopTable> selectedTables, Customer selectedCustomer, int numberOfGuests) throws TicketAlreadyExistsException {
        try {
            if (!this.hasPermission()) {
                POSMessageDialog.showError(Messages.getString("DefaultOrderServiceExtension.5"));
                return;
            }
            Ticket ticket = new Ticket(true);
            ticket.setOrderType(orderType);
            if (TerminalConfig.isActiveCustomerDisplay()) {
                DrawerUtil.setCustomerDisplayMessage(TerminalConfig.getCustomerDisplayPort(), Messages.getString("DefaultOrderServiceExtension.14"));
            }
            if (orderType.isRequiredCustomerData().booleanValue() && selectedCustomer == null && (selectedCustomer = PosGuiUtil.captureCustomer(orderType)) == null) {
                return;
            }
            ticket.setNumberOfGuests(numberOfGuests);
            ticket.setCustomer(selectedCustomer);
            ticket.setShouldIncludeInSales(true);
            if (selectedTables != null) {
                for (ShopTable shopTable : selectedTables) {
                    shopTable.setTableStatus(TableStatus.Serving);
                    SalesArea salesArea = shopTable.getSalesArea();
                    if (salesArea != null) {
                        ticket.setSalesArea(salesArea);
                        ticket.setSalesAreaId(salesArea.getId());
                    }
                    ticket.addTable(shopTable.getTableNumber());
                }
            }
            OrderView.getInstance().setCurrentTicket(ticket);
            RootView.getInstance().showView("ORDER_VIEW");
            if (orderType.isShowGuestSelection().booleanValue() && numberOfGuests == 0) {
                ticket.setNumberOfGuests(PosGuiUtil.captureGuestNumber());
                OrderView.getInstance().updateView();
            }
        }
        catch (DatabaseConnectionException e) {
            POSMessageDialog.showError(Messages.getString("DefaultOrderServiceExtension.15"));
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }

    public void showDeliveryInfo(Ticket ticket, OrderType orderType, Customer customer) {
    }

    public String getUpdateServerURL() {
        return null;
    }

    public Integer getProductNumericVersion() {
        return null;
    }

    private boolean hasPermission() {
        User user = Application.getCurrentUser();
        UserType userType = user.getType();
        if (userType != null) {
            Set<UserPermission> permissions = userType.getPermissions();
            for (UserPermission permission : permissions) {
                if (!permission.equals(UserPermission.CREATE_TICKET)) continue;
                return true;
            }
        }
        return false;
    }
}

