/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.POSDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class OrderTypeSelectionDialog
extends POSDialog {
    private OrderType selectedOrderType;

    public OrderTypeSelectionDialog() throws HeadlessException {
        this.setTitle(Messages.getString("OrderTypeSelectionDialog.0"));
        this.setLayout(new BorderLayout(5, 5));
        JPanel orderTypePanel = new JPanel(new WrapLayout());
        orderTypePanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        List<OrderType> values = Application.getInstance().getOrderTypes();
        for (final OrderType orderType : values) {
            PosButton btnOrderType = new PosButton(orderType.toString());
            btnOrderType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OrderTypeSelectionDialog.this.selectedOrderType = orderType;
                    OrderTypeSelectionDialog.this.setCanceled(false);
                    OrderTypeSelectionDialog.this.dispose();
                }
            });
            orderTypePanel.add(btnOrderType);
        }
        PosButton btnCancel = new PosButton(POSConstants.CANCEL_BUTTON_TEXT);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderTypeSelectionDialog.this.setCanceled(true);
                OrderTypeSelectionDialog.this.dispose();
            }
        });
        JPanel actionPanel = new JPanel();
        actionPanel.add(btnCancel);
        this.add(new PosScrollPane(orderTypePanel));
        this.add((Component)actionPanel, "South");
        this.setSize(PosUIManager.getSize(700, 450));
    }

    public OrderType getSelectedOrderType() {
        return this.selectedOrderType;
    }
}

