/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.StyledTicketSelectionDialog;
import com.floreantpos.util.CurrencyUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

public class TicketSelectionDialog
extends OkCancelOptionDialog {
    private ScrollableFlowPanel buttonsPanel;
    private List<Ticket> addedTicketListModel = new ArrayList<Ticket>();
    private POSToggleButton btnSelectAll;

    public TicketSelectionDialog() {
        super((Window)Application.getPosWindow(), Messages.getString("TicketSelectionDialog.0"));
        this.initComponent();
        this.initData();
    }

    public TicketSelectionDialog(List<Ticket> tickets) {
        this.initComponent();
        this.rendererTickets(tickets);
        this.setResizable(true);
    }

    private void initComponent() {
        this.setOkButtonText(Messages.getString("DONE"));
        this.buttonsPanel = new ScrollableFlowPanel(3);
        this.btnSelectAll = new POSToggleButton(Messages.getString("TicketSelectionDialog.1"));
        this.btnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TicketSelectionDialog.this.addedTicketListModel.clear();
                for (Component c : TicketSelectionDialog.this.buttonsPanel.getContentPane().getComponents()) {
                    TicketButton button = (TicketButton)c;
                    if (TicketSelectionDialog.this.btnSelectAll.isSelected()) {
                        button.setSelected(true);
                        TicketSelectionDialog.this.addedTicketListModel.add(button.getTicket());
                        continue;
                    }
                    button.setSelected(false);
                }
            }
        });
        this.getButtonPanel().add((Component)this.btnSelectAll, 0);
        PosScrollPane scrollPane = new PosScrollPane(this.buttonsPanel, 20, 31);
        scrollPane.getVerticalScrollBar().setPreferredSize(PosUIManager.getSize(40, 0));
        this.getContentPanel().add((Component)scrollPane, "Center");
        this.setSize(1024, 600);
    }

    private void initData() {
        TicketDAO dao = new TicketDAO();
        try {
            List<Ticket> tickets = dao.getTicketsWithSpecificFields(Ticket.PROP_ID, Ticket.PROP_DUE_AMOUNT, Ticket.PROP_TOKEN_NO);
            Dimension size = PosUIManager.getSize(130, 100);
            for (Ticket ticket : tickets) {
                if (ticket.getDueAmount() <= 0.0) continue;
                TicketButton btnTicket = new TicketButton(ticket);
                this.buttonsPanel.add(btnTicket);
                btnTicket.setPreferredSize(size);
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getLocalizedMessage(), e);
        }
    }

    private void rendererTickets(List<Ticket> tickets) {
        try {
            for (Ticket ticket : tickets) {
                this.buttonsPanel.add(new TicketButton(ticket));
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void doOk() {
        if (this.addedTicketListModel.isEmpty()) {
            POSMessageDialog.showMessage(Messages.getString("TicketSelectionDialog.5"));
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void doCancel() {
        this.addedTicketListModel.clear();
        this.setCanceled(true);
        this.dispose();
    }

    public List<Ticket> getSelectedTickets() {
        return this.addedTicketListModel;
    }

    private class TicketButton
    extends POSToggleButton
    implements ActionListener {
        private Ticket ticket;

        TicketButton(Ticket ticket) {
            this.ticket = ticket;
            Terminal terminal = Application.getInstance().getTerminal();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html><body><center>");
            if (!terminal.isShowTableNumber()) {
                stringBuilder.append(String.format("<h3 style='margin:0px; font-size: %spx;'>%s</h3>", PosUIManager.getSize(11), Messages.getString("TicketSelectionDialog.4") + ticket.getTableNames()));
            } else if (ticket.getTableNumbers() != null && ticket.getTableNumbers().size() > 0) {
                stringBuilder.append(String.format("<h3 style='margin:0px; font-size: %spx;'>%s</h3>", PosUIManager.getSize(11), Messages.getString("TicketSelectionDialog.4") + ticket.getTableNames()));
            }
            stringBuilder.append(String.format("<h3 style='margin:0px; font-size: %spx;'>%s</h3>", PosUIManager.getSize(11), ticket.getNumberToDisplay()));
            stringBuilder.append(String.format("<h4 style='margin:0px; font-size: %spx;'>%s</h4>", PosUIManager.getSize(10), POSConstants.DUE + ": " + CurrencyUtil.getCurrencySymbol() + ticket.getDueAmount()));
            stringBuilder.append("</center></body></html>");
            this.setText(stringBuilder.toString());
            this.setPreferredSize(StyledTicketSelectionDialog.tokenSize);
            this.addActionListener(this);
        }

        public Ticket getTicket() {
            return this.ticket;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isSelected()) {
                TicketSelectionDialog.this.addedTicketListModel.add(this.ticket);
            } else {
                TicketSelectionDialog.this.addedTicketListModel.remove(this.ticket);
            }
        }
    }
}

