/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.CustomerSelectionChangeException;
import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.ApplyDiscountAction;
import com.floreantpos.bo.actions.PromotionAction;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.extension.PromotionPaymentPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Currency;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.CustomPaymentDAO;
import com.floreantpos.payment.MemberPaymentPlugin;
import com.floreantpos.payment.PaymentPlugin;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.MultiCurrencyTenderDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.dialog.TaxExemptDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class PaymentView
extends JPanel {
    private static final String ZERO = "0";
    private static final String REMOVE = "1";
    private PosButton btnGratuity;
    private PosButton btnCancel;
    private PosButton btnCash;
    private PosButton btnPrint;
    private PosButton btnCreditCard;
    private PosButton btnGift;
    private PosButton btnOther;
    private TransparentPanel calcButtonPanel;
    private JLabel labelDueAmount;
    private JLabel labelTenderedAmount;
    private TransparentPanel actionButtonPanel;
    private PosButton btn7;
    private PosButton btnDot;
    private PosButton btn0;
    private PosButton btnClear;
    private PosButton btn8;
    private PosButton btn9;
    private PosButton btn4;
    private PosButton btn5;
    private PosButton btn6;
    private PosButton btn3;
    private PosButton btn2;
    private PosButton btn1;
    private PosButton btn00;
    private PosButton btnNextAmount;
    private PosButton btnAmount1;
    private PosButton btnAmount2;
    private PosButton btnAmount5;
    private PosButton btnAmount10;
    private PosButton btnAmount20;
    private PosButton btnAmount50;
    private PosButton btnAmount100;
    private PosButton btnExactAmount;
    private JTextField txtTenderedAmount;
    private JTextField txtDueAmount;
    private PosButton btnRefund;
    private PosButton btnVoid;
    private PosButton btnTicketItemDiscount;
    private PosButton btnTaxExempt;
    private Ticket ticket;
    private SettleTicketProcessor ticketProcessor;
    private boolean clearPreviousAmount = true;
    private Terminal terminal;
    private int width = PosUIManager.getSize(160);
    private PosButton btnSplitTicket;
    private RefreshableView refreshableView;
    Action calAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField textField = PaymentView.this.txtTenderedAmount;
            PosButton button = (PosButton)e.getSource();
            String command = button.getActionCommand();
            if (command.equals(Messages.getString("PaymentView.66"))) {
                textField.setText(PaymentView.ZERO);
            } else if (command.equals(".")) {
                if (textField.getText().indexOf(46) < 0) {
                    textField.setText(textField.getText() + ".");
                }
            } else {
                String string;
                int index;
                if (PaymentView.this.clearPreviousAmount) {
                    textField.setText("");
                    PaymentView.this.clearPreviousAmount = false;
                }
                if ((index = (string = textField.getText()).indexOf(46)) < 0) {
                    double value = 0.0;
                    try {
                        value = Double.parseDouble(string);
                    }
                    catch (NumberFormatException x) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    if (value == 0.0) {
                        textField.setText(command);
                    } else {
                        textField.setText(string + command);
                    }
                } else {
                    textField.setText(string + command);
                }
            }
        }
    };
    Action nextButtonAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PaymentView.this.fillPredefinedAmount(e);
        }
    };

    public PaymentView(SettleTicketProcessor ticketProcessor) {
        this(ticketProcessor, null);
    }

    public PaymentView(SettleTicketProcessor ticketProcessor, RefreshableView refreshableView) {
        this.ticketProcessor = ticketProcessor;
        this.refreshableView = refreshableView;
        this.terminal = Application.getInstance().getTerminal();
        this.initComponents();
        this.setVisibilityBtnByConfig();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("fill, ins 5", "[grow][grow]", ""));
        JPanel leftPanel = new JPanel(new BorderLayout());
        TransparentPanel topPanel = new TransparentPanel((LayoutManager)new MigLayout("hidemode 3,ins 0 0 5 0", "[][grow,fill]", "[grow][][grow]"));
        this.labelDueAmount = new JLabel();
        this.labelTenderedAmount = new JLabel();
        this.txtDueAmount = new JTextField();
        this.txtTenderedAmount = new JTextField();
        Font font1 = new Font("Tahoma", 1, PosUIManager.getFontSize(20));
        Font font2 = new Font("Arial", 0, PosUIManager.getFontSize(34));
        this.labelTenderedAmount.setFont(font1);
        this.labelTenderedAmount.setText(Messages.getString("PaymentView.54") + " " + CurrencyUtil.getCurrencySymbol());
        this.labelTenderedAmount.setForeground(Color.gray);
        this.txtTenderedAmount.setHorizontalAlignment(4);
        this.txtTenderedAmount.setFont(font1);
        this.labelDueAmount.setFont(font1);
        this.labelDueAmount.setText(Messages.getString("PaymentView.52") + " " + CurrencyUtil.getCurrencySymbol());
        this.labelDueAmount.setForeground(Color.gray);
        this.txtDueAmount.setFont(font1);
        this.txtDueAmount.setEditable(false);
        this.txtDueAmount.setHorizontalAlignment(4);
        topPanel.add((Component)this.labelDueAmount, "cell 0 0,alignx right,aligny center");
        topPanel.add((Component)this.labelTenderedAmount, "cell 0 1,alignx left,aligny center");
        topPanel.add((Component)this.txtDueAmount, "cell 1 0,growx,aligny top");
        topPanel.add((Component)this.txtTenderedAmount, "cell 1 1,growx,aligny top");
        leftPanel.add((Component)topPanel, "North");
        this.calcButtonPanel = new TransparentPanel();
        this.calcButtonPanel.setLayout((LayoutManager)new MigLayout("wrap 4,fill, ins 0", "sg, fill", "sg, fill"));
        this.btnNextAmount = new PosButton();
        this.btnAmount1 = new PosButton();
        this.btnAmount1.setFont(font2);
        this.btnAmount2 = new PosButton();
        this.btnAmount2.setFont(font2);
        this.btnAmount5 = new PosButton();
        this.btnAmount5.setFont(font2);
        this.btnAmount10 = new PosButton();
        this.btnAmount10.setFont(font2);
        this.btnAmount20 = new PosButton();
        this.btnAmount20.setFont(font2);
        this.btnAmount50 = new PosButton();
        this.btnAmount50.setFont(font2);
        this.btnAmount100 = new PosButton();
        this.btnAmount100.setFont(font2);
        this.btnExactAmount = new PosButton();
        this.btn7 = new PosButton();
        this.btn8 = new PosButton();
        this.btn9 = new PosButton();
        this.btn4 = new PosButton();
        this.btn5 = new PosButton();
        this.btn6 = new PosButton();
        this.btn1 = new PosButton();
        this.btn2 = new PosButton();
        this.btn3 = new PosButton();
        this.btn0 = new PosButton();
        this.btnDot = new PosButton();
        this.btnClear = new PosButton();
        this.btn00 = new PosButton();
        this.btnAmount1.setForeground(Color.blue);
        this.btnAmount1.setAction(this.nextButtonAction);
        this.btnAmount1.setText(Messages.getString("PaymentView.1"));
        this.btnAmount1.setActionCommand(REMOVE);
        this.btnAmount1.setFocusable(false);
        this.calcButtonPanel.add(this.btnAmount1);
        this.btn7.setAction(this.calAction);
        this.btn7.setText("7");
        this.btn7.setFont(font2);
        this.btn7.setActionCommand("7");
        this.btn7.setFocusable(false);
        this.calcButtonPanel.add(this.btn7);
        this.btn8.setAction(this.calAction);
        this.btn8.setText("8");
        this.btn8.setFont(font2);
        this.btn8.setActionCommand("8");
        this.btn8.setFocusable(false);
        this.calcButtonPanel.add(this.btn8);
        this.btn9.setAction(this.calAction);
        this.btn9.setText("9");
        this.btn9.setFont(font2);
        this.btn9.setActionCommand("9");
        this.btn9.setFocusable(false);
        this.calcButtonPanel.add(this.btn9);
        this.btnAmount2.setForeground(Color.blue);
        this.btnAmount2.setAction(this.nextButtonAction);
        this.btnAmount2.setText(Messages.getString("PaymentView.10"));
        this.btnAmount2.setActionCommand("2");
        this.btnAmount2.setFocusable(false);
        this.calcButtonPanel.add(this.btnAmount2);
        this.btn4.setAction(this.calAction);
        this.btn4.setText("4");
        this.btn4.setFont(font2);
        this.btn4.setActionCommand("4");
        this.btn4.setFocusable(false);
        this.calcButtonPanel.add(this.btn4);
        this.btn5.setAction(this.calAction);
        this.btn5.setText("5");
        this.btn5.setFont(font2);
        this.btn5.setActionCommand("5");
        this.btn5.setFocusable(false);
        this.calcButtonPanel.add(this.btn5);
        this.btn6.setAction(this.calAction);
        this.btn6.setText("6");
        this.btn6.setFont(font2);
        this.btn6.setActionCommand("6");
        this.btn6.setFocusable(false);
        this.calcButtonPanel.add(this.btn6);
        this.btnAmount5.setForeground(Color.blue);
        this.btnAmount5.setAction(this.nextButtonAction);
        this.btnAmount5.setText(Messages.getString("PaymentView.12"));
        this.btnAmount5.setActionCommand("5");
        this.btnAmount5.setFocusable(false);
        this.calcButtonPanel.add(this.btnAmount5);
        this.btn1.setAction(this.calAction);
        this.btn1.setText(REMOVE);
        this.btn1.setFont(font2);
        this.btn1.setActionCommand(REMOVE);
        this.btn1.setFocusable(false);
        this.calcButtonPanel.add(this.btn1);
        this.btn2.setAction(this.calAction);
        this.btn2.setText("2");
        this.btn2.setFont(font2);
        this.btn2.setActionCommand("2");
        this.btn2.setFocusable(false);
        this.calcButtonPanel.add(this.btn2);
        this.btn3.setAction(this.calAction);
        this.btn3.setText("3");
        this.btn3.setFont(font2);
        this.btn3.setActionCommand("3");
        this.btn3.setFocusable(false);
        this.calcButtonPanel.add(this.btn3);
        this.btnAmount10.setForeground(Color.blue);
        this.btnAmount10.setAction(this.nextButtonAction);
        this.btnAmount10.setText(Messages.getString("PaymentView.14"));
        this.btnAmount10.setActionCommand("10");
        this.btnAmount10.setFocusable(false);
        this.calcButtonPanel.add((Component)this.btnAmount10, "grow");
        this.btn0.setAction(this.calAction);
        this.btn0.setText(ZERO);
        this.btn0.setFont(font2);
        this.btn0.setActionCommand(ZERO);
        this.btn0.setFocusable(false);
        this.calcButtonPanel.add(this.btn0);
        this.btn00.setFont(new Font("Arial", 0, 30));
        this.btn00.setAction(this.calAction);
        this.btn00.setText(Messages.getString("PaymentView.18"));
        this.btn00.setActionCommand("00");
        this.btn00.setFocusable(false);
        this.calcButtonPanel.add(this.btn00);
        this.btnDot.setAction(this.calAction);
        this.btnDot.setIcon(IconFactory.getIcon("/ui_icons/", "dot.png"));
        this.btnDot.setActionCommand(".");
        this.btnDot.setFocusable(false);
        this.calcButtonPanel.add(this.btnDot);
        this.btnAmount20.setForeground(Color.BLUE);
        this.btnAmount20.setAction(this.nextButtonAction);
        this.btnAmount20.setText("20");
        this.btnAmount20.setActionCommand("20");
        this.btnAmount20.setFocusable(false);
        this.calcButtonPanel.add((Component)this.btnAmount20, "grow");
        this.btnAmount50.setForeground(Color.blue);
        this.btnAmount50.setAction(this.nextButtonAction);
        this.btnAmount50.setText("50");
        this.btnAmount50.setActionCommand("50");
        this.btnAmount50.setFocusable(false);
        this.calcButtonPanel.add((Component)this.btnAmount50, "grow");
        this.btnAmount100.setForeground(Color.blue);
        this.btnAmount100.setAction(this.nextButtonAction);
        this.btnAmount100.setText("100");
        this.btnAmount100.setActionCommand("100");
        this.btnAmount100.setFocusable(false);
        this.calcButtonPanel.add((Component)this.btnAmount100, "grow");
        this.btnClear.setAction(this.calAction);
        this.btnClear.setIcon(IconFactory.getIcon("/ui_icons/", "clear.png"));
        this.btnClear.setText(Messages.getString("PaymentView.38"));
        this.btnClear.setFocusable(false);
        this.calcButtonPanel.add(this.btnClear);
        this.btnExactAmount.setAction(this.nextButtonAction);
        this.btnExactAmount.setText(Messages.getString("PaymentView.20"));
        this.btnExactAmount.setActionCommand("exactAmount");
        this.btnExactAmount.setFocusable(false);
        this.calcButtonPanel.add((Component)this.btnExactAmount, "span 2,grow");
        this.btnNextAmount.setAction(this.nextButtonAction);
        this.btnNextAmount.setText(Messages.getString("PaymentView.23"));
        this.btnNextAmount.setActionCommand("nextAmount");
        this.btnNextAmount.setFocusable(false);
        this.calcButtonPanel.add((Component)this.btnNextAmount, "span 2,grow");
        this.btnGratuity = new PosButton(POSConstants.ADD_GRATUITY_TEXT);
        this.btnGratuity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaymentView.this.doSetGratuity();
            }
        });
        this.btnVoid = new PosButton(POSConstants.VOID.toUpperCase());
        this.btnVoid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaymentView.this.ticketProcessor.doVoidTicket();
            }
        });
        this.btnTicketItemDiscount = new PosButton("<html><center>ITEM <br>DISCOUNT</center></html>");
        this.btnTicketItemDiscount.addActionListener(new ApplyDiscountAction(this.ticketProcessor, 0));
        this.btnTaxExempt = new PosButton("<html><center>TAX<br>EXEMPT</center></html>");
        this.btnTaxExempt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    User user = PasswordEntryDialog.getUser(Application.getPosWindow(), Messages.getString("PosAction.0"), Messages.getString("PosAction.0"));
                    if (user == null) {
                        return;
                    }
                    if (!user.isManager() || !user.isAdministrator()) {
                        POSMessageDialog.showError(Messages.getString("PasswordEntryDialog.4"));
                        return;
                    }
                    PaymentView.this.doOpenTaxExemptDialog();
                }
                catch (Exception e) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
                }
            }
        });
        this.btnPrint = new PosButton(POSConstants.PRINT_TICKET);
        this.btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaymentView.this.ticketProcessor.printTicket(PaymentView.this.getTicket());
            }
        });
        this.btnSplitTicket = new PosButton("SPLIT");
        this.btnSplitTicket.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaymentView.this.ticketProcessor.doSplitTicket();
            }
        });
        PosButton btnNoSale = new PosButton("NO SALE");
        btnNoSale.setFocusable(false);
        btnNoSale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawerUtil.kickDrawer();
            }
        });
        JPanel actionButtonPanelThird = new JPanel(new GridLayout(1, 0, 5, 5));
        JPanel actionButtonPanelFirst = new JPanel(new GridLayout(1, 0, 5, 5));
        JPanel actionButtonPanelSecond = new JPanel(new GridLayout(1, 0, 5, 5));
        actionButtonPanelFirst.add(this.btnGratuity);
        actionButtonPanelFirst.add(this.btnExactAmount);
        actionButtonPanelFirst.add(this.btnNextAmount);
        actionButtonPanelSecond.add(this.btnVoid);
        actionButtonPanelSecond.add(this.btnTicketItemDiscount);
        actionButtonPanelSecond.add(this.btnTaxExempt);
        actionButtonPanelThird.add(this.btnSplitTicket);
        actionButtonPanelThird.add(this.btnPrint);
        actionButtonPanelThird.add(btnNoSale);
        this.calcButtonPanel.add((Component)actionButtonPanelFirst, "span 4,growx");
        this.calcButtonPanel.add((Component)actionButtonPanelSecond, "span 4,growx");
        this.calcButtonPanel.add((Component)actionButtonPanelThird, "span 4,growx");
        leftPanel.add((Component)this.calcButtonPanel, "Center");
        this.actionButtonPanel = new TransparentPanel();
        this.actionButtonPanel.setOpaque(true);
        this.actionButtonPanel.setLayout((LayoutManager)new MigLayout("hidemode 3,wrap 1, ins 0 20 0 0, fill", "sg, fill", ""));
        final MemberPaymentPlugin memberPaymentPlugin = new MemberPaymentPlugin();
        PosButton btnMemberAcctPayment = new PosButton(memberPaymentPlugin.getName());
        this.actionButtonPanel.add((Component)btnMemberAcctPayment, "grow,w " + this.width + "!");
        btnMemberAcctPayment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PaymentView.this.doPaymentByPlugin((PaymentPlugin)memberPaymentPlugin);
            }
        });
        this.btnCash = new PosButton(Messages.getString("PaymentView.31"));
        this.actionButtonPanel.add((Component)this.btnCash, "grow,w " + this.width + "!");
        this.btnCash.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaymentView.this.doPayByCash();
            }
        });
        PosButton btnMultiCurrencyCash = new PosButton("MULTI CURRENCY CASH");
        this.actionButtonPanel.add((Component)btnMultiCurrencyCash, "grow,w " + this.width + "!");
        btnMultiCurrencyCash.setVisible(this.terminal.isEnableMultiCurrency());
        btnMultiCurrencyCash.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaymentView.this.doPayByMulticurrencyCash();
            }
        });
        this.btnCreditCard = new PosButton(Messages.getString("PaymentView.33"));
        this.actionButtonPanel.add((Component)this.btnCreditCard, "grow,w " + this.width + "!");
        this.btnCreditCard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaymentView.this.doPayBy(PaymentType.CREDIT_CARD);
            }
        });
        this.btnGift = new PosButton(Messages.getString("PaymentView.35"));
        this.actionButtonPanel.add((Component)this.btnGift, "grow,w " + this.width + "!");
        this.btnGift.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PaymentView.this.ticket.hasGiftCard()) {
                    POSMessageDialog.showMessage(Messages.getString("PaymentView.3"));
                    return;
                }
                PaymentView.this.doPayBy(PaymentType.GIFT_CERTIFICATE);
            }
        });
        List paymentPlugins = ExtensionManager.getPlugins(PaymentPlugin.class);
        for (FloreantPlugin floreantPlugin : paymentPlugins) {
            final PaymentPlugin paymentPlugin = (PaymentPlugin)floreantPlugin;
            if (paymentPlugin instanceof GiftCardPaymentPlugin || paymentPlugin instanceof MemberPaymentPlugin) continue;
            PosButton btnPay = new PosButton(paymentPlugin.getName());
            this.actionButtonPanel.add((Component)btnPay, "grow,w " + this.width + "!");
            btnPay.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    try {
                        if (paymentPlugin instanceof PromotionPaymentPlugin) {
                            new PromotionAction(PaymentView.this, paymentPlugin).actionPerformed(ev);
                        } else {
                            PaymentView.this.doPaymentByPlugin(paymentPlugin);
                        }
                    }
                    catch (Exception e) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage().toString());
                    }
                }
            });
        }
        this.btnOther = new PosButton("OTHER");
        this.actionButtonPanel.add((Component)this.btnOther, "grow,w " + this.width + "!");
        this.btnOther.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaymentView.this.doPayBy(PaymentType.CUSTOM_PAYMENT);
            }
        });
        this.btnRefund = new PosButton("REFUND");
        this.btnRefund.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaymentView.this.ticketProcessor.doRefund();
            }
        });
        this.actionButtonPanel.add((Component)this.btnRefund, "grow,w " + this.width + "!");
        this.add((Component)leftPanel, "cell 0 0,grow");
        this.add((Component)this.actionButtonPanel, "cell 1 0,grow");
    }

    private void setVisibilityBtnByConfig() {
        if (this.terminal == null) {
            return;
        }
        Boolean isHideCashPayment = Boolean.valueOf(this.terminal.getProperty("hideCashPayment"));
        Boolean isHideCardPayment = Boolean.valueOf(this.terminal.getProperty("hideCardPayment"));
        Boolean isHideGiftCardPayment = Boolean.valueOf(this.terminal.getProperty("hideGiftCardPayment"));
        Boolean isHideCustomPayment = Boolean.valueOf(this.terminal.getProperty("hideCustomPayment"));
        Boolean isShowIndivBtn = Boolean.valueOf(this.terminal.getProperty("showIndivBtn"));
        this.btnCash.setVisible(isHideCashPayment == false);
        this.btnCreditCard.setVisible(isHideCardPayment == false);
        this.btnGift.setVisible(isHideGiftCardPayment == false);
        if (!isHideCustomPayment.booleanValue() && isShowIndivBtn.booleanValue()) {
            this.btnOther.setVisible(false);
            List<CustomPayment> custompPayments = CustomPaymentDAO.getInstance().findAll();
            for (final CustomPayment customPayment : custompPayments) {
                if (!customPayment.isEnable().booleanValue()) continue;
                PosButton button = new PosButton("<html><body><center>" + customPayment.getName() + "</center></body></html>");
                button.setPreferredSize(new Dimension(120, 80));
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            PaymentView.this.ticketProcessor.payByCustomPayment(customPayment, PaymentView.this.getTenderAmountFieldValue());
                        }
                        catch (PosException x) {
                            POSMessageDialog.showError(PaymentView.this.getParent(), x.getMessage());
                        }
                        catch (Exception x) {
                            POSMessageDialog.showError(PaymentView.this.getParent(), x.getMessage(), x);
                        }
                    }
                });
                this.actionButtonPanel.add((Component)button, "grow,w " + this.width + "!");
            }
        } else if (!isHideCustomPayment.booleanValue()) {
            this.btnOther.setVisible(isHideCustomPayment == false);
        } else {
            this.btnOther.setVisible(isHideCustomPayment == false);
        }
        this.doAddCancelButton();
    }

    private void doAddCancelButton() {
        PosButton btnHold = new PosButton(POSConstants.HOLD_BUTTON_TEXT.toUpperCase());
        this.actionButtonPanel.add((Component)btnHold, "grow,w " + this.width + "!");
        btnHold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaymentView.this.ticketProcessor.doHoldTicket();
            }
        });
        this.btnCancel = new PosButton("RETURN");
        this.actionButtonPanel.add((Component)this.btnCancel, "grow,w " + this.width + "!");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PaymentView.this.btnCancelActionPerformed(evt);
            }
        });
    }

    protected List<MultiCurrencyTenderDialog.PaymentByCurrency> getMulticurrencyPayment(List<Currency> currencyList) {
        MultiCurrencyTenderDialog dialog = new MultiCurrencyTenderDialog(this.getTicket(), currencyList);
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return null;
        }
        this.txtTenderedAmount.setText(NumberUtil.formatNumber(dialog.getTenderedAmount()));
        return dialog.getPaymentByCurrencies();
    }

    protected void doSetGratuity() {
        this.ticketProcessor.doSetGratuity();
    }

    protected void doTaxExempt() {
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.ticketProcessor.cancelPayment();
    }

    public void updateView() {
        double dueAmount;
        if (this.ticket == null) {
            this.clearFields();
            return;
        }
        double dueAmountToShow = dueAmount = this.getDueAmount();
        this.txtDueAmount.setText(NumberUtil.formatNumber(dueAmountToShow, true));
        this.txtTenderedAmount.setText(NumberUtil.formatNumber(dueAmount, true));
    }

    public double getTenderedAmount() throws ParseException {
        double doubleValue = NumberUtil.parse(this.txtTenderedAmount.getText()).doubleValue();
        return doubleValue;
    }

    protected double getPaidAmount() {
        return this.getTicket().getPaidAmount();
    }

    protected double getDueAmount() {
        return this.getTicket().getDueAmount();
    }

    protected double getAdvanceAmount() {
        Gratuity gratuity = this.getTicket().getGratuity();
        return gratuity != null ? gratuity.getAmount() : 0.0;
    }

    protected double getTotalGratuity() {
        return this.getTicket().getPaidAmount();
    }

    public void setDefaultFocus() {
        this.txtTenderedAmount.requestFocus();
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
        this.ticketProcessor.setTicket(ticket);
        this.updateView();
    }

    public SettleTicketProcessor getTicketProcessor() {
        return this.ticketProcessor;
    }

    public void setTicketProcessor(SettleTicketProcessor ticketProcessor) {
        this.ticketProcessor = ticketProcessor;
    }

    private double getDueAmountFieldValue() {
        try {
            String dueAmountString = this.txtDueAmount.getText();
            NumberFormat format = NumberFormat.getNumberInstance();
            Number number = format.parse(dueAmountString);
            double dueAmount = number.doubleValue();
            if (dueAmount <= 0.0) {
                throw new PosException("Invalid due amount");
            }
            return dueAmount;
        }
        catch (Exception e) {
            throw new PosException("Invalid due amount");
        }
    }

    private double getTenderAmountFieldValue() {
        try {
            String tenderedAmountString = this.txtTenderedAmount.getText();
            NumberFormat format = NumberFormat.getNumberInstance();
            Number number = format.parse(tenderedAmountString);
            double tenderAmount = number.doubleValue();
            if (tenderAmount < 0.0) {
                throw new PosException("Invalid tender amount");
            }
            return tenderAmount;
        }
        catch (Exception e) {
            throw new PosException("Invalid tender amount");
        }
    }

    private void doPayByCash() {
        try {
            if (this.isTicketEmpty()) {
                return;
            }
            double terderAmount = this.getTenderAmountFieldValue();
            if (Application.getInstance().getTerminal().isEnableMultiCurrency().booleanValue()) {
                Currency mainCurrency;
                User currentUser = Application.getCurrentUser();
                CashDrawer cashDrawer = currentUser.getActiveDrawerPullReport();
                CashBreakdown item = cashDrawer.getCurrencyBalance(mainCurrency = CurrencyUtil.getMainCurrency());
                if (item == null) {
                    item = new CashBreakdown();
                    item.setCurrency(mainCurrency);
                    cashDrawer.addTocashBreakdownList(item);
                    item.setCashDrawer(cashDrawer);
                }
                double amount = 0.0;
                Ticket ticket = this.getTicket();
                amount = terderAmount >= ticket.getDueAmount() ? ticket.getDueAmount() : terderAmount;
                item.setBalance(NumberUtil.roundToThreeDigit(item.getBalance() + amount));
                if (terderAmount > 0.0) {
                    ticket.addProperty(mainCurrency.getName(), String.valueOf(terderAmount));
                }
                if (terderAmount - amount > 0.0) {
                    ticket.addProperty(mainCurrency.getName() + "_CASH_BACK", String.valueOf(terderAmount - ticket.getDueAmount()));
                }
            }
            this.doSelectCustomer();
            this.ticketProcessor.doSettle(PaymentType.CASH, terderAmount);
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.refreshableView);
        }
        catch (PosException e) {
            POSMessageDialog.showError(this.getParent(), e.getMessage());
        }
        catch (CustomerSelectionChangeException e) {
            POSMessageDialog.showMessage(this.getParent(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(this.getParent(), e.getMessage(), e);
        }
    }

    private boolean isTicketEmpty() {
        if (this.getTicket().getTicketItems().size() <= 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Ticket is empty!");
            return true;
        }
        return false;
    }

    private void doPayByMulticurrencyCash() {
        try {
            if (this.isTicketEmpty()) {
                return;
            }
            List<Currency> currencyList = CurrencyUtil.getAllCurrency();
            List<MultiCurrencyTenderDialog.PaymentByCurrency> paymentByCurrencyList = null;
            if (currencyList.size() > 0 && (paymentByCurrencyList = this.getMulticurrencyPayment(currencyList)) == null) {
                return;
            }
            double terderAmount = this.getTenderAmountFieldValue();
            this.doSelectCustomer();
            this.ticketProcessor.doSettle(PaymentType.CASH, terderAmount, paymentByCurrencyList);
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.refreshableView);
        }
        catch (PosException e) {
            POSMessageDialog.showError(this.getParent(), e.getMessage());
        }
        catch (CustomerSelectionChangeException e) {
            POSMessageDialog.showMessage(this.getParent(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(this.getParent(), e.getMessage(), e);
        }
    }

    private void doPayBy(PaymentType paymentType) {
        try {
            Customer customer;
            if (this.isTicketEmpty()) {
                return;
            }
            double terderAmount = this.getTenderAmountFieldValue();
            this.doSelectCustomer();
            if (paymentType == PaymentType.MEMBER_ACCOUNT && (customer = this.ticket.getCustomer()) == null) {
                return;
            }
            this.ticketProcessor.doSettle(paymentType, terderAmount);
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(this.getParent(), this.refreshableView);
        }
        catch (PosException e) {
            POSMessageDialog.showError(this.getParent(), e.getMessage());
        }
        catch (CustomerSelectionChangeException e) {
            POSMessageDialog.showMessage(this.getParent(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(this.getParent(), e.getMessage(), e);
        }
    }

    private void fillPredefinedAmount(ActionEvent e) {
        try {
            DecimalFormat format = new DecimalFormat("##.00");
            PosButton button = (PosButton)e.getSource();
            String command = button.getActionCommand();
            if (command.equals("exactAmount")) {
                double dueAmount = this.getDueAmount();
                this.txtTenderedAmount.setText(NumberUtil.formatNumber(dueAmount));
            } else if (command.equals("nextAmount")) {
                double amount = Math.ceil(this.getDueAmountFieldValue());
                this.txtTenderedAmount.setText(String.valueOf(format.format(amount)));
            } else {
                if (this.clearPreviousAmount) {
                    this.txtTenderedAmount.setText(ZERO);
                    this.clearPreviousAmount = false;
                }
                double tenderAmount = this.getTenderAmountFieldValue();
                double inputValue = Double.parseDouble(command);
                double newAmount = tenderAmount + inputValue;
                this.txtTenderedAmount.setText(String.valueOf(format.format(newAmount)));
            }
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.refreshableView);
        }
        catch (PosException ex) {
            POSMessageDialog.showError(this.getParent(), ex.getMessage());
        }
        catch (Exception ex) {
            POSMessageDialog.showError(this.getParent(), ex.getMessage(), ex);
        }
    }

    public void doSelectCustomer() {
        if (this.ticket.getCustomer() != null) {
            return;
        }
        CustomerSelectorDialog dialog = CustomerSelectorFactory.createCustomerSelectorDialog(this.ticket.getOrderType());
        dialog.setCreateNewTicket(false);
        if (this.ticket != null) {
            dialog.setTicket(this.ticket);
        }
        dialog.openUndecoratedFullScreen();
        if (dialog.isCanceled()) {
            if (this.ticket.getOrderType().isRequiredCustomerData().booleanValue()) {
                throw new PosException(Messages.getString("PaymentView.8"));
            }
            return;
        }
        Customer customer = dialog.getSelectedCustomer();
        if (customer == null && this.ticket.getOrderType().isRequiredCustomerData().booleanValue()) {
            throw new PosException(Messages.getString("PaymentView.8"));
        }
        this.ticket.setCustomer(customer);
        OrderController.saveOrder(this.ticket);
        this.ticketProcessor.doInformListenerPaymentUpdate();
        throw new CustomerSelectionChangeException(POSConstants.CUSTOMER + " " + customer.getName() + " " + Messages.getString("PaymentView.57"));
    }

    public void doPaymentByPlugin(PaymentPlugin paymentPlugin) {
        try {
            if (this.isTicketEmpty()) {
                return;
            }
            double terderAmount = this.getTenderAmountFieldValue();
            if (Application.getInstance().getTerminal().isEnableMultiCurrency().booleanValue()) {
                Currency mainCurrency;
                User currentUser = Application.getCurrentUser();
                CashDrawer cashDrawer = currentUser.getActiveDrawerPullReport();
                CashBreakdown item = cashDrawer.getCurrencyBalance(mainCurrency = CurrencyUtil.getMainCurrency());
                if (item == null) {
                    item = new CashBreakdown();
                    item.setCurrency(mainCurrency);
                    cashDrawer.addTocashBreakdownList(item);
                    item.setCashDrawer(cashDrawer);
                }
                double amount = 0.0;
                Ticket ticket = this.getTicket();
                amount = terderAmount >= ticket.getDueAmount() ? ticket.getDueAmount() : terderAmount;
                item.setBalance(NumberUtil.roundToThreeDigit(item.getBalance() + amount));
                if (terderAmount > 0.0) {
                    ticket.addProperty(mainCurrency.getName(), String.valueOf(terderAmount));
                }
                if (terderAmount - amount > 0.0) {
                    ticket.addProperty(mainCurrency.getName() + "_CASH_BACK", String.valueOf(terderAmount - ticket.getDueAmount()));
                }
            }
            paymentPlugin.pay(this.getTicket(), terderAmount, this.ticketProcessor);
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.refreshableView);
        }
        catch (PosException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
        catch (CustomerSelectionChangeException e) {
            POSMessageDialog.showMessage(this.getParent(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doOpenTaxExemptDialog() {
        TaxExemptDialog taxExemptDialog = new TaxExemptDialog();
        taxExemptDialog.setTitle("Tax exempt");
        taxExemptDialog.setSize(740, 385);
        taxExemptDialog.open();
        if (taxExemptDialog.isCanceled()) {
            return;
        }
        String taxExemptId = taxExemptDialog.getTaxExemptId();
        String taxExemptOrgName = taxExemptDialog.getTaxExemptName();
        Ticket ticket = this.getTicket();
        ticket.addProperty("tax_exempt_id", taxExemptId);
        ticket.addProperty("tax_exempt_org_name", taxExemptOrgName);
        ticket.setTaxExempt(true);
        ticket.calculatePrice();
        this.ticketProcessor.doInformListenerPaymentUpdate();
        ActionHistoryDAO.addActionHistory(ticket, "Tax exempt", null);
    }

    private void clearFields() {
        this.txtDueAmount.setText(ZERO);
        this.txtTenderedAmount.setText(ZERO);
    }
}

