/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.actions.TaxExemptAction;
import com.floreantpos.config.CardConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.TicketUtil;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.ticket.TicketViewerTableChangeListener;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.payment.AuthorizationDialog;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.ui.views.payment.PaymentListener;
import com.floreantpos.ui.views.payment.PaymentView;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.jidesoft.swing.TitledSeparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class SettleTicketDialog
extends POSDialog
implements PaymentListener,
TicketViewerTableChangeListener,
RefreshableView {
    private PaymentView paymentView;
    private TicketViewerTable ticketViewerTable;
    private JScrollPane ticketScrollPane;
    private Ticket ticket;
    private JTextField tfSubtotal;
    private JTextField tfDiscount;
    private JTextField tfRefundAmount = new JTextField();
    private JTextField tfPaidAmount = new JTextField();
    private JTextField tfDeliveryCharge;
    private JTextField tfTax;
    private JTextField tfServiceCharge;
    private JTextField tfTotal;
    private JTextField tfGratuity;
    private JPanel bottomPanel;
    private JPanel discountInfoPanel;
    private JScrollPane scrollPane;
    private JPanel centerPanel;
    private SettleTicketProcessor ticketProcessor = null;
    private JTable discountTable;
    private TicketDiscountTableModel discountTableModel;
    private JPanel transactionListPanel;
    private JTable transactionsTable;
    private TransactionDataTableModel transactionTableModel;
    private JLabel lblRefundAmount;
    private JLabel labelTicketNumber;
    private JButton btnTaxExempt;

    public SettleTicketDialog(Ticket ticket, User currentUser) {
        this.ticket = ticket;
        this.ticketProcessor = new SettleTicketProcessor(currentUser, this);
        if (ticket.getOrderType().isConsolidateItemsInReceipt().booleanValue()) {
            ticket.consolidateTicketItems();
        }
        this.setTitle(Messages.getString("SettleTicketDialog.6"));
        this.getContentPane().setLayout(new BorderLayout());
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.centerPanel = new JPanel(new BorderLayout(5, 5));
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 3, 5));
        this.ticketViewerTable = new TicketViewerTable(ticket);
        this.ticketViewerTable.getModel().addTicketDataChangeListener(this);
        this.ticketViewerTable.setVisibleDeleteButton(0);
        this.ticketViewerTable.getModel().setEditable(true);
        this.ticketScrollPane = new PosScrollPane(this.ticketViewerTable);
        TitledSeparator ticketInfoTitled = new TitledSeparator((JComponent)this.createTicketInfoPanel(), 0);
        this.ticketScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        this.ticketViewerTable.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 35));
        this.bottomPanel = new JPanel(new BorderLayout());
        JPanel summaryPanel = new JPanel(new BorderLayout());
        summaryPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.bottomPanel.add((Component)summaryPanel, "Center");
        this.discountInfoPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        this.scrollPane = new JScrollPane(this.discountInfoPanel);
        this.scrollPane.setPreferredSize(PosUIManager.getSize(0, 70));
        this.scrollPane.setVisible(false);
        this.bottomPanel.add((Component)this.scrollPane, "North");
        this.centerPanel.add((Component)ticketInfoTitled, "North");
        this.centerPanel.add((Component)this.ticketScrollPane, "Center");
        this.centerPanel.add((Component)this.bottomPanel, "South");
        this.paymentView = new PaymentView(this.ticketProcessor, this);
        summaryPanel.add((Component)this.createTotalViewerPanel(), "East");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.getContentPane().add((Component)this.paymentView, "East");
        this.createTicketDiscountPanel();
        this.createTransactionListPanel();
        summaryPanel.add((Component)this.transactionListPanel, "Center");
        this.ticketProcessor.addPaymentListener(this);
        this.updateView();
        this.paymentView.setTicket(ticket);
        this.ticketProcessor.setTicket(ticket);
        this.paymentView.setDefaultFocus();
        this.paymentView.updateView();
    }

    public void updateView() {
        if (this.ticket == null) {
            this.tfSubtotal.setText("");
            this.tfDiscount.setText("");
            this.tfDeliveryCharge.setText("");
            this.tfTax.setText("");
            this.tfServiceCharge.setText("");
            this.tfRefundAmount.setText("");
            this.tfPaidAmount.setText("");
            this.tfTotal.setText("");
            this.tfGratuity.setText("");
            return;
        }
        this.updateTicketTokenText();
        this.tfSubtotal.setText(NumberUtil.formatNumber(this.ticket.getSubtotalAmount(), true));
        this.tfDiscount.setText(NumberUtil.formatNumber(this.ticket.getDiscountAmount(), true));
        this.tfDeliveryCharge.setText(NumberUtil.formatNumber(this.ticket.getDeliveryCharge()));
        this.tfServiceCharge.setText(NumberUtil.formatNumberAcceptNegative(this.ticket.getServiceCharge()));
        Store store = DataProvider.get().getStore();
        if (POSUtil.getBoolean(store.getProperty("show_tax_exempt_button.in_settlement_screen"))) {
            this.btnTaxExempt.setVisible(Boolean.TRUE);
            if (this.ticket.isTaxExempt().booleanValue()) {
                this.btnTaxExempt.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.UNDO, (float)15.0f));
            } else {
                this.btnTaxExempt.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.CLEAR, (float)15.0f));
            }
        } else {
            this.btnTaxExempt.setVisible(Boolean.FALSE);
        }
        if (Application.getInstance().isPriceIncludesTax()) {
            this.tfTax.setText(Messages.getString("TicketView.35"));
        } else {
            this.tfTax.setText(NumberUtil.formatNumber(this.ticket.getTaxAmount(), true));
        }
        if (this.ticket.getGratuity() != null) {
            this.tfGratuity.setText(NumberUtil.formatNumber(this.ticket.getGratuity().getAmount()));
        } else {
            this.tfGratuity.setText("0.00");
        }
        Double refundAmount = this.ticket.getRefundAmount();
        this.tfRefundAmount.setText(NumberUtil.formatNumber(refundAmount));
        this.tfPaidAmount.setText(NumberUtil.formatNumber(this.ticket.getPaidAmount()));
        this.tfTotal.setText(NumberUtil.formatNumber(this.ticket.getTotalAmountWithTips(), true));
        this.lblRefundAmount.setVisible(refundAmount > 0.0);
        this.tfRefundAmount.setVisible(refundAmount > 0.0);
        this.rendererTicketDiscounts();
        this.rendererTransactions();
    }

    private JPanel createTicketInfoPanel() {
        JLabel lblTable = new JLabel();
        Font bigBoldFont = lblTable.getFont().deriveFont(1);
        this.labelTicketNumber = new JLabel();
        Font bigFont = this.labelTicketNumber.getFont().deriveFont(1);
        this.labelTicketNumber.setFont(bigFont);
        lblTable.setFont(bigBoldFont);
        lblTable.setText(", " + Messages.getString("SettleTicketDialog.3"));
        JLabel labelTableNumber = new JLabel();
        labelTableNumber.setFont(bigFont);
        if (!this.getTerminal().isShowTableNumber()) {
            labelTableNumber.setText(" " + this.ticket.getTableNames());
        } else {
            labelTableNumber.setText(" " + this.ticket.getTableNameDisplay());
            if (this.ticket.getTableNumbers() == null || this.ticket.getTableNumbers().isEmpty()) {
                labelTableNumber.setVisible(false);
                lblTable.setVisible(false);
            }
        }
        JLabel lblCustomer = new JLabel();
        lblCustomer.setFont(bigBoldFont);
        lblCustomer.setText(", " + Messages.getString("SettleTicketDialog.10") + ": ");
        JLabel labelCustomer = new JLabel();
        labelCustomer.setFont(bigFont);
        labelCustomer.setText(this.ticket.getProperty("CUSTOMER_NAME") + " " + this.ticket.getProperty("CUSTOMER_LAST_NAME"));
        if (this.ticket.getProperty("CUSTOMER_NAME") == null) {
            labelCustomer.setVisible(false);
            lblCustomer.setVisible(false);
        }
        TransparentPanel ticketInfoPanel = new TransparentPanel((LayoutManager)new MigLayout("hidemode 3,ins 0", "[]0[]0[]0[]0[]0[]", "[]"));
        ticketInfoPanel.add(this.labelTicketNumber);
        ticketInfoPanel.add(lblTable);
        ticketInfoPanel.add(labelTableNumber);
        ticketInfoPanel.add(lblCustomer);
        ticketInfoPanel.add(labelCustomer);
        Color color = UIManager.getColor("TitledBorder.titleColor");
        this.labelTicketNumber.setForeground(color);
        lblTable.setForeground(color);
        labelTableNumber.setForeground(color);
        lblCustomer.setForeground(color);
        labelCustomer.setForeground(color);
        return ticketInfoPanel;
    }

    private void updateTicketTokenText() {
        String ticketName = Messages.getString("TicketView.37");
        if (this.ticket.getId() != null) {
            this.labelTicketNumber.setText(ticketName + this.ticket.getId());
        } else {
            this.labelTicketNumber.setText(Messages.getString("SettleTicketDialog.13"));
        }
    }

    public void createTransactionListPanel() {
        this.transactionListPanel = new JPanel(new BorderLayout());
        this.transactionsTable = new JTable();
        this.transactionsTable.setGridColor(Color.LIGHT_GRAY);
        this.transactionsTable.setCellSelectionEnabled(false);
        this.transactionsTable.setColumnSelectionAllowed(false);
        this.transactionsTable.setRowSelectionAllowed(false);
        this.transactionsTable.setAutoscrolls(true);
        this.transactionsTable.setRowHeight(PosUIManager.getSize(44));
        this.transactionsTable.setShowVerticalLines(false);
        this.transactionsTable.setIntercellSpacing(new Dimension(0, 2));
        this.transactionsTable.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.transactionsTable.setFocusable(false);
        this.transactionsTable.getTableHeader().setPreferredSize(new Dimension(0, 0));
        this.transactionsTable.getTableHeader().setVisible(false);
        this.transactionsTable.setAutoResizeMode(4);
        this.transactionTableModel = new TransactionDataTableModel();
        this.transactionsTable.setModel(this.transactionTableModel);
        this.transactionsTable.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                this.setHorizontalAlignment(4);
                if (isSelected) {
                    return rendererComponent;
                }
                rendererComponent.setBackground(table.getBackground());
                return rendererComponent;
            }

            @Override
            protected void setValue(Object value) {
                if (value == null) {
                    this.setText("");
                    return;
                }
                String text = value.toString();
                if (value instanceof Double || value instanceof Float) {
                    text = NumberUtil.formatNumberAcceptNegative(((Number)value).doubleValue());
                }
                this.setText(text);
            }
        });
        this.setColumnWidth(1, PosUIManager.getSize(50), this.transactionsTable);
        this.setColumnWidth(2, PosUIManager.getSize(90), this.transactionsTable);
        this.setColumnWidth(3, PosUIManager.getSize(50), this.transactionsTable);
        PosAction captureAction = new PosAction(){
            int selectedRow = -1;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.selectedRow = Integer.parseInt(e.getActionCommand());
                super.actionPerformed(e);
            }

            @Override
            public void execute() {
                if (this.selectedRow == -1) {
                    return;
                }
                PosTransaction item = (PosTransaction)SettleTicketDialog.this.transactionTableModel.getRowData(this.selectedRow);
                if (item == null) {
                    return;
                }
                SettleTicketDialog.this.doAuthorize(item);
            }
        };
        captureAction.setRequiredPermission(UserPermission.AUTHORIZE_TICKETS);
        PosAction deleteAction = new PosAction(){
            int selectedRow = -1;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.selectedRow = Integer.parseInt(e.getActionCommand());
                super.actionPerformed(e);
            }

            @Override
            public void execute() {
                if (this.selectedRow == -1) {
                    return;
                }
                PosTransaction transaction = (PosTransaction)SettleTicketDialog.this.transactionTableModel.getRowData(this.selectedRow);
                if (transaction == null) {
                    return;
                }
                SettleTicketDialog.this.doReversePayment(transaction, false);
            }
        };
        deleteAction.setRequiredPermission(UserPermission.VOID_PAYMENTS);
        ButtonColumn btnDelete = new ButtonColumn(this.transactionsTable, deleteAction, 3){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                PosButton button = (PosButton)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                button.setText("X");
                button.setHorizontalAlignment(0);
                return button;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return super.getTableCellEditorComponent(table, value, false, row, column);
            }
        };
        ButtonColumn btnCapture = new ButtonColumn(this.transactionsTable, captureAction, 2){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                PosButton button = (PosButton)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                PosTransaction transaction = (PosTransaction)SettleTicketDialog.this.transactionTableModel.getRowData(row);
                if (transaction.isCard() && transaction.isAuthorizable().booleanValue() && !transaction.isCaptured().booleanValue()) {
                    button.setText("<html>" + Messages.getString("SettleTicketDialog.15") + "</html>");
                    button.setHorizontalAlignment(0);
                    button.setVerticalAlignment(1);
                    return button;
                }
                return new JLabel("");
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                PosTransaction transaction = (PosTransaction)SettleTicketDialog.this.transactionTableModel.getRowData(row);
                if (transaction.isCard() && transaction.isAuthorizable().booleanValue() && !transaction.isCaptured().booleanValue()) {
                    return super.getTableCellEditorComponent(table, value, false, row, column);
                }
                return new JLabel("");
            }
        };
        MatteBorder selectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, this.transactionsTable.getBackground());
        MatteBorder unselectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, this.transactionsTable.getBackground());
        PosButton sampleButton = new PosButton();
        CompoundBorder border1 = new CompoundBorder(selectedBorder, sampleButton.getBorder());
        CompoundBorder border2 = new CompoundBorder(unselectedBorder, sampleButton.getBorder());
        btnCapture.setUnselectedBorder(border1);
        btnCapture.setFocusBorder(border2);
        btnDelete.setUnselectedBorder(border1);
        btnDelete.setFocusBorder(border2);
        PosScrollPane scrollPane = new PosScrollPane(this.transactionsTable);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.getString("SettleTicketDialog.24")), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
        this.transactionListPanel.add(scrollPane);
        scrollPane.setPreferredSize(PosUIManager.getSize(0, 130));
        this.transactionListPanel.setVisible(false);
        this.rendererTransactions();
    }

    private void doReversePayment(PosTransaction transaction, boolean forceVoid) {
        try {
            boolean reverseGiftCardBalance = false;
            if (transaction.getPaymentTypeString().equals(PaymentType.MEMBER_ACCOUNT.name())) {
                if (this.ticket.isAnyItemCloudSynced()) {
                    POSMessageDialog.showError(this, Messages.getString("SettleTicketDialog.23"));
                    return;
                }
            } else if (transaction.isCloudSynced().booleanValue()) {
                POSMessageDialog.showError(this, Messages.getString("SettleTicketDialog.23"));
                return;
            }
            if (this.ticket.isRefunded().booleanValue()) {
                POSMessageDialog.showError(this, Messages.getString("SettleTicketDialog.25"));
                return;
            }
            if (!forceVoid && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketDialog.26"), POSConstants.CONFIRM) != 0) {
                return;
            }
            if (transaction.getGiftCardBalanceAddInfo() != null && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketDialog.31"), POSConstants.CONFIRM) == 0) {
                reverseGiftCardBalance = true;
            }
            TicketDAO.getInstance().reversePayment(this.ticket, transaction, forceVoid, reverseGiftCardBalance);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketDialog.27"));
            this.ticketDataChanged();
        }
        catch (Exception e) {
            if (transaction.isCard()) {
                if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketDialog.28"), POSConstants.CONFIRM) == 0) {
                    this.doReversePayment(transaction, true);
                }
            }
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doAuthorize(PosTransaction transaction) {
        try {
            if (!this.confirmTips(transaction)) {
                return;
            }
            ArrayList<PosTransaction> transactions = new ArrayList<PosTransaction>();
            transactions.add(transaction);
            AuthorizationDialog authorizingDialog = new AuthorizationDialog(this, transactions);
            authorizingDialog.setVisible(true);
            TicketUtil.closeTicketIfApplicable(this.ticket);
            TicketDAO.getInstance().saveOrUpdate(this.ticket);
            if (this.ticket.isClosed().booleanValue()) {
                this.dispose();
            } else {
                this.updateView();
            }
        }
        catch (Exception e) {
            this.ticket = TicketDAO.getInstance().loadFullTicket(this.ticket.getId());
            this.updateView();
            POSMessageDialog.showError(this, e.getMessage());
            PosLog.error(this.getClass(), e);
        }
    }

    private boolean confirmTips(PosTransaction transaction) {
        double oldTipsAmount = transaction.getTipsAmount();
        double newTipsAmount = NumberSelectionDialog2.takeDoubleInput(Messages.getString("EnterTipsAmount"), oldTipsAmount, true);
        if (newTipsAmount == -1.0) {
            return false;
        }
        transaction.setTipsAmount(newTipsAmount);
        transaction.setAmount(transaction.getAmount() - oldTipsAmount + newTipsAmount);
        if (this.ticket.hasGratuity()) {
            double ticketTipsAmount = this.ticket.getGratuity().getAmount();
            double ticketPaidAmount = this.ticket.getPaidAmount();
            double newTicketTipsAmount = ticketTipsAmount - oldTipsAmount + newTipsAmount;
            double newTicketPaidAmount = ticketPaidAmount - oldTipsAmount + newTipsAmount;
            this.ticket.setGratuityAmount(newTicketTipsAmount);
            this.ticket.setPaidAmount(newTicketPaidAmount);
        } else {
            this.ticket.setGratuityAmount(newTipsAmount);
            this.ticket.setPaidAmount(this.ticket.getPaidAmount() + newTipsAmount);
        }
        this.ticket.calculatePrice();
        return true;
    }

    public void createTicketDiscountPanel() {
        this.discountInfoPanel = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 2 0 0 0"));
        this.discountTable = new JTable();
        this.discountTable.setGridColor(Color.LIGHT_GRAY);
        this.discountTable.setCellSelectionEnabled(false);
        this.discountTable.setColumnSelectionAllowed(false);
        this.discountTable.setRowSelectionAllowed(false);
        this.discountTable.setAutoscrolls(true);
        this.discountTable.setRowHeight(PosUIManager.getSize(40));
        this.discountTable.setShowGrid(true);
        this.discountTable.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.discountTable.setFocusable(false);
        this.discountTable.getTableHeader().setPreferredSize(new Dimension(0, 0));
        this.discountTable.getTableHeader().setVisible(false);
        this.discountTable.setAutoResizeMode(4);
        this.discountTableModel = new TicketDiscountTableModel();
        this.discountTable.setModel(this.discountTableModel);
        this.discountTable.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                this.setHorizontalAlignment(4);
                if (isSelected) {
                    return rendererComponent;
                }
                rendererComponent.setBackground(table.getBackground());
                return rendererComponent;
            }

            @Override
            protected void setValue(Object value) {
                if (value == null) {
                    this.setText("");
                    return;
                }
                String text = value.toString();
                if (value instanceof Double || value instanceof Float) {
                    text = NumberUtil.formatNumberAcceptNegative(((Number)value).doubleValue());
                }
                this.setText(text);
            }
        });
        this.setColumnWidth(1, PosUIManager.getSize(50), this.discountTable);
        this.setColumnWidth(2, PosUIManager.getSize(50), this.discountTable);
        JLabel lblDiscountTitle = new JLabel(Messages.getString("SettleTicketDialog.30"));
        this.discountInfoPanel.add((Component)lblDiscountTitle, "wrap");
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = Integer.parseInt(e.getActionCommand());
                TicketDiscount item = (TicketDiscount)SettleTicketDialog.this.discountTableModel.getRowData(row);
                List<TicketDiscount> discounts = SettleTicketDialog.this.ticket.getDiscounts();
                if (discounts != null) {
                    Iterator<TicketDiscount> iterator = discounts.iterator();
                    while (iterator.hasNext()) {
                        TicketDiscount ticketDiscount = iterator.next();
                        if (ticketDiscount != item) continue;
                        iterator.remove();
                        ActionHistoryDAO.addDiscountRemovedActionHistory(SettleTicketDialog.this.ticket, ticketDiscount);
                        break;
                    }
                    SettleTicketDialog.this.ticketDataChanged();
                }
                SettleTicketDialog.this.ticket.setDiscounts(discounts);
            }
        };
        ButtonColumn coloum = new ButtonColumn(this.discountTable, action, 0){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JPanel panel = (JPanel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                int verticalGap = PosUIManager.getSize(15);
                int horizontalGap = PosUIManager.getSize(2);
                PosButton button = (PosButton)panel.getComponent(0);
                button.setOpaque(false);
                button.setBorder(new EmptyBorder(verticalGap, horizontalGap, verticalGap, horizontalGap));
                button.setIcon(IconFactory.getIcon("/ui_icons/", "delete-icon.png"));
                table.setRowHeight(row, table.getRowHeight(0));
                return panel;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return super.getTableCellEditorComponent(table, value, false, row, column);
            }
        };
        coloum.showColumnValueInLabel(true);
        JScrollPane scrollPane = new JScrollPane(this.discountTable);
        this.discountInfoPanel.add((Component)scrollPane, "newline,grow,span");
        scrollPane.setPreferredSize(PosUIManager.getSize(0, 70));
        this.discountInfoPanel.setVisible(false);
        this.bottomPanel.add((Component)this.discountInfoPanel, "North");
        this.rendererTicketDiscounts();
    }

    private void refreshOrderView() {
        if (OrderView.getInstance().isVisible()) {
            OrderView.getInstance().setCurrentTicket(this.ticket);
        }
    }

    private void setColumnWidth(int columnNumber, int width, JTable table) {
        TableColumn column = table.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    private void rendererTicketDiscounts() {
        List<TicketDiscount> discounts = this.ticket.getDiscounts();
        this.discountTableModel.setRows(discounts);
        this.discountInfoPanel.setVisible(discounts != null && discounts.size() > 0);
        this.centerPanel.revalidate();
        this.centerPanel.repaint();
        this.repaint();
    }

    private void rendererTransactions() {
        Set<PosTransaction> transactions = this.ticket.getTransactions();
        if (transactions == null || transactions.size() == 0) {
            return;
        }
        ArrayList<PosTransaction> rows = new ArrayList<PosTransaction>();
        for (PosTransaction posTransaction : transactions) {
            if (posTransaction.isVoided().booleanValue() || posTransaction instanceof RefundTransaction) continue;
            rows.add(posTransaction);
        }
        Collections.sort(rows, new Comparator<PosTransaction>(){

            @Override
            public int compare(PosTransaction o1, PosTransaction o2) {
                return o1.getTransactionTime().compareTo(o2.getTransactionTime());
            }
        });
        this.transactionTableModel.setRows(rows);
        this.transactionListPanel.setVisible(rows.size() > 0);
        this.centerPanel.revalidate();
        this.centerPanel.repaint();
        this.repaint();
    }

    private JPanel createTotalViewerPanel() {
        JLabel lblSubtotal = new JLabel();
        lblSubtotal.setHorizontalAlignment(4);
        lblSubtotal.setText(POSConstants.SUBTOTAL + ": " + CurrencyUtil.getCurrencySymbol());
        this.tfSubtotal = new JTextField(10);
        this.tfSubtotal.setHorizontalAlignment(11);
        this.tfSubtotal.setEditable(false);
        JLabel lblDiscount = new JLabel();
        lblDiscount.setHorizontalAlignment(4);
        lblDiscount.setText(Messages.getString("TicketView.9") + " " + CurrencyUtil.getCurrencySymbol());
        this.tfDiscount = new JTextField(10);
        this.tfDiscount.setHorizontalAlignment(11);
        this.tfDiscount.setEditable(false);
        this.tfDiscount.setText(this.ticket.getDiscountAmount().toString());
        JLabel lblDeliveryCharge = new JLabel();
        lblDeliveryCharge.setHorizontalAlignment(4);
        lblDeliveryCharge.setText(Messages.getString("SettleTicketDialog.1") + " " + CurrencyUtil.getCurrencySymbol());
        this.tfDeliveryCharge = new JTextField(10);
        this.tfDeliveryCharge.setHorizontalAlignment(11);
        this.tfDeliveryCharge.setEditable(false);
        JLabel lblTax = new JLabel();
        lblTax.setHorizontalAlignment(4);
        lblTax.setText(POSConstants.TAX + ": " + CurrencyUtil.getCurrencySymbol());
        this.btnTaxExempt = new JButton();
        this.btnTaxExempt.setVisible(false);
        this.btnTaxExempt.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.CLEAR, (float)15.0f));
        this.btnTaxExempt.addActionListener(e -> this.doPerformTaxExempt());
        this.tfTax = new JTextField(10);
        this.tfTax.setEditable(false);
        this.tfTax.setHorizontalAlignment(11);
        JLabel lblServiceCharge = new JLabel();
        lblServiceCharge.setHorizontalAlignment(4);
        lblServiceCharge.setText(Messages.getString("SettleTicketDialog.2") + " " + CurrencyUtil.getCurrencySymbol());
        this.tfServiceCharge = new JTextField(10);
        this.tfServiceCharge.setEditable(false);
        this.tfServiceCharge.setHorizontalAlignment(11);
        this.tfRefundAmount.setEditable(false);
        this.tfRefundAmount.setHorizontalAlignment(11);
        this.tfPaidAmount.setEditable(false);
        this.tfPaidAmount.setHorizontalAlignment(11);
        JLabel lblGratuity = new JLabel();
        lblGratuity.setHorizontalAlignment(4);
        lblGratuity.setText(Messages.getString("SettleTicketDialog.5") + ": " + CurrencyUtil.getCurrencySymbol());
        this.tfGratuity = new JTextField(10);
        this.tfGratuity.setEditable(false);
        this.tfGratuity.setHorizontalAlignment(11);
        JLabel lblTotal = new JLabel();
        lblTotal.setFont(lblTotal.getFont().deriveFont(1, PosUIManager.getFontSize(18)));
        lblTotal.setHorizontalAlignment(4);
        lblTotal.setText(POSConstants.TOTAL + ": " + CurrencyUtil.getCurrencySymbol());
        this.tfTotal = new JTextField(10);
        this.tfTotal.setFont(this.tfTotal.getFont().deriveFont(1, PosUIManager.getFontSize(18)));
        this.tfTotal.setHorizontalAlignment(11);
        this.tfTotal.setEditable(false);
        TransparentPanel ticketAmountPanel = new TransparentPanel((LayoutManager)new MigLayout("fillx,hidemode 3,ins 2 10 3 2,alignx trailing", "[grow]2[]", ""));
        ticketAmountPanel.add((Component)lblSubtotal, "growx,aligny center");
        ticketAmountPanel.add((Component)this.tfSubtotal, "growx,aligny center");
        ticketAmountPanel.add((Component)lblDiscount, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfDiscount, "growx,aligny center");
        ticketAmountPanel.add((Component)lblServiceCharge, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfServiceCharge, "growx,aligny center");
        ticketAmountPanel.add((Component)lblTax, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.btnTaxExempt, "growx,aligny center,split 2");
        ticketAmountPanel.add((Component)this.tfTax, "growx,aligny center");
        if (this.ticket.getOrderType().isDelivery().booleanValue() && !this.ticket.isCustomerWillPickup().booleanValue()) {
            ticketAmountPanel.add((Component)lblDeliveryCharge, "newline,growx,aligny center");
            ticketAmountPanel.add((Component)this.tfDeliveryCharge, "growx,aligny center");
        }
        ticketAmountPanel.add((Component)lblGratuity, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfGratuity, "growx,aligny center");
        ticketAmountPanel.add((Component)lblTotal, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfTotal, "growx,aligny center");
        ticketAmountPanel.add((Component)new JLabel(Messages.getString("SettleTicketDialog.36") + CurrencyUtil.getCurrencySymbol(), 11), "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfPaidAmount, "growx,aligny center");
        this.lblRefundAmount = new JLabel(Messages.getString("SettleTicketDialog.37") + CurrencyUtil.getCurrencySymbol(), 11);
        ticketAmountPanel.add((Component)this.lblRefundAmount, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfRefundAmount, "growx,aligny center");
        return ticketAmountPanel;
    }

    private void doPerformTaxExempt() {
        try {
            Boolean isTaxExempt = this.ticket.isTaxExempt();
            String message = isTaxExempt != false ? Messages.getString("SettleTicketDialog.19") : Messages.getString("SettleTicketDialog.4");
            int option = POSMessageDialog.showYesNoQuestionDialog(this, message, POSConstants.CONFIRM);
            if (option != 0) {
                return;
            }
            new TaxExemptAction(this.ticket, this, this.paymentView).actionPerformed(null);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }

    @Override
    public void open() {
        super.open();
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
        this.ticketProcessor.setTicket(ticket);
        this.ticketViewerTable.setTicket(ticket);
        this.paymentView.setTicket(ticket);
    }

    @Override
    public void paymentCanceled() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void paymentDone() {
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void paymentDataChanged() {
        this.updateView();
        this.paymentView.updateView();
        this.ticketViewerTable.updateView();
    }

    public SettleTicketProcessor getTicketProcessor() {
        return this.ticketProcessor;
    }

    @Override
    public void ticketDataChanged() {
        this.ticket.calculatePrice();
        this.updateView();
        this.ticketViewerTable.updateView();
        this.paymentView.updateView();
    }

    private Terminal getTerminal() {
        return Application.getInstance().getTerminal();
    }

    @Override
    public void refresh() {
        Ticket ticket = TicketDAO.getInstance().loadFullTicket(this.getTicket().getId());
        this.setTicket(ticket);
        this.ticketDataChanged();
    }

    public void settleBartab() throws Exception {
        String noButtonText;
        String yesButtonText;
        String title;
        String message;
        int option;
        PosTransaction bartabTransaction = this.ticket.getBartabTransaction();
        if (bartabTransaction != null && !bartabTransaction.isCaptured().booleanValue() && !bartabTransaction.isVoided().booleanValue() && (option = POSMessageDialog.showYesNoQuestionDialog(this, message = Messages.getString("SettleTicketDialog.53"), title = Messages.getString("SettleTicketDialog.54"), yesButtonText = Messages.getString("SettleTicketDialog.55"), noButtonText = Messages.getString("SettleTicketDialog.56"))) == 0) {
            this.payUsingPreAuthorizedBartab(bartabTransaction);
            return;
        }
        int option2 = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("SettleTicketDialog.57"), Messages.getString("SettleTicketDialog.58"), Messages.getString("SettleTicketDialog.59"), Messages.getString("Cancel"));
        if (option2 != 0) {
            POSMessageDialog.showMessage(Messages.getString("SettleTicketDialog.61"));
            this.setCanceled(true);
            this.dispose();
            return;
        }
        this.doVoidBartab(bartabTransaction);
        POSMessageDialog.showMessage(Messages.getString("SettleTicketDialog.62"));
    }

    private void payUsingPreAuthorizedBartab(PosTransaction bartabTransaction) throws Exception {
        ReceiptPrintService.printTicket(this.ticket);
        double tipsAmount = NumberSelectionDialog2.takeDoubleInput(Messages.getString("EnterTipsAmount"), 0.0);
        if (tipsAmount > 0.0) {
            this.ticket.setGratuityAmount(tipsAmount);
            this.ticket.calculatePrice();
        }
        Double dueAmount = this.ticket.getDueAmount();
        bartabTransaction.setTenderAmount(dueAmount);
        bartabTransaction.setTipsAmount(tipsAmount);
        bartabTransaction.setAmount(dueAmount);
        this.ticketProcessor.setTenderAmount(dueAmount);
        this.captureBartabTransaction(bartabTransaction);
        this.ticket.setPaidAmount(this.ticket.getPaidAmount() + bartabTransaction.getAmount());
        this.ticket.calculatePrice();
        dueAmount = this.ticket.getDueAmount() + bartabTransaction.getAmount();
        if (this.ticket.getDueAmount() == 0.0) {
            this.ticket.setPaid(true);
            OrderType ticketType = this.ticket.getOrderType();
            if (ticketType.isCloseOnPaid().booleanValue()) {
                this.ticket.setClosed(true);
                this.ticket.setClosingDate(new Date());
            }
        }
        Transaction tx = null;
        try (Session session = TicketDAO.getInstance().createNewSession();){
            tx = session.beginTransaction();
            TicketDAO.getInstance().update(this.ticket, session);
            tx.commit();
            this.ticketProcessor.doAfterSettleTask(bartabTransaction, dueAmount, true);
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    public boolean captureBartabTransaction(PosTransaction bartabTransaction) throws Exception {
        CardProcessor cardProcessor = CardConfig.getPaymentGateway().getProcessor();
        cardProcessor.captureAuthAmount(bartabTransaction);
        return true;
    }

    public void doVoidBartab(PosTransaction barTabTransaction) throws Exception, PosException {
        if (barTabTransaction == null || barTabTransaction.isVoided().booleanValue() || barTabTransaction.isCaptured().booleanValue()) {
            return;
        }
        CardProcessor cardProcessor = CardConfig.getPaymentGateway().getProcessor();
        cardProcessor.voidTransaction(barTabTransaction);
    }

    public class TransactionDataTableModel
    extends ListTableModel<PosTransaction> {
        public TransactionDataTableModel() {
            super(new String[]{Messages.getString("SettleTicketDialog.9"), Messages.getString("SettleTicketDialog.11"), "", ""});
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2 || columnIndex == 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            PosTransaction transaction = (PosTransaction)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    if (transaction instanceof CustomPaymentTransaction) {
                        CustomPaymentTransaction tx = (CustomPaymentTransaction)transaction;
                        return " " + tx.getCustomPaymentName();
                    }
                    String cardType = transaction.getCardType();
                    if (StringUtils.isEmpty((String)cardType)) {
                        return " " + (Object)((Object)transaction.getPaymentType());
                    }
                    if (StringUtils.isNotEmpty((String)transaction.getCardNumber())) {
                        cardType = cardType + " [" + transaction.getCardNumber().replace("X", "") + "]";
                    }
                    return " " + cardType;
                }
                case 1: {
                    if (transaction.isVoided().booleanValue() || transaction instanceof RefundTransaction) {
                        return "-" + NumberUtil.formatNumber(transaction.getAmount()) + " ";
                    }
                    return NumberUtil.formatNumber(transaction.getAmount()) + " ";
                }
                case 2: {
                    return Messages.getString("SettleTicketDialog.51");
                }
                case 3: {
                    return "";
                }
            }
            return null;
        }
    }

    public class TicketDiscountTableModel
    extends ListTableModel<TicketDiscount> {
        public TicketDiscountTableModel() {
            super(new String[]{"name", "qty", "subtotal"});
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TicketDiscount discount = (TicketDiscount)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return discount.getNameDisplay();
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return -discount.getTotalDiscountAmount().doubleValue();
                }
            }
            return null;
        }
    }
}

