/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.actions.SplitTicketAction;
import com.floreantpos.actions.VoidTicketAction;
import com.floreantpos.config.CardConfig;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.extension.ExternalPaymentGatewayPlugin;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.extension.InginicoPlugin;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.services.PostPaymentProcessor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.MultiCurrencyTenderDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.RefundDialog;
import com.floreantpos.ui.dialog.TicketDiscountSelectionDialog;
import com.floreantpos.ui.dialog.TicketItemDiscountSelectionDialog;
import com.floreantpos.ui.dialog.TransactionCompletionDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.payment.AuthorizationCodeDialog;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.ui.views.payment.CreditCardInputListener;
import com.floreantpos.ui.views.payment.CustomPaymentSelectionDialog;
import com.floreantpos.ui.views.payment.GiftCardInputListener;
import com.floreantpos.ui.views.payment.GratuityInputDialog;
import com.floreantpos.ui.views.payment.ManualCardEntryDialog;
import com.floreantpos.ui.views.payment.PaymentListener;
import com.floreantpos.ui.views.payment.PaymentReferenceEntryDialog;
import com.floreantpos.ui.views.payment.SwipeCardDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.HeadlessException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingWorker;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class SettleTicketProcessor {
    private Vector<PaymentListener> paymentListeners = new Vector(3);
    private Ticket ticket;
    private double tenderAmount;
    private PaymentType paymentType;
    private User currentUser;
    private RefreshableView refreshableView;

    public SettleTicketProcessor(User currentUser, RefreshableView refreshableView) {
        this.currentUser = currentUser;
        this.refreshableView = refreshableView;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public double getTenderAmount() {
        return this.tenderAmount;
    }

    public void setTenderAmount(double tenderAmount) {
        this.tenderAmount = tenderAmount;
    }

    public void addPaymentListener(PaymentListener paymentListener) {
        this.paymentListeners.add(paymentListener);
    }

    public void removePaymentListener(PaymentListener paymentListener) {
        this.paymentListeners.remove(paymentListener);
    }

    public void doSettle(PaymentType paymentType, double tenderAmount) throws Exception {
        this.doSettle(paymentType, tenderAmount, null);
    }

    public void doSettle(PaymentType paymentType, double tenderAmount, List<MultiCurrencyTenderDialog.PaymentByCurrency> paymentByCurrencyList) throws Exception {
        this.tenderAmount = tenderAmount;
        if (this.ticket == null) {
            return;
        }
        if (!POSUtil.checkDrawerAssignment()) {
            return;
        }
        if (!this.confirmPayment()) {
            return;
        }
        this.paymentType = paymentType;
        switch (paymentType) {
            case CASH: {
                DrawerUtil.kickDrawer();
                this.doPayByCash(paymentType, paymentByCurrencyList);
                break;
            }
            case CUSTOM_PAYMENT: {
                CustomPaymentSelectionDialog customPaymentDialog = new CustomPaymentSelectionDialog();
                customPaymentDialog.setTitle(Messages.getString("SettleTicketDialog.8"));
                customPaymentDialog.pack();
                customPaymentDialog.open();
                if (customPaymentDialog.isCanceled()) {
                    return;
                }
                PosTransaction transaction = paymentType.createTransaction();
                CustomPaymentTransaction customPaymentTransaction = (CustomPaymentTransaction)transaction;
                customPaymentTransaction.setCustomPaymentFieldName(customPaymentDialog.getPaymentFieldName());
                customPaymentTransaction.setCustomPaymentName(customPaymentDialog.getPaymentName());
                customPaymentTransaction.setCustomPaymentRef(customPaymentDialog.getPaymentRef());
                this.doPayByCustomPayment(customPaymentTransaction);
                break;
            }
            case CREDIT_CARD: 
            case DEBIT_CARD: {
                this.doPayByCard(tenderAmount);
                break;
            }
            case GIFT_CERTIFICATE: {
                this.doPayByGiftCard(tenderAmount);
                break;
            }
            case MEMBER_ACCOUNT: {
                CustomerAccountTransaction customerAccountTransaction = (CustomerAccountTransaction)paymentType.createTransaction();
                customerAccountTransaction.setTicket(this.ticket);
                customerAccountTransaction.setCaptured(true);
                this.setTransactionAmounts(customerAccountTransaction);
                customerAccountTransaction.setCustomerId(this.ticket.getCustomerId());
                this.settleTicket(customerAccountTransaction);
                break;
            }
        }
    }

    private void doPayByCash(PaymentType paymentType) {
        this.doPayByCash(paymentType, null);
    }

    private void doPayByCash(final PaymentType paymentType, final List<MultiCurrencyTenderDialog.PaymentByCurrency> paymentByCurrencies) {
        final BusyDialog waitDialog = new BusyDialog();
        SwingWorker<Double, Void> worker = new SwingWorker<Double, Void>(){
            private PosTransaction transaction;

            @Override
            protected Double doInBackground() throws Exception {
                Double dueAmount = SettleTicketProcessor.this.ticket.getDueAmount();
                this.transaction = paymentType.createTransaction();
                this.transaction.setTicket(SettleTicketProcessor.this.ticket);
                SettleTicketProcessor.this.setTransactionAmounts(this.transaction);
                SettleTicketProcessor.this.populateCashBackProperty(this.transaction, paymentByCurrencies);
                SettleTicketProcessor.this.settleTicket(this.transaction, null, true, false, paymentByCurrencies);
                return dueAmount;
            }

            @Override
            protected void done() {
                try {
                    Double dueAmount = (Double)this.get();
                    SettleTicketProcessor.this.doAfterSettleTask(this.transaction, dueAmount, true);
                }
                catch (Exception e) {
                    waitDialog.dispose();
                    Throwable cause = e.getCause();
                    if (cause instanceof PosException) {
                        POSMessageDialog.showError(cause.getMessage());
                    } else if (cause instanceof StaleStateException) {
                        POSMessageDialog.showError(Messages.getString("SplitedTicketSelectionDialog.0"));
                        SettleTicketProcessor.this.refreshableView.refresh();
                    } else {
                        POSMessageDialog.showError(cause.getMessage(), cause);
                    }
                }
                finally {
                    waitDialog.dispose();
                }
            }
        };
        worker.execute();
        waitDialog.setVisible(true);
    }

    private void populateCashBackProperty(PosTransaction transaction, List<MultiCurrencyTenderDialog.PaymentByCurrency> paymentByCurrencies) {
        if (transaction == null || paymentByCurrencies == null) {
            return;
        }
        paymentByCurrencies.forEach(paymentByCurrency -> {
            String cashBackKey = paymentByCurrency.currency.getId() + "_CASH_BACK";
            String tenderedKey = paymentByCurrency.currency.getId() + "_TENDERED";
            transaction.addProperty(tenderedKey, String.valueOf(paymentByCurrency.tenderedAmount));
            transaction.addProperty(cashBackKey, String.valueOf(paymentByCurrency.cashBackAmount));
        });
    }

    public void payByCustomPayment(CustomPayment customPayment, double tenderAmount) {
        this.tenderAmount = tenderAmount;
        CustomPaymentTransaction transaction = new CustomPaymentTransaction();
        transaction.setCustomPaymentFieldName(customPayment.getRefNumberFieldName());
        transaction.setCustomPaymentName(customPayment.getName());
        if (customPayment.isRequiredRefNumber().booleanValue() && StringUtils.isEmpty((String)transaction.getCustomPaymentRef())) {
            PaymentReferenceEntryDialog dialog = new PaymentReferenceEntryDialog(customPayment);
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            transaction.setCustomPaymentRef(dialog.getPaymentRef());
        }
        this.doPayByCustomPayment(transaction);
    }

    public void doPayByCustomPayment(CustomPaymentTransaction transaction) {
        transaction.setPaymentType(PaymentType.CUSTOM_PAYMENT);
        transaction.setTicket(this.ticket);
        transaction.setCaptured(true);
        this.setTransactionAmounts(transaction);
        this.settleTicket(transaction);
    }

    private void doPayByGiftCard(double tenderedAmount) throws Exception {
        try {
            GiftCardPaymentPlugin giftCardPaymentPlugin = GiftCardConfig.getPaymentGateway();
            if (giftCardPaymentPlugin == null) {
                throw new PosException(Messages.getString("SettleTicketProcessor.0"));
            }
            GiftCardInputListener giftCardInputListener = new GiftCardInputListener(this);
            SwipeCardDialog swipeGiftCardDialog = new SwipeCardDialog(giftCardInputListener, this.paymentType, (boolean)Boolean.TRUE);
            swipeGiftCardDialog.setAuthorizationEntryVisible(false);
            swipeGiftCardDialog.pack();
            swipeGiftCardDialog.open();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private boolean confirmPayment() {
        if (!DataProvider.get().getCurrentTerminal().isConfirmTicketSettlement().booleanValue()) {
            return true;
        }
        String message = String.format("Confirm payment of %s%s?", CurrencyUtil.getCurrencySymbol(), NumberUtil.trimDecilamIfNotNeeded(this.tenderAmount));
        int option = POSMessageDialog.showYesNoQuestionDialog(message);
        return option == 0;
    }

    public void doSettleBarTabTicket(Ticket ticket, User currentUser) {
        try {
            String msg = "Do you want to settle ticket?";
            int option1 = POSMessageDialog.showYesNoQuestionDialog(null, msg, Messages.getString("NewBarTabAction.4"));
            if (option1 != 0) {
                return;
            }
            for (PosTransaction barTabTransaction : ticket.getTransactions()) {
                barTabTransaction.setAmount(ticket.getDueAmount());
                barTabTransaction.setTenderAmount(ticket.getDueAmount());
                barTabTransaction.setAuthorizable(true);
                this.settleTicket(barTabTransaction);
            }
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.refreshableView);
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public void settleTicket(PosTransaction transaction) {
        try {
            this.settleTicket(transaction, null, true, true);
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.refreshableView);
        }
        catch (UnknownHostException e) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SettleTicketDialog.12"));
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public void settleTicket(PosTransaction transaction, PostPaymentProcessor postPaymentProcessor) {
        try {
            this.settleTicket(transaction, postPaymentProcessor, true, true);
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.refreshableView);
        }
        catch (UnknownHostException e) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SettleTicketDialog.12"));
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public void settleTicket(PosTransaction transaction, PostPaymentProcessor postPaymentProcessor, boolean printReceipt, boolean peformAfterSettle) throws Exception {
        this.settleTicket(transaction, postPaymentProcessor, printReceipt, peformAfterSettle, null);
    }

    public void settleTicket(PosTransaction transaction, PostPaymentProcessor postPaymentProcessor, boolean printReceipt, boolean peformAfterSettle, List<MultiCurrencyTenderDialog.PaymentByCurrency> paymentByCurrencyList) throws Exception {
        double dueAmount = this.ticket.getDueAmount();
        PosTransactionService transactionService = PosTransactionService.getInstance();
        if (postPaymentProcessor == null) {
            transactionService.settleTicket(this.ticket, transaction, this.getCurrentUser(), null, paymentByCurrencyList);
        } else {
            transactionService.settleTicket(this.ticket, transaction, this.getCurrentUser(), postPaymentProcessor, paymentByCurrencyList);
        }
        if (printReceipt) {
            this.printTicket(this.ticket, transaction);
        }
        if (peformAfterSettle) {
            this.doAfterSettleTask(transaction, dueAmount, true);
        }
    }

    public void doAfterSettleTask(PosTransaction transaction, double dueAmount, boolean printTicket) throws HeadlessException {
        int option;
        double remainingGratuity;
        SettleTicketProcessor.showTransactionCompleteMsg(dueAmount, transaction.getTenderAmount(), this.ticket, transaction);
        if (this.ticket.isCoreAmountPaid() && (remainingGratuity = this.ticket.getRemainingGratuity()) > 0.0 && (option = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("SettleTicketProcessor.13"), POSConstants.CONFIRM)) != 0) {
            this.finalizeGratuity(remainingGratuity);
        }
        if (NumberUtil.isZero(this.ticket.getDueAmount())) {
            this.doInformListenerPaymentDone();
        } else {
            this.setTicket(this.ticket);
            this.doInformListenerPaymentUpdate();
        }
    }

    private void doPayByCard(double tenderedAmount) throws Exception {
        try {
            BusyDialog waitDialog = new BusyDialog();
            PaymentGatewayPlugin paymentGateway = CardConfig.getPaymentGateway();
            CreditCardInputListener creditCardInputListener = new CreditCardInputListener(this);
            if (paymentGateway instanceof ExternalPaymentGatewayPlugin) {
                AuthorizationCodeDialog authorizationCodeDialog = new AuthorizationCodeDialog(creditCardInputListener, this.paymentType);
                authorizationCodeDialog.pack();
                authorizationCodeDialog.open();
                return;
            }
            if (paymentGateway instanceof InginicoPlugin) {
                waitDialog.setVisible(true);
                if (!waitDialog.isCanceled()) {
                    this.doInformListenerPaymentDone();
                }
                return;
            }
            if (!paymentGateway.shouldShowCardInputProcessor()) {
                String option;
                PosTransaction transaction = this.paymentType.createTransaction();
                if (paymentGateway.supportsDualEntryMode() && (option = POSMessageDialog.showOptionDialog(POSUtil.getFocusedWindow(), "Please select card entry method", "Process card", "Automatic", "Manual")) != null && "Manual".equalsIgnoreCase(option)) {
                    paymentGateway.setManualEntryMode(true);
                    CardConfig.setSwipeCardSupported(false);
                    ManualCardEntryDialog dialog = new ManualCardEntryDialog(creditCardInputListener, this.paymentType);
                    dialog.pack();
                    dialog.open();
                    return;
                }
                paymentGateway.setManualEntryMode(false);
                transaction.setTicket(this.ticket);
                transaction.setCaptured(false);
                transaction.setCardMerchantGateway(paymentGateway.getProductName());
                this.setTransactionAmounts(transaction);
                if (this.ticket.getOrderType().isPreAuthCreditCard().booleanValue()) {
                    paymentGateway.getProcessor().preAuth(transaction);
                } else {
                    paymentGateway.getProcessor().chargeAmount(transaction);
                }
                this.settleTicket(transaction);
                return;
            }
            CardReader cardReader = CardConfig.getCardReader();
            switch (cardReader) {
                default: 
            }
            SwipeCardDialog swipeCardDialog = new SwipeCardDialog(creditCardInputListener, this.paymentType);
            swipeCardDialog.pack();
            swipeCardDialog.open();
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.refreshableView);
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private void updateModel() {
        if (this.ticket == null) {
            return;
        }
        this.ticket.calculatePrice();
    }

    public void doApplyCoupon(int couponType) {
        try {
            if (this.ticket == null) {
                return;
            }
            if (!this.ticket.isDiscountable()) {
                String message = POSConstants.TICKET_IS_EMPTY_;
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
                return;
            }
            if (!this.ticket.isAnyItemCloudSynced() && this.ticket.getPaidAmount() > 0.0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketProcessor.21"));
                return;
            }
            if (this.ticket.isAnyItemCloudSynced() && this.ticket.getPaidAmount() > 0.0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketProcessor.25"));
                return;
            }
            if (couponType == 1) {
                TicketDiscountSelectionDialog dialog = new TicketDiscountSelectionDialog(this.ticket);
                dialog.openFullScreen();
            } else {
                TicketItemDiscountSelectionDialog dialog = new TicketItemDiscountSelectionDialog(this.ticket);
                dialog.openFullScreen();
            }
            this.updateModel();
            this.doInformListenerPaymentUpdate();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    public void doAddLoyaltyDiscount() {
        boolean isLoyaltyEnabled;
        if (this.ticket == null) {
            return;
        }
        if (!this.ticket.isDiscountable()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.TICKET_IS_EMPTY_);
            return;
        }
        Store store = DataProvider.get().getStore();
        String loyaltyProperty = store.getProperty("loyalty.enabled");
        boolean bl = isLoyaltyEnabled = StringUtils.isNotEmpty((String)loyaltyProperty) && Boolean.valueOf(loyaltyProperty) != false;
        if (!isLoyaltyEnabled) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketProcessor.9"));
            return;
        }
        Customer customer = this.ticket.getCustomer();
        if (customer == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketProcessor.10"));
            return;
        }
        CustomerDAO.getInstance().refresh(customer);
        Integer customerLoyaltyPoint = customer.getLoyaltyPoint();
        List<TicketDiscount> discounts = this.ticket.getDiscounts();
        for (TicketDiscount discount : discounts) {
            if (discount.getType() != 3 || discount.isSaved()) continue;
            customerLoyaltyPoint = customerLoyaltyPoint - discount.getLoyaltyPoint();
        }
        double loyaltyExchangeRate = Double.parseDouble(store.getProperty("loyalty.exchangeRate", "0"));
        int allowedLoyaltyPoints = (int)(this.ticket.getDueAmount() / loyaltyExchangeRate);
        Integer minLoyaltyPoint = Integer.parseInt(store.getProperty("loyalty.minRedeemablePoint"));
        if (customerLoyaltyPoint < minLoyaltyPoint) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketProcessor.11"));
            return;
        }
        String dialogTitle = Messages.getString("SettleTicketProcessor.12");
        StringBuilder dialogCaption = new StringBuilder();
        dialogCaption.append("<html>");
        dialogCaption.append(String.format(Messages.getString("SettleTicketProcessor.16"), customerLoyaltyPoint));
        dialogCaption.append("<br>");
        dialogCaption.append(String.format(Messages.getString("SettleTicketProcessor.19"), CurrencyUtil.getCurrencySymbol(), NumberUtil.getCurrencyFormatWithoutCurrencySymbol((double)customerLoyaltyPoint.intValue() * loyaltyExchangeRate)));
        dialogCaption.append("</html>");
        long loyaltyPoint = NumberSelectionDialog2.takeIntInput(dialogTitle, dialogCaption.toString(), allowedLoyaltyPoints);
        if (loyaltyPoint <= 0L) {
            return;
        }
        if (loyaltyPoint > (long)customerLoyaltyPoint.intValue()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketProcessor.11"));
            return;
        }
        double discountValue = loyaltyExchangeRate * (double)loyaltyPoint;
        if (discountValue > this.ticket.getDueAmount()) {
            String message = String.format(Messages.getString("SettleTicketProcessor.20"), allowedLoyaltyPoints);
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
            return;
        }
        TicketDiscount ticketDiscount = Ticket.buildLoyaltyDiscount(this.ticket);
        ticketDiscount.setLoyaltyPoint((int)loyaltyPoint);
        this.ticket.addTodiscounts(ticketDiscount);
        ticketDiscount.setValue(discountValue);
        this.ticket.calculatePrice();
        this.doInformListenerPaymentUpdate();
    }

    public void doSetGratuity() {
        if (this.ticket == null) {
            return;
        }
        GratuityInputDialog d = new GratuityInputDialog();
        d.setGratuity(this.ticket.getGratuityAmount());
        d.setSubTotalAmount(this.ticket.getSubtotalAmount());
        d.pack();
        d.setResizable(false);
        d.open();
        if (d.isCanceled()) {
            return;
        }
        this.ticket.setGratuityAmount(d.getGratuityAmount());
        this.ticket.calculatePrice();
        this.doInformListenerPaymentUpdate();
        ActionHistoryDAO.addSetGratuityActionHistory(this.ticket, this.ticket.getGratuity());
    }

    public void doInformListenerPaymentUpdate() {
        for (PaymentListener paymentListener : this.paymentListeners) {
            paymentListener.paymentDataChanged();
        }
    }

    public void setTransactionAmounts(PosTransaction transaction) {
        transaction.setTenderAmount(this.tenderAmount);
        if (this.tenderAmount >= this.ticket.getDueAmount()) {
            transaction.setAmount(this.ticket.getDueAmount());
        } else {
            transaction.setAmount(this.tenderAmount);
        }
    }

    public void doHoldTicket() {
        try {
            if (this.ticket.isReOpened().booleanValue() && this.ticket.getDueAmount() == 0.0) {
                this.ticket.setClosed(true);
            }
            if (this.ticket.getTicketItems() == null || this.ticket.getTicketItems().size() == 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.TICKET_IS_EMPTY_);
                return;
            }
            TicketDAO.getInstance().saveOrUpdate(this.ticket);
            for (PaymentListener paymentListener : this.paymentListeners) {
                paymentListener.paymentDone();
            }
        }
        catch (PosException x) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), x.getMessage());
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.refreshableView);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }

    public void printTicket(Ticket ticket) {
        ReceiptPrintService.printTicket(ticket);
        for (PaymentListener paymentListener : this.paymentListeners) {
            paymentListener.paymentDataChanged();
        }
    }

    public void doSplitTicket() {
        DataChangeListener listener = new DataChangeListener(){

            @Override
            public Object getSelectedData() {
                return SettleTicketProcessor.this.ticket;
            }

            @Override
            public void dataSetUpdated() {
            }

            @Override
            public void dataRemoved(Object object) {
            }

            @Override
            public void dataChanged(Object object) {
                if (object == null) {
                    return;
                }
                Ticket ticket = (Ticket)object;
                String id = ticket.getId();
                if (StringUtils.isNotEmpty((String)id)) {
                    OrderType orderType = ticket.getOrderType();
                    if (orderType != null && orderType.isRetailOrder().booleanValue()) {
                        SettleTicketProcessor.this.doInformListenerPaymentCancelled();
                    } else {
                        SettleTicketProcessor.this.doInformListenerPaymentDone();
                    }
                } else {
                    SettleTicketProcessor.this.doInformListenerPaymentUpdate();
                }
            }

            @Override
            public void dataChangeCanceled(Object object) {
            }

            @Override
            public void dataAdded(Object object) {
            }
        };
        SplitTicketAction splitAction = new SplitTicketAction();
        splitAction.setRefreshableView(this.refreshableView);
        splitAction.setDataChangedListener(listener);
        splitAction.execute();
    }

    public void cancelPayment() {
        for (PaymentListener paymentListener : this.paymentListeners) {
            paymentListener.paymentCanceled();
        }
    }

    public static void showTransactionCompleteMsg(double dueAmount, double tenderedAmount, Ticket ticket, PosTransaction transaction) {
        TransactionCompletionDialog dialog = new TransactionCompletionDialog(transaction);
        dialog.setCompletedTransaction(transaction);
        dialog.setTenderedAmount(tenderedAmount);
        dialog.setTotalAmount(dueAmount);
        dialog.setPaidAmount(transaction.getAmount());
        dialog.setDueAmount(ticket.getDueAmount());
        dialog.setGratuityAmount(transaction.getTipsAmount());
        dialog.setChangeAmount(transaction.getChangeAmount());
        dialog.updateView();
        dialog.pack();
        dialog.open();
    }

    private void printTicket(Ticket ticket, PosTransaction transaction) {
        try {
            if (ticket.getOrderType().isShouldPrintToKitchen().booleanValue() && ticket.needsKitchenPrint()) {
                ReceiptPrintService.printToKitchen(ticket);
            }
            if (DataProvider.get().getCurrentTerminal().isAutoPrintReceipt()) {
                ReceiptPrintService.printTransaction(transaction);
            }
        }
        catch (Exception ee) {
            PosLog.error(SettleTicketProcessor.class, ee);
        }
    }

    public void doRefund() {
        new RefundAction().actionPerformed(null);
    }

    public void doVoidTicket() {
        if (this.ticket == null) {
            return;
        }
        if (this.ticket.isAnyItemCloudSynced()) {
            String message = Messages.getString("SettleTicketProcessor.24");
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
            return;
        }
        if (!this.ticket.isVoidable()) {
            String message = POSConstants.TICKET_IS_EMPTY_;
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
            return;
        }
        int option = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("WantedToVoid"), POSConstants.CONFIRM);
        if (option != 0) {
            return;
        }
        if (this.ticket.getId() == null) {
            this.doInformListenerPaymentDone();
            return;
        }
        this.ticket.calculatePrice();
        if (this.ticket.getPaidAmount() > 0.0) {
            POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("SettleTicketProcessor.7"));
            return;
        }
        VoidTicketAction action = new VoidTicketAction(this.ticket);
        action.actionPerformed(null);
        if (this.ticket.isVoided().booleanValue()) {
            this.doInformListenerPaymentDone();
        }
    }

    private void finalizeGratuity(double remainingGratuity) {
        if (!this.ticket.hasGratuity()) {
            return;
        }
        Gratuity gratuity = this.ticket.getGratuity();
        gratuity.setAmount(gratuity.getAmount() - remainingGratuity);
        this.ticket.calculatePrice();
        PosTransactionService.closeTicketIfApplicable(this.ticket, StoreDAO.getServerTimestamp());
        TicketDAO.getInstance().saveOrUpdate(this.ticket);
    }

    private void doInformListenerPaymentDone() {
        for (PaymentListener paymentListener : this.paymentListeners) {
            paymentListener.paymentDone();
        }
    }

    private void doInformListenerPaymentCancelled() {
        for (PaymentListener paymentListener : this.paymentListeners) {
            paymentListener.paymentCanceled();
        }
    }

    public User getCurrentUser() {
        return this.currentUser != null ? this.currentUser : Application.getCurrentUser();
    }

    public void setCurrentUser(User currentUser) {
        this.currentUser = currentUser;
    }

    public RefreshableView getRefreshableView() {
        return this.refreshableView;
    }

    private class RefundAction
    extends PosAction {
        public RefundAction() {
            this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
            this.setMandatoryPermission(true);
        }

        @Override
        public void execute() {
            try {
                double refundedAmount;
                if (SettleTicketProcessor.this.ticket.getTransactions() == null) {
                    SettleTicketProcessor.this.ticket.setTransactions(new HashSet<PosTransaction>());
                }
                if ((refundedAmount = SettleTicketProcessor.this.ticket.getDueAmount().doubleValue()) >= 0.0) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketProcessor.8"));
                    return;
                }
                RefundDialog dialog = new RefundDialog(POSUtil.getFocusedWindow(), SettleTicketProcessor.this.ticket, SettleTicketProcessor.this);
                dialog.setSize(810, 600);
                dialog.open();
                SettleTicketProcessor.this.ticket.calculatePrice();
                if (NumberUtil.isZero(SettleTicketProcessor.this.ticket.getDueAmount())) {
                    SettleTicketProcessor.this.doInformListenerPaymentDone();
                } else {
                    SettleTicketProcessor.this.doInformListenerPaymentUpdate();
                }
            }
            catch (PosException e) {
                POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
            }
            catch (Exception e) {
                POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
            }
        }
    }
}

