/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.ShowGiftCardAction;
import com.floreantpos.config.CardConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.PaymentType;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.views.payment.AuthorizationCodeDialog;
import com.floreantpos.ui.views.payment.CardInputListener;
import com.floreantpos.ui.views.payment.CardInputProcessor;
import com.floreantpos.ui.views.payment.ManualCardEntryDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class SwipeCardDialog
extends POSDialog
implements CardInputProcessor {
    private CardInputListener cardInputListener;
    private JPasswordField passwordField;
    private String cardString;
    private PosButton btnManualEntry;
    private PaymentType paymentType;

    public SwipeCardDialog(CardInputListener cardInputListener, PaymentType paymentType) {
        this(cardInputListener, paymentType, (boolean)Boolean.FALSE);
    }

    public SwipeCardDialog(CardInputListener cardInputListener, PaymentType paymentType, boolean showGiftCardSearchButton) {
        this.cardInputListener = cardInputListener;
        this.paymentType = paymentType;
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("SwipeCardDialog.0"));
        this.getContentPane().add((Component)titlePanel, "North");
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "South");
        panel.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel(new GridLayout(1, 0, 5, 5));
        panel_2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(panel_2);
        this.btnManualEntry = new PosButton();
        panel_2.add(this.btnManualEntry);
        if (showGiftCardSearchButton) {
            this.btnManualEntry.setText(POSConstants.SEARCH_ITEM_BUTTON_TEXT);
            this.btnManualEntry.putClientProperty("id", "SEARCH");
        } else {
            this.btnManualEntry.setText(Messages.getString("SwipeCardDialog.1"));
            this.btnManualEntry.putClientProperty("id", "MANUAL_ENTRY");
        }
        this.btnManualEntry.addActionListener(e -> this.openManualEntry());
        PosButton btnSubmit = new PosButton();
        panel_2.add(btnSubmit);
        btnSubmit.addActionListener(e -> {
            this.setCanceled(false);
            this.dispose();
            this.submitCard();
        });
        btnSubmit.setText(Messages.getString("SwipeCardDialog.3"));
        PosButton psbtnCancel = new PosButton();
        panel_2.add(psbtnCancel);
        psbtnCancel.addActionListener(e -> {
            this.setCanceled(true);
            this.dispose();
        });
        psbtnCancel.setText(Messages.getString("CANCEL"));
        JSeparator separator = new JSeparator();
        panel.add((Component)separator, "North");
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new EmptyBorder(20, 10, 20, 10));
        this.getContentPane().add((Component)panel_1, "Center");
        panel_1.setLayout(new BorderLayout(0, 0));
        this.passwordField = new JPasswordField();
        this.passwordField.addActionListener(e -> this.submitCard());
        this.passwordField.setColumns(30);
        panel_1.add(this.passwordField);
        if (Application.getInstance().isDevelopmentMode()) {
            this.passwordField.setText("%B4111111111111111^SHAH/RIAR^2303101000000000020000831000000?;4111111111111111=2303101000020000831?");
        }
        if (!CardConfig.isManualEntrySupported()) {
            this.btnManualEntry.setEnabled(false);
        }
    }

    protected void openAuthorizationEntryDialog() {
        this.setCanceled(true);
        this.dispose();
        AuthorizationCodeDialog dialog = new AuthorizationCodeDialog(this.cardInputListener, this.paymentType);
        dialog.setLocationRelativeTo(this);
        dialog.pack();
        dialog.open();
    }

    protected void openManualEntry() {
        this.setCanceled(true);
        this.dispose();
        Object property = this.btnManualEntry.getClientProperty("id");
        if (property instanceof String) {
            String propertyName = (String)property;
            if (propertyName.equals("SEARCH")) {
                ShowGiftCardAction showGiftCardAction = new ShowGiftCardAction(Boolean.FALSE, this.cardInputListener, this.paymentType);
                showGiftCardAction.execute();
            } else {
                ManualCardEntryDialog dialog = new ManualCardEntryDialog(this.cardInputListener, this.paymentType);
                dialog.setLocationRelativeTo(this);
                dialog.pack();
                dialog.open();
            }
        }
    }

    public String getCardString() {
        return this.cardString;
    }

    public void setCardString(String cardString) {
        this.cardString = cardString;
    }

    private void submitCard() {
        this.cardString = new String(this.passwordField.getPassword());
        this.cardInputListener.cardInputted(this, this.paymentType, null);
    }

    public void setManualEntryVisible(boolean visible) {
        this.btnManualEntry.setVisible(visible);
    }

    public void setAuthorizationEntryVisible(boolean visible) {
    }
}

