/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment.creditbook;

import com.floreantpos.Messages;
import com.floreantpos.config.AppProperties;
import com.floreantpos.model.CreditBookType;
import com.floreantpos.model.Customer;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosTable;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JScrollPane;

public class CreditBookTypesSelectionDialog
extends OkCancelOptionDialog {
    private Customer member;
    private List<CreditBookType> creditBookTypes;
    private PosTable creditBookTable;
    private BeanTableModel<CreditBookType> tableModel;
    private CreditBookType creditBookType;

    public CreditBookTypesSelectionDialog(Customer member, List<CreditBookType> creditBookTypes) {
        super(POSUtil.getFocusedWindow());
        this.member = member;
        this.creditBookTypes = creditBookTypes;
        this.setTitle(AppProperties.getAppName());
        this.initComponents();
    }

    private void initComponents() {
        this.getContentPanel().setLayout(new BorderLayout(5, 5));
        this.setCaption(Messages.getString("CreditBookTypesSelectionDialog.0") + ": " + this.member.getName());
        this.tableModel = new BeanTableModel(CreditBookType.class);
        this.tableModel.addColumn(Messages.getString("CreditBookTypesSelectionDialog.1"), "label");
        this.tableModel.addColumn(Messages.getString("CreditBookTypesSelectionDialog.2"), "memberBalance", BeanTableModel.EditMode.NON_EDITABLE, 11, BeanTableModel.DataType.MONEY);
        this.creditBookTable = new PosTable(this.tableModel);
        this.creditBookTable.setRowHeight(60);
        this.tableModel.setRows(this.creditBookTypes);
        this.tableModel.fireTableDataChanged();
        this.getContentPanel().add(new JScrollPane((Component)((Object)this.creditBookTable)));
    }

    @Override
    public void doOk() {
        int index = this.creditBookTable.getSelectedRow();
        if (index < 0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SELECT_A_ROW"));
            return;
        }
        index = this.creditBookTable.convertRowIndexToModel(index);
        this.creditBookType = this.tableModel.getRow(index);
        this.setCanceled(false);
        this.dispose();
    }

    public CreditBookType getSelectedCreditBookType() {
        return this.creditBookType;
    }
}

