/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public class JsonUtil {
    public static String getString(JsonObject jsonObject, String propertyName) {
        if (!jsonObject.containsKey((Object)propertyName)) {
            return null;
        }
        return jsonObject.getString(propertyName);
    }

    public static Boolean getBoolean(JsonObject jsonObject, String propertyName) {
        if (!jsonObject.containsKey((Object)propertyName)) {
            return null;
        }
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)propertyName);
        JsonValue.ValueType valueType = jsonValue.getValueType();
        switch (valueType) {
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
        }
        return Boolean.valueOf(jsonValue.toString());
    }

    public static Boolean getBooleanNotNull(JsonObject jsonObject, String propertyName) {
        if (!jsonObject.containsKey((Object)propertyName)) {
            return false;
        }
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)propertyName);
        JsonValue.ValueType valueType = jsonValue.getValueType();
        switch (valueType) {
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
        }
        return Boolean.valueOf(jsonValue.toString());
    }

    public static Integer getInt(JsonObject jsonObject, String propertyName) {
        if (!jsonObject.containsKey((Object)propertyName)) {
            return null;
        }
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)propertyName);
        JsonValue.ValueType valueType = jsonValue.getValueType();
        switch (valueType) {
            case NUMBER: {
                return ((JsonNumber)jsonValue).intValue();
            }
        }
        return Integer.parseInt(jsonValue.toString());
    }

    public static Double getDouble(JsonObject jsonObject, String propertyName) {
        if (!jsonObject.containsKey((Object)propertyName)) {
            return null;
        }
        JsonValue jsonValue = (JsonValue)jsonObject.get((Object)propertyName);
        JsonValue.ValueType valueType = jsonValue.getValueType();
        switch (valueType) {
            case NUMBER: {
                return ((JsonNumber)jsonValue).doubleValue();
            }
        }
        return Double.parseDouble(jsonValue.toString());
    }

    public static String getStringValue(JsonValue jsonValue) {
        if (jsonValue == JsonValue.NULL || jsonValue == null) {
            return null;
        }
        JsonValue.ValueType valueType = jsonValue.getValueType();
        switch (valueType) {
            case STRING: {
                return ((JsonString)jsonValue).getString();
            }
        }
        return jsonValue.toString().replaceAll("\"", "");
    }

    public static int getIntValue(JsonValue jsonValue) {
        if (jsonValue == null) {
            return 0;
        }
        JsonValue.ValueType valueType = jsonValue.getValueType();
        switch (valueType) {
            case NUMBER: {
                return ((JsonNumber)jsonValue).intValue();
            }
        }
        return Integer.parseInt(jsonValue.toString().replaceAll("\"", ""));
    }

    public static double getDoubleValue(JsonValue jsonValue) {
        if (jsonValue == null || jsonValue.toString().equals("null")) {
            return 0.0;
        }
        JsonValue.ValueType valueType = jsonValue.getValueType();
        switch (valueType) {
            case NUMBER: {
                return ((JsonNumber)jsonValue).doubleValue();
            }
        }
        double parseDouble = Double.parseDouble(jsonValue.toString().replaceAll("\"", ""));
        return parseDouble;
    }
}

