/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.PosLog;
import com.floreantpos.model.NumberBound;
import com.floreantpos.util.CurrencyUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class NumberUtil {
    private static final NumberFormat numberFormat = NumberFormat.getNumberInstance();
    private static final NumberFormat numberFormat2 = NumberFormat.getNumberInstance();
    private static final DecimalFormat decimalFormat = new DecimalFormat("#.##");
    private static final DecimalFormat twoDigitFormat = new DecimalFormat("0.00");
    private static final NumberFormat integerFormat = new DecimalFormat("0");
    private static final NumberFormat currencyFormat = new DecimalFormat("0.00");
    private static final NumberFormat numberFormatWithSixDigit = new DecimalFormat("0.######");
    private static Map<NumberBound, Pattern> patterns = new HashMap<NumberBound, Pattern>();
    private static final char decimalSeparator;
    private static final char groupingSeparator;

    public static double round(double value) {
        if (Double.isNaN(value)) {
            return 0.0;
        }
        BigDecimal bd = new BigDecimal(String.valueOf(value));
        bd = bd.setScale(2, 4);
        return bd.doubleValue();
    }

    public static BigDecimal round(BigDecimal value) {
        return value.setScale(2, 4);
    }

    public static double round(double value, int degit) {
        if (Double.isNaN(value)) {
            return 0.0;
        }
        BigDecimal bd = new BigDecimal(String.valueOf(value));
        bd = bd.setScale(degit, 4);
        return bd.doubleValue();
    }

    public static double roundToOneDigit(double value) {
        if (Double.isNaN(value)) {
            return 0.0;
        }
        BigDecimal bd = new BigDecimal(String.valueOf(value));
        bd = bd.setScale(1, 4);
        return bd.doubleValue();
    }

    public static double roundToTwoDigit(double value) {
        if (Double.isNaN(value)) {
            return 0.0;
        }
        BigDecimal bd = new BigDecimal(String.valueOf(value));
        bd = bd.setScale(2, 4);
        return bd.doubleValue();
    }

    public static double roundToThreeDigit(double value) {
        if (Double.isNaN(value)) {
            return 0.0;
        }
        BigDecimal bd = new BigDecimal(String.valueOf(value));
        bd = bd.setScale(3, 4);
        return bd.doubleValue();
    }

    public static String format3DigitNumber(Double number) {
        return NumberUtil.format3DigitNumber((Number)number);
    }

    public static String format3DigitNumber(Number number) {
        if (number == null) {
            return numberFormat2.format(0L);
        }
        String value = numberFormat2.format(number);
        return value;
    }

    public static String format6DigitNumber(Double number) {
        if (number == null) {
            return numberFormatWithSixDigit.format(0L);
        }
        String value = numberFormatWithSixDigit.format(number);
        return value;
    }

    public static String format6DigitNumber(Number number) {
        if (number == null) {
            return numberFormatWithSixDigit.format(0L);
        }
        String value = numberFormatWithSixDigit.format(number);
        return value;
    }

    public static String formatNumber(Double doubleValue, boolean isAllowedNegative) {
        return NumberUtil.formatNumberAcceptNegative(doubleValue);
    }

    public static String formatNumber(Number number, boolean isAllowedNegative) {
        if (number == null) {
            return numberFormat.format(0L);
        }
        String value = numberFormat.format(number);
        if (!isAllowedNegative && value.startsWith("-")) {
            return numberFormat.format(0L);
        }
        return value;
    }

    public static String formatNumber(Double number) {
        return NumberUtil.formatNumber(number, false);
    }

    public static String formatNumber(Number number) {
        return NumberUtil.formatNumber(number, false);
    }

    public static String trimDecilamIfNotNeeded(Double doubleValue) {
        return NumberUtil.trimDecilamIfNotNeeded(doubleValue, false);
    }

    public static String trimDecilamIfNotNeeded(Number number) {
        return NumberUtil.trimDecilamIfNotNeeded(number, false);
    }

    public static String trimDecilamIfNotNeeded(Number number, boolean allowNegative) {
        if (number == null) {
            return decimalFormat.format(0L);
        }
        String value = decimalFormat.format(number);
        if (allowNegative) {
            return value;
        }
        if (value.startsWith("-")) {
            return decimalFormat.format(0L);
        }
        return value;
    }

    public static String formatNumberAcceptNegative(Double number) {
        return NumberUtil.formatNumberAcceptNegative((Number)number);
    }

    public static String formatNumberAcceptNegative(Number number) {
        if (number == null) {
            return numberFormat.format(0L);
        }
        return numberFormat.format(number);
    }

    public static Number parse(String number) throws ParseException {
        if (StringUtils.isBlank((String)number)) {
            return 0;
        }
        return numberFormat.parse(number);
    }

    public static Number parseOrGetZero(String number) {
        try {
            if (StringUtils.isBlank((String)number)) {
                return 0;
            }
            return numberFormat.parse(number);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String getCurrencyFormat(Object d) {
        return CurrencyUtil.getCurrencySymbol() + currencyFormat.format(d);
    }

    public static String getCurrencyFormatWithoutCurrencySymbol(Object d) {
        return currencyFormat.format(d);
    }

    public static double getCurrencyFormatWithoutSymbol(Object d) {
        return Double.valueOf(currencyFormat.format(d));
    }

    public static int getIntegerFormat(Object d) {
        return Integer.valueOf(integerFormat.format(d));
    }

    public static BigDecimal convertToBigDecimal(double value) {
        return new BigDecimal(Double.toString(value));
    }

    public static BigDecimal convertToBigDecimal(String value) {
        return new BigDecimal(value);
    }

    public static boolean isZero(Double number) {
        return NumberUtil.isZero((Number)number);
    }

    public static boolean isZero(Number number) {
        String value = twoDigitFormat.format(number);
        try {
            return Math.abs(twoDigitFormat.parse(value).doubleValue()) == 0.0;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static String getCurrencyTwoDigitFormat(double value) {
        return twoDigitFormat.format(value);
    }

    public static Boolean isFractional(String number) {
        try {
            return NumberUtil.isFractional(Double.parseDouble(number));
        }
        catch (Exception e0) {
            PosLog.error(NumberUtil.class, e0);
            return null;
        }
    }

    public static Boolean isFractional(Double number) {
        int intValue;
        if (number == null || number.isNaN()) {
            return null;
        }
        double doubleValue = number;
        return doubleValue > (number = new Double(intValue = (int)doubleValue));
    }

    public static String formatNumberIfNeeded(Double number) {
        Boolean isFractional = NumberUtil.isFractional(number);
        String value = isFractional != false ? NumberUtil.formatNumber(number) : String.valueOf((int)number.doubleValue());
        return value;
    }

    public static String formatAmount(Double amount) {
        return NumberUtil.formatAmount((Number)amount);
    }

    public static String formatAmount(Number amount) {
        return currencyFormat.format(amount);
    }

    public static boolean isValidDouble(String value) {
        return NumberUtil.isValidDouble(value, new NumberBound(8, 2));
    }

    public static boolean isValidDouble(String value, int beforeDecimal, int afterDecimal) {
        return NumberUtil.isValidDouble(value, new NumberBound(beforeDecimal, afterDecimal));
    }

    private static boolean isValidDouble(String value, NumberBound bound) {
        if (value == null) {
            return false;
        }
        Pattern pattern = NumberUtil.getPattern(bound);
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.getDefault());
        String groupingSeparator = "" + symbols.getGroupingSeparator();
        value = value.replace(groupingSeparator, "");
        return pattern.matcher(value).matches();
    }

    public static Pattern getPattern(NumberBound bound) {
        if (!patterns.containsKey(bound)) {
            NumberUtil.initPattern(bound);
        }
        Pattern pattern = patterns.get(bound);
        return pattern;
    }

    private static void initPattern(NumberBound bound) {
        StringBuilder regexBuilder = new StringBuilder();
        regexBuilder.append("[-]?[0-9]{0,");
        regexBuilder.append(bound.getBeforeDecimal());
        regexBuilder.append("}(\\");
        regexBuilder.append(decimalSeparator);
        regexBuilder.append("[0-9]{0,");
        regexBuilder.append(bound.getAfterDecimal());
        regexBuilder.append("})?");
        String regex = regexBuilder.toString();
        patterns.put(bound, Pattern.compile(regex));
    }

    public static char getDecimalSeparator() {
        return decimalSeparator;
    }

    public static char getGroupingSeparator() {
        return groupingSeparator;
    }

    static {
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        numberFormat2.setMinimumFractionDigits(3);
        numberFormat2.setMaximumFractionDigits(3);
        numberFormat.setGroupingUsed(false);
        numberFormat2.setGroupingUsed(false);
        currencyFormat.setGroupingUsed(true);
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.getDefault(Locale.Category.FORMAT));
        decimalSeparator = symbols.getDecimalSeparator();
        groupingSeparator = symbols.getGroupingSeparator();
    }
}

