/*
 * Decompiled with CFR 0.152.
 */
package com.foretees.salesforce.sync;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.SFSyncErrorLog;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.dao.GratuityDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.SFSyncDAO;
import com.floreantpos.model.dao.SFSyncErrorLogDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.foretees.salesforce.sync.SFDateUtil;
import com.foretees.salesforce.sync.SFException;
import com.foretees.salesforce.sync.SFJsonInfoDisplayDialog;
import com.foretees.salesforce.sync.SFUtil;
import com.foretees.salesforce.sync.SalesForceSyncable;
import com.foretees.salesforce.sync.SyncCanceledException;
import com.foretees.salesforce.sync.SyncView;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JTextArea;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class PaymentSyncable
implements SalesForceSyncable {
    private SyncView syncView;
    private int count;
    public boolean hasSyncError;
    private String currentErrorMessage;
    private List<Object> objects;
    private Map<String, String> errorMap = new HashMap<String, String>();
    private List<TicketItem> errornuousItemList = new ArrayList<TicketItem>();
    private List<Gratuity> errornuousGratuityList = new ArrayList<Gratuity>();
    private List<PosTransaction> errornuousTransList = new ArrayList<PosTransaction>();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private ArrayList<Object> errorItems;
    private boolean isCanceled = false;
    private int uploadSize = 20;

    public PaymentSyncable(List<Object> objects) {
        this(objects, false);
    }

    public PaymentSyncable(List<Object> objects, boolean isUploadSeperately) {
        this.objects = objects;
        if (isUploadSeperately) {
            this.uploadSize = 1;
        }
    }

    public PaymentSyncable(List<Object> objects, Boolean isUploadSeperately, int numItemsToUpload) {
        this.objects = objects;
        if (isUploadSeperately == null) {
            this.uploadSize = numItemsToUpload;
        } else if (isUploadSeperately.booleanValue()) {
            this.uploadSize = 1;
        }
    }

    public SyncView getSyncView() {
        return this.syncView;
    }

    public void setSyncView(SyncView syncView) {
        this.syncView = syncView;
    }

    @Override
    public void doSync() throws Exception {
        this.errornuousItemList.clear();
        this.errornuousGratuityList.clear();
        this.errornuousTransList.clear();
        if (this.syncView == null) {
            return;
        }
        this.hasSyncError = false;
        this.currentErrorMessage = "";
        this.errorMap.clear();
        if (this.objects == null || this.objects.isEmpty()) {
            throw new PosException(Messages.getString("PaymentSyncable.2"));
        }
        int itemsToUpload = this.objects.size();
        HashMap<String, Ticket> ticketMap = new HashMap<String, Ticket>();
        for (Object object : this.objects) {
            Ticket ticket = this.getTicket(object);
            ticketMap.put(ticket.getId(), ticket);
        }
        this.count = 0;
        this.syncView.setSyncMessage(Messages.getString("PaymentSyncable.3") + itemsToUpload);
        this.syncView.setProgressMaximum(itemsToUpload);
        this.doUploadItems();
        if (this.isCanceled) {
            return;
        }
        this.logResult();
        this.doUpdateSyncedTime();
        this.objects.clear();
        if (this.syncView != null) {
            this.syncView.dispose();
        }
    }

    private void doUploadTransactions(HashMap<String, RefundedTicket> refundItemsAndTransactions) throws Exception, SFException, IOException {
        ArrayList<PosTransaction> transactions = new ArrayList<PosTransaction>();
        for (Object object : this.objects) {
            if (object instanceof PosTransaction) {
                PosTransaction transaction = (PosTransaction)object;
                if (transaction instanceof RefundTransaction) {
                    String ticketId = transaction.getTicketId();
                    RefundedTicket refundedTicket = refundItemsAndTransactions.get(ticketId);
                    if (refundedTicket == null) {
                        refundedTicket = new RefundedTicket();
                        refundedTicket.ticket = transaction.getTicket();
                        refundItemsAndTransactions.put(ticketId, refundedTicket);
                    }
                    refundedTicket.refundedTrans.add(transaction);
                } else {
                    transactions.add(transaction);
                }
            }
            if (transactions.size() == this.uploadSize) {
                this.uploadTransactions(transactions);
                transactions.clear();
            }
            if (refundItemsAndTransactions.size() != this.uploadSize) continue;
            this.uploadRefundItemsAndTransactions(refundItemsAndTransactions);
            refundItemsAndTransactions.clear();
        }
        if (transactions.size() > 0) {
            this.uploadTransactions(transactions);
        }
        if (refundItemsAndTransactions.size() > 0) {
            this.uploadRefundItemsAndTransactions(refundItemsAndTransactions);
        }
    }

    private void doUploadItems() throws SFException, IOException, Exception {
        ArrayList<Object> ticketItems = new ArrayList<Object>();
        HashMap<String, RefundedTicket> refundItemsAndTransactions = new HashMap<String, RefundedTicket>();
        for (Object object : this.objects) {
            if (object instanceof TicketItem) {
                TicketItem ticketItem = (TicketItem)object;
                if (ticketItem.isVoided().booleanValue()) {
                    String ticketId = ticketItem.getTicket().getId();
                    RefundedTicket refundedTicket = refundItemsAndTransactions.get(ticketId);
                    if (refundedTicket == null) {
                        refundedTicket = new RefundedTicket();
                        refundedTicket.ticket = ticketItem.getTicket();
                        refundItemsAndTransactions.put(ticketId, refundedTicket);
                    }
                    refundedTicket.refundedItems.add(ticketItem);
                } else {
                    ticketItems.add(ticketItem);
                }
            } else if (object instanceof Gratuity) {
                Gratuity gratuity = (Gratuity)object;
                if (gratuity.isRefunded().booleanValue()) continue;
                ticketItems.add(object);
            }
            if (ticketItems.size() == this.uploadSize) {
                this.uploadTicketItems(ticketItems);
                ticketItems.clear();
            }
            if (refundItemsAndTransactions.size() != this.uploadSize) continue;
            this.uploadRefundItemsAndTransactions(refundItemsAndTransactions);
            refundItemsAndTransactions.clear();
        }
        if (ticketItems.size() > 0) {
            this.uploadTicketItems(ticketItems);
        }
        this.doUploadTransactions(refundItemsAndTransactions);
    }

    private void doUpdateSyncedTime() {
        try {
            DataProvider.get().refreshStore();
            Store store = DataProvider.get().getStore();
            store.addProperty("salesforce.paymentSyncTime", SFDateUtil.formatDateAsSFFormat(new Date()));
            StoreDAO.getInstance().saveOrUpdate(store);
            DataProvider.get().refreshStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void uploadRefundItemsAndTransactions(HashMap<String, RefundedTicket> refundItemsAndTransactions) throws Exception, SFException, IOException {
        HttpResponse response;
        Collection<RefundedTicket> values = refundItemsAndTransactions.values();
        JSONArray roObject = new JSONArray();
        for (RefundedTicket refundedTicket : values) {
            JSONObject refundJson = this.getRefundJson(refundedTicket);
            roObject.put((Object)refundJson);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("memberRefunds", (Object)roObject);
        PosLog.debug(this.getClass(), jsonObject.toString());
        String customizedJsonString = jsonObject.toString();
        boolean isDebugMode = AppConfig.getBoolean("salesforce.debug.enabled", false);
        if (isDebugMode) {
            customizedJsonString = this.doCustomizeJsonString(jsonObject.toString(5));
        }
        if ((response = SFUtil.postSfService(customizedJsonString, "memberRefund")) == null) {
            throw new PosException(Messages.getString("PaymentSyncable.6"));
        }
        boolean hasError = !this.verifySFResponse(response);
        this.doUpdateRefundItemsAndTx(values, hasError);
        this.syncView.setProgressValue(this.count += this.objects.size());
        if (!isDebugMode) {
            Thread.sleep(5000L);
        }
    }

    private void doUpdateRefundItemsAndTx(Collection<RefundedTicket> values, boolean hasError) {
        for (RefundedTicket refundedTicket : values) {
            List<TicketItem> refundedItems = refundedTicket.refundedItems;
            List<PosTransaction> refundedTrans = refundedTicket.refundedTrans;
            if (!refundedItems.isEmpty()) {
                for (TicketItem ticketItem : refundedItems) {
                    ticketItem.setHasSyncError(hasError);
                    ticketItem.setCloudSynced(!hasError);
                    TicketItem ticketItem2 = TicketItemDAO.getInstance().get(ticketItem.getId());
                    ticketItem2.setHasSyncError(hasError);
                    ticketItem2.setCloudSynced(!hasError);
                    TicketItemDAO.getInstance().update(ticketItem2);
                }
            }
            if (refundedTrans.isEmpty()) continue;
            for (PosTransaction transaction : refundedTrans) {
                if (transaction.getId() == null) continue;
                transaction.setHasSyncError(hasError);
                transaction.setCloudSynced(!hasError);
                PosTransactionDAO.getInstance().update(transaction);
            }
        }
    }

    public void uploadTicketItems(List<Object> objects) throws Exception, SFException, IOException {
        HttpResponse response;
        JSONArray array = new JSONArray();
        for (Object object : objects) {
            JSONObject itemJson = null;
            if (object instanceof TicketItem) {
                itemJson = this.getItemJson((TicketItem)object);
            } else if (object instanceof Gratuity) {
                itemJson = this.getGratuityJson((Gratuity)object);
            }
            if (itemJson == null) continue;
            array.put((Object)itemJson);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("updateTickets", (Object)array);
        PosLog.debug(this.getClass(), jsonObject.toString());
        String customizedJsonString = jsonObject.toString();
        boolean isDebugMode = AppConfig.getBoolean("salesforce.debug.enabled", false);
        if (isDebugMode) {
            customizedJsonString = this.doCustomizeJsonString(jsonObject.toString(5));
        }
        if ((response = SFUtil.postSfService(customizedJsonString, SFUtil.POST_SERVICE_TYPE.ITEM)) == null) {
            throw new PosException(Messages.getString("PaymentSyncable.8"));
        }
        boolean hasError = !this.verifySFResponse(response);
        this.doUpdateItems(objects, hasError);
        this.syncView.setProgressValue(this.count += objects.size());
        if (!isDebugMode) {
            Thread.sleep(5000L);
        }
    }

    private void doUpdateItems(List<Object> objects, boolean hasError) {
        for (Object object : objects) {
            if (object instanceof TicketItem) {
                TicketItem ticketItem = (TicketItem)object;
                if (hasError) {
                    this.errornuousItemList.add(ticketItem);
                    this.errorMap.put(ticketItem.getId(), this.currentErrorMessage);
                }
                ticketItem.setHasSyncError(hasError);
                ticketItem.setCloudSynced(!hasError);
                TicketItem ticketItem2 = TicketItemDAO.getInstance().get(ticketItem.getId());
                ticketItem2.setHasSyncError(hasError);
                ticketItem2.setCloudSynced(!hasError);
                TicketItemDAO.getInstance().update(ticketItem2);
                continue;
            }
            if (!(object instanceof Gratuity)) continue;
            Gratuity gratuity = (Gratuity)object;
            if (hasError) {
                this.errornuousGratuityList.add(gratuity);
                this.errorMap.put(gratuity.getId(), this.currentErrorMessage);
            }
            gratuity.setCloudSynced(!hasError);
            gratuity.setHasSyncError(hasError);
            Gratuity gratuity2 = GratuityDAO.getInstance().get(gratuity.getId());
            gratuity2.setCloudSynced(!hasError);
            gratuity2.setHasSyncError(hasError);
            GratuityDAO.getInstance().update(gratuity2);
        }
    }

    private String doCustomizeJsonString(String jsonString) {
        SFJsonInfoDisplayDialog dialog = new SFJsonInfoDisplayDialog(jsonString);
        dialog.open();
        if (dialog.isCanceled()) {
            this.syncView.setCanceled(true);
            throw new SyncCanceledException(Messages.getString("PaymentSyncable.9"));
        }
        return dialog.getJsonString();
    }

    public void uploadTransactions(List<PosTransaction> transactions) throws Exception, SFException, IOException {
        HttpResponse response;
        JSONArray array = new JSONArray();
        for (PosTransaction transaction : transactions) {
            JSONObject itemJson = this.getTransJson(transaction);
            if (itemJson == null) continue;
            array.put((Object)itemJson);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("memberPayments", (Object)array);
        PosLog.debug(this.getClass(), jsonObject.toString());
        String customizedJsonString = jsonObject.toString();
        boolean isDebugMode = AppConfig.getBoolean("salesforce.debug.enabled", false);
        if (isDebugMode) {
            customizedJsonString = this.doCustomizeJsonString(jsonObject.toString(5));
        }
        if ((response = SFUtil.postSfService(customizedJsonString, SFUtil.POST_SERVICE_TYPE.TRANSACTION)) == null) {
            throw new PosException(Messages.getString("PaymentSyncable.11"));
        }
        boolean hasError = !this.verifySFResponse(response);
        this.doUpdateTransactions(transactions, hasError);
        this.syncView.setProgressValue(this.count += transactions.size());
        if (!isDebugMode) {
            Thread.sleep(5000L);
        }
    }

    private void doUpdateTransactions(List<PosTransaction> transactions, boolean hasError) {
        if (hasError) {
            for (PosTransaction transaction : transactions) {
                if (transaction.getId() == null) {
                    String ticketItemId = transaction.getProperty("item_id");
                    TicketItem ticketItem = TicketItemDAO.getInstance().get(ticketItemId);
                    ticketItem.setCloudSynced(false);
                    ticketItem.setHasSyncError(true);
                    TicketItemDAO.getInstance().update(ticketItem);
                    continue;
                }
                this.errornuousTransList.add(transaction);
                this.errorMap.put(transaction.getId(), this.currentErrorMessage);
                transaction.setCloudSynced(false);
                transaction.setHasSyncError(true);
                PosTransaction posTransaction = PosTransactionDAO.getInstance().get(transaction.getId());
                posTransaction.setCloudSynced(false);
                posTransaction.setHasSyncError(true);
                PosTransactionDAO.getInstance().update(posTransaction);
            }
        } else {
            for (PosTransaction transaction : transactions) {
                if (transaction.getId() == null) {
                    String ticketItemId = transaction.getProperty("item_id");
                    TicketItem ticketItem = TicketItemDAO.getInstance().get(ticketItemId);
                    ticketItem.setCloudSynced(true);
                    ticketItem.setHasSyncError(false);
                    TicketItemDAO.getInstance().update(ticketItem);
                    continue;
                }
                transaction.setCloudSynced(true);
                transaction.setHasSyncError(false);
                PosTransaction posTransaction = PosTransactionDAO.getInstance().get(transaction.getId());
                posTransaction.setCloudSynced(true);
                posTransaction.setHasSyncError(false);
                PosTransactionDAO.getInstance().update(posTransaction);
            }
        }
    }

    public List<Object> getErrorItems() {
        return this.errorItems;
    }

    private Ticket getTicket(Object object) {
        Ticket ticket = null;
        if (object instanceof TicketItem) {
            ticket = ((TicketItem)object).getTicket();
        } else if (object instanceof Gratuity) {
            ticket = ((Gratuity)object).getTicket();
        }
        if (object instanceof PosTransaction) {
            ticket = ((PosTransaction)object).getTicket();
        }
        return ticket;
    }

    private JSONObject getItemJson(TicketItem ticketItem) throws Exception, SFException, IOException {
        String reciprocalNote;
        if (!this.isSyncable(ticketItem)) {
            return null;
        }
        Ticket ticket = ticketItem.getTicket();
        MenuItem menuItem = ticketItem.getMenuItem();
        JSONObject ticketItemObj = new JSONObject();
        ticketItemObj.put("ticket_no", (Object)ticket.getId());
        ticketItemObj.put("ticket_line", (Object)String.valueOf(this.count));
        ticketItemObj.put("ticket_item_id", (Object)ticketItem.getId());
        if (menuItem != null && menuItem.isVariant().booleanValue()) {
            ticketItemObj.put("item_id", (Object)menuItem.getParentMenuItemId());
        } else {
            ticketItemObj.put("item_id", (Object)ticketItem.getMenuItemId());
        }
        ticketItemObj.put("net_total", (Object)String.valueOf(ticketItem.getSubtotalAmount() - ticketItem.getDiscountAmount()));
        ticketItemObj.put("line_update_date", (Object)this.dateFormat.format(ticket.getCreateDate()));
        ticketItemObj.put("pos_terminal", (Object)String.valueOf(ticket.getTerminalId()));
        ticketItemObj.put("is_open", (Object)String.valueOf(ticket.isClosed() == false));
        ticketItemObj.put("ticket_owner", (Object)this.getTicketOwnerSfId(ticket));
        ticketItemObj.put("tax", (Object)String.valueOf(ticketItem.getTaxAmount()));
        ticketItemObj.put("service_charge", (Object)String.valueOf(ticketItem.getServiceCharge()));
        ticketItemObj.put("quantity", (Object)String.valueOf(ticketItem.getQuantity()));
        ticketItemObj.put("type", (Object)(ticketItem.getCmsTypeName() == null ? "" : ticketItem.getCmsTypeName()));
        ticketItemObj.put("subType", (Object)(ticketItem.getCmsSubTypeName() == null ? "" : ticketItem.getCmsSubTypeName()));
        ticketItemObj.put("cost", (Object)String.valueOf(ticketItem.getUnitCost()));
        if (ticket.getSalesArea() != null) {
            ticketItemObj.put("Sales_Area", (Object)ticket.getSalesArea().getName());
        }
        if (StringUtils.isNotEmpty((String)ticket.getCustomerId())) {
            ticketItemObj.put("member_id", (Object)ticket.getCustomerId());
        }
        if (ticket.getNote() != null) {
            ticketItemObj.put("guestNotes", (Object)ticket.getNote());
        }
        if (StringUtils.isBlank((String)(reciprocalNote = ticket.getProperty("reciprocal_member.note")))) {
            reciprocalNote = "";
        }
        ticketItemObj.put("reciprocalMemberNotes", (Object)reciprocalNote);
        Double discountAmount = ticketItem.getDiscountAmount();
        String discountName = "";
        List<TicketItemDiscount> discounts = ticketItem.getDiscounts();
        if (discounts != null) {
            Iterator<TicketItemDiscount> iterator = discounts.iterator();
            while (iterator.hasNext()) {
                TicketItemDiscount ticketItemDiscount = iterator.next();
                discountName = discountName + ticketItemDiscount.getName();
                if (!iterator.hasNext()) continue;
                discountName = discountName + "; ";
            }
        }
        ticketItemObj.put("amountDiscounted", (Object)String.valueOf(discountAmount));
        ticketItemObj.put("discountName", (Object)discountName);
        JSONArray itemTaxOrSC = this.createTaxOrServiceChargesObject(ticketItem, ticket.isTaxExempt());
        ticketItemObj.put("TaxOrServiceCharges", (Object)itemTaxOrSC);
        return ticketItemObj;
    }

    private JSONArray createTaxOrServiceChargesObject(TicketItem ticketItem, boolean taxExempt) {
        JSONArray itemTaxOrSC = new JSONArray();
        List<TicketItemTax> taxes = ticketItem.getTaxes();
        for (TicketItemTax ticketItemTax : taxes) {
            JSONObject itemTaxObject = new JSONObject();
            Double taxAmount = ticketItemTax.getTaxAmount();
            if (taxExempt) {
                taxAmount = 0.0;
            }
            itemTaxObject.put("amount", (Object)String.valueOf(taxAmount));
            itemTaxObject.put("type", (Object)"Taxes");
            if (StringUtils.isNotBlank((String)ticketItemTax.getSfName())) {
                itemTaxObject.put("taxScId", (Object)ticketItemTax.getSfName());
            } else {
                itemTaxObject.put("taxScId", (Object)ticketItemTax.getName());
            }
            itemTaxOrSC.put((Object)itemTaxObject);
        }
        JSONObject itemSCObj = new JSONObject();
        itemSCObj.put("amount", (Object)String.valueOf(ticketItem.getServiceCharge()));
        itemSCObj.put("type", (Object)"Service Charges");
        itemSCObj.put("taxScId", (Object)ticketItem.getServiceChargeName());
        itemTaxOrSC.put((Object)itemSCObj);
        return itemTaxOrSC;
    }

    private JSONObject getGratuityJson(Gratuity gratuity) throws Exception {
        if (gratuity != null && gratuity.getAmount() > 0.0) {
            String reciprocalNote;
            if (gratuity.isCloudSynced().booleanValue()) {
                return null;
            }
            MenuItem gratuityItem = MenuItemDAO.getInstance().findByName("Gratuity");
            if (gratuityItem == null) {
                PosLog.error(this.getClass(), Messages.getString("PaymentSyncable.39"));
                gratuity.setCloudSynced(false);
                gratuity.setHasSyncError(true);
                GratuityDAO.getInstance().update(gratuity);
                return null;
            }
            JSONObject ticketItemObj = new JSONObject();
            Ticket ticket = gratuity.getTicket();
            ticketItemObj.put("ticket_no", (Object)ticket.getId());
            if (ticket.getNote() != null) {
                ticketItemObj.put("guestNotes", (Object)ticket.getNote());
            }
            if (StringUtils.isBlank((String)(reciprocalNote = ticket.getProperty("reciprocal_member.note")))) {
                reciprocalNote = "";
            }
            ticketItemObj.put("reciprocalMemberNotes", (Object)reciprocalNote);
            ticketItemObj.put("ticket_line", (Object)String.valueOf(this.count++));
            ticketItemObj.put("ticket_item_id", (Object)gratuity.getId());
            ticketItemObj.put("item_id", (Object)gratuityItem.getId());
            ticketItemObj.put("net_total", (Object)String.valueOf(ticket.getGratuityAmount()));
            ticketItemObj.put("line_update_date", (Object)this.dateFormat.format(ticket.getCreateDate()));
            ticketItemObj.put("pos_terminal", (Object)String.valueOf(ticket.getTerminalId()));
            ticketItemObj.put("is_open", (Object)String.valueOf(ticket.isClosed() == false));
            ticketItemObj.put("ticket_owner", (Object)this.getTicketOwnerSfId(ticket));
            ticketItemObj.put("tax", (Object)String.valueOf(0));
            ticketItemObj.put("type", (Object)(gratuityItem.getCmsTypeName() == null ? "" : gratuityItem.getCmsTypeName()));
            ticketItemObj.put("subType", (Object)(gratuityItem.getCmsSubTypeName() == null ? "" : gratuityItem.getCmsSubTypeName()));
            if (ticket.getSalesArea() != null) {
                ticketItemObj.put("Sales_Area", (Object)ticket.getSalesArea().getName());
            }
            ticketItemObj.put("cost", (Object)String.valueOf(0));
            ticketItemObj.put("service_charge", (Object)String.valueOf(0));
            ticketItemObj.put("quantity", (Object)String.valueOf(1));
            if (StringUtils.isNotEmpty((String)ticket.getCustomerId())) {
                ticketItemObj.put("member_id", (Object)ticket.getCustomerId());
            }
            JSONArray itemTaxOrSC = new JSONArray();
            JSONObject itemTaxObj = new JSONObject();
            itemTaxObj.put("amount", (Object)String.valueOf(0));
            itemTaxObj.put("type", (Object)"Taxes");
            itemTaxOrSC.put((Object)itemTaxObj);
            ticketItemObj.put("TaxOrServiceCharges", (Object)itemTaxOrSC);
            return ticketItemObj;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private JSONObject getRefundJson(RefundedTicket refundedTicket) throws Exception, SFException, IOException {
        JSONObject ticketItemObj;
        block25: {
            void var11_15;
            Iterator<TicketItemDiscount> iterator;
            String reciprocalNote;
            ticketItemObj = new JSONObject();
            Ticket ticket = refundedTicket.ticket;
            if (StringUtils.isNotEmpty((String)ticket.getCustomerId())) {
                ticketItemObj.put("member_id", (Object)ticket.getCustomerId());
            }
            ticketItemObj.put("line_update_date", (Object)this.dateFormat.format(ticket.getCreateDate()));
            ticketItemObj.put("is_open", (Object)String.valueOf(ticket.isClosed() == false));
            if (ticket.getNote() != null) {
                ticketItemObj.put("guestNotes", (Object)ticket.getNote());
            }
            if (StringUtils.isBlank((String)(reciprocalNote = ticket.getProperty("reciprocal_member.note")))) {
                reciprocalNote = "";
            }
            ticketItemObj.put("reciprocalMemberNotes", (Object)reciprocalNote);
            ArrayList<String> returnTicketItemIds = new ArrayList<String>();
            List<PosTransaction> posTransactions = refundedTicket.refundedTrans;
            for (PosTransaction posTransaction : posTransactions) {
                returnTicketItemIds.addAll(posTransaction.getReturnTicketItemIds());
            }
            List<TicketItem> unsyncedItems = SFSyncDAO.getInstance().findUnsyncedItems(ticket.getId(), returnTicketItemIds);
            String refundReason = null;
            JSONArray itemArray = new JSONArray();
            for (TicketItem ticketItem : unsyncedItems) {
                if (!refundedTicket.refundedItems.contains(ticketItem)) {
                    refundedTicket.refundedItems.add(ticketItem);
                }
                JSONObject itemObj = new JSONObject();
                itemObj.put("quantity", (Object)String.valueOf(ticketItem.getQuantity() * -1.0));
                itemObj.put("ticket_item_id", (Object)ticketItem.getId());
                itemObj.put("item_id", (Object)ticketItem.getMenuItemId());
                itemObj.put("price", (Object)String.valueOf(ticketItem.getUnitPrice()));
                itemObj.put("amount", (Object)String.valueOf(ticketItem.getTotalAmount()));
                itemObj.put("cost", (Object)String.valueOf(ticketItem.getUnitCost()));
                List<TicketItemDiscount> discounts = ticketItem.getDiscounts();
                if (discounts != null && !discounts.isEmpty()) {
                    for (TicketItemDiscount ticketItemDiscount : discounts) {
                        if (ticketItemDiscount.getType() == 2) {
                            itemObj.put("amountDiscounted", (Object)String.valueOf(0.0));
                        } else {
                            itemObj.put("amountDiscounted", (Object)String.valueOf(ticketItemDiscount.getAmount()));
                        }
                        itemObj.put("discountName", (Object)ticketItemDiscount.getName());
                    }
                } else {
                    itemObj.put("amountDiscounted", (Object)String.valueOf(0.0));
                    itemObj.put("discountName", (Object)"");
                }
                itemObj.put("type", (Object)(ticketItem.getCmsTypeName() == null ? "" : ticketItem.getCmsTypeName()));
                itemObj.put("subType", (Object)(ticketItem.getCmsSubTypeName() == null ? "" : ticketItem.getCmsSubTypeName()));
                if (refundReason == null && StringUtils.isEmpty((String)(refundReason = ticketItem.getVoidReason()))) {
                    refundReason = VoidItemDAO.getInstance().getVoidReason(ticketItem.getTicket().getId());
                }
                itemObj.put("return_reason", (Object)refundReason);
                JSONArray itemTaxOrSC = this.createTaxOrServiceChargesObject(ticketItem, ticket.isTaxExempt());
                itemObj.put("TaxOrServiceCharges", (Object)itemTaxOrSC);
                itemArray.put((Object)itemObj);
                ticketItem.setCloudSynced(true);
            }
            ticketItemObj.put("item_id", (Object)itemArray);
            JSONArray netTotalArray = new JSONArray();
            for (PosTransaction transaction : refundedTicket.refundedTrans) {
                ticketItemObj.put("line_update_date", (Object)this.dateFormat.format(transaction.getTransactionTime()));
                ticketItemObj.put("credit_book_type", (Object)this.getCreditBookType(transaction));
                JSONObject netTotalObj = new JSONObject();
                double amount = transaction.getAmount() == 0.0 ? 0.0 : transaction.getAmount() * -1.0;
                netTotalObj.put("amount", (Object)String.valueOf(amount));
                if (transaction.getPaymentType() != null) {
                    String paymentType = StringUtils.capitalize((String)transaction.getPaymentType().getDisplayString().toLowerCase());
                    if ("Member account".equals(paymentType)) {
                        paymentType = "Member Payment";
                    } else if ("Credit book".equals(paymentType)) {
                        paymentType = "Credit Book";
                    } else if ("Gift certificate".equals(paymentType)) {
                        paymentType = "Gift Card";
                    } else if ("Credit card".equalsIgnoreCase(paymentType)) {
                        paymentType = "Credit Card";
                    }
                    if (amount == 0.0) {
                        paymentType = "Member account";
                    }
                    netTotalObj.put("payment_type", (Object)paymentType);
                }
                netTotalArray.put((Object)netTotalObj);
            }
            ticketItemObj.put("net_total", (Object)netTotalArray);
            ticketItemObj.put("ticket_no", (Object)ticket.getId());
            ticketItemObj.put("return_reason", refundReason);
            ticketItemObj.put("ticket_owner", (Object)this.getTicketOwnerSfId(ticket));
            ticketItemObj.put("pos_terminal", (Object)String.valueOf(ticket.getTerminalId()));
            ticketItemObj.put("ticket_line", (Object)String.valueOf(this.count++));
            if (ticket.getSalesArea() != null) {
                ticketItemObj.put("Sales_Area", (Object)ticket.getSalesArea().getName());
            } else {
                ticketItemObj.put("Sales_Area", (Object)"");
            }
            String string = "";
            Double discountAmount = 0.0;
            Iterator<TicketItem> iterator2 = unsyncedItems.iterator();
            if (!iterator2.hasNext()) break block25;
            TicketItem ticketItem = iterator2.next();
            discountAmount = discountAmount + ticketItem.getDiscountAmount();
            List<TicketItemDiscount> discounts = ticketItem.getDiscounts();
            if (discounts != null && (iterator = discounts.iterator()).hasNext()) {
                TicketItemDiscount ticketItemDiscount = iterator.next();
                String string2 = string + ticketItemDiscount.getName();
            }
            ticketItemObj.put("amountDiscounted", (Object)String.valueOf(discountAmount));
            ticketItemObj.put("discountName", (Object)var11_15);
        }
        return ticketItemObj;
    }

    private boolean verifySFResponse(HttpResponse response) throws SFException, ParseException, IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
            this.hasSyncError = true;
            this.currentErrorMessage = sfdcError;
            return false;
        }
        byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        JSONObject jsonObject = new JSONObject(new String(bytes));
        Object object = jsonObject.get("statusCode");
        if (JSONObject.NULL.equals(object)) {
            return true;
        }
        String jsonStatusCode = (String)object;
        if (!"200".equals(jsonStatusCode)) {
            Object msgObj = jsonObject.get("message");
            if (msgObj != null) {
                String errorMessage;
                this.currentErrorMessage = errorMessage = msgObj.toString();
            }
            this.hasSyncError = true;
            return false;
        }
        return true;
    }

    private JSONObject getTransJson(PosTransaction transaction) throws Exception, IOException, SFException {
        String customPaymentName;
        this.syncView.checkCancelStatus();
        Ticket ticket = transaction.getTicket();
        if (transaction.isVoided().booleanValue() || transaction.isCloudSynced().booleanValue()) {
            return null;
        }
        String paymentMethod = "";
        String note = "";
        PaymentType paymentType = transaction.getPaymentType();
        JSONObject txObj = new JSONObject();
        txObj.put("ticket_no", (Object)transaction.getTicketId());
        if (ticket.getNote() != null) {
            txObj.put("guestNotes", (Object)ticket.getNote());
        }
        txObj.put("ticket_item_id", (Object)transaction.getId());
        String reciprocalNote = ticket.getProperty("reciprocal_member.note");
        if (StringUtils.isBlank((String)reciprocalNote)) {
            reciprocalNote = "";
        }
        txObj.put("reciprocalMemberNotes", (Object)reciprocalNote);
        txObj.put("pos_terminal", (Object)String.valueOf(transaction.getTerminalId()));
        txObj.put("is_open", (Object)String.valueOf(ticket.isClosed() == false));
        txObj.put("ticket_owner", (Object)this.getTicketOwnerSfId(ticket));
        txObj.put("note", (Object)note);
        txObj.put("cost", (Object)String.valueOf(transaction.getAmount()));
        txObj.put("line_update_date", (Object)this.dateFormat.format(transaction.getTicket().getCreateDate()));
        if (ticket.getSalesArea() != null) {
            txObj.put("Sales_Area", (Object)ticket.getSalesArea().getName());
        }
        if (StringUtils.isNotEmpty((String)ticket.getCustomerId())) {
            txObj.put("member_id", (Object)ticket.getCustomerId());
        }
        if (paymentType == PaymentType.CREDIT_BOOK) {
            paymentMethod = "Credit";
            note = "Credit payment";
            String creditBookTypeId = this.getCreditBookType(transaction);
            txObj.put("creditbook_type", (Object)creditBookTypeId);
        } else if (paymentType == PaymentType.CASH) {
            paymentMethod = "Cash";
            note = "Cash payment";
        } else if (paymentType == PaymentType.GIFT_CERTIFICATE) {
            paymentMethod = "Gift Card";
            note = "Gift card payment";
        } else if (paymentType == PaymentType.PROMOTION) {
            paymentMethod = "Promotion";
            txObj.put("promotion_name", (Object)transaction.getCustomPaymentName());
        } else if (paymentType.isCreditCard() || paymentType == PaymentType.DEBIT_CARD) {
            paymentMethod = "Credit Card";
            note = "Card payment";
        } else if (paymentType == PaymentType.MEMBER_ACCOUNT) {
            paymentMethod = "Member account";
            note = "Member account payment";
        } else if (paymentType == PaymentType.CUSTOM_PAYMENT && StringUtils.isNotBlank((String)(customPaymentName = transaction.getCustomPaymentName())) && customPaymentName.equalsIgnoreCase("Check")) {
            paymentMethod = "Check";
        }
        if (transaction instanceof RefundTransaction) {
            txObj.put("net_total", (Object)String.valueOf(transaction.getAmount()));
            txObj.put("refund_method", (Object)paymentMethod);
        } else {
            txObj.put("net_total", (Object)String.valueOf(-transaction.getAmount().doubleValue()));
            txObj.put("payment_method", (Object)paymentMethod);
            txObj.put("note", (Object)note);
        }
        return txObj;
    }

    private String getTicketOwnerSfId(Ticket ticket) {
        return ticket.getOwner().getParentUserId();
    }

    private String getCreditBookType(PosTransaction transaction) {
        if (transaction.getPaymentType() != PaymentType.CREDIT_BOOK) {
            return "";
        }
        return transaction.getCustomPaymentRef();
    }

    private boolean isSyncable(TicketItem ticketItem) {
        return !StringUtils.isEmpty((String)ticketItem.getMenuItemId()) && ticketItem.isCloudSynced() == false;
    }

    private void logResult() {
        String errorLogString;
        StringBuffer buffer = new StringBuffer();
        if (this.errornuousItemList.size() > 0) {
            buffer.append("Error syncing the following items:\n");
            for (TicketItem ticketItem : this.errornuousItemList) {
                buffer.append(String.format("ticket id: %s, item id: %s, item name: %s, amount %s, error reason: %s", ticketItem.getTicket().getId(), ticketItem.getId(), ticketItem.getName(), ticketItem.getSubtotalAmount(), this.errorMap.get(ticketItem.getId())));
                buffer.append("\n");
            }
        }
        if (this.errornuousGratuityList.size() > 0) {
            buffer.append("Error syncing the following tips:\n");
            for (Gratuity gratuity : this.errornuousGratuityList) {
                buffer.append(String.format("ticket id: %s, gratuity id: %s, amount %s, error reason: %s", gratuity.getTicketId(), gratuity.getId(), gratuity.getAmount(), this.errorMap.get(gratuity.getId())));
                buffer.append("\n");
            }
        }
        if (this.errornuousTransList.size() > 0) {
            buffer.append("Error syncing the following transactions:\n");
            for (PosTransaction transaction : this.errornuousTransList) {
                buffer.append(String.format("ticket id: %s, transaction id: %s, amount %s, error reason: %s", transaction.getTicketId(), transaction.getId(), transaction.getAmount(), this.errorMap.get(transaction.getId())));
                buffer.append("\n");
            }
        }
        if (StringUtils.isNotEmpty((String)(errorLogString = buffer.toString()))) {
            PosLog.error(this.getClass(), "Sync error------------------------\n" + errorLogString);
        }
        if (this.hasSyncError) {
            this.errorItems = new ArrayList();
            this.errorItems.addAll(this.errornuousItemList);
            this.errorItems.addAll(this.errornuousGratuityList);
            this.errorItems.addAll(this.errornuousTransList);
            ArrayList<SFSyncErrorLog> errorLogs = new ArrayList<SFSyncErrorLog>();
            for (Map.Entry<String, String> entry : this.errorMap.entrySet()) {
                SFSyncErrorLog errorLog = new SFSyncErrorLog();
                errorLog.setId(entry.getKey());
                String reason = entry.getValue() != null ? entry.getValue().substring(0, Math.min(entry.getValue().length(), 255)) : "";
                errorLog.setErrorReason(reason);
                errorLogs.add(errorLog);
            }
            SFSyncErrorLogDAO.getInstance().saveAll(errorLogs);
        }
    }

    public Map<String, String> getErrorMap() {
        return this.errorMap;
    }

    class TempAction
    extends AbstractAction {
        JTextArea input;
        JTextArea output;
        TicketItem ticketItem;
        PosTransaction transaction = null;
        List<TicketItem> errorItems2 = new ArrayList<TicketItem>();

        TempAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                boolean hasError;
                HttpResponse response = SFUtil.postSfService(this.input.getText(), SFUtil.POST_SERVICE_TYPE.REFUND);
                if (response == null) {
                    this.output.append("\nNo response found...");
                }
                boolean bl = hasError = !PaymentSyncable.this.verifySFResponse(response);
                if (hasError) {
                    PaymentSyncable.this.errornuousItemList.addAll(this.errorItems2);
                    if (this.ticketItem != null) {
                        PaymentSyncable.this.errorMap.put(this.ticketItem.getId(), PaymentSyncable.this.currentErrorMessage);
                        this.ticketItem.setHasSyncError(true);
                        this.ticketItem.setCloudSynced(false);
                    }
                    if (this.transaction != null) {
                        this.transaction.setHasSyncError(true);
                        this.transaction.setCloudSynced(false);
                    }
                    this.output.append("\nResponse:");
                    this.output.append("\n" + PaymentSyncable.this.currentErrorMessage);
                } else {
                    if (this.ticketItem != null) {
                        this.ticketItem.setCloudSynced(true);
                        this.ticketItem.setHasSyncError(false);
                    }
                    if (this.transaction != null) {
                        this.transaction.setHasSyncError(false);
                        this.transaction.setCloudSynced(true);
                    }
                    this.output.append("\nUpload successful");
                }
                if (this.ticketItem != null) {
                    TicketItemDAO.getInstance().update(this.ticketItem);
                }
                if (this.transaction != null) {
                    PosTransactionDAO.getInstance().update(this.transaction);
                }
            }
            catch (Exception e2) {
                this.output.append(e2.getMessage());
            }
        }
    }

    class RefundedTicket {
        Ticket ticket;
        final List<TicketItem> refundedItems = new ArrayList<TicketItem>();
        List<PosTransaction> refundedTrans = new ArrayList<PosTransaction>();

        RefundedTicket() {
        }
    }
}

