/*
 * Decompiled with CFR 0.152.
 */
package com.foretees.salesforce.sync;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

public class SFDateUtil {
    private static final SimpleDateFormat salesForceFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    private static final SimpleDateFormat salesForceFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final SimpleDateFormat salesForceFormat3 = new SimpleDateFormat("yyyy-MM-dd");

    public static String formatDateAsSFFormat(Date date) {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        SimpleDateFormat salesForceFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        salesForceFormat.setTimeZone(timeZone);
        String dateString = salesForceFormat.format(date);
        return dateString;
    }

    public static Date parseBySFDate(String date) throws Exception {
        try {
            if (StringUtils.isEmpty((String)date)) {
                return null;
            }
            return salesForceFormat.parse(date);
        }
        catch (Exception e) {
            try {
                return salesForceFormat2.parse(date);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static Date parseBySFFormat3Date(String date) throws Exception {
        try {
            if (StringUtils.isEmpty((String)date)) {
                return null;
            }
            return salesForceFormat3.parse(date);
        }
        catch (Exception e) {
            try {
                return salesForceFormat.parse(date);
            }
            catch (Exception e2) {
                try {
                    return salesForceFormat2.parse(date);
                }
                catch (Exception e3) {
                    return null;
                }
            }
        }
    }
}

