/*
 * Decompiled with CFR 0.152.
 */
package com.foretees.salesforce.sync;

import com.floreantpos.Messages;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class SFJsonInfoDisplayDialog
extends POSDialog {
    private String jsonString;
    private JTextArea taJson;
    private boolean uploadJsonTrue;

    public SFJsonInfoDisplayDialog(String jsonString) {
        this.jsonString = jsonString;
        this.initComponents();
        this.initData();
    }

    private void initData() {
        this.taJson.setText(this.jsonString);
    }

    private void initComponents() {
        this.setTitle(VersionInfo.getAppName());
        this.setSize(PosUIManager.getSize(500, 500));
        this.setLayout(new BorderLayout());
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("SFJsonInfoDisplayDialog.0"));
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5));
        this.taJson = new JTextArea();
        centerPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        centerPanel.add(new JScrollPane(this.taJson));
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("center"));
        PosButton btnSend = new PosButton(Messages.getString("SFJsonInfoDisplayDialog.2"));
        PosButton btnCancel = new PosButton(Messages.getString("SFJsonInfoDisplayDialog.3"));
        btnSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String jsonString = SFJsonInfoDisplayDialog.this.taJson.getText();
                if (StringUtils.isEmpty((String)jsonString)) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SFJsonInfoDisplayDialog.4"));
                    return;
                }
                SFJsonInfoDisplayDialog.this.uploadJsonTrue = true;
                SFJsonInfoDisplayDialog.this.setCanceled(false);
                SFJsonInfoDisplayDialog.this.dispose();
            }
        });
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SFJsonInfoDisplayDialog.this.setCanceled(true);
                SFJsonInfoDisplayDialog.this.dispose();
            }
        });
        buttonPanel.add(btnSend);
        buttonPanel.add(btnCancel);
        this.add((Component)titlePanel, "North");
        this.add(centerPanel);
        this.add((Component)buttonPanel, "South");
    }

    public String getJsonString() {
        return this.jsonString;
    }

    public void setJsonString(String jsonString) {
        this.jsonString = jsonString;
        this.taJson.setText(jsonString);
    }

    public boolean isUploadJsonTrue() {
        return this.uploadJsonTrue;
    }

    public void setUploadJsonTrue(boolean uploadJsonTrue) {
        this.uploadJsonTrue = uploadJsonTrue;
    }
}

