/*
 * Decompiled with CFR 0.152.
 */
package com.foretees.salesforce.sync;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.SFSyncErrorLog;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class SFResetAction
extends PosAction {
    public SFResetAction() {
        this(Messages.getString("SFResetAction.0"), UserPermission.PERFORM_ADMINISTRATIVE_TASK);
    }

    public SFResetAction(String name, UserPermission requiredPermission) {
        super(name);
        this.setRequiredPermission(requiredPermission);
        this.setMandatoryPermission(true);
    }

    @Override
    public void execute() {
        try {
            this.doReset();
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SFResetAction.1"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void doReset() {
        Session session = null;
        Transaction transaction = null;
        try {
            GenericDAO dao = new GenericDAO();
            session = dao.createNewSession();
            transaction = session.beginTransaction();
            this.doResetCloudSyncAndSyncError(session, TicketItem.class.getSimpleName());
            this.doResetCloudSyncAndSyncError(session, PosTransaction.class.getSimpleName());
            this.doResetCloudSyncAndSyncError(session, Gratuity.class.getSimpleName());
            this.doClearSyncErrors(session);
            this.doUpdateActionHistory(session);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw e;
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    private void doResetCloudSyncAndSyncError(Session session, String className) {
        Query query = session.createQuery("update " + className + " set " + TicketItem.PROP_CLOUD_SYNCED + " = :cloudSynced, " + TicketItem.PROP_HAS_SYNC_ERROR + " = :syncedError");
        query.setParameter("cloudSynced", (Object)false);
        query.setParameter("syncedError", (Object)false);
        query.executeUpdate();
    }

    private void doClearSyncErrors(Session session) {
        Query query = session.createQuery("delete from " + SFSyncErrorLog.class.getSimpleName());
        query.executeUpdate();
    }

    private void doUpdateActionHistory(Session session) {
        String actionMessage = Messages.getString("SFResetAction.2");
        ActionHistoryDAO.getInstance();
        ActionHistoryDAO.saveHistory(Application.getCurrentUser(), Messages.getString("SFResetAction.2"), actionMessage);
    }
}

