/*
 * Decompiled with CFR 0.152.
 */
package com.foretees.salesforce.sync;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.clubmember.ClubMemberSelectionPane;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.GratuityDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TitledView;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.UserListDialog;
import com.floreantpos.util.JsonUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.versioning.VersionInfo;
import com.foretees.salesforce.sync.PaymentSyncable;
import com.foretees.salesforce.sync.SFUtil;
import com.foretees.salesforce.sync.SyncDialog;
import com.foretees.salesforce.sync.SyncItemsCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXDatePicker;

public class SyncErrorInfoDialogNew
extends POSDialog {
    private List<Object> items;
    private HashMap<String, String> errorLogMap = new HashMap();
    private JTable itemsTable;
    private ItemModel tableModel;
    private JXDatePicker fromDatePicker;

    public SyncErrorInfoDialogNew(List<Object> items) {
        this.items = items;
        this.setTitle(VersionInfo.getAppName());
        this.initComponents();
        this.initData();
    }

    public SyncErrorInfoDialogNew() {
        this.setTitle(VersionInfo.getAppName());
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setSize(PosUIManager.getSize(1300, 750));
        this.createSearchPanel();
        this.tableModel = new ItemModel();
        this.tableModel.setRows(this.items);
        this.itemsTable = new JTable(this.tableModel);
        this.itemsTable.setDefaultRenderer(Object.class, new SyncItemsCellRenderer());
        this.itemsTable.setSelectionMode(0);
        this.itemsTable.setAutoCreateColumnsFromModel(true);
        this.itemsTable.setRowHeight(50);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyncErrorInfoDialogNew.this.doUploadSelectedItem(e);
            }
        };
        new ButtonColumn(this.itemsTable, action, 11);
        PosScrollPane jScrollPane = new PosScrollPane(this.itemsTable);
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill, ins 5 10 5 10"));
        centerPanel.add((Component)jScrollPane, "grow");
        this.add(centerPanel);
        PosButton btnSetSynced = new PosButton(Messages.getString("UploadPaymentDialog.6"));
        PosButton btnSetMenuItem = new PosButton(Messages.getString("SyncErrorItemsInfoDialog.3"));
        PosButton btnSetMember = new PosButton(Messages.getString("SyncErrorItemsInfoDialog.4"));
        PosButton btnSetGratuity = new PosButton(Messages.getString("SyncErrorItemsInfoDialog.5"));
        PosButton btnSetEmployee = new PosButton(Messages.getString("SyncErrorItemsInfoDialog.6"));
        btnSetSynced.addActionListener(ev -> this.doMarkAsSynced());
        btnSetMenuItem.addActionListener(ev -> this.doSetMenuItem());
        btnSetMember.addActionListener(ev -> this.doSetMember());
        btnSetGratuity.addActionListener(ev -> this.doSetGratuity());
        btnSetEmployee.addActionListener(ev -> this.doSetEmployee());
        PosButton btnUploadAll = new PosButton(Messages.getString("SyncErrorItemsInfoDialog.7"));
        PosButton btnUploadSeperately = new PosButton(Messages.getString("UploadPaymentDialog.22"));
        PosButton btnClose = new PosButton("Close");
        btnUploadAll.addActionListener(ev -> this.doUploadAll(false));
        btnUploadSeperately.addActionListener(e -> this.doUploadAll(true));
        btnClose.addActionListener(e -> this.doClose());
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        bottomPanel.add((Component)btnSetSynced, "right, split 4");
        bottomPanel.add(btnSetMenuItem);
        bottomPanel.add(btnSetMember);
        bottomPanel.add(btnSetGratuity);
        bottomPanel.add(btnSetEmployee);
        bottomPanel.add((Component)btnUploadSeperately, "right,split 2");
        bottomPanel.add(btnClose);
        this.add((Component)bottomPanel, "South");
        this.resizeColumnWidth(this.itemsTable);
    }

    private void doMarkAsSynced() {
        try {
            Object object = this.getRowFromTable();
            if (object == null) {
                return;
            }
            Ticket ticket = this.getTicket(object);
            StringBuilder des = new StringBuilder();
            des.append("Ticket: " + ticket.getId());
            if (object instanceof TicketItem) {
                TicketItem ticketItem = (TicketItem)object;
                ticketItem.setCloudSynced(true);
                TicketItem ticketItem2 = TicketItemDAO.getInstance().get(ticketItem.getId());
                ticketItem2.setCloudSynced(true);
                TicketItemDAO.getInstance().update(ticketItem2);
                des.append(". Item: " + ticketItem.getId());
            } else if (object instanceof Gratuity) {
                Gratuity gratuity = (Gratuity)object;
                gratuity.setCloudSynced(true);
                Gratuity gratuity2 = GratuityDAO.getInstance().get(gratuity.getId());
                gratuity2.setCloudSynced(true);
                GratuityDAO.getInstance().update(gratuity2);
                des.append(". Gratuity: " + gratuity.getId());
            } else if (object instanceof PosTransaction) {
                PosTransaction posTransaction = (PosTransaction)object;
                posTransaction.setCloudSynced(true);
                PosTransaction posTransaction2 = PosTransactionDAO.getInstance().get(posTransaction.getId());
                posTransaction2.setCloudSynced(true);
                posTransaction2.setHasSyncError(false);
                PosTransactionDAO.getInstance().update(posTransaction2);
                des.append(". Transaction: " + posTransaction.getId());
            }
            this.tableModel.deleteItem(object);
            POSMessageDialog.showMessage(this, Messages.getString("UploadPaymentDialog.51"));
            this.tableModel.fireTableDataChanged();
        }
        catch (Exception x) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void createSearchPanel() {
        TitledView titledView = new TitledView(Messages.getString("SyncErrorItemsInfoDialog.12"));
        this.add((Component)titledView, "North");
        JPanel titleContentPane = titledView.getContentPane();
        titleContentPane.setLayout((LayoutManager)new MigLayout());
        this.fromDatePicker = new JXDatePicker();
        JButton btnSearch = new JButton(Messages.getString("UploadSfTicketsDialog.1"));
        btnSearch.addActionListener(event -> this.doSearch());
        titleContentPane.add((Component)new JLabel("Date:"), "grow");
        titleContentPane.add((Component)this.fromDatePicker);
        titleContentPane.add((Component)btnSearch, "grow");
    }

    private void doSearch() {
        Date date = this.fromDatePicker.getDate();
        if (date == null) {
            POSMessageDialog.showError("Please select a date");
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMM-dd");
        String format = dateFormat.format(date);
        this.items = new ArrayList<Object>();
        this.errorLogMap.clear();
        try {
            JsonArray errorItems = SFUtil.getErrorItems(format);
            for (JsonObject itemObject : errorItems) {
                Comparable item;
                String chargeTicketItemId = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"chargeTicketItemId"));
                String transactionId = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"paymentTicketItemId"));
                String gratuityId = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"adjustmentTicketItemId"));
                String exceptionMessage = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"chargeExceptionMessage"));
                if (StringUtils.isNotBlank((String)chargeTicketItemId)) {
                    TicketItem ticketItem = TicketItemDAO.getInstance().get(chargeTicketItemId);
                    if (ticketItem != null) {
                        this.items.add(ticketItem);
                    } else {
                        this.items.add(new TicketItem(chargeTicketItemId));
                    }
                    this.errorLogMap.put(chargeTicketItemId, exceptionMessage);
                    continue;
                }
                if (StringUtils.isNotBlank((String)transactionId)) {
                    item = PosTransactionDAO.getInstance().get(transactionId);
                    if (item != null) {
                        this.items.add(item);
                    } else {
                        this.items.add(new PosTransaction(transactionId));
                    }
                    this.errorLogMap.put(transactionId, exceptionMessage);
                    continue;
                }
                if (!StringUtils.isNotBlank((String)gratuityId)) continue;
                item = GratuityDAO.getInstance().get(gratuityId);
                if (item != null) {
                    this.items.add(item);
                } else {
                    this.items.add(new Gratuity(gratuityId));
                }
                this.errorLogMap.put(gratuityId, exceptionMessage);
            }
            this.tableModel.setRows(this.items);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void updateItemStatus(Object object) {
        if (object instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)object;
            ticketItem.setHasSyncError(false);
        } else if (object instanceof Gratuity) {
            Gratuity gratuity = (Gratuity)object;
            gratuity.setHasSyncError(false);
        }
        if (object instanceof PosTransaction) {
            PosTransaction transaction = (PosTransaction)object;
            transaction.setHasSyncError(false);
        }
        this.tableModel.fireTableDataChanged();
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth(this.getColumnWidth().get(column));
        }
    }

    private List<Integer> getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(120);
        columnWidth.add(120);
        columnWidth.add(150);
        columnWidth.add(200);
        columnWidth.add(150);
        columnWidth.add(150);
        columnWidth.add(150);
        columnWidth.add(100);
        columnWidth.add(150);
        columnWidth.add(70);
        columnWidth.add(300);
        columnWidth.add(120);
        return columnWidth;
    }

    private void initData() {
        if (this.items == null || this.items.isEmpty()) {
            return;
        }
        this.sortItemsByTicketId();
        ArrayList<String> itemIds = new ArrayList<String>();
        for (Object object : this.items) {
            String txId;
            String gratuityId;
            if (object instanceof TicketItem) {
                TicketItem ticketItem = (TicketItem)object;
                String ticketItemId = ticketItem.getId();
                if (!itemIds.contains(ticketItemId)) {
                    itemIds.add(ticketItemId);
                }
            } else if (object instanceof Gratuity && !itemIds.contains(gratuityId = ((Gratuity)object).getId())) {
                itemIds.add(gratuityId);
            }
            if (!(object instanceof PosTransaction) || itemIds.contains(txId = ((PosTransaction)object).getId())) continue;
            itemIds.add(txId);
        }
    }

    private void sortItemsByTicketId() {
        Collections.sort(this.items, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return SyncErrorInfoDialogNew.this.getTicket(o1).getId().compareTo(SyncErrorInfoDialogNew.this.getTicket(o2).getId());
            }
        });
    }

    private Ticket getTicket(Object object) {
        if (object instanceof TicketItem) {
            Ticket ticket = ((TicketItem)object).getTicket();
            return ticket;
        }
        if (object instanceof Gratuity) {
            Ticket ticket = ((Gratuity)object).getTicket();
            return ticket;
        }
        if (object instanceof PosTransaction) {
            Ticket ticket = ((PosTransaction)object).getTicket();
            return ticket;
        }
        return null;
    }

    private Object getRowFromTable() {
        int index = this.itemsTable.getSelectedRow();
        if (index < 0) {
            POSMessageDialog.showMessage(this, Messages.getString("SyncErrorItemsInfoDialog.40"));
            return null;
        }
        index = this.itemsTable.convertRowIndexToModel(index);
        Object object = this.tableModel.getRowData(index);
        return object;
    }

    private void doSetMenuItem() {
        try {
            Object object = this.getRowFromTable();
            if (object == null) {
                return;
            }
            if (object instanceof PosTransaction) {
                POSMessageDialog.showMessage(this, Messages.getString("SyncErrorItemsInfoDialog.41"));
                return;
            }
            if (object instanceof Gratuity) {
                POSMessageDialog.showMessage(this, Messages.getString("SyncErrorItemsInfoDialog.42"));
                return;
            }
            TicketItem ticketItem = (TicketItem)object;
            MenuItemSelectionDialog dialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>());
            dialog.setSelectionMode(0);
            dialog.setSize(PosUIManager.getSize(600, 515));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            MenuItem menuItem = dialog.getSelectedRowData();
            if (menuItem == null) {
                return;
            }
            ticketItem.setMenuItemId(menuItem.getId());
            ticketItem.setName(menuItem.getName());
            this.updateItemStatus(object);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doSetMember() {
        try {
            Object object = this.getRowFromTable();
            if (object == null) {
                return;
            }
            Ticket ticket = this.getTicket(object);
            if (ticket == null) {
                return;
            }
            CustomerSelectorDialog dialog = new CustomerSelectorDialog(new ClubMemberSelectionPane(null));
            dialog.setCreateNewTicket(false);
            dialog.openUndecoratedFullScreen();
            if (dialog.isCanceled()) {
                return;
            }
            Customer customer = dialog.getSelectedCustomer();
            String customerId = customer.getId();
            for (Object obj : this.tableModel.getRows()) {
                Gratuity gratuity;
                Ticket ticket2;
                if (obj instanceof PosTransaction) {
                    PosTransaction transaction = (PosTransaction)obj;
                    if (!transaction.getTicketId().equals(ticket.getId())) continue;
                    transaction.setCustomerId(customerId);
                    transaction.setHasSyncError(false);
                    ticket2 = transaction.getTicket();
                    TicketDAO.getInstance().loadFullTicket(ticket2);
                    ticket2.setCustomer(customer);
                    continue;
                }
                if (obj instanceof TicketItem) {
                    TicketItem ticketItem = (TicketItem)obj;
                    if (!ticketItem.getTicket().getId().equals(ticket.getId())) continue;
                    ticket2 = ticketItem.getTicket();
                    TicketDAO.getInstance().loadFullTicket(ticket2);
                    ticket2.setCustomer(customer);
                    ticket2.setCustomerId(customerId);
                    ticketItem.setHasSyncError(false);
                    continue;
                }
                if (!(obj instanceof Gratuity) || !(gratuity = (Gratuity)obj).getTicket().getId().equals(ticket.getId())) continue;
                ticket2 = gratuity.getTicket();
                TicketDAO.getInstance().loadFullTicket(ticket2);
                ticket2.setCustomer(customer);
                ticket2.setCustomerId(customerId);
                gratuity.setHasSyncError(false);
            }
            this.updateItemStatus(object);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doSetGratuity() {
        try {
            Object object = this.getRowFromTable();
            if (object == null) {
                return;
            }
            if (object instanceof PosTransaction) {
                POSMessageDialog.showMessage(this, Messages.getString("SyncErrorItemsInfoDialog.43"));
                return;
            }
            if (object instanceof TicketItem) {
                POSMessageDialog.showMessage(this, Messages.getString("SyncErrorItemsInfoDialog.44"));
                return;
            }
            MenuItemSelectionDialog dialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>());
            dialog.setSelectionMode(0);
            dialog.setSize(PosUIManager.getSize(600, 515));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.updateItemStatus(object);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doClose() {
        this.setCanceled(true);
        this.dispose();
    }

    private void doSetEmployee() {
        try {
            Object object = this.getRowFromTable();
            if (object == null) {
                return;
            }
            Ticket ticket = this.getTicket(object);
            if (ticket == null) {
                return;
            }
            UserListDialog dialog = new UserListDialog();
            dialog.setUsers(UserDAO.getInstance().findAllActive());
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            User user = dialog.getSelectedUser();
            for (Object obj : this.tableModel.getRows()) {
                Gratuity gratuity;
                Ticket ticket2;
                if (obj instanceof PosTransaction) {
                    PosTransaction transaction = (PosTransaction)obj;
                    if (!transaction.getTicketId().equals(ticket.getId())) continue;
                    transaction.setUser(user);
                    transaction.setHasSyncError(false);
                    ticket2 = transaction.getTicket();
                    ticket2.setOwner(user);
                    continue;
                }
                if (obj instanceof TicketItem) {
                    TicketItem ticketItem = (TicketItem)obj;
                    if (!ticketItem.getTicket().getId().equals(ticket.getId())) continue;
                    ticket2 = ticketItem.getTicket();
                    ticket2.setOwner(user);
                    ticketItem.setHasSyncError(false);
                    continue;
                }
                if (!(obj instanceof Gratuity) || !(gratuity = (Gratuity)obj).getTicket().getId().equals(ticket.getId())) continue;
                ticket2 = gratuity.getTicket();
                ticket2.setOwner(user);
                gratuity.setHasSyncError(false);
            }
            this.updateItemStatus(object);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doUploadSelectedItem(ActionEvent e) {
        try {
            int row = Integer.parseInt(e.getActionCommand());
            if (row < 0) {
                return;
            }
            Object object = this.tableModel.getRowData(row = this.itemsTable.convertRowIndexToModel(row));
            Ticket ticket = this.getTicket(object);
            if (ticket == null) {
                return;
            }
            ArrayList<Object> objects = new ArrayList<Object>();
            objects.add(object);
            PaymentSyncable paymentSyncable = new PaymentSyncable(objects);
            SyncDialog dialog = new SyncDialog(paymentSyncable);
            paymentSyncable.setSyncView(dialog);
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            if (!paymentSyncable.hasSyncError) {
                this.tableModel.deleteItem(object);
                this.tableModel.fireTableDataChanged();
                POSMessageDialog.showMessage(this, Messages.getString("SyncErrorItemsInfoDialog.45"));
            } else {
                POSMessageDialog.showError(this, Messages.getString("SyncErrorItemsInfoDialog.46"));
                this.initData();
                this.tableModel.fireTableDataChanged();
                this.doSyncDataUpdate(object);
            }
        }
        catch (Exception x) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doSyncDataUpdate(Object object) {
        if (object instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)object;
            ticketItem.setSyncEdited(true);
        } else if (object instanceof Gratuity) {
            Gratuity gratuity = (Gratuity)object;
            gratuity.setSyncEdited(true);
        } else if (object instanceof PosTransaction) {
            PosTransaction posTransaction = (PosTransaction)object;
            posTransaction.setSyncEdited(true);
        }
    }

    private void doUploadAll(boolean isUploadSeperately) {
        try {
            List<Object> rows = this.tableModel.getRows();
            if (rows == null || rows.isEmpty()) {
                return;
            }
            PaymentSyncable paymentSyncable = new PaymentSyncable(rows, isUploadSeperately);
            SyncDialog dialog = new SyncDialog(paymentSyncable);
            paymentSyncable.setSyncView(dialog);
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            if (!paymentSyncable.hasSyncError) {
                this.tableModel.fireTableDataChanged();
                POSMessageDialog.showMessage(this, Messages.getString("SyncErrorItemsInfoDialog.47"));
            } else {
                POSMessageDialog.showError(this, Messages.getString("SyncErrorItemsInfoDialog.48"));
                this.items = paymentSyncable.getErrorItems();
                this.initData();
                this.tableModel.setRows(this.items);
                this.tableModel.fireTableDataChanged();
                if (this.items == null) {
                    return;
                }
                for (Object obj : this.items) {
                    this.doSyncDataUpdate(obj);
                }
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    public class ItemModel
    extends ListTableModel<Object> {
        private String[] columnNames = new String[]{Messages.getString("SyncErrorItemsInfoDialog.0"), Messages.getString("SyncErrorItemsInfoDialog.15"), Messages.getString("SyncErrorItemsInfoDialog.16"), Messages.getString("SyncErrorItemsInfoDialog.17"), Messages.getString("SyncErrorItemsInfoDialog.18"), Messages.getString("SyncErrorItemsInfoDialog.19"), Messages.getString("SyncErrorItemsInfoDialog.20"), Messages.getString("SyncErrorItemsInfoDialog.21"), Messages.getString("SyncErrorItemsInfoDialog.22"), Messages.getString("SyncErrorItemsInfoDialog.23"), Messages.getString("SyncErrorItemsInfoDialog.24"), "-"};

        public ItemModel(List<Object> rows) {
            this.setColumnNames(this.columnNames);
            this.setRows(rows);
        }

        public ItemModel() {
            this.setColumnNames(this.columnNames);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 11;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object object = this.getRows().get(rowIndex);
            Ticket ticket = SyncErrorInfoDialogNew.this.getTicket(object);
            switch (columnIndex) {
                case 0: {
                    if (ticket != null) {
                        return ticket.getId();
                    }
                    return "";
                }
                case 1: {
                    if (ticket != null) {
                        return ticket.getCreateDate();
                    }
                    return "";
                }
                case 2: {
                    if (object instanceof TicketItem) {
                        return ((TicketItem)object).getId();
                    }
                    if (object instanceof Gratuity) {
                        return ((Gratuity)object).getId();
                    }
                    if (object instanceof PosTransaction) {
                        return ((PosTransaction)object).getId();
                    }
                    return "";
                }
                case 3: {
                    if (object instanceof TicketItem) {
                        return ((TicketItem)object).getName();
                    }
                    if (object instanceof Gratuity) {
                        return "Gratuity";
                    }
                    if (object instanceof PosTransaction) {
                        return "Payment";
                    }
                    return "";
                }
                case 4: {
                    Customer customer;
                    if (ticket != null && (customer = ticket.getCustomer()) != null) {
                        return customer.getId();
                    }
                    return "";
                }
                case 5: {
                    Customer customer;
                    if (ticket != null && (customer = ticket.getCustomer()) != null) {
                        return customer.getName();
                    }
                    return "";
                }
                case 6: {
                    if (object instanceof TicketItem) {
                        return ((TicketItem)object).getMenuItemId();
                    }
                    return "";
                }
                case 7: {
                    Terminal terminal;
                    if (ticket != null && (terminal = ticket.getTerminal()) != null) {
                        return terminal;
                    }
                    return "";
                }
                case 8: {
                    User user;
                    if (ticket != null && (user = ticket.getOwner()) != null) {
                        return user;
                    }
                    return "";
                }
                case 9: {
                    if (object instanceof TicketItem) {
                        return NumberUtil.roundToTwoDigit(((TicketItem)object).getTotalAmount());
                    }
                    if (object instanceof Gratuity) {
                        return NumberUtil.roundToTwoDigit(((Gratuity)object).getAmount());
                    }
                    if (object instanceof PosTransaction) {
                        return NumberUtil.roundToTwoDigit(((PosTransaction)object).getAmount());
                    }
                    return "";
                }
                case 10: {
                    if (object instanceof TicketItem) {
                        String ticketItemId = ((TicketItem)object).getId();
                        return SyncErrorInfoDialogNew.this.errorLogMap.get(ticketItemId);
                    }
                    if (object instanceof Gratuity) {
                        String gratuityId = ((Gratuity)object).getId();
                        return SyncErrorInfoDialogNew.this.errorLogMap.get(gratuityId);
                    }
                    if (object instanceof PosTransaction) {
                        String txId = ((PosTransaction)object).getId();
                        return SyncErrorInfoDialogNew.this.errorLogMap.get(txId);
                    }
                    return "";
                }
                case 11: {
                    if (ticket == null) {
                        return null;
                    }
                    return "Upload";
                }
            }
            return null;
        }
    }
}

