/*
 * Decompiled with CFR 0.152.
 */
package com.foretees.salesforce.sync;

import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.TicketItem;
import com.floreantpos.util.NumberUtil;
import com.foretees.salesforce.sync.SyncErrorItemsInfoDialog;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class SyncItemsCellRenderer
extends CustomCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableModel tableModel;
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        this.setHorizontalAlignment(10);
        label.setBackground(table.getBackground());
        if (value instanceof Double) {
            label.setHorizontalAlignment(4);
            label.setText(String.valueOf(NumberUtil.roundToTwoDigit((Double)value)));
        }
        if ((tableModel = table.getModel()) instanceof SyncErrorItemsInfoDialog.ItemModel) {
            SyncErrorItemsInfoDialog.ItemModel itemModel = (SyncErrorItemsInfoDialog.ItemModel)tableModel;
            Object rowData = itemModel.getRowData(row);
            if (rowData instanceof TicketItem) {
                TicketItem ticketItem = (TicketItem)rowData;
                if (!ticketItem.isHasSyncError().booleanValue()) {
                    label.setBackground(Color.GREEN.darker());
                    return label;
                }
                if (ticketItem.isHasSyncError().booleanValue() && ticketItem.isSyncEdited()) {
                    label.setBackground(Color.RED);
                    return label;
                }
            } else if (rowData instanceof Gratuity) {
                Gratuity gratuity = (Gratuity)rowData;
                if (!gratuity.isHasSyncError().booleanValue()) {
                    label.setBackground(Color.GREEN.darker());
                    return label;
                }
                if (gratuity.isHasSyncError().booleanValue() && gratuity.isSyncEdited()) {
                    label.setBackground(Color.RED);
                    return label;
                }
            } else if (rowData instanceof PosTransaction) {
                PosTransaction transaction = (PosTransaction)rowData;
                if (!transaction.isHasSyncError().booleanValue()) {
                    label.setBackground(Color.GREEN.darker());
                    return label;
                }
                if (transaction.isHasSyncError().booleanValue() && transaction.isSyncEdited()) {
                    label.setBackground(Color.RED);
                    return label;
                }
            }
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

