/*
 * Decompiled with CFR 0.152.
 */
package com.foretees.salesforce.sync;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.SFSyncErrorLog;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.SFSyncErrorLogDAO;
import com.floreantpos.ui.dialog.UploadSfTicketsDialog;
import com.foretees.salesforce.sync.SFDateUtil;
import com.foretees.salesforce.sync.SFException;
import com.foretees.salesforce.sync.SFJsonInfoDisplayDialog;
import com.foretees.salesforce.sync.SFUtil;
import com.foretees.salesforce.sync.SalesForceSyncable;
import com.foretees.salesforce.sync.SyncCanceledException;
import com.foretees.salesforce.sync.SyncView;
import com.orostock.inventory.report.InventoryStockData;
import com.orostock.inventory.report.dao.ReportDAO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class UpdateItemCountSync
implements SalesForceSyncable {
    private SyncView syncView;
    private int count;
    private List<InventoryStockData> inventoryTransactions;
    private Map<String, String> errorMap = new HashMap<String, String>();
    private List<InventoryStockData> errornuousItemList = new ArrayList<InventoryStockData>();
    public boolean hasSyncError;
    private String currentErrorMessage;
    private ArrayList<Object> errorItems;

    public SyncView getSyncView() {
        return this.syncView;
    }

    public void setSyncView(SyncView syncView) {
        this.syncView = syncView;
    }

    @Override
    public void doSync() throws Exception {
        if (this.syncView == null) {
            return;
        }
        this.errornuousItemList.clear();
        this.errorMap.clear();
        this.hasSyncError = false;
        this.currentErrorMessage = "";
        Store store = Application.getInstance().getStore();
        String syncTimeStr = store.getProperty("salesforce.updateItemCountSyncTime");
        if (StringUtils.isEmpty((String)syncTimeStr)) {
            throw new PosException(Messages.getString("UpdateItemCountSync.3"));
        }
        Date currentSyncTime = StringUtils.isNotEmpty((String)syncTimeStr) ? SFDateUtil.parseBySFDate(syncTimeStr) : null;
        ReportDAO dao = new ReportDAO();
        this.inventoryTransactions = dao.getInventoryOnHandReportData("", null, null, currentSyncTime, true);
        if (this.inventoryTransactions == null || this.inventoryTransactions.isEmpty()) {
            throw new PosException(Messages.getString("UpdateItemCountSync.0"));
        }
        int itemsToUpload = this.inventoryTransactions.size();
        this.count = 1;
        this.syncView.setSyncMessage(Messages.getString("UpdateItemCountSync.1") + itemsToUpload);
        this.syncView.setProgressMaximum(itemsToUpload);
        List partitions = ListUtils.partition(this.inventoryTransactions, (int)50);
        for (List list : partitions) {
            this.doUploadItems(list, currentSyncTime);
        }
        this.logResult();
        if (this.syncView != null) {
            this.syncView.dispose();
        }
    }

    private void doUploadItems(List<InventoryStockData> inventoryTransactions, Date currentSyncTime) throws Exception, IOException, SFException {
        boolean hasError;
        this.syncView.checkCancelStatus();
        JSONArray rootArray = new JSONArray();
        for (InventoryStockData inventoryTransaction : inventoryTransactions) {
            JSONObject menuItemObj = new JSONObject();
            this.createMenuItemObj(menuItemObj, inventoryTransaction, currentSyncTime);
            rootArray.put((Object)menuItemObj);
            this.syncView.setProgressValue(this.count++);
        }
        String customizedJsonString = rootArray.toString();
        boolean isDebugMode = AppConfig.getBoolean("salesforce.debug.enabled", false);
        if (isDebugMode) {
            customizedJsonString = this.doCustomizeJsonString(rootArray.toString(5));
        }
        PosLog.info(this.getClass(), rootArray.toString());
        HttpResponse response = SFUtil.postSfService(customizedJsonString, SFUtil.POST_SERVICE_TYPE.UPDATE_INVENTORY_COUNT);
        if (response == null) {
            throw new PosException(Messages.getString("UpdateItemCountSync.2"));
        }
        boolean bl = hasError = !this.verifySFResponse(response);
        if (hasError) {
            PosLog.error(UpdateItemCountSync.class, this.currentErrorMessage);
        }
    }

    private void createMenuItemObj(JSONObject menuItemObj, InventoryStockData inventoryTransaction, Date currentSyncTime) {
        String menuItemId = inventoryTransaction.getMenuItemId();
        MenuItem menuItem = inventoryTransaction.getMenuItem();
        if (menuItem != null && menuItem.isVariant().booleanValue()) {
            menuItemId = menuItem.getParentMenuItemId();
        }
        menuItemObj.put("chargeItemId", (Object)menuItemId);
        menuItemObj.put("locationName", (Object)inventoryTransaction.getLocationName());
        menuItemObj.put("inventoryDate", (Object)UploadSfTicketsDialog.getDateFormat().format(currentSyncTime));
        menuItemObj.put("inventoryCost", inventoryTransaction.getMenuItemCost());
        menuItemObj.put("inventoryCount", inventoryTransaction.getQuantityInHand());
    }

    private boolean verifySFResponse(HttpResponse response) throws SFException, ParseException, IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new SFException(sfdcError, statusCode);
        }
        byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        JSONObject jsonObject = new JSONObject(new String(bytes));
        String jsonStatusCode = (String)jsonObject.get("statusCode");
        if (!"200".equals(jsonStatusCode)) {
            Object msgObj = jsonObject.get("message");
            if (msgObj != null) {
                String errorMessage;
                this.currentErrorMessage = errorMessage = msgObj.toString();
            }
            this.hasSyncError = true;
            return false;
        }
        return true;
    }

    private void logResult() {
        String errorLogString;
        StringBuffer buffer = new StringBuffer();
        if (this.errornuousItemList.size() > 0) {
            buffer.append("Error syncing the following items:\n");
            for (InventoryStockData menuItem : this.errornuousItemList) {
                buffer.append(String.format("item id: %s, name %s, cost %s, error reason: %s", menuItem.getMenuItemId(), menuItem.getMenuItemName(), menuItem.getMenuItemCost(), this.errorMap.get(menuItem.getMenuItemId())));
                buffer.append("\n");
            }
        }
        if (StringUtils.isNotEmpty((String)(errorLogString = buffer.toString()))) {
            PosLog.error(this.getClass(), "Sync error------------------------\n" + errorLogString);
        }
        if (this.hasSyncError) {
            this.errorItems = new ArrayList();
            this.errorItems.addAll(this.errornuousItemList);
            ArrayList<SFSyncErrorLog> errorLogs = new ArrayList<SFSyncErrorLog>();
            for (Map.Entry<String, String> entry : this.errorMap.entrySet()) {
                SFSyncErrorLog errorLog = new SFSyncErrorLog();
                errorLog.setId(entry.getKey());
                String reason = entry.getValue() != null ? entry.getValue().substring(0, Math.min(entry.getValue().length(), 255)) : "";
                errorLog.setErrorReason(reason);
                errorLogs.add(errorLog);
            }
            SFSyncErrorLogDAO.getInstance().saveAll(errorLogs);
        }
    }

    private String doCustomizeJsonString(String jsonString) {
        SFJsonInfoDisplayDialog dialog = new SFJsonInfoDisplayDialog(jsonString);
        dialog.open();
        if (dialog.isCanceled()) {
            this.syncView.setCanceled(true);
            throw new SyncCanceledException(Messages.getString("PaymentSyncable.9"));
        }
        return dialog.getJsonString();
    }
}

