/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.callerid;

import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.forms.QuickCustomerForm;
import com.floreantpos.ui.views.order.SelectionView;
import com.orocube.orocust.OroCustMessages;
import com.orocube.orocust.callerid.CallButtonClickListener;
import com.orocube.orocust.callerid.CallListener;
import com.orocube.orocust.callerid.LineStatus;
import com.orocube.orocust.callerid.ad101.AD101DeviceHandler;
import com.orocube.orocust.callerid.whozz.WhozzCallReceiver;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class CallInformationView
extends SelectionView
implements CallListener {
    private static final long serialVersionUID = 1L;
    HashMap<String, PhoneCallButton> callerIdMap = new HashMap();
    HashMap<Integer, PhoneCallButton> lineMap = new HashMap();
    private CallButtonClickListener callButtonClickListener;
    private AD101DeviceHandler ad101DeviceHandler;
    private ActionListener listener;
    private PosButton btnClearAll;

    public CallInformationView(CallButtonClickListener callButtonClickListener) {
        super(OroCustMessages.getString("CallInformationView.0"), (LayoutManager)new MigLayout("inset 5 2 0 2,alignx center, aligny top,wrap 1,fillx", "sg, fill", ""), PosUIManager.getSize(160), PosUIManager.getSize(110));
        this.callButtonClickListener = callButtonClickListener;
        this.listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhoneCallButton button = (PhoneCallButton)e.getSource();
                button.buttonClicked();
            }
        };
        this.setDataModel(new PaginatedListModel(100));
        this.setPreferredSize(new Dimension(PosUIManager.getSize(180, 130)));
        this.btnPrev.setText(OroCustMessages.getString("CallInformationView.4"));
        this.btnNext.setText(OroCustMessages.getString("CallInformationView.5"));
        this.btnClearAll = new PosButton(OroCustMessages.getString("CallInformationView.6"));
        this.btnClearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = CallInformationView.this.dataModel.getDataList();
                if (list == null) {
                    return;
                }
                CallInformationView.this.lineMap.clear();
                CallInformationView.this.callerIdMap.clear();
                CallInformationView.this.dataModel.setData(new ArrayList());
                CallInformationView.this.renderItems();
            }
        });
        this.actionButtonPanel.add((Component)this.btnClearAll, "newline,split 2,growx,gapbottom 5");
        try {
            String callerIdDevice = Application.getInstance().getStore().getProperty("callerId.device");
            PosLog.info(this.getClass(), "Caller id device: " + callerIdDevice);
            if (callerIdDevice.equals("Whozz calling")) {
                WhozzCallReceiver whozzCallReceiver = new WhozzCallReceiver(this);
                whozzCallReceiver.start();
            } else if (callerIdDevice.equals("AD101")) {
                this.ad101DeviceHandler = new AD101DeviceHandler(this);
            }
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), "Could not register device.");
        }
    }

    @Override
    protected void renderItems() {
        boolean existsCallList;
        boolean bl = existsCallList = this.dataModel.getDataList() != null && !this.dataModel.getDataList().isEmpty();
        if (existsCallList) {
            Collections.sort(this.dataModel.getDataList(), new Comparator<PhoneCallButton>(){

                @Override
                public int compare(PhoneCallButton o1, PhoneCallButton o2) {
                    return o2.getSortOrder() - o1.getSortOrder();
                }
            });
        }
        super.renderItems();
        this.setVisible(existsCallList);
        if (this.btnClearAll != null) {
            this.btnClearAll.setVisible(existsCallList);
        }
    }

    public void initialize() {
        this.dataModel.setData(new ArrayList());
    }

    @Override
    protected AbstractButton createItemButton(Object item) {
        PhoneCallButton button = (PhoneCallButton)item;
        if (button != null) {
            button.addActionListener(this.listener);
        }
        return button;
    }

    public void setCallButtonClickListener(CallButtonClickListener callButtonClickListener) {
        this.callButtonClickListener = callButtonClickListener;
    }

    protected void updateView(PhoneCallButton lineButton, boolean newButton) {
        List<PhoneCallButton> list = this.dataModel.getDataList();
        if (list == null) {
            list = new ArrayList();
        }
        if (!list.contains(lineButton)) {
            list.add(lineButton);
        }
        this.dataModel.setData(list);
        this.renderItems();
    }

    private void removeCallButton(PhoneCallButton callButton) {
        List list = this.dataModel.getDataList();
        if (list == null) {
            return;
        }
        this.lineMap.remove(callButton.line);
        this.callerIdMap.remove(callButton.callerId);
        callButton.removeActionListener(this.listener);
        list.remove(callButton);
        this.renderItems();
    }

    public void cleanup() {
    }

    private void createNewCallButton(final int line, final String callerId, final String callerName, final String callTime) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                List<Customer> customerList = CustomerDAO.getInstance().findByMobileNumber(callerId);
                Customer customer = null;
                if (customerList != null && customerList.size() > 0) {
                    customer = customerList.get(0);
                }
                PhoneCallButton callButton = new PhoneCallButton(line, callerId, callerName, callTime);
                callButton.setCustomer(customer);
                callButton.setStatus(LineStatus.RING_ON);
                callButton.setSortOrder((int)System.currentTimeMillis());
                CallInformationView.this.updateView(callButton, true);
                CallInformationView.this.callerIdMap.put(StringUtils.deleteWhitespace((String)callerId).replaceAll("-", ""), callButton);
                CallInformationView.this.lineMap.put(line, callButton);
            }
        });
        thread.start();
    }

    @Override
    public void callArrived(int line, String callerId, String callerName, String callTime) {
        PhoneCallButton existingButton = this.callerIdMap.get(StringUtils.deleteWhitespace((String)callerId).replaceAll("-", ""));
        if (existingButton == null) {
            this.createNewCallButton(line, callerId, callerName, callTime);
            return;
        }
        if (existingButton.getStatus() == LineStatus.MISSED_CALL || existingButton.getStatus() == LineStatus.CALL_ENDED) {
            existingButton.setStatus(LineStatus.RING_ON);
            existingButton.setSortOrder((int)System.currentTimeMillis());
            this.lineMap.put(line, existingButton);
            this.updateView(existingButton, false);
        } else {
            this.createNewCallButton(line, callerId, callerName, callTime);
        }
    }

    @Override
    public void callReceived(int line) {
        PhoneCallButton existingButton = this.lineMap.get(line);
        if (existingButton == null) {
            return;
        }
        existingButton.setStatus(LineStatus.CALL_IN_PROGRESS);
        this.updateView(existingButton, false);
    }

    @Override
    public void callMissed(int line) {
        PhoneCallButton existingButton = this.lineMap.get(line);
        if (existingButton == null) {
            return;
        }
        existingButton.setStatus(LineStatus.MISSED_CALL);
        this.updateView(existingButton, false);
    }

    @Override
    public void callEnd(int line) {
        PhoneCallButton existingButton = this.lineMap.get(line);
        if (existingButton == null) {
            return;
        }
        if (existingButton.getStatus().equals((Object)LineStatus.CALL_IN_PROGRESS)) {
            existingButton.setStatus(LineStatus.CALL_ENDED);
        } else {
            existingButton.setStatus(LineStatus.MISSED_CALL);
        }
        this.lineMap.remove(line);
        this.updateView(existingButton, false);
    }

    class PhoneCallButton
    extends PosButton {
        Customer customer;
        private int line;
        private String callerId = "";
        private String callerName = "";
        private String callTime = "";
        private int missedCallCount;
        private LineStatus lineStatus;
        private int sortOrder;

        public PhoneCallButton() {
        }

        public PhoneCallButton(int line, String callerId, String callerName, String time) {
            this.line = line;
            this.callerId = StringUtils.deleteWhitespace((String)callerId).replaceAll("-", "");
            this.callerName = callerName;
            this.callTime = time;
        }

        public void update() {
            String text = "<html>";
            text = text + "<b>LINE- " + this.line + "</b><br>";
            if (this.customer != null) {
                if (this.customer.getMobileNo() != null) {
                    text = text + this.customer.getMobileNo() + "<br>";
                }
            } else {
                text = text + this.callerId + "<br>";
            }
            text = text + this.lineStatus.toString();
            if (this.lineStatus == LineStatus.MISSED_CALL) {
                text = text + " (" + this.missedCallCount + ")";
            }
            text = text + "<br>";
            text = text + "</html>";
            this.setText(text);
        }

        public boolean equals(Object o) {
            if (!(o instanceof PhoneCallButton)) {
                return false;
            }
            PhoneCallButton that = (PhoneCallButton)o;
            String thisCallerId = this.callerId;
            String thatCallerId = that.callerId;
            return StringUtils.equals((String)thisCallerId, (String)thatCallerId);
        }

        public void buttonClicked() {
            if (CallInformationView.this.callButtonClickListener != null) {
                CallInformationView.this.callButtonClickListener.callButtonClicked(this.line, this.callerId, this.callerName);
            }
            CallInformationView.this.removeCallButton(this);
        }

        public LineStatus getStatus() {
            return this.lineStatus;
        }

        public void setStatus(LineStatus status) {
            if (this.lineStatus == status) {
                return;
            }
            this.lineStatus = status;
            if (this.lineStatus == LineStatus.MISSED_CALL) {
                ++this.missedCallCount;
            }
            this.update();
        }

        protected void doCreateNewCustomer(String phoneNo) {
            boolean setKeyPad = true;
            QuickCustomerForm form = new QuickCustomerForm(setKeyPad);
            form.setPhoneNo(phoneNo);
            form.enableCustomerFields(true);
            BeanEditorDialog dialog = new BeanEditorDialog(form);
            dialog.setResizable(false);
            dialog.open();
            if (!dialog.isCanceled()) {
                this.customer = (Customer)form.getBean();
            }
        }

        public Customer getCustomer() {
            return this.customer;
        }

        public void setCustomer(Customer customer) {
            this.customer = customer;
        }

        public int getLine() {
            return this.line;
        }

        public void setLine(int line) {
            this.line = line;
        }

        public String getCallerId() {
            return this.callerId;
        }

        public void setCallerId(String callerId) {
            this.callerId = callerId;
        }

        public String getCallerName() {
            return this.callerName;
        }

        public void setCallerName(String callerName) {
            this.callerName = callerName;
        }

        public String getCallTime() {
            return this.callTime;
        }

        public void setCallTime(String callTime) {
            this.callTime = callTime;
        }

        public LineStatus getLineStatus() {
            return this.lineStatus;
        }

        public void setLineStatus(LineStatus lineStatus) {
            this.lineStatus = lineStatus;
        }

        public int getMissedCallCount() {
            return this.missedCallCount;
        }

        public void setSortOrder(int currentTimeMillis) {
            this.sortOrder = currentTimeMillis;
        }

        public int getSortOrder() {
            return this.sortOrder;
        }
    }
}

