/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.callerid.ad101;

import com.floreantpos.IconFactory;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orocube.orocust.OroCustMessages;
import com.orocube.orocust.callerid.ad101.AD101Device;
import com.sun.jna.Pointer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import net.miginfocom.swing.MigLayout;

public class AD101Emulator
extends POSDialog
implements ActionListener,
AD101Device {
    private int defaultValue;
    private static JTextField tfNumber;
    private PosButton btnCall;
    private PosButton btnEndCall;
    private PosButton btnReceiveCall;
    private JPanel headerPanel;
    private JLabel lblHeader;
    private boolean floatingPoint;
    Font f = new Font("Verdana", 1, 16);
    Color color = Color.WHITE;
    private JPanel contentPane;
    private JPanel callingPane;
    private Timer callingTimer;
    private JLabel lblNumber;
    private JLabel lblTime = new JLabel("");
    private JPanel centerPanel;
    private static AD101Device.AD101Callback fun;
    int line;
    private CallerServiceListener listener;

    public AD101Emulator() {
        super(POSUtil.getFocusedWindow(), OroCustMessages.getString("AD101Emulator.2"));
        this.setIconImage(Application.getApplicationIcon().getImage());
        this.init();
        tfNumber.requestFocus();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 0));
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.lblHeader = new JLabel(OroCustMessages.getString("AD101Emulator.3"));
        this.lblHeader.setFont(this.f);
        this.lblHeader.setForeground(this.color);
        this.headerPanel = new JPanel((LayoutManager)new MigLayout("inset 0,fill"));
        this.headerPanel.add((Component)this.lblHeader, "h 40!,wrap");
        this.headerPanel.setBackground(Color.black);
        JSeparator sep = new JSeparator();
        sep.setBackground(Color.white);
        sep.setForeground(Color.white);
        this.headerPanel.add((Component)sep, "grow,h 1!,span");
        this.add((Component)this.headerPanel, "North");
        Dimension size = PosUIManager.getSize_w100_h70();
        this.centerPanel = new JPanel((LayoutManager)new MigLayout("inset 0,fill, hidemode 3"));
        this.contentPane = new JPanel((LayoutManager)new MigLayout("fill"));
        tfNumber = new JTextField();
        tfNumber.setText(String.valueOf(this.defaultValue));
        tfNumber.setFont(tfNumber.getFont().deriveFont(0, PosUIManager.getNumberFieldFontSize() + 4));
        tfNumber.setFocusable(true);
        tfNumber.setBorder(null);
        tfNumber.setHorizontalAlignment(0);
        tfNumber.setBackground(new Color(10, 21, 24));
        tfNumber.setForeground(this.color);
        this.contentPane.add((Component)tfNumber, "span,h 60!, grow");
        this.contentPane.setBackground(new Color(0, 21, 26));
        String[][] numbers = new String[][]{{"7", "8", "9"}, {"4", "5", "6"}, {"1", "2", "3"}, {"+", "0", "X"}};
        Font font = new Font("Arail", 1, 30);
        for (int i = 0; i < numbers.length; ++i) {
            for (int j = 0; j < numbers[i].length; ++j) {
                PosButton posButton = new PosButton();
                posButton.setFocusable(false);
                String buttonText = String.valueOf(numbers[i][j]);
                posButton.setText(buttonText);
                posButton.setFont(font);
                posButton.setForeground(new Color(2, 175, 215));
                posButton.setBackground(new Color(0, 21, 26));
                posButton.setBorder(new LineBorder(new Color(0, 27, 30), 1, true));
                posButton.setActionCommand(buttonText);
                posButton.addActionListener(this);
                String constraints = "grow,w " + size.width + "!,h " + size.height + "!";
                if (j == numbers[i].length - 1) {
                    constraints = constraints + ",wrap";
                }
                this.contentPane.add((Component)posButton, constraints);
            }
        }
        JSeparator jSeparator1 = new JSeparator();
        jSeparator1.setBackground(Color.black);
        jSeparator1.setForeground(Color.black);
        this.btnCall = new PosButton(IconFactory.getIcon("/images/", "call.png"));
        this.btnEndCall = new PosButton(IconFactory.getIcon("/images/", "callend.png"));
        this.btnReceiveCall = new PosButton(IconFactory.getIcon("/images/", "callreceive.png"));
        this.btnCall.setBorder(null);
        this.btnEndCall.setBorder(null);
        this.btnReceiveCall.setBorder(null);
        JPanel southPanel = new JPanel((LayoutManager)new MigLayout("fill, inset 0"));
        Dimension btnSize = PosUIManager.getSize(100, 70);
        southPanel.add((Component)jSeparator1, "newline, grow,h 3!, span");
        this.btnCall.setPreferredSize(btnSize);
        this.btnCall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AD101Emulator.this.doCall();
            }
        });
        southPanel.add((Component)this.btnCall, "grow");
        this.btnReceiveCall.setPreferredSize(btnSize);
        this.btnReceiveCall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AD101Emulator.this.doReceiveCall();
            }
        });
        southPanel.add((Component)this.btnReceiveCall, "grow");
        this.btnEndCall.setPreferredSize(btnSize);
        this.btnEndCall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AD101Emulator.this.endCall();
            }
        });
        southPanel.add((Component)this.btnEndCall, "grow");
        this.btnEndCall.setBackground(new Color(2, 32, 38));
        this.btnCall.setBackground(new Color(2, 32, 38));
        this.btnReceiveCall.setBackground(new Color(2, 32, 38));
        this.btnReceiveCall.setEnabled(false);
        southPanel.setBackground(new Color(2, 32, 38));
        this.centerPanel.add((Component)this.contentPane, "grow,wrap");
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)southPanel, "South");
        this.createCallingPanel();
    }

    public void createCallingPanel() {
        this.callingPane = new JPanel((LayoutManager)new MigLayout("fill"));
        this.lblNumber = new JLabel("");
        this.lblNumber.setFont(this.lblNumber.getFont().deriveFont(0, PosUIManager.getNumberFieldFontSize() + 4));
        this.lblNumber.setBorder(null);
        this.lblNumber.setHorizontalAlignment(0);
        this.lblNumber.setBackground(new Color(10, 21, 24));
        this.lblNumber.setForeground(this.color);
        this.lblTime.setFont(this.lblNumber.getFont().deriveFont(0, PosUIManager.getNumberFieldFontSize() + 4));
        this.lblTime.setBorder(null);
        this.lblTime.setHorizontalAlignment(0);
        this.lblTime.setBackground(new Color(10, 21, 24));
        this.lblTime.setForeground(this.color);
        this.callingPane.add((Component)this.lblNumber, "span, grow");
        this.callingPane.add((Component)this.lblTime, "span, grow");
        this.callingPane.setBackground(new Color(89, 117, 8));
        this.centerPanel.add((Component)this.callingPane, "grow,wrap");
        this.callingPane.setVisible(false);
    }

    public void doCall() {
        String number = tfNumber.getText();
        if (fun == null || number.isEmpty()) {
            return;
        }
        this.listener = new CallerServiceListener();
        this.listener.callButtonPressed();
        this.callingTimer = new Timer(1000, this.listener);
        this.listener.update(0, 8, 7);
        this.callingTimer.start();
        this.lblNumber.setText("<html>" + number + "<br><h1>Calling....</h1><html>");
        this.contentPane.setVisible(false);
        this.callingPane.setVisible(true);
        this.btnCall.setEnabled(false);
        this.btnReceiveCall.setEnabled(true);
        this.btnEndCall.setEnabled(true);
    }

    protected void doReceiveCall() {
        if (fun == null) {
            return;
        }
        if (this.callingTimer != null && this.callingTimer.isRunning()) {
            this.callingTimer.stop();
        }
        this.listener = new CallerServiceListener();
        this.listener.callReceived();
        this.callingTimer = new Timer(1000, this.listener);
        this.listener.update(0, 187, 0);
        this.callingTimer.start();
        String number = tfNumber.getText();
        this.lblNumber.setText("<html>" + number + "<br><h1>Call In Progress..</h1><html>");
        this.contentPane.setVisible(false);
        this.callingPane.setVisible(true);
        this.btnCall.setEnabled(false);
        this.btnReceiveCall.setEnabled(false);
        this.btnEndCall.setEnabled(true);
    }

    protected void endCall() {
        if (fun == null || this.listener == null) {
            return;
        }
        this.lblNumber.setText("");
        this.contentPane.setVisible(true);
        this.callingPane.setVisible(false);
        if (fun == null) {
            return;
        }
        if (this.callingTimer != null && this.callingTimer.isRunning()) {
            this.callingTimer.stop();
        }
        if (!this.listener.isCallInProgress()) {
            this.listener.missedCall();
        } else {
            this.listener.endCall();
        }
        this.lblNumber.setText("");
        tfNumber.requestFocus();
        this.btnCall.setEnabled(true);
        this.btnReceiveCall.setEnabled(false);
    }

    public void setCallerService(AD101Device.AD101Callback fun, int line) {
        AD101Emulator.fun = fun;
        this.line = line;
    }

    private void doClearAll() {
        tfNumber.setText("");
    }

    private void doInsertNumber(String number) {
        String s = tfNumber.getText();
        if (!this.validate(s = s + number)) {
            POSMessageDialog.showError(this, POSConstants.INVALID_NUMBER);
            return;
        }
        tfNumber.setText(s);
    }

    private void doInsertDot() {
        String string = tfNumber.getText() + "+";
        if (!this.validate(string)) {
            POSMessageDialog.showError(this, POSConstants.INVALID_NUMBER);
            return;
        }
        tfNumber.setText(string);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (POSConstants.OK.equalsIgnoreCase(actionCommand)) {
            this.doCall();
        } else if (actionCommand.equals("X")) {
            this.doClearAll();
        } else if (actionCommand.equals("+")) {
            this.doInsertDot();
        } else {
            this.doInsertNumber(actionCommand);
        }
    }

    private boolean validate(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (Exception x) {
            return false;
        }
        return true;
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
    }

    public void setDialogTitle(String title) {
        super.setTitle(title);
    }

    public static void main(String[] args) {
        AD101Emulator dialog2 = new AD101Emulator();
        dialog2.pack();
        dialog2.setVisible(true);
    }

    @Override
    public int AD101_GetCurDevCount() {
        return 0;
    }

    @Override
    public int AD101_GetDevice() {
        return 0;
    }

    @Override
    public int AD101_InitDevice(long hWnd) {
        AD101Emulator dialog2 = new AD101Emulator();
        dialog2.pack();
        dialog2.setVisible(true);
        return 1;
    }

    @Override
    public void setVisible(boolean b) {
        this.setLocationRelativeTo(this.getParent());
        super.setVisible(b);
    }

    @Override
    public void AD101_SetDialOutStartTalkingTime(int nSecond) {
    }

    @Override
    public void AD101_SetRingOffTime(int nSecond) {
    }

    @Override
    public void AD101_SetEventCallbackFun(AD101Device.AD101Callback fun) {
        AD101Emulator.fun = fun;
    }

    @Override
    public int AD101_GetCallerID(int dwChannel, Pointer szCallerIDBuffer, Pointer szName, Pointer szTime) {
        szCallerIDBuffer.setString(0L, tfNumber.getText());
        return 1;
    }

    private class CallerServiceListener
    implements ActionListener {
        int line;
        int event;
        int param;
        boolean callInProgress;
        Calendar cal = Calendar.getInstance();

        private CallerServiceListener() {
        }

        public void update(int line, int event, int param) {
            this.line = line;
            this.event = event;
            this.param = param;
        }

        public void endCall() {
            fun.EVENTCALLBACKPROC(0, 8, 1);
            tfNumber.setText("");
            AD101Emulator.this.lblTime.setText("");
        }

        public void missedCall() {
            fun.EVENTCALLBACKPROC(0, 170, 0);
            tfNumber.setText("");
            AD101Emulator.this.lblTime.setText("");
        }

        public void callReceived() {
            fun.EVENTCALLBACKPROC(0, 187, 0);
            this.callInProgress = true;
            this.cal.set(10, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 0);
        }

        public void callButtonPressed() {
            this.callInProgress = false;
            fun.EVENTCALLBACKPROC(0, 9, 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            fun.EVENTCALLBACKPROC(this.line, this.event, this.param);
            if (this.callInProgress) {
                this.cal.set(13, this.cal.get(13) + 1);
                AD101Emulator.this.lblTime.setText(OroCustMessages.getString("AD101Emulator.0") + this.cal.get(12) + ":" + this.cal.get(13));
            }
        }

        public boolean isCallInProgress() {
            return this.callInProgress;
        }
    }
}

