/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui;

import com.floreantpos.IconFactory;
import com.floreantpos.model.Ticket;
import com.floreantpos.util.NumberUtil;
import com.orocube.orocust.ui.TicketListTableModel;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class DispatchTableCellRenderer
extends DefaultTableCellRenderer {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, h:m a");

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel rendererComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        rendererComponent.setIcon(null);
        TicketListTableModel model = (TicketListTableModel)table.getModel();
        Ticket ticket = (Ticket)model.getRowData(row);
        if (column == 0) {
            String property = ticket.getProperty("source");
            if (property == null) {
                return rendererComponent;
            }
            if (property.equals("online")) {
                rendererComponent.setIcon(IconFactory.getIcon("/ui_icons/", "cloud.png"));
            }
        }
        return rendererComponent;
    }

    @Override
    protected void setValue(Object value) {
        if (value == null) {
            this.setText("");
            return;
        }
        String text = value.toString();
        if (value instanceof Double || value instanceof Float) {
            text = NumberUtil.formatNumber(((Number)value).doubleValue());
            this.setHorizontalAlignment(4);
        } else if (value instanceof Integer) {
            this.setHorizontalAlignment(4);
        } else if (value instanceof Date) {
            text = dateFormat.format(value);
            this.setHorizontalAlignment(2);
        } else {
            this.setHorizontalAlignment(2);
        }
        this.setText(" " + text + " ");
    }
}

