/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.DeliveryAddress;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.orocube.orocust.OroCustMessages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class DeliveryAddressSelectionDialog
extends POSDialog {
    private JList<DeliveryAddress> list;
    private DefaultListModel<DeliveryAddress> listModel;
    private DeliveryAddress selectedDeliveryAddress;
    private JPanel centerPanel;

    public DeliveryAddressSelectionDialog(Customer customer) {
        this.init();
        this.setDeliveryAddresses(customer.getDeliveryAddresses());
    }

    public DeliveryAddressSelectionDialog(List<DeliveryAddress> deliveryAddressList) {
        this.init();
        this.setDeliveryAddresses(deliveryAddressList);
    }

    private void setDeliveryAddresses(List<DeliveryAddress> deliveryAddressList) {
        if (deliveryAddressList != null) {
            for (DeliveryAddress deliveryAddress : deliveryAddressList) {
                String address = deliveryAddress.getAddress();
                if (address == null || address.isEmpty()) continue;
                this.listModel.addElement(deliveryAddress);
            }
        }
    }

    private void init() {
        this.setTitle(VersionInfo.getAppName());
        this.setLayout(new BorderLayout(5, 5));
        this.centerPanel = new JPanel(new BorderLayout(5, 5));
        this.centerPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.listModel = new DefaultListModel();
        JScrollPane scrollPane = new JScrollPane();
        this.list = new JList<DeliveryAddress>(this.listModel);
        this.list.setFixedCellHeight(60);
        this.list.setFocusable(true);
        scrollPane.setViewportView(this.list);
        this.centerPanel.add((Component)scrollPane, "Center");
        this.add(this.centerPanel);
        this.addButtonPanel();
    }

    private void addButtonPanel() {
        PosButton selectButton = new PosButton(OroCustMessages.getString("DeliveryAddressSelectionDialog.0"));
        selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DeliveryAddressSelectionDialog.this.selectedDeliveryAddress = (DeliveryAddress)DeliveryAddressSelectionDialog.this.list.getSelectedValue();
                    if (DeliveryAddressSelectionDialog.this.selectedDeliveryAddress == null) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), OroCustMessages.getString("DeliveryAddressNotSelected"));
                        return;
                    }
                    DeliveryAddressSelectionDialog.this.setCanceled(false);
                    DeliveryAddressSelectionDialog.this.dispose();
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        PosButton cancelButton = new PosButton(POSConstants.CANCEL.toUpperCase());
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeliveryAddressSelectionDialog.this.setCanceled(true);
                DeliveryAddressSelectionDialog.this.dispose();
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(selectButton);
        panel.add(cancelButton);
        this.centerPanel.add((Component)panel, "South");
    }

    public DeliveryAddress getSelectedAddress() {
        return this.selectedDeliveryAddress;
    }
}

