/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.model.OrderType;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSDialog;
import com.orocube.orocust.OroCustMessages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class DeliveryOrderTypeSelectionDialog
extends POSDialog {
    private OrderType selectedOrderType;
    private List<OrderType> orderTypes;

    public DeliveryOrderTypeSelectionDialog(List<OrderType> orderTypes) {
        this.orderTypes = orderTypes;
        this.initializeComponent();
    }

    private void initializeComponent() {
        this.setTitle(OroCustMessages.getString("OrderTypeSelectionDialog.0"));
        this.setResizable(false);
        this.setLayout(new BorderLayout(5, 5));
        JPanel orderTypePanel = new JPanel(new GridLayout(1, 0, 10, 10));
        orderTypePanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        if (this.orderTypes != null) {
            for (OrderType orderType : this.orderTypes) {
                DeliveryOrderTypeButton btnDeliveryOrderType = new DeliveryOrderTypeButton(orderType);
                orderTypePanel.add(btnDeliveryOrderType);
            }
        }
        PosButton btnCancel = new PosButton(POSConstants.CANCEL_BUTTON_TEXT);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeliveryOrderTypeSelectionDialog.this.setCanceled(true);
                DeliveryOrderTypeSelectionDialog.this.dispose();
            }
        });
        orderTypePanel.add((Component)btnCancel, "growx, span");
        this.add(orderTypePanel);
    }

    public OrderType getSelectedOrderType() {
        return this.selectedOrderType;
    }

    private class DeliveryOrderTypeButton
    extends PosButton
    implements ActionListener {
        OrderType orderType;

        public DeliveryOrderTypeButton(OrderType orderType) {
            this.orderType = orderType;
            this.setText(orderType.getName());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DeliveryOrderTypeSelectionDialog.this.selectedOrderType = this.orderType;
            DeliveryOrderTypeSelectionDialog.this.setCanceled(false);
            DeliveryOrderTypeSelectionDialog.this.dispose();
        }
    }
}

