/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.DeliveryAddress;
import com.floreantpos.model.DeliveryCharge;
import com.floreantpos.model.DeliveryInstruction;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.DeliveryChargeDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosOptionPane;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosSmallButton;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.swing.TimeSelector;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.LengthInputDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.orocube.orocust.OroCustMessages;
import com.orocube.orocust.ui.dialog.DeliveryAddressSelectionDialog;
import com.orocube.orocust.ui.dialog.DeliveryInstructionSelectionDialog;
import com.orocube.orocust.ui.util.GMapUtil;
import com.orocube.orocust.ui.view.MapBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.calendar.CalendarUtils;

public class DeliverySelectionDialog
extends POSDialog {
    private Date selectedDate;
    private String shippingAddress;
    private String zipCode;
    private JXDatePicker datePicker;
    private JTextArea taDeliveryAddress;
    private TimeSelector timeSelector;
    private JTextField tfRecipientName;
    private JTextArea taExtraInstruction;
    private JTextArea taManagerInstruction;
    private PosSmallButton btnCancel;
    private DoubleTextField tfDeliveryChargeAmount;
    private JComboBox<Object> cbDeliveryChargeList;
    private FixedLengthTextField tfPhoneNo;
    private FixedLengthTextField tfPhoneExtension;
    private FixedLengthTextField tfRoomNo;
    private POSToggleButton cbCustomerPickup;
    private Customer customer;
    private OrderType orderType;
    private QwertyKeyPad qwertyKeyPad;
    private DeliveryAddress deliveryAddress;
    private DeliveryInstruction deliveryInstruction;
    private MapBrowser mapPanel;
    private String terminalLocation;
    private Timer timer;
    private PosButton btnSelectCustomer;
    private PosButton btnAddDeliveryCharge;
    private PosButton btnDeliveryAddress;
    private boolean chargeByZipcode;
    private double distance;
    private Ticket ticket;

    public DeliverySelectionDialog(JFrame parent, Ticket ticket, OrderType orderType, Customer customer) {
        super((Frame)parent, true);
        this.setTitle(VersionInfo.getAppName());
        this.orderType = orderType;
        this.ticket = ticket;
        this.createUI();
        this.setCustomer(customer);
        this.initData();
    }

    private void initData() {
        CustomerDAO.getInstance().initialize(this.customer);
        this.terminalLocation = DataProvider.get().getCurrentTerminal().getLocation();
        Store store = DataProvider.get().getStore();
        this.chargeByZipcode = Boolean.valueOf(store.getProperty("deliveryConfig.zipcode"));
        if (this.customer != null && (this.customer.getDeliveryAddresses() == null || this.customer.getDeliveryAddresses().isEmpty()) && StringUtils.isNotBlank((String)this.customer.getAddress())) {
            DeliveryAddress deliveryAddress = new DeliveryAddress();
            deliveryAddress.setAddress(this.customer.getAddress());
            this.customer.addTodeliveryAddresses(deliveryAddress);
        }
        List<DeliveryCharge> deliveryChargeList = DeliveryChargeDAO.getInstance().findAll();
        Collections.sort(deliveryChargeList, new Comparator<DeliveryCharge>(){

            @Override
            public int compare(DeliveryCharge o1, DeliveryCharge o2) {
                return (int)(o1.getChargeAmount() - o2.getChargeAmount());
            }
        });
        this.cbDeliveryChargeList.addItem(OroCustMessages.getString("OroCust.DSD.0"));
        for (DeliveryCharge deliveryCharge : deliveryChargeList) {
            this.cbDeliveryChargeList.addItem(deliveryCharge);
        }
        String address = "";
        if (this.ticket != null) {
            address = this.ticket.getDeliveryAddress();
        } else if (this.customer != null) {
            address = this.customer.getAddress();
            if (StringUtils.isNotEmpty((String)address)) {
                address = address + ", ";
            }
            if (StringUtils.isNotEmpty((String)this.customer.getCity())) {
                address = address + this.customer.getCity() + ", ";
            }
            if (StringUtils.isNotEmpty((String)this.customer.getState())) {
                address = address + this.customer.getState() + " ";
            }
            if (StringUtils.isNotEmpty((String)this.customer.getZipCode())) {
                address = address + this.customer.getZipCode() + " ";
            }
        }
        this.taDeliveryAddress.setText(address);
        this.applyDeliveryChargeByZipCode();
        this.loadMapImage();
        this.setLastSelectedRange();
        this.setTicket(this.ticket);
    }

    private void setLastSelectedRange() {
        if (this.ticket != null) {
            Double deliveryCharge = this.ticket.getDeliveryCharge();
            Double distance2 = this.mapPanel.getDistance();
            DeliveryChargeDAO dao = DeliveryChargeDAO.getInstance();
            List<DeliveryCharge> deliveryChargeList = dao.findByDistance(distance2);
            if (deliveryChargeList != null && !deliveryChargeList.isEmpty()) {
                this.cbDeliveryChargeList.setSelectedItem(deliveryChargeList.get(0));
            } else if (dao.findMaxRange() != null && distance2 > dao.findMaxRange()) {
                this.cbDeliveryChargeList.setSelectedIndex(this.cbDeliveryChargeList.getModel().getSize() - 1);
            } else {
                this.cbDeliveryChargeList.setSelectedIndex(0);
            }
            this.tfDeliveryChargeAmount.setText(String.valueOf(deliveryCharge));
        }
    }

    private void createUI() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("hidemode 3, fill,inset 10 10 0 10", "[40%][60%]", ""));
        this.setDefaultCloseOperation(2);
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(OroCustMessages.getString("OroCust.DSD.9"));
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "[][][][]", ""));
        topPanel.setBorder(new TitledBorder(null, OroCustMessages.getString("OroCust.DSD.10"), 4, 2, null, null));
        this.getContentPane().add((Component)titlePanel, "North");
        JLabel lblRecepientName = new JLabel(OroCustMessages.getString("DeliverySelectionView.9"));
        this.tfRecipientName = new JTextField();
        this.tfRecipientName.setEditable(false);
        this.tfRecipientName.setColumns(10);
        this.btnSelectCustomer = new PosButton(OroCustMessages.getString("CallerIdCustomerSelectionDialog.0"));
        this.btnSelectCustomer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeliverySelectionDialog.this.doSelectCustomer();
            }
        });
        JLabel lblDeliveryDate = new JLabel(OroCustMessages.getString("DeliverySelectionView.15"));
        this.datePicker = new JXDatePicker();
        Calendar calendar = this.datePicker.getMonthView().getCalendar();
        calendar.setTime(new Date());
        this.datePicker.getMonthView().setLowerBound(calendar.getTime());
        CalendarUtils.endOfWeek((Calendar)calendar);
        calendar.add(calendar.get(4), 4);
        this.datePicker.getMonthView().setUpperBound(calendar.getTime());
        this.datePicker.setDate(new Date());
        this.datePicker.getEditor().setEditable(false);
        this.timeSelector = new TimeSelector();
        JLabel lblShippingAddress = new JLabel(OroCustMessages.getString("DeliverySelectionView.20"));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(3, 80));
        PosButton btnSearchMap = new PosButton(OroCustMessages.getString("OroCust.DSD.12"));
        btnSearchMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeliverySelectionDialog.this.doSearchAddresses();
            }
        });
        this.btnDeliveryAddress = new PosButton("<html><center>" + OroCustMessages.getString("OroCust.DSD.14") + "</center></html>");
        this.btnDeliveryAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeliverySelectionDialog.this.doSelectPreviousDeliveryAddress();
            }
        });
        this.taDeliveryAddress = new JTextArea();
        scrollPane.setViewportView(this.taDeliveryAddress);
        JLabel lblExtraInstruction = new JLabel(OroCustMessages.getString("DeliverySelectionView.23"));
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setPreferredSize(new Dimension(3, 80));
        PosButton btnExtranInstructions = new PosButton("<html><center>" + OroCustMessages.getString("OroCust.DSD.17") + "</center></html>");
        btnExtranInstructions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeliverySelectionDialog.this.doShowAllExtraInfo();
            }
        });
        if (this.taExtraInstruction == null) {
            this.taExtraInstruction = new JTextArea();
        }
        this.taExtraInstruction.setPreferredSize(new Dimension(0, 40));
        this.taExtraInstruction.setRows(3);
        scrollPane_1.setViewportView(this.taExtraInstruction);
        this.taManagerInstruction = new JTextArea();
        this.taManagerInstruction.setPreferredSize(new Dimension(0, 40));
        this.taManagerInstruction.setRows(3);
        JScrollPane scrollPane_2 = new JScrollPane();
        scrollPane_2.setPreferredSize(new Dimension(3, 80));
        scrollPane_2.setViewportView(this.taManagerInstruction);
        this.tfDeliveryChargeAmount = new DoubleTextField(10);
        this.cbDeliveryChargeList = new JComboBox();
        this.cbDeliveryChargeList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object object = e.getItem();
                DeliverySelectionDialog.this.doSetDeliveryCharge(object);
            }
        });
        this.btnAddDeliveryCharge = new PosButton("<html><center>" + OroCustMessages.getString("OroCust.DSD.20") + "</center></html>");
        this.btnAddDeliveryCharge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double distance = LengthInputDialog.takeDoubleInput(OroCustMessages.getString("OroCust.DSD.22"), 0.0);
                if (distance < 0.0) {
                    return;
                }
                DeliverySelectionDialog.this.updateDeliveryCharge(distance);
            }
        });
        JLabel lblPhone = new JLabel(OroCustMessages.getString("OroCust.DSD.23"), 4);
        topPanel.add((Component)lblPhone, "cell 1 0,alignx trailing");
        this.tfPhoneNo = new FixedLengthTextField();
        this.tfPhoneNo.setLength(20);
        topPanel.add((Component)this.tfPhoneNo, "flowx,cell 2 0,grow");
        JLabel label = new JLabel(OroCustMessages.getString("OroCust.DSD.24"));
        topPanel.add((Component)label, "cell 2 0,alignx trailing");
        this.tfPhoneExtension = new FixedLengthTextField();
        this.tfPhoneExtension.setLength(5);
        topPanel.add((Component)this.tfPhoneExtension, "cell 2 0, width 70!");
        topPanel.add((Component)lblRecepientName, "cell 1 1,alignx trailing");
        topPanel.add((Component)this.tfRecipientName, "cell 2 1,growx,split 2,height 35!");
        topPanel.add((Component)this.btnSelectCustomer, "cell 2 3, grow, w 127!,height 35!");
        this.cbCustomerPickup = new POSToggleButton(OroCustMessages.getString("DeliverySelectionView.14"));
        this.cbCustomerPickup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = DeliverySelectionDialog.this.cbCustomerPickup.isSelected();
                DeliverySelectionDialog.this.setPickupEnable(enabled);
            }
        });
        topPanel.add((Component)this.cbCustomerPickup, "cell 2 2");
        topPanel.add((Component)lblDeliveryDate, "cell 1 3,alignx trailing,growy");
        topPanel.add((Component)this.datePicker, "cell 2 3,growy,height 40!,width 180!");
        topPanel.add((Component)this.timeSelector, "cell 2 3,growy");
        topPanel.add((Component)lblShippingAddress, "cell 1 4,alignx trailing,aligny top");
        topPanel.add((Component)scrollPane, "cell 2 4,grow,split 3");
        topPanel.add((Component)btnSearchMap, "cell 3 4,growy");
        topPanel.add((Component)this.btnDeliveryAddress, "cell 4 4,aligny top,growy, w 100!");
        JLabel label_2 = new JLabel(OroCustMessages.getString("OroCust.DSD.26"));
        topPanel.add((Component)label_2, "cell 1 5,alignx trailing,aligny top");
        this.tfRoomNo = new FixedLengthTextField();
        this.tfRoomNo.setLength(20);
        topPanel.add((Component)this.tfRoomNo, "cell 2 5,width 70!");
        topPanel.add((Component)lblExtraInstruction, "cell 1 7,alignx trailing,aligny top");
        topPanel.add((Component)scrollPane_1, "cell 2 7,aligny top,grow,split 2");
        topPanel.add((Component)btnExtranInstructions, "cell 3 7 2 1,aligny top,growy, w 150!");
        topPanel.add((Component)new JLabel(OroCustMessages.getString("OroCust.DSD.29")), "cell 1 8,alignx trailing,aligny top");
        topPanel.add((Component)scrollPane_2, "cell 2 8,aligny top,grow");
        topPanel.add((Component)new JLabel(OroCustMessages.getString("OroCust.DSD.31")), "cell 1 9,aligny top,gapy 5,grow");
        topPanel.add((Component)this.tfDeliveryChargeAmount, "cell 2 9,growy,aligny top,gapy 5");
        topPanel.add(this.cbDeliveryChargeList, "cell 2 9,height 35!,aligny top,gapy 5,grow,split 2");
        topPanel.add((Component)this.btnAddDeliveryCharge, "cell 3 9,height 35!,aligny top,gapy 5,growy, w 150!");
        JPanel leftPanel = new JPanel(new BorderLayout());
        PosScrollPane jScrollPane = new PosScrollPane(topPanel, 20, 31);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        leftPanel.add((Component)jScrollPane, "Center");
        contentPanel.add((Component)leftPanel, "grow");
        this.mapPanel = new MapBrowser();
        this.mapPanel.setBorder(BorderFactory.createTitledBorder(OroCustMessages.getString("OroCust.DSD.37")));
        contentPanel.add((Component)this.mapPanel, "grow, gapbottom 2");
        PosScrollPane posScrollPane = new PosScrollPane(contentPanel);
        posScrollPane.setVerticalScrollBarPolicy(20);
        posScrollPane.setHorizontalScrollBarPolicy(31);
        this.getContentPane().add((Component)contentPanel, "Center");
        JPanel footerPanel = new JPanel(new BorderLayout(10, 10));
        footerPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.qwertyKeyPad = new QwertyKeyPad();
        this.qwertyKeyPad.setCollapsed(true);
        JPanel keyBoardPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3, fill, ins 0 0 2 2"));
        keyBoardPanel.add((Component)((Object)this.qwertyKeyPad), "grow");
        leftPanel.add((Component)keyBoardPanel, "South");
        JPanel panel_1 = new JPanel((LayoutManager)new MigLayout("inset 0 0 5 0,al center", "sg, fill", ""));
        PosButton btnKeyboard = new PosButton(IconFactory.getIcon("/images/", "keyboard.png"));
        btnKeyboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeliverySelectionDialog.this.qwertyKeyPad.setCollapsed(!DeliverySelectionDialog.this.qwertyKeyPad.isCollapsed());
            }
        });
        panel_1.add((Component)btnKeyboard, "grow");
        this.btnCancel = new PosSmallButton();
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeliverySelectionDialog.this.setCanceled(true);
                DeliverySelectionDialog.this.dispose();
            }
        });
        this.btnCancel.setText(OroCustMessages.getString("DeliverySelectionView.27"));
        panel_1.add((Component)this.btnCancel, "grow");
        PosSmallButton btnSaveProceed = new PosSmallButton();
        btnSaveProceed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DeliverySelectionDialog.this.finish()) {
                    DeliverySelectionDialog.this.setCanceled(false);
                    DeliverySelectionDialog.this.dispose();
                }
            }
        });
        btnSaveProceed.setText(OroCustMessages.getString("DeliverySelectionView.28"));
        panel_1.add((Component)btnSaveProceed, "grow");
        footerPanel.add((Component)new JSeparator(), "Center");
        footerPanel.add((Component)panel_1, "South");
        this.getContentPane().add((Component)footerPanel, "South");
    }

    protected void doSelectCustomer() {
        CustomerSelectorDialog dialog = CustomerSelectorFactory.createCustomerSelectorDialog(this.orderType);
        dialog.setCreateNewTicket(false);
        dialog.setCallerId(this.tfPhoneNo.getText());
        dialog.updateView(true);
        dialog.openUndecoratedFullScreen();
        if (dialog.isCanceled()) {
            return;
        }
        this.customer = dialog.getSelectedCustomer();
        if (this.customer == null) {
            return;
        }
        CustomerDAO.getInstance().initialize(this.customer);
        this.tfPhoneNo.setText(this.customer.getMobileNo());
        this.tfRecipientName.setText(this.customer.getName());
        if (this.ticket != null) {
            this.ticket.setCustomer(this.customer);
        }
    }

    protected void applyDeliveryChargeByZipCode() {
        if (this.customer == null) {
            return;
        }
        DeliveryChargeDAO dao = DeliveryChargeDAO.getInstance();
        List<DeliveryCharge> deliveryChargeList = null;
        if (this.chargeByZipcode) {
            deliveryChargeList = dao.findByZipCode(this.customer.getZipCode());
            if (deliveryChargeList != null && !deliveryChargeList.isEmpty()) {
                this.cbDeliveryChargeList.setSelectedItem(deliveryChargeList.get(0));
            } else {
                this.cbDeliveryChargeList.setSelectedIndex(0);
            }
        }
    }

    private void doSearchAddresses() {
        if (this.taDeliveryAddress.getText().isEmpty()) {
            return;
        }
        if (this.terminalLocation == null || this.terminalLocation.isEmpty()) {
            this.terminalLocation = PosOptionPane.showInputDialog(OroCustMessages.getString("OroCust.DSD.47"));
            if (this.terminalLocation == null) {
                return;
            }
            TerminalDAO terminalDAO = TerminalDAO.getInstance();
            Terminal terminal = terminalDAO.get(Application.getInstance().getTerminal().getId());
            terminal.setLocation(this.terminalLocation);
            terminalDAO.saveOrUpdate(terminal);
            Application.getInstance().refreshAndGetTerminal();
        }
        List<DeliveryAddress> deliveryAddresses = GMapUtil.getPlaces(this.taDeliveryAddress.getText());
        DeliveryAddressSelectionDialog dialog = new DeliveryAddressSelectionDialog(deliveryAddresses);
        dialog.setSize(600, 415);
        dialog.open();
        if (!dialog.isCanceled()) {
            this.taDeliveryAddress.setText(dialog.getSelectedAddress().getAddress());
            this.loadMapImage();
            try {
                this.distance = this.mapPanel.getDistance();
                this.updateDeliveryCharge(this.distance);
            }
            catch (Exception ex) {
                PosLog.error(DeliverySelectionDialog.class, ex.getMessage());
            }
        }
    }

    private void loadMapImage() {
        this.mapPanel.load(this.terminalLocation, this.taDeliveryAddress.getText());
    }

    private void updateDeliveryCharge(double distance) {
        DeliveryChargeDAO dao;
        List<DeliveryCharge> deliveryChargeList;
        if (this.chargeByZipcode) {
            return;
        }
        if (distance <= 0.0) {
            this.cbDeliveryChargeList.setSelectedIndex(0);
        }
        if ((deliveryChargeList = (dao = DeliveryChargeDAO.getInstance()).findByDistance(distance)) != null && !deliveryChargeList.isEmpty()) {
            this.cbDeliveryChargeList.setSelectedIndex(0);
            this.cbDeliveryChargeList.setSelectedItem(deliveryChargeList.get(0));
        } else {
            Double maxRange = dao.findMaxRange();
            if (maxRange == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), OroCustMessages.getString("DeliverySelectionDialog.0"));
                return;
            }
            if (distance > maxRange) {
                this.cbDeliveryChargeList.setSelectedIndex(0);
                this.cbDeliveryChargeList.setSelectedIndex(this.cbDeliveryChargeList.getModel().getSize() - 1);
            } else {
                this.cbDeliveryChargeList.setSelectedIndex(0);
            }
        }
    }

    private Date captureDeliveryDate() {
        Date date = this.datePicker.getDate();
        if (date == null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), OroCustMessages.getString("OroCust.DSD.48"));
            return null;
        }
        int hour = this.timeSelector.getSelectedHour();
        int min = this.timeSelector.getSelectedMin();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(10, hour == 12 ? 0 : hour);
        calendar.set(12, min);
        calendar.set(9, this.timeSelector.getAmPm());
        return calendar.getTime();
    }

    private String captureShippingAddress() {
        return this.taDeliveryAddress.getText();
    }

    public Date getDeliveryDate() {
        return this.selectedDate;
    }

    public String getShippingAddress() {
        return this.shippingAddress;
    }

    public String getExtraDeliveryInfo() {
        return this.taExtraInstruction.getText().trim();
    }

    public String getManagerInstruction() {
        return this.taManagerInstruction.getText().trim();
    }

    public void setExtraDeliveryInfo(String extraInfo) {
        this.taExtraInstruction.setText(extraInfo);
    }

    @Override
    public String getName() {
        return OroCustMessages.getString("DeliverySelectionView.33");
    }

    public void setRecipientName(String name) {
        this.tfRecipientName.setText(name);
    }

    public void setDeliveryAddress(String shippingAddress) {
        this.taDeliveryAddress.setText(shippingAddress);
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeliverySelectionDialog.this.loadMap();
            }
        });
        this.timer.setRepeats(false);
        this.timer.start();
    }

    public void loadMap() {
        if (this.customer.getAddress() != null && !this.customer.getAddress().isEmpty()) {
            this.loadMapImage();
        }
    }

    public boolean willCustomerPickup() {
        return this.cbCustomerPickup.isSelected();
    }

    public boolean finish() {
        try {
            String phoneNo = this.tfPhoneNo.getText();
            String delAddress = this.taDeliveryAddress.getText();
            if (!this.cbCustomerPickup.isSelected()) {
                if (StringUtils.isBlank((String)phoneNo)) {
                    POSMessageDialog.showError(this, OroCustMessages.getString("OroCust.DSD.49"));
                    return false;
                }
                if (StringUtils.isBlank((String)delAddress)) {
                    POSMessageDialog.showError(this, OroCustMessages.getString("OroCust.DSD.9"));
                    return false;
                }
            }
            if (this.customer == null) {
                if (StringUtils.isBlank((String)phoneNo)) {
                    POSMessageDialog.showError(this, OroCustMessages.getString("OroCust.DSD.49"));
                    return false;
                }
                List<Customer> customers = CustomerDAO.getInstance().findByMobileNumber(phoneNo);
                if (customers.size() > 0) {
                    this.customer = customers.get(0);
                } else {
                    this.customer = new Customer();
                    this.customer.setMobileNo(phoneNo.trim());
                    this.customer.setFirstName(phoneNo.trim());
                    this.customer.setName(phoneNo.trim());
                    CustomerDAO.getInstance().save(this.customer);
                }
            }
            this.selectedDate = this.captureDeliveryDate();
            if (this.selectedDate == null) {
                return false;
            }
            if (this.selectedDate.compareTo(new Date()) < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), OroCustMessages.getString("OroCust.DSD.50"));
                return false;
            }
            this.shippingAddress = this.captureShippingAddress();
            if (this.customer != null && this.customer.getDeliveryAddresses() != null) {
                for (DeliveryAddress address : this.customer.getDeliveryAddresses()) {
                    if (address.getAddress() == null || !address.getAddress().equals(this.shippingAddress)) continue;
                    this.deliveryAddress = address;
                }
            }
            if (this.deliveryAddress == null) {
                this.deliveryAddress = new DeliveryAddress();
                this.deliveryAddress.setCustomer(this.customer);
                this.customer.addTodeliveryAddresses(this.deliveryAddress);
            }
            if (this.deliveryAddress.getDistance() <= 0.0) {
                this.deliveryAddress.setDistance(this.distance);
            }
            this.deliveryAddress.setAddress(delAddress.trim());
            this.deliveryAddress.setPhoneExtension(this.tfPhoneExtension.getText().trim());
            this.deliveryAddress.setRoomNo(this.tfRoomNo.getText().trim());
            if (this.customer.getDeliveryInstructions() != null) {
                for (DeliveryInstruction instruction : this.customer.getDeliveryInstructions()) {
                    if (instruction.getNotes() == null || !instruction.getNotes().equals(this.taExtraInstruction.getText())) continue;
                    this.deliveryInstruction = instruction;
                }
            }
            if (this.deliveryInstruction == null) {
                this.deliveryInstruction = new DeliveryInstruction();
                this.deliveryInstruction.setCustomer(this.customer);
                this.customer.addTodeliveryInstructions(this.deliveryInstruction);
            }
            this.deliveryInstruction.setNotes(this.taExtraInstruction.getText().trim());
            CustomerDAO.getInstance().saveOrUpdate(this.customer);
            if (this.ticket != null) {
                this.ticket.addProperty("CUSTOMER_NAME", this.tfRecipientName.getText().trim());
                this.ticket.addProperty("CUSTOMER_MOBILE", this.tfPhoneNo.getText().trim());
                this.ticket.addProperty("PHONE_EXTENSION", this.getPhoneExtension());
                this.ticket.setDeliveryDate(this.selectedDate);
                this.ticket.setDeliveryAddress(this.shippingAddress.trim());
                this.ticket.setExtraDeliveryInfo(this.getExtraDeliveryInfo());
                this.ticket.addProperty("MANAGER_INSTRUCTION", this.getManagerInstruction());
                this.ticket.setDeliveryCharge(this.getDeliveryCharge());
                this.ticket.setCustomerWillPickup(this.cbCustomerPickup.isSelected());
                this.ticket.setCustomer(this.customer);
            }
            this.ticket.calculatePrice();
            return true;
        }
        catch (PosException e) {
            POSMessageDialog.showError(e.getMessage());
            return false;
        }
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
        if (customer != null) {
            this.setRecipientName(customer.getName());
        }
    }

    public void setCustomerWillPickUp(boolean enabled) {
        this.cbCustomerPickup.setSelected(enabled);
        this.setPickupEnable(enabled);
    }

    public void setPickupEnable(boolean enabled) {
        this.taDeliveryAddress.setEditable(!enabled);
        this.tfRoomNo.setEditable(!enabled);
        this.tfDeliveryChargeAmount.setText("");
        this.tfDeliveryChargeAmount.setEditable(!enabled);
        this.cbDeliveryChargeList.setEnabled(!enabled);
        this.btnAddDeliveryCharge.setEnabled(!enabled);
        this.btnDeliveryAddress.setEnabled(!enabled);
    }

    public String getDeliveryAddress() {
        return this.tfRoomNo.getText() + " " + this.getShippingAddress();
    }

    public String getZipCode() {
        if (this.zipCode == null) {
            return this.customer.getZipCode();
        }
        return this.zipCode;
    }

    public OrderType getTicketType() {
        return this.orderType;
    }

    public void setDeliveryCharge(Double value) {
        this.tfDeliveryChargeAmount.setText(String.valueOf(value));
    }

    public double getDeliveryCharge() {
        if (this.tfDeliveryChargeAmount.isEmpty()) {
            return 0.0;
        }
        return this.tfDeliveryChargeAmount.getDouble();
    }

    public String getPhoneExtension() {
        return this.tfPhoneExtension.getText().trim();
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
        if (ticket == null) {
            return;
        }
        this.setDeliveryTime(ticket);
        String phone = ticket.getProperty("CUSTOMER_MOBILE");
        if (StringUtils.isEmpty((String)phone) && this.customer != null) {
            phone = this.customer.getMobileNo();
        }
        this.tfPhoneNo.setText(phone);
        this.tfPhoneExtension.setText(ticket.getProperty("PHONE_EXTENSION"));
        this.cbCustomerPickup.setSelected(ticket.isCustomerWillPickup());
        this.taExtraInstruction.setText(ticket.getExtraDeliveryInfo());
        this.taManagerInstruction.setText(ticket.getProperty("MANAGER_INSTRUCTION"));
    }

    private void setDeliveryTime(Ticket ticket) {
        Date deliveryDate = ticket.getDeliveryDate();
        if (deliveryDate == null) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(deliveryDate);
        this.datePicker.setDate(deliveryDate);
        this.timeSelector.setSelectedHour(calendar.get(10));
        this.timeSelector.setSelectedMin(calendar.get(12));
        this.timeSelector.setAmPm(calendar.get(9));
    }

    private void doSelectPreviousDeliveryAddress() {
        boolean isEmpty;
        if (this.customer == null) {
            return;
        }
        List<DeliveryAddress> deliveryAddresses = this.customer.getDeliveryAddresses();
        boolean bl = isEmpty = deliveryAddresses == null || deliveryAddresses.isEmpty();
        if (isEmpty || !deliveryAddresses.stream().anyMatch(address -> StringUtils.isNotBlank((String)address.getAddress()))) {
            POSMessageDialog.showMessage(OroCustMessages.getString("OroCust.DSD.53"));
            return;
        }
        DeliveryAddressSelectionDialog explorer = new DeliveryAddressSelectionDialog(this.customer);
        explorer.setSize(600, 415);
        explorer.open();
        if (!explorer.isCanceled()) {
            this.deliveryAddress = explorer.getSelectedAddress();
            this.taDeliveryAddress.setText(this.deliveryAddress.getAddress());
            this.tfPhoneExtension.setText(this.deliveryAddress.getPhoneExtension());
            this.tfRoomNo.setText(this.deliveryAddress.getRoomNo());
            this.mapPanel.load(this.terminalLocation, this.deliveryAddress.getAddress());
            try {
                Double distance = this.deliveryAddress.getDistance();
                if (distance <= 0.0) {
                    distance = GMapUtil.getDistanceAsDouble(this.terminalLocation, this.taDeliveryAddress.getText());
                    distance = distance / 1000.0;
                }
                this.updateDeliveryCharge(distance);
            }
            catch (Exception ex) {
                PosLog.error(this.getClass(), ex.getMessage(), ex);
            }
        }
    }

    private void doShowAllExtraInfo() {
        if (CollectionUtils.isEmpty(this.customer.getDeliveryInstructions())) {
            POSMessageDialog.showMessage(OroCustMessages.getString("OroCust.DSD.53"));
            return;
        }
        DeliveryInstructionSelectionDialog explorer = new DeliveryInstructionSelectionDialog(this.customer);
        explorer.setSize(600, 400);
        explorer.open();
        if (!explorer.isCanceled()) {
            this.deliveryInstruction = explorer.getSelectedInstruction();
            this.taExtraInstruction.setText(this.deliveryInstruction.getNotes());
        }
    }

    private void doSetDeliveryCharge(Object object) {
        if (object instanceof DeliveryCharge) {
            DeliveryCharge deliveryCharge = (DeliveryCharge)object;
            this.tfDeliveryChargeAmount.setText(String.valueOf(deliveryCharge.getChargeAmount()));
        } else {
            this.tfDeliveryChargeAmount.setText("0");
        }
    }
}

