/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.util;

import com.floreantpos.model.DeliveryAddress;
import com.floreantpos.model.Store;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import com.google.maps.DirectionsApi;
import com.google.maps.DistanceMatrixApi;
import com.google.maps.GeoApiContext;
import com.google.maps.GeocodingApi;
import com.google.maps.PlacesApi;
import com.google.maps.model.AutocompletePrediction;
import com.google.maps.model.DirectionsResult;
import com.google.maps.model.DirectionsRoute;
import com.google.maps.model.DistanceMatrix;
import com.google.maps.model.GeocodingResult;
import com.orocube.orocust.OroCustMessages;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class GMapUtil {
    private static GeoApiContext context = new GeoApiContext();

    public static List<DeliveryAddress> getPlaces(String searchString) {
        searchString = searchString.replaceAll(" ", "+");
        ArrayList<DeliveryAddress> list = new ArrayList<DeliveryAddress>();
        try {
            AutocompletePrediction[] response = (AutocompletePrediction[])PlacesApi.queryAutocomplete((GeoApiContext)context, (String)searchString).awaitIgnoreError();
            for (int i = 0; i < response.length; ++i) {
                DeliveryAddress address = new DeliveryAddress();
                address.setAddress(response[i].description);
                list.add(address);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return list;
    }

    public static List<DeliveryAddress> getNearByPlaces(String searchString) {
        searchString = searchString.replaceAll(" ", "+");
        ArrayList<DeliveryAddress> list = new ArrayList<DeliveryAddress>();
        try {
            GeocodingResult[] results = (GeocodingResult[])GeocodingApi.newRequest((GeoApiContext)context).address(searchString).await();
            for (int i = 0; i < results.length; ++i) {
                DeliveryAddress address = new DeliveryAddress();
                address.setAddress(results[i].formattedAddress);
                list.add(address);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return list;
    }

    public static String getDistance(String source, String destination) {
        String outputString = "";
        String[] origins = new String[]{source};
        String[] destinations = new String[]{destination};
        try {
            DistanceMatrix matrix = (DistanceMatrix)DistanceMatrixApi.getDistanceMatrix((GeoApiContext)context, (String[])origins, (String[])destinations).await();
            double distance = matrix.rows[0].elements[0].distance.inMeters;
            distance = NumberUtil.roundToTwoDigit(distance * 6.21371E-4);
            outputString = outputString + OroCustMessages.getString("GMapUtil.6") + distance + " " + "MILE".toLowerCase();
            outputString = outputString + OroCustMessages.getString("GMapUtil.8") + matrix.rows[0].elements[0].duration.humanReadable;
        }
        catch (Exception e) {
            return "";
        }
        return outputString;
    }

    public static String[] getDistanceAndDuration(String source, String destination) {
        String[] outputString = new String[]{"0", "0"};
        String[] origins = new String[]{source};
        String[] destinations = new String[]{destination};
        try {
            DistanceMatrix matrix = (DistanceMatrix)DistanceMatrixApi.getDistanceMatrix((GeoApiContext)context, (String[])origins, (String[])destinations).await();
            double distance = matrix.rows[0].elements[0].distance.inMeters;
            outputString[0] = String.valueOf(distance);
            outputString[1] = matrix.rows[0].elements[0].duration.humanReadable;
        }
        catch (Exception e) {
            return outputString;
        }
        return outputString;
    }

    public static double getDistanceAsDouble(String source, String destination) {
        double distance = 0.0;
        String[] origins = new String[]{source};
        String[] destinations = new String[]{destination};
        try {
            DistanceMatrix matrix = (DistanceMatrix)DistanceMatrixApi.getDistanceMatrix((GeoApiContext)context, (String[])origins, (String[])destinations).await();
            distance = matrix.rows[0].elements[0].distance.inMeters;
        }
        catch (Exception e) {
            return 0.0;
        }
        return distance;
    }

    public static String getDirection(String source, String destination) {
        String outputString = "";
        try {
            DirectionsResult result = (DirectionsResult)DirectionsApi.getDirections((GeoApiContext)context, (String)source, (String)destination).await();
            DirectionsRoute path = result.routes[0];
            outputString = path.overviewPolyline.getEncodedPath();
        }
        catch (Exception e) {
            return "";
        }
        return outputString;
    }

    static {
        Store store = DataProvider.get().getStore();
        String googleMapApiKey = store.getProperty("google.map.api.key", "AIzaSyDc-5LFTSC-bB9kQcZkM74LHUxwndRy_XM");
        context.setApiKey(googleMapApiKey).setConnectTimeout(30L, TimeUnit.SECONDS).setReadTimeout(30L, TimeUnit.SECONDS).setWriteTimeout(30L, TimeUnit.SECONDS);
    }
}

