/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.view;

import com.floreantpos.IconFactory;
import com.floreantpos.PosLog;
import com.floreantpos.customer.CustomerListTableModel;
import com.floreantpos.customer.CustomerSelector;
import com.floreantpos.customer.CustomerTable;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.model.Customer;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosBlinkButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.QuickCustomerForm;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.TicketAlreadyExistsException;
import com.orocube.orocust.OroCustMessages;
import com.orocube.orocust.ui.dialog.CustomerHistoryDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class CustomerListView
extends CustomerSelector {
    private PosBlinkButton btnCreateNewCustomer;
    private CustomerTable customerTable;
    private POSTextField tfSearchString;
    private PosButton btnInfo;
    protected Customer selectedCustomer;
    private PosButton btnRemoveCustomer;
    private Ticket ticket;
    private QwertyKeyPad qwertyKeyPad;
    private PosButton btnCancel;
    private static CustomerListView instance;
    private PosBlinkButton btnSelect;
    private CustomerListTableModel customerListTableModel;
    private PosButton btnNext;
    private PosButton btnPrevious;
    private JLabel lblNumberOfItem;
    private PosButton btnHistory;
    private PosButton btnSearch;

    public CustomerListView() {
        this.initUI();
    }

    public void initUI() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(new EmptyBorder(5, 0, 0, 0));
        JPanel searchPanel = new JPanel((LayoutManager)new MigLayout("fill,inset 5 0 5 0"));
        this.tfSearchString = new POSTextField(16);
        this.tfSearchString.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerListView.this.customerListTableModel.setCurrentRowIndex(0);
                CustomerListView.this.doSearchCustomer();
            }
        });
        PosButton btnKeyboard = new PosButton(IconFactory.getIcon("/images/", "keyboard.png"));
        btnKeyboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerListView.this.qwertyKeyPad.setCollapsed(!CustomerListView.this.qwertyKeyPad.isCollapsed());
            }
        });
        this.btnSearch = new PosButton(OroCustMessages.getString("CustomerSelectionDialog.15"));
        this.btnSearch.setFocusable(false);
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerListView.this.customerListTableModel.setCurrentRowIndex(0);
                CustomerListView.this.doSearchCustomer();
            }
        });
        searchPanel.add((Component)this.tfSearchString, "split 3,grow,span");
        searchPanel.add((Component)btnKeyboard, "h " + PosUIManager.getSize(45) + "!");
        searchPanel.add((Component)this.btnSearch, "w " + PosUIManager.getSize(100) + "!,h " + PosUIManager.getSize(45) + "!");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new TitledBorder(null, OroCustMessages.getString("CustomerListView.7"), 2, 2, null, null));
        JPanel customerListPanel = new JPanel(new BorderLayout(5, 5));
        customerListPanel.setBorder(new EmptyBorder(5, 5, 2, 5));
        this.customerTable = new CustomerTable();
        this.customerListTableModel = new CustomerListTableModel();
        this.customerListTableModel.setPageSize(20);
        this.customerTable.setModel(this.customerListTableModel);
        this.customerTable.setFocusable(false);
        this.customerTable.setRowHeight(35);
        this.customerTable.getTableHeader().setPreferredSize(new Dimension(100, 35));
        this.customerTable.getSelectionModel().setSelectionMode(0);
        this.customerTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CustomerListView.this.selectedCustomer = CustomerListView.this.customerTable.getSelectedCustomer();
                CustomerListView.this.btnSelect.setBlinking(true);
                CustomerListView.this.btnCreateNewCustomer.setBlinking(false);
            }
        });
        PosScrollPane scrollPane = new PosScrollPane();
        scrollPane.setFocusable(false);
        scrollPane.setViewportView(this.customerTable);
        customerListPanel.add((Component)searchPanel, "North");
        customerListPanel.add((Component)scrollPane, "Center");
        this.qwertyKeyPad = new QwertyKeyPad();
        this.qwertyKeyPad.setCollapsed(false);
        customerListPanel.add((Component)((Object)this.qwertyKeyPad), "South");
        centerPanel.add((Component)customerListPanel, "Center");
        this.add((Component)centerPanel, "Center");
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fillx, ins 0 0 0 0", "[center, grow][]", ""));
        this.btnInfo = new PosButton(OroCustMessages.getString("CustomerSelectionDialog.23"));
        this.btnInfo.setFocusable(false);
        this.btnInfo.setEnabled(false);
        this.btnHistory = new PosButton("<html><center>" + OroCustMessages.getString("CustomerListView.12") + "<center><html>");
        this.btnHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Customer customer;
                CustomerListView.this.selectedCustomer = customer = CustomerListView.this.customerTable.getSelectedCustomer();
                if (customer == null) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), OroCustMessages.getString("CustomerSelectionDialog.27"));
                    return;
                }
                CustomerListView.this.openCustomerHistory(customer);
            }
        });
        this.btnCreateNewCustomer = new PosBlinkButton("<html><center>" + OroCustMessages.getString("CustomerListView.15") + "<center><html>");
        this.btnCreateNewCustomer.setFocusable(false);
        this.btnCreateNewCustomer.setBlinking(false);
        this.btnCreateNewCustomer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerListView.this.btnCreateNewCustomer.setBlinking(false);
                CustomerListView.this.doCreateNewCustomer();
            }
        });
        this.btnRemoveCustomer = new PosButton(OroCustMessages.getString("CustomerSelectionDialog.26"));
        this.btnRemoveCustomer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerListView.this.doRemoveCustomerFromTicket();
            }
        });
        this.btnSelect = new PosBlinkButton(OroCustMessages.getString("CustomerSelectionDialog.28"));
        this.btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerListView.this.doSelectCustomer();
            }
        });
        this.btnSelect.setBlinking(false);
        this.btnCancel = new PosButton(OroCustMessages.getString("CustomerSelectionDialog.29"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerListView.this.closeDialog(true);
            }
        });
        this.btnNext = new PosButton(OroCustMessages.getString("CustomerListView.19"));
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomerListView.this.customerListTableModel.hasNext()) {
                    CustomerListView.this.customerListTableModel.setCurrentRowIndex(CustomerListView.this.customerListTableModel.getNextRowIndex());
                    CustomerListView.this.doSearchCustomer();
                }
            }
        });
        this.btnPrevious = new PosButton(OroCustMessages.getString("CustomerListView.20"));
        this.btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomerListView.this.customerListTableModel.hasPrevious()) {
                    CustomerListView.this.customerListTableModel.setCurrentRowIndex(CustomerListView.this.customerListTableModel.getPreviousRowIndex());
                    CustomerListView.this.doSearchCustomer();
                }
                CustomerListView.this.updateButtonStatus();
            }
        });
        Dimension size = PosUIManager.getSize(96, 50);
        panel.add((Component)this.btnHistory, "w " + size.width + "!, h " + size.height + "!, split 4");
        panel.add((Component)this.btnCreateNewCustomer, "w " + size.width + "!, h " + size.height + "!");
        panel.add((Component)this.btnSelect, "w " + size.width + "!, h " + size.height + "!");
        panel.add((Component)this.btnCancel, "w " + size.width + "!, h " + size.height + "!");
        this.lblNumberOfItem = new JLabel();
        panel.add(this.lblNumberOfItem);
        panel.add(this.btnPrevious);
        panel.add(this.btnNext);
        centerPanel.add((Component)panel, "South");
        this.updateButtonStatus();
    }

    public void updateButtonStatus() {
        this.btnNext.setEnabled(this.customerListTableModel.hasNext());
        this.btnPrevious.setEnabled(this.customerListTableModel.hasPrevious());
    }

    private void openCustomerHistory(Customer customer) {
        CustomerHistoryDialog dialog = new CustomerHistoryDialog(customer.getId(), this);
        dialog.openUndecoratedFullScreen();
        boolean reordered = dialog.isTicketReordered();
        if (reordered) {
            this.closeDialog(Boolean.TRUE);
        }
    }

    private void loadCustomer() {
        Customer customer = this.getCustomer();
        this.customerListTableModel.setCurrentRowIndex(0);
        if (customer != null) {
            this.tfSearchString.setText(customer.getMobileNo());
            this.doSearchCustomer();
        } else {
            this.tfSearchString.setText(this.getCallerId());
            this.doSearchCustomer();
        }
    }

    protected void doSetCustomer(Customer customer) {
        if (this.ticket != null) {
            this.ticket.setCustomer(customer);
            TicketDAO.getInstance().saveOrUpdate(this.ticket);
        }
    }

    protected void doRemoveCustomerFromTicket() {
        int option = POSMessageDialog.showYesNoQuestionDialog(this, OroCustMessages.getString("CustomerSelectionDialog.2"), OroCustMessages.getString("OrderWithCustomerService.9"));
        if (option != 0) {
            return;
        }
        this.ticket.removeCustomer();
        TicketDAO.getInstance().saveOrUpdate(this.ticket);
    }

    private void doCreateNewTicket() {
        try {
            Customer selectedCustomer = this.getSelectedCustomer();
            if (selectedCustomer == null) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), OroCustMessages.getString("CustomerSelectionDialog.27"));
                return;
            }
            this.closeDialog(false);
            OrderServiceFactory.getOrderService().createNewTicket(this.getOrderType(), null, selectedCustomer);
        }
        catch (TicketAlreadyExistsException ticketAlreadyExistsException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSearchCustomer() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.qwertyKeyPad.setCollapsed(true);
            String searchString = this.tfSearchString.getText();
            if (StringUtils.isEmpty((String)searchString)) {
                CustomerDAO.getInstance().loadCustomers(this.customerListTableModel);
            } else {
                CustomerDAO.getInstance().findByPhoneOrName(searchString, this.customerListTableModel);
            }
            if (this.customerListTableModel.getRows().size() == 0) {
                this.btnSelect.setBlinking(false);
                this.btnCreateNewCustomer.setBlinking(true);
            } else {
                this.btnSelect.setBlinking(true);
                this.btnCreateNewCustomer.setBlinking(false);
            }
            int startNumber = this.customerListTableModel.getCurrentRowIndex() + 1;
            int endNumber = this.customerListTableModel.getNextRowIndex();
            int totalNumber = this.customerListTableModel.getNumRows();
            if (endNumber > totalNumber) {
                endNumber = totalNumber;
            }
            this.lblNumberOfItem.setText(String.format(OroCustMessages.getString("CustomerListView.33"), startNumber, endNumber, totalNumber));
            this.customerListTableModel.fireTableDataChanged();
            this.customerTable.repaint();
            this.updateButtonStatus();
        }
        catch (Exception e) {
            PosLog.error(CustomerListView.class, e);
            e.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void closeDialog(boolean canceled) {
        Window windowAncestor = SwingUtilities.getWindowAncestor(this);
        if (windowAncestor instanceof POSDialog) {
            ((POSDialog)windowAncestor).setCanceled(canceled);
            windowAncestor.dispose();
        }
    }

    protected void doCreateNewCustomer() {
        try {
            boolean setKeyPad = true;
            QuickCustomerForm form = new QuickCustomerForm(setKeyPad);
            form.enableCustomerFields(true);
            String phoneNo = this.tfSearchString.getText();
            if (StringUtils.isEmpty((String)phoneNo)) {
                phoneNo = this.getCallerId();
            }
            form.setPhoneNo(phoneNo);
            BeanEditorDialog dialog = new BeanEditorDialog(POSUtil.getFocusedWindow(), (BeanEditor)form);
            dialog.setResizable(false);
            dialog.open();
            if (!dialog.isCanceled()) {
                this.selectedCustomer = (Customer)form.getBean();
                CustomerListTableModel model = (CustomerListTableModel)this.customerTable.getModel();
                model.addItem(this.selectedCustomer);
                if (this.selectedCustomer.getMobileNo() == null) {
                    this.tfSearchString.setText(this.selectedCustomer.getFirstName());
                } else {
                    this.tfSearchString.setText(this.selectedCustomer.getMobileNo());
                }
                this.customerListTableModel.setCurrentRowIndex(0);
                this.doSearchCustomer();
                this.customerTable.getSelectionModel().addSelectionInterval(0, 0);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    @Override
    public String getName() {
        return "C";
    }

    @Override
    public Customer getSelectedCustomer() {
        return this.selectedCustomer;
    }

    public void setRemoveButtonEnable(boolean enable) {
        this.btnRemoveCustomer.setEnabled(enable);
    }

    @Override
    public void updateView(boolean update) {
        this.btnCreateNewCustomer.setVisible(!this.isVisibleOnlySelectionButtons());
        this.btnHistory.setVisible(!this.isVisibleOnlySelectionButtons());
        if (update) {
            this.btnCancel.setVisible(true);
        } else {
            this.btnCancel.setVisible(false);
        }
        this.loadCustomer();
    }

    @Override
    public void redererCustomers() {
    }

    private void doSelectCustomer() {
        try {
            this.btnSelect.setBlinking(false);
            Customer selectedCustomer = this.getSelectedCustomer();
            if (selectedCustomer == null) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), OroCustMessages.getString("CustomerSelectionDialog.27"));
                return;
            }
            OrderType orderType = this.getOrderType();
            if (this.isCreateNewTicket()) {
                OrderServiceFactory.getOrderService().createNewTicket(orderType, null, selectedCustomer);
            }
            this.closeDialog(false);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
    }

    public static CustomerListView getInstance() {
        if (instance == null) {
            instance = new CustomerListView();
        }
        return instance;
    }
}

