/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.view;

import com.floreantpos.ITicketList;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TicketListUpdateListener;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.views.OrderInfoDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.payment.GratuityInputDialog;
import com.floreantpos.ui.views.payment.SettleTicketDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.TicketAlreadyExistsException;
import com.floreantpos.webservice.CloudDataUploader;
import com.orocube.orocust.OroCustMessages;
import com.orocube.orocust.ui.dialog.DeliveryOrderTypeSelectionDialog;
import com.orocube.orocust.ui.dialog.DeliverySelectionDialog;
import com.orocube.orocust.ui.dialog.DeliveryTicketSelectionDialog;
import com.orocube.orocust.ui.dialog.DriverSelectionDialog;
import com.orocube.orocust.ui.dialog.KitchenStatusDialog;
import com.orocube.orocust.ui.view.DeliveryDispatchTicketListView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class DeliveryDispatchTicketActivity
extends JPanel
implements ActionListener,
ITicketList,
TicketListUpdateListener {
    private PosButton btnNewTicket;
    private PosButton btnEditTicket;
    private PosButton btnOrderInfo;
    private PosButton btnKitchenStatus;
    private PosButton btnSendToKitchen;
    private PosButton btnEditDeliveryInfo;
    private PosButton btnAssignDriver;
    private PosButton btnUnassignDriver;
    private PosButton btnCloseOrder;
    private PosButton btnSettleTicket;
    private OrderType orderType;
    private DeliveryDispatchTicketListView ticketList;
    private PosButton btnCancel;
    private PosButton btnTips;

    public DeliveryDispatchTicketActivity(OrderType orderType) {
        this.orderType = orderType;
        this.setLayout(new BorderLayout());
        this.initComponents();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        this.updateTicketList();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5));
        this.ticketList = new DeliveryDispatchTicketListView();
        this.ticketList.setOrderType(this.orderType);
        this.ticketList.addTicketListUpateListener(this);
        JPanel ticketsAndActivityPanel = new JPanel(new BorderLayout(5, 5));
        TitledBorder border = BorderFactory.createTitledBorder(null, OroCustMessages.getString("DeliveryDispatchTicketActivity.0"), 2, 0);
        JPanel activityPanel = this.createActivityPanel();
        ticketsAndActivityPanel.setBorder(BorderFactory.createCompoundBorder(border, new EmptyBorder(2, 2, 2, 2)));
        ticketsAndActivityPanel.add((Component)this.ticketList, "Center");
        ticketsAndActivityPanel.add((Component)activityPanel, "South");
        this.btnCloseOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeliveryDispatchTicketActivity.this.doCloseOrder();
            }
        });
        this.btnSettleTicket.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Ticket ticket = DeliveryDispatchTicketActivity.this.getFirstSelectedTicket();
                if (ticket == null) {
                    return;
                }
                new SettleTicketAction(ticket).actionPerformed(e);
            }
        });
        centerPanel.add((Component)ticketsAndActivityPanel, "Center");
        this.add((Component)centerPanel, "Center");
    }

    private JPanel createActivityPanel() {
        JPanel activityPanel = new JPanel(new BorderLayout(5, 5));
        JPanel innerActivityPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3, fill, ins 0", "fill, grow", ""));
        JPanel actionButtonPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.btnNewTicket = new PosButton(OroCustMessages.getString("DeliveryDispatchTicketActivity.2"));
        this.btnEditTicket = new PosButton(OroCustMessages.getString("DeliveryDispatchTicketActivity.3"));
        this.btnOrderInfo = new PosButton(POSConstants.ORDER_INFO_BUTTON_TEXT);
        this.btnKitchenStatus = new PosButton(OroCustMessages.getString("DeliveryDispatchTicketActivity.4"));
        this.btnSendToKitchen = new PosButton(OroCustMessages.getString("DeliveryDispatchTicketActivity.5"));
        this.btnTips = new PosButton(OroCustMessages.getString("DeliveryDispatchTicketActivity.6"));
        this.btnEditDeliveryInfo = new PosButton(OroCustMessages.getString("DeliveryDispatchTicketActivity.7"));
        this.btnAssignDriver = new PosButton(POSConstants.ASSIGN_DRIVER_BUTTON_TEXT);
        this.btnUnassignDriver = new PosButton(OroCustMessages.getString("DeliveryDispatchTicketActivity.8"));
        this.btnCloseOrder = new PosButton(POSConstants.CLOSE_ORDER_BUTTON_TEXT);
        this.btnSettleTicket = new PosButton(POSConstants.SETTLE_TICKET_BUTTON_TEXT);
        this.btnNewTicket.addActionListener(this);
        this.btnEditTicket.addActionListener(this);
        this.btnOrderInfo.addActionListener(this);
        this.btnKitchenStatus.addActionListener(this);
        this.btnSendToKitchen.addActionListener(this);
        this.btnEditDeliveryInfo.addActionListener(this);
        this.btnAssignDriver.addActionListener(this);
        this.btnUnassignDriver.addActionListener(this);
        this.btnTips.addActionListener(this);
        actionButtonPanel.add((Component)this.btnOrderInfo, "grow");
        actionButtonPanel.add((Component)this.btnKitchenStatus, "grow");
        actionButtonPanel.add((Component)this.btnSendToKitchen, "grow");
        actionButtonPanel.add((Component)this.btnTips, "grow");
        actionButtonPanel.add((Component)this.btnNewTicket, "grow");
        actionButtonPanel.add((Component)this.btnEditTicket, "grow");
        actionButtonPanel.add((Component)this.btnEditDeliveryInfo, "grow");
        actionButtonPanel.add((Component)this.btnSettleTicket, "grow");
        actionButtonPanel.add((Component)this.btnCloseOrder, "grow");
        actionButtonPanel.add((Component)this.btnAssignDriver, "grow");
        actionButtonPanel.add((Component)this.btnUnassignDriver, "grow");
        innerActivityPanel.add(actionButtonPanel);
        this.btnCancel = new PosButton(POSConstants.CANCEL.toUpperCase());
        this.btnCancel.setPreferredSize(new Dimension(78, 0));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeliveryDispatchTicketActivity.this.closeDialog(false);
            }
        });
        this.btnCancel.setVisible(false);
        activityPanel.add(innerActivityPanel);
        activityPanel.add((Component)this.btnCancel, "East");
        return activityPanel;
    }

    private void closeTicket(Ticket selectedTicket) {
        User assignedDriver;
        User currentUser = Application.getCurrentUser();
        if (this.doUserBaseTicketClose(selectedTicket, currentUser, assignedDriver = selectedTicket.getAssignedDriver())) {
            return;
        }
        User user = PasswordEntryDialog.getUser(Application.getPosWindow(), OroCustMessages.getString("OrderWithCustomerService.2"), OroCustMessages.getString("OrderWithCustomerService.3"));
        if (user == null) {
            return;
        }
        if (this.doUserBaseTicketClose(selectedTicket, user, assignedDriver)) {
            return;
        }
        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), OroCustMessages.getString("DeliveryDispatchTicketActivity.20"));
    }

    private boolean doUserBaseTicketClose(Ticket selectedTicket, User currentUser, User assignedDriver) {
        if (currentUser.isAdministrator() || currentUser.isManager()) {
            this.doTicketClose(selectedTicket);
            return true;
        }
        if (assignedDriver != null && currentUser.equals(assignedDriver)) {
            this.doTicketClose(selectedTicket);
            return true;
        }
        if (assignedDriver == null && currentUser.equals(selectedTicket.getOwner())) {
            this.doTicketClose(selectedTicket);
            return true;
        }
        return false;
    }

    private void doTicketClose(Ticket selectedTicket) {
        Ticket checkedTicket = this.doCheckTicketPaid(selectedTicket);
        if (checkedTicket != null) {
            TicketDAO.closeOrders(selectedTicket);
        }
    }

    protected void doCloseOrder() {
        Ticket selectedTicket = this.getSelectedTicket();
        User currentUser = Application.getCurrentUser();
        ArrayList<Ticket> selectedTickets = new ArrayList<Ticket>();
        if (selectedTicket != null) {
            this.closeTicket(selectedTicket);
            this.updateTicketList();
            return;
        }
        List<Ticket> tickets = this.ticketList.getTickets();
        if (tickets == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), OroCustMessages.getString("DeliveryDispatchTicketActivity.21"));
            return;
        }
        ArrayList<Ticket> userTickets = new ArrayList<Ticket>();
        for (Ticket ticket : tickets) {
            if (currentUser.isAdministrator() || currentUser.isManager()) {
                userTickets.add(ticket);
                continue;
            }
            User ticketUser = ticket.getOwner();
            User assignedDriver = ticket.getAssignedDriver();
            if (assignedDriver != null && currentUser.equals(assignedDriver)) {
                userTickets.add(ticket);
                continue;
            }
            if (assignedDriver != null || !ticketUser.getId().equals(currentUser.getId())) continue;
            userTickets.add(ticket);
        }
        if (userTickets.isEmpty()) {
            POSMessageDialog.showMessage(OroCustMessages.getString("DeliveryDispatchTicketActivity.21"));
            return;
        }
        DeliveryTicketSelectionDialog dialog = new DeliveryTicketSelectionDialog(userTickets);
        dialog.setTitle(OroCustMessages.getString("DeliveryDispatchTicketActivity.23"));
        dialog.setCaption(OroCustMessages.getString("DeliveryDispatchTicketActivity.24"));
        dialog.openFullScreen();
        if (dialog.isCanceled()) {
            return;
        }
        for (Ticket ticket : dialog.getSelectedTickets()) {
            Ticket checkedTicket = this.doCheckTicketPaid(ticket);
            if (checkedTicket == null) continue;
            selectedTickets.add(checkedTicket);
        }
        if (selectedTickets == null || selectedTickets.size() == 0) {
            return;
        }
        int n = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), OroCustMessages.getString("DeliveryDispatchTicketActivity.25"), OroCustMessages.getString("DeliveryDispatchTicketActivity.26"));
        if (n == 0) {
            TicketDAO.closeOrders(selectedTickets.toArray(new Ticket[selectedTickets.size()]));
        }
        this.updateTicketList();
    }

    private Ticket doCheckTicketPaid(Ticket ticket) {
        if (ticket.getDueAmount() > 0.0) {
            int option = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), OroCustMessages.getString("SwitchboardView.6") + ticket.getId() + OroCustMessages.getString("DeliveryDispatchTicketActivity.28"), OroCustMessages.getString("OrderWithCustomerService.9"));
            if (option == 0) {
                if (!POSUtil.checkDrawerAssignment()) {
                    return null;
                }
                ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                SettleTicketDialog posDialog = new SettleTicketDialog(ticket, Application.getCurrentUser());
                posDialog.setSize(Application.getPosWindow().getSize());
                posDialog.setDefaultCloseOperation(2);
                posDialog.openUndecoratedFullScreen();
                if (posDialog.isCanceled()) {
                    return null;
                }
                if (ticket.isPaid().booleanValue()) {
                    return ticket;
                }
            }
        } else {
            return ticket;
        }
        return null;
    }

    private void doShowOrderInfo() {
        List<Ticket> tickets = this.ticketList.getSelectedTickets();
        try {
            if (tickets.size() == 0) {
                POSMessageDialog.showMessage(OroCustMessages.getString("DeliveryDispatchTicketActivity.30"));
                return;
            }
            ArrayList<Ticket> ticketsToShow = new ArrayList<Ticket>();
            for (int i = 0; i < tickets.size(); ++i) {
                Ticket ticket = tickets.get(i);
                ticketsToShow.add(TicketDAO.getInstance().loadFullTicket(ticket.getId()));
            }
            OrderInfoView view = new OrderInfoView(ticketsToShow);
            OrderInfoDialog dialog = new OrderInfoDialog(view);
            dialog.updateView();
            dialog.pack();
            dialog.setSize(dialog.getSize().width + 50, PosUIManager.getSize(650));
            dialog.setLocationRelativeTo(Application.getPosWindow());
            dialog.setVisible(true);
            if (dialog.isReorder()) {
                this.closeDialog(true);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void doEditDeliveryInfo() {
        Ticket ticket = this.getFirstSelectedTicket();
        if (ticket == null) {
            return;
        }
        TicketDAO.getInstance().loadFullTicket(ticket);
        Customer customer = null;
        if (ticket.getCustomerId() != null) {
            customer = CustomerDAO.getInstance().findById(ticket.getCustomerId());
        }
        if (!ticket.getOrderType().isDelivery().booleanValue()) {
            return;
        }
        DeliverySelectionDialog deliveryDialog = new DeliverySelectionDialog(Application.getPosWindow(), ticket, ticket.getOrderType(), customer);
        deliveryDialog.setLocationRelativeTo(Application.getPosWindow());
        deliveryDialog.setRecipientName(customer.getName());
        deliveryDialog.setCustomerWillPickUp(ticket.isCustomerWillPickup());
        deliveryDialog.setDeliveryAddress(ticket.getDeliveryAddress());
        deliveryDialog.setExtraDeliveryInfo(ticket.getExtraDeliveryInfo());
        deliveryDialog.setDeliveryCharge(ticket.getDeliveryCharge());
        deliveryDialog.setTicket(ticket);
        deliveryDialog.openUndecoratedFullScreen();
        if (deliveryDialog.isCanceled()) {
            return;
        }
        OrderController.saveOrder(ticket);
        this.updateTicketList();
    }

    private boolean doEditTicket() {
        Ticket ticket = this.getFirstSelectedTicket();
        if (ticket == null) {
            return false;
        }
        try {
            if (!this.editTicket(ticket)) {
                return false;
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
        this.updateTicketList();
        return true;
    }

    private boolean editTicket(Ticket ticket) {
        if (ticket.isPaid().booleanValue()) {
            POSMessageDialog.showMessage(this, OroCustMessages.getString("SwitchboardView.14"));
            return false;
        }
        Ticket ticketToEdit = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        OrderView.getInstance().setCurrentTicket(ticketToEdit);
        RootView.getInstance().showView("ORDER_VIEW");
        return true;
    }

    public void updateView() {
        Set<UserPermission> permissions;
        User user = Application.getCurrentUser();
        UserType userType = user.getType();
        if (userType != null && (permissions = userType.getPermissions()) != null) {
            this.btnEditTicket.setEnabled(false);
            for (UserPermission permission : permissions) {
                if (!permission.equals(UserPermission.CREATE_TICKET)) continue;
                this.btnEditTicket.setEnabled(true);
            }
        }
        this.updateTicketList();
    }

    private User captureDriver() {
        User currentUser = Application.getCurrentUser();
        if (currentUser.isDriver().booleanValue()) {
            return currentUser;
        }
        List<User> drivers = UserDAO.getInstance().findDrivers();
        if (drivers == null || drivers.size() == 0) {
            POSMessageDialog.showError(Application.getPosWindow(), OroCustMessages.getString("DeliveryDispatchTicketActivity.31"));
            return null;
        }
        DriverSelectionDialog dialog = new DriverSelectionDialog(Application.getPosWindow());
        dialog.setSize(550, 450);
        dialog.setData(null, drivers);
        dialog.setLocationRelativeTo(Application.getPosWindow());
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return null;
        }
        return dialog.getSelectedDriver();
    }

    private List<Ticket> getReadyToDeliveryTicketList() {
        ArrayList<Ticket> readyTicketList = new ArrayList<Ticket>();
        for (Ticket ticket : this.ticketList.getTickets()) {
            if (ticket.isCustomerWillPickup().booleanValue() || this.isDriverOut(ticket)) continue;
            readyTicketList.add(ticket);
        }
        return readyTicketList;
    }

    private boolean isDriverOut(Ticket ticket) {
        String driverOutTime = ticket.getProperty("OUT_AT");
        return StringUtils.isNotEmpty((String)driverOutTime);
    }

    protected void doAssignDriver() {
        try {
            List<Ticket> tickets = new ArrayList<Ticket>();
            User driver = null;
            Ticket selectedTicket = this.getSelectedTicket();
            if (selectedTicket != null) {
                if (selectedTicket.isCustomerWillPickup().booleanValue()) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), OroCustMessages.getString("DeliveryDispatchTicketActivity.32"));
                    return;
                }
                if (this.isTicketOnDelivery(selectedTicket)) {
                    return;
                }
                driver = this.captureDriver();
                if (driver == null) {
                    return;
                }
                tickets.add(selectedTicket);
            } else {
                driver = this.captureDriver();
                if (driver == null) {
                    return;
                }
                List<Ticket> readyToDeliveryTicketList = this.getReadyToDeliveryTicketList();
                DeliveryTicketSelectionDialog dialog = new DeliveryTicketSelectionDialog(readyToDeliveryTicketList);
                dialog.setTitle(OroCustMessages.getString("DeliveryDispatchTicketActivity.33"));
                dialog.setCaption(OroCustMessages.getString("DeliveryDispatchTicketActivity.34"));
                dialog.openFullScreen();
                if (dialog.isCanceled()) {
                    return;
                }
                tickets = dialog.getSelectedTickets();
            }
            if (tickets.size() == 0) {
                return;
            }
            for (Ticket ticket : tickets) {
                TicketDAO.getInstance().loadFullTicket(ticket);
                ticket.setAssignedDriver(driver);
                TicketDAO.getInstance().saveOrUpdate(ticket);
                ReceiptPrintService.printTicket(ticket);
                CloudDataUploader.get().uploadToCloudIfOnlineOrder(ticket);
            }
            tickets.clear();
            this.updateTicketList();
            if (selectedTicket != null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), OroCustMessages.getString("DeliveryDispatchTicketActivity.35") + selectedTicket.getNumberToDisplay());
            } else {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), OroCustMessages.getString("DeliveryDispatchTicketActivity.36"));
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
    }

    protected void doUnassignDriver() {
        try {
            Ticket selectedTicket = this.getFirstSelectedTicket();
            if (selectedTicket == null) {
                return;
            }
            TicketDAO.getInstance().loadFullTicket(selectedTicket);
            if (selectedTicket.isCustomerWillPickup().booleanValue()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), OroCustMessages.getString("DeliveryDispatchTicketActivity.37"));
                return;
            }
            if (this.isTicketOnDelivery(selectedTicket)) {
                return;
            }
            User assignedDriver = selectedTicket.getAssignedDriver();
            if (assignedDriver == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), OroCustMessages.getString("DeliveryDispatchTicketActivity.38") + selectedTicket.getId() + OroCustMessages.getString("DeliveryDispatchTicketActivity.39"));
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), OroCustMessages.getString("DeliveryDispatchTicketActivity.40"), OroCustMessages.getString("DeliveryDispatchTicketActivity.41"));
            if (option != 0) {
                return;
            }
            selectedTicket.setAssignedDriver(null);
            TicketDAO.getInstance().saveOrUpdate(selectedTicket);
            this.updateTicketList();
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), OroCustMessages.getString("DeliveryDispatchTicketActivity.42") + selectedTicket.getId());
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
    }

    private boolean isTicketOnDelivery(Ticket selectedTicket) {
        if (this.isDriverOut(selectedTicket)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), OroCustMessages.getString("DeliveryDispatchTicketActivity.43") + OroCustMessages.getString("DeliveryDispatchTicketActivity.44"));
            return true;
        }
        return false;
    }

    private void doAddTips() {
        try {
            Ticket ticket = this.getFirstSelectedTicket();
            if (ticket == null) {
                return;
            }
            if (ticket.getAssignedDriver() == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), OroCustMessages.getString("DeliveryDispatchTicketActivity.45"));
                return;
            }
            GratuityInputDialog d = new GratuityInputDialog();
            d.setSubTotalAmount(ticket.getSubtotalAmount());
            d.pack();
            d.setResizable(false);
            d.open();
            if (d.isCanceled()) {
                return;
            }
            ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
            double gratuityAmount = d.getGratuityAmount();
            Gratuity gratuity = ticket.getGratuity();
            if (gratuity == null) {
                gratuity = ticket.createGratuity();
                gratuity.setAmount(gratuityAmount);
            } else {
                gratuity.setAmount(gratuityAmount += gratuity.getAmount().doubleValue());
            }
            ticket.setGratuity(gratuity);
            ticket.calculatePrice();
            OrderController.saveOrder(ticket);
            this.updateTicketList();
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), OroCustMessages.getString("DeliveryDispatchTicketActivity.46") + ticket.getId());
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
    }

    void closeDialog(boolean closeParent) {
        Window windowAncestor = SwingUtilities.getWindowAncestor(this);
        if (windowAncestor instanceof POSDialog) {
            ((POSDialog)windowAncestor).setCanceled(true);
            windowAncestor.dispose();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateView();
            this.ticketList.setAutoUpdateCheck(true);
        } else {
            this.ticketList.setAutoUpdateCheck(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.btnEditTicket) {
            if (this.doEditTicket()) {
                this.closeDialog(true);
            }
        } else if (source == this.btnNewTicket) {
            this.doCreateNewTicket();
        } else if (source == this.btnOrderInfo) {
            this.doShowOrderInfo();
        } else if (source == this.btnKitchenStatus) {
            this.doShowKitchenInfo();
        } else if (source == this.btnSendToKitchen) {
            this.doSendToKitchen();
        } else if (source == this.btnEditDeliveryInfo) {
            this.doEditDeliveryInfo();
        } else if (source == this.btnAssignDriver) {
            this.doAssignDriver();
        } else if (source == this.btnUnassignDriver) {
            this.doUnassignDriver();
        } else if (source == this.btnTips) {
            this.doAddTips();
        }
    }

    private void doSendToKitchen() {
        Ticket ticket = this.getFirstSelectedTicket();
        if (ticket == null) {
            return;
        }
        ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        if (ticket.getTicketItems() == null || ticket.getTicketItems().isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SendToKitchenAction.4"));
            return;
        }
        if (!ticket.getOrderType().isShouldPrintToKitchen().booleanValue()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SendToKitchenAction.2"));
            return;
        }
        if (ticket.needsKitchenPrint()) {
            ReceiptPrintService.printToKitchen(ticket, true);
            POSMessageDialog.showMessage(Messages.getString("TicketView.32"));
        } else {
            POSMessageDialog.showMessage(Messages.getString("TicketView.333"));
        }
        this.updateTicketList();
    }

    private void doShowKitchenInfo() {
        Ticket ticket = this.getFirstSelectedTicket();
        if (ticket == null) {
            return;
        }
        KitchenStatusDialog dialog = new KitchenStatusDialog(ticket);
        dialog.setSize(PosUIManager.getSize(500, 680));
        dialog.open();
    }

    private void doCreateNewTicket() {
        if (this.orderType == null) {
            List<OrderType> orderTypes = Application.getInstance().getOrderTypes();
            ArrayList<OrderType> deliveryOrderTypes = new ArrayList<OrderType>();
            if (orderTypes != null) {
                for (OrderType orderType : orderTypes) {
                    if (!orderType.isDelivery().booleanValue()) continue;
                    deliveryOrderTypes.add(orderType);
                }
            }
            if (deliveryOrderTypes.size() > 1) {
                DeliveryOrderTypeSelectionDialog orderTypeSelector = new DeliveryOrderTypeSelectionDialog(deliveryOrderTypes);
                orderTypeSelector.pack();
                orderTypeSelector.open();
                if (orderTypeSelector.isCanceled()) {
                    return;
                }
                this.orderType = orderTypeSelector.getSelectedOrderType();
            } else {
                if (deliveryOrderTypes.isEmpty()) {
                    POSMessageDialog.showError(this, OroCustMessages.getString("NO_DELIVERY_ORDER_TYPE"));
                    return;
                }
                this.orderType = (OrderType)deliveryOrderTypes.get(0);
            }
        }
        try {
            OrderServiceFactory.getOrderService().createNewTicket(this.orderType, null, null);
        }
        catch (TicketAlreadyExistsException e) {
            POSMessageDialog.showError(this, OroCustMessages.getString("DeliveryDispatchTicketActivity.47") + "\n" + OroCustMessages.getString("DeliveryDispatchTicketActivity.49"), e);
        }
        this.updateTicketList();
    }

    public Ticket getFirstSelectedTicket() {
        List<Ticket> selectedTickets = this.ticketList.getSelectedTickets();
        if (selectedTickets.size() == 0 || selectedTickets.size() > 1) {
            POSMessageDialog.showMessage(this, OroCustMessages.getString("SwitchboardView.22"));
            return null;
        }
        Ticket ticket = selectedTickets.get(0);
        if (ticket.isClosed().booleanValue()) {
            POSMessageDialog.showError(this, OroCustMessages.getString("DeliveryDispatchTicketActivity.50"));
            return null;
        }
        return ticket;
    }

    @Override
    public Ticket getSelectedTicket() {
        List<Ticket> selectedTickets = this.ticketList.getSelectedTickets();
        if (selectedTickets.size() == 0 || selectedTickets.size() > 1) {
            return null;
        }
        Ticket ticket = selectedTickets.get(0);
        return ticket;
    }

    @Override
    public void updateTicketList() {
        this.ticketList.updateTicketList();
    }

    @Override
    public void ticketListUpdated() {
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public void setOrderType(OrderType orderType) {
        this.orderType = orderType;
        this.ticketList.setOrderType(orderType);
    }
}

