/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.action;

import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.report.InventoryTransactionReportView;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class InventoryTransactionReportAction
extends AbstractAction {
    public InventoryTransactionReportAction() {
        super(InvMessages.getString("IVTRA.0"));
    }

    public InventoryTransactionReportAction(String name) {
        super(name);
    }

    public InventoryTransactionReportAction(String name, Icon icon) {
        super(name, icon);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        BackOfficeWindow window = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane tabbedPane = window.getTabbedPane();
            InventoryTransactionReportView reportView = null;
            int index = tabbedPane.indexOfTab(InvMessages.getString("IVTRA.0"));
            if (index == -1) {
                reportView = new InventoryTransactionReportView();
                tabbedPane.addTab(InvMessages.getString("IVTRA.0"), reportView);
            } else {
                reportView = (InventoryTransactionReportView)tabbedPane.getComponentAt(index);
            }
            tabbedPane.setSelectedComponent(reportView);
        }
        catch (Exception e) {
            POSMessageDialog.showError(window, e.getMessage(), e);
        }
    }
}

