/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.report;

import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.report.InventoryAverageCostUnitReportModel;
import com.orostock.inventory.report.ReportParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class InventoryAverageUnitCostReportView
extends TransparentPanel {
    private JButton btnGo;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;
    private JPanel reportPanel;
    private JPanel contentPane;
    private JComboBox jcbTtype;
    private JComboBox cbGroup;
    private JComboBox cbCategory;
    private List<MenuGroup> groups;

    public InventoryAverageUnitCostReportView() {
        this.$$$setupUI$$$();
        TerminalDAO terminalDAO = new TerminalDAO();
        List<Terminal> terminals = terminalDAO.findAll();
        terminals.add(0, (Terminal)((Object)POSConstants.ALL));
        this.setLayout(new BorderLayout());
        this.add(this.contentPane);
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryTransactionDAO dao = new InventoryTransactionDAO();
                Object selectedCategory = InventoryAverageUnitCostReportView.this.cbCategory.getSelectedItem();
                MenuCategory category = null;
                if (selectedCategory instanceof MenuCategory) {
                    category = (MenuCategory)selectedCategory;
                }
                Object selectedGroup = InventoryAverageUnitCostReportView.this.cbGroup.getSelectedItem();
                MenuGroup group = null;
                if (selectedGroup instanceof MenuGroup) {
                    group = (MenuGroup)selectedGroup;
                }
                Date startOfMonth = DateUtil.startOfMonth(InventoryAverageUnitCostReportView.this.fromDatePicker.getDate());
                Date endOfMonth = DateUtil.endOfMonth(InventoryAverageUnitCostReportView.this.fromDatePicker.getDate());
                List<InventoryTransaction> findTransaction = dao.findTransactionsForAvgCosting(category, group, startOfMonth, endOfMonth);
                String strCategory = "All";
                String strGroup = "All";
                if (category != null) {
                    strCategory = category.getName();
                }
                if (group != null) {
                    strGroup = group.getName();
                }
                String searchKey = " Category: " + strCategory + "; Group: " + strGroup + ";";
                InventoryAverageUnitCostReportView.this.viewReport(findTransaction, searchKey);
            }
        });
    }

    private void viewReport(List<InventoryTransaction> inventList, String searchKey) {
        try {
            HashSet<MenuItem> uniqueMenuItems = new HashSet<MenuItem>();
            for (InventoryTransaction trans : inventList) {
                uniqueMenuItems.add(trans.getMenuItem());
            }
            Date date = this.fromDatePicker.getDate();
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            c.add(2, -1);
            date = c.getTime();
            Date startOfMonth = DateUtil.startOfMonth(date);
            Date endOfMonth = DateUtil.endOfMonth(date);
            for (MenuItem menuItem : uniqueMenuItems) {
                InventoryTransaction openingBalance = InventoryTransactionDAO.getInstance().findOpeningBalance(menuItem, startOfMonth, endOfMonth);
                for (InventoryTransaction trans : inventList) {
                    if (trans.getMenuItem() != menuItem) continue;
                    trans.setOpeningCost(openingBalance.getUnitCost());
                    trans.setOpeningQty(openingBalance.getQuantity());
                    trans.setOpeningTotalCost(openingBalance.getTotal());
                }
            }
            String reportName = "inventoryAverageUnitCost";
            JasperReport report = ReportParser.getReport("/reports/" + PaperSize.getReportNameAccording2Size(reportName) + ".jasper");
            HashMap<String, String> properties = new HashMap<String, String>();
            ReportUtil.populateRestaurantProperties(properties);
            String dateRange = InvMessages.getString("IVCRV.7") + DateUtil.getOnlyFormattedDate(new Date());
            properties.put("DateRange", dateRange);
            properties.put("group", searchKey);
            Store store = Application.getInstance().getStore();
            properties.put("companyName", store.getName());
            properties.put("address", store.getAddressLine1());
            properties.put("city", store.getAddressLine2());
            properties.put("address3", store.getAddressLine3());
            properties.put("phone", store.getTelephone());
            InventoryAverageCostUnitReportModel reportModel = new InventoryAverageCostUnitReportModel();
            if (inventList == null || inventList.size() <= 0) {
                this.reportPanel.removeAll();
                POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), InvMessages.getString("IVCRV.13"));
                return;
            }
            reportModel.setRows(inventList);
            properties.put("totalExpenses", String.valueOf(reportModel.getTotalAmount()));
            properties.put("totalQuantity", String.valueOf(reportModel.getTotalQuantity()));
            JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
            JRViewer viewer = ReportUtil.getCustomJRViewer(print);
            this.reportPanel.removeAll();
            this.reportPanel.add((Component)viewer);
            this.reportPanel.revalidate();
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new MigLayout("fill,hidemode 3", "", "[][][grow]"));
        JLabel lblFrom = new JLabel(POSConstants.MONTH + ":");
        this.fromDatePicker = UiUtil.getCurrentMonthStart();
        this.btnGo = new JButton();
        this.btnGo.setPreferredSize(PosUIManager.getSize(100, 0));
        this.btnGo.setText(POSConstants.GO);
        JLabel lblCategory = new JLabel(InvMessages.getString("IVCRV.20"));
        this.cbCategory = new JComboBox();
        this.cbCategory.addItem(InvMessages.getString("IVCRV.21"));
        List<MenuCategory> categories = MenuCategoryDAO.getInstance().findAllForReport(false);
        for (MenuCategory menuCategory : categories) {
            this.cbCategory.addItem(menuCategory);
        }
        this.cbCategory.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object selectedItem = InventoryAverageUnitCostReportView.this.cbCategory.getSelectedItem();
                if (selectedItem instanceof MenuCategory) {
                    InventoryAverageUnitCostReportView.this.groups = MenuGroupDAO.getInstance().findByParent((MenuCategory)selectedItem);
                }
                InventoryAverageUnitCostReportView.this.cbGroup.removeAllItems();
                InventoryAverageUnitCostReportView.this.cbGroup.addItem(InvMessages.getString("IVCRV.21"));
                for (MenuGroup group : InventoryAverageUnitCostReportView.this.groups) {
                    InventoryAverageUnitCostReportView.this.cbGroup.addItem(group);
                }
            }
        });
        JLabel lblGroup = new JLabel(InvMessages.getString("IVCRV.23"));
        this.cbGroup = new JComboBox();
        this.cbGroup.addItem(InvMessages.getString("IVCRV.21"));
        this.groups = MenuGroupDAO.getInstance().findAllForReport(false);
        for (MenuGroup group : this.groups) {
            this.cbGroup.addItem(group);
        }
        JSeparator jSeparator = new JSeparator();
        this.reportPanel = new JPanel();
        this.reportPanel.setLayout(new BorderLayout(0, 0));
        this.contentPane.add((Component)lblCategory, "split 9");
        this.contentPane.add((Component)this.cbCategory, "gapright 20");
        this.contentPane.add(lblGroup);
        this.contentPane.add((Component)this.cbGroup, "gapright 20");
        this.contentPane.add(lblFrom);
        this.contentPane.add((Component)this.fromDatePicker, "gapright 20");
        this.contentPane.add(this.btnGo);
        this.contentPane.add((Component)jSeparator, "newline,growx");
        this.contentPane.add((Component)this.reportPanel, "newline,grow,span");
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

