/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.report;

import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.report.InventoryOnHandReportModel;
import com.orostock.inventory.report.InventoryStockData;
import com.orostock.inventory.report.ReportParser;
import com.orostock.inventory.report.dao.ReportDAO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import org.jdesktop.swingx.JXDatePicker;

public class InventoryOnHandReportView
extends TransparentPanel {
    private JTextField tfNameSku;
    private MultiSelectComboBox<MenuCategory> cbMenuCategory;
    private MultiSelectComboBox<MenuGroup> cbGroup;
    private MultiSelectComboBox<InventoryLocation> cbLocation;
    private JComboBox<Object> cbSortBy;
    private JXDatePicker dpDate;
    private JCheckBox chkShowInGroups;
    private JPanel reportPanel;
    private boolean showGroupSummary;

    public InventoryOnHandReportView() {
        this(true);
    }

    public InventoryOnHandReportView(boolean showGroupSummary) {
        this.showGroupSummary = showGroupSummary;
        this.initComponents();
        this.loadData();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel contentPane = new JPanel();
        contentPane.setLayout((LayoutManager)new MigLayout("fill,hidemode 3", "", "[][][grow]"));
        this.add(contentPane);
        this.dpDate = UiUtil.getDeafultDate();
        this.chkShowInGroups = new JCheckBox(InvMessages.getString("IVOHRV.3"));
        JButton btnGo = new JButton();
        btnGo.setPreferredSize(PosUIManager.getSize(100, 0));
        btnGo.setText(POSConstants.GO);
        JLabel lblNameSku = new JLabel(InvMessages.getString("IVOHRV.4"));
        this.tfNameSku = new JTextField();
        this.tfNameSku.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryOnHandReportView.this.showReport();
            }
        });
        JLabel lblLocation = new JLabel(InvMessages.getString("IVOHRV.5"));
        this.cbLocation = new MultiSelectComboBox();
        JLabel lblcategory = new JLabel(POSConstants.CATEGORY);
        this.cbMenuCategory = new MultiSelectComboBox();
        JLabel lblGroup = new JLabel(InvMessages.getString("IVCRV.23"));
        this.cbGroup = new MultiSelectComboBox();
        this.cbSortBy = new JComboBox();
        this.cbSortBy.addItem(POSConstants.NAME);
        this.cbSortBy.addItem(MenuItem.PROP_SKU.toUpperCase());
        this.cbSortBy.setSelectedIndex(0);
        JSeparator separator1 = new JSeparator();
        this.reportPanel = new JPanel();
        this.reportPanel.setLayout(new BorderLayout(0, 0));
        this.dpDate.setDate(new Date());
        btnGo.addActionListener(e -> this.showReport());
        contentPane.add((Component)lblNameSku, "split ");
        contentPane.add((Component)this.tfNameSku, "grow, gapright 20, w 200!");
        contentPane.add((Component)lblLocation, "");
        contentPane.add(this.cbLocation, "gapright 20");
        contentPane.add((Component)lblcategory, "");
        contentPane.add(this.cbMenuCategory, "gapright 20");
        contentPane.add(lblGroup);
        contentPane.add(this.cbGroup, "gapright 20");
        contentPane.add(this.cbSortBy);
        contentPane.add(new JLabel(InvMessages.getString("IVOHRV.14")));
        contentPane.add((Component)this.dpDate, "gapright 20");
        if (this.showGroupSummary) {
            contentPane.add(this.chkShowInGroups);
        }
        contentPane.add(btnGo);
        contentPane.add((Component)separator1, "newline,growx, span");
        contentPane.add((Component)this.reportPanel, "newline,grow,span");
        this.add(contentPane);
    }

    private void loadData() {
        List<InventoryLocation> locations = InventoryLocationDAO.getInstance().findAll();
        this.cbLocation.setItems(locations);
        List<MenuGroup> groups = MenuGroupDAO.getInstance().findAllForReport(false);
        this.cbGroup.setItems(groups);
        List<MenuCategory> category = MenuCategoryDAO.getInstance().findAllForReport(false);
        this.cbMenuCategory.setItems(category);
    }

    private void showReport() {
        try {
            String nameOrSku = this.tfNameSku.getText();
            List<InventoryLocation> selectedLocations = this.cbLocation.getSelectedItems();
            List<MenuCategory> selectedcategories = this.cbMenuCategory.getSelectedItems();
            List<MenuGroup> selectedGroups = this.cbGroup.getSelectedItems();
            ReportDAO dao = new ReportDAO();
            List<InventoryStockData> stockDataList = dao.getInventoryOnHandReportData(nameOrSku, selectedLocations, selectedcategories, selectedGroups, null, null, this.dpDate.getDate(), this.chkShowInGroups.isSelected(), false);
            if (stockDataList != null) {
                this.doSortReportDataList(stockDataList);
                Iterator<InventoryStockData> iterator = stockDataList.iterator();
                while (iterator.hasNext()) {
                    InventoryStockData inventoryStockData = iterator.next();
                    if (!this.chkShowInGroups.isSelected()) {
                        inventoryStockData.setMenuGroup(null);
                    }
                    if (inventoryStockData.getQuantityInHand() != 0.0) continue;
                    iterator.remove();
                }
            }
            InventoryOnHandReportModel model = new InventoryOnHandReportModel();
            model.setRows(stockDataList);
            this.viewReport(model, this.dpDate.getDate());
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doSortReportDataList(List<InventoryStockData> stockDataList) {
        if (this.cbSortBy.getSelectedIndex() == 1) {
            Collections.sort(stockDataList, new Comparator<InventoryStockData>(){

                @Override
                public int compare(InventoryStockData o1, InventoryStockData o2) {
                    return o1.getSku().compareTo(o2.getSku());
                }
            });
        } else {
            Collections.sort(stockDataList, new Comparator<InventoryStockData>(){

                @Override
                public int compare(InventoryStockData o1, InventoryStockData o2) {
                    return o1.getMenuItemName().compareTo(o2.getMenuItemName());
                }
            });
        }
        if (this.chkShowInGroups.isSelected()) {
            Collections.sort(stockDataList, new Comparator<InventoryStockData>(){

                @Override
                public int compare(InventoryStockData o1, InventoryStockData o2) {
                    if (o1.getMenuGroup() == null || o2.getMenuGroup() == null) {
                        return 0;
                    }
                    return o1.getMenuGroup().compareTo(o2.getMenuGroup());
                }
            });
        }
    }

    private void viewReport(InventoryOnHandReportModel model, Date date) throws JRException {
        String reportName = this.showGroupSummary ? "inventoryOnHandReport" : "inventoryOnHandReportWithGroup";
        JasperReport report = ReportParser.getReport("/reports/" + PaperSize.getReportNameAccording2Size(reportName) + ".jasper");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Store store = Application.getInstance().getStore();
        properties.put("companyName", store.getName());
        properties.put("address", store.getAddressLine1());
        properties.put("city", store.getAddressLine2());
        properties.put("address3", store.getAddressLine3());
        properties.put("phone", store.getTelephone());
        properties.put("fax", store.getZipCode());
        properties.put("email", store.getAddressLine3());
        properties.put("isGroup", this.chkShowInGroups.isSelected());
        properties.put("currencySymbol", CurrencyUtil.getCurrencySymbolWithBracket());
        properties.put("reportDate", DateUtil.formatDateWithTime(new Date()));
        properties.put("date", DateUtil.formatDate(date));
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)model));
        this.reportPanel.removeAll();
        this.reportPanel.add((Component)ReportUtil.getCustomJRViewer(print));
        this.reportPanel.revalidate();
    }
}

