/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.report.dao;

import com.floreantpos.model.InventoryClosingBalance;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.InventoryClosingBalanceDAO;
import com.floreantpos.model.dao.InventoryStockDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.report.InventoryStockData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.hibernate.type.DoubleType;
import org.hibernate.type.Type;

public class ReportDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryStockData> getInventoryOnhandReprotDataWithGroup(String nameOrSku, InventoryLocation location, MenuGroup menuGroup) {
        InventoryStockDAO stockDAO = InventoryStockDAO.getInstance();
        Session session = null;
        try {
            session = stockDAO.createNewSession();
            String hql = "select stock.%s, stock.%s, stock.%s, stock.%s, location.%s, menuItem.%s, menuGroup.%s from InventoryStock stock, InventoryLocation location, MenuItem menuItem, MenuGroup menuGroup where stock.%s=location.%s and stock.%s = menuItem.%s and menuItem.%s=menuGroup.%s";
            hql = String.format(hql, InventoryStock.PROP_ITEM_NAME, InventoryStock.PROP_SKU, InventoryStock.PROP_QUANTITY_IN_HAND, InventoryStock.PROP_UNIT, InventoryLocation.PROP_NAME, MenuItem.PROP_COST, MenuGroup.PROP_NAME, InventoryStock.PROP_LOCATION_ID, InventoryLocation.PROP_ID, InventoryStock.PROP_MENU_ITEM_ID, MenuItem.PROP_ID, MenuItem.PROP_MENU_GROUP_ID, MenuGroup.PROP_ID);
            String str = nameOrSku.toLowerCase();
            if (StringUtils.isNotEmpty((String)str)) {
                String name = nameOrSku.toLowerCase();
                String sku = nameOrSku;
                hql = hql + " and (LOWER( stock.itemName ) like '%" + name + "%' or stock.sku ='" + sku + "')";
            }
            if (location != null) {
                hql = hql + " and stock.locationId= '" + location.getId() + "'";
            }
            if (menuGroup != null) {
                hql = hql + " and " + MenuItem.PROP_MENU_GROUP_ID + "= '" + menuGroup.getId() + "'";
            }
            hql = hql + " order by menuGroup." + MenuGroup.PROP_NAME + ", menuItem." + MenuItem.PROP_NAME;
            String hql2 = "select stock.%s, stock.%s, stock.%s, stock.%s, location.%s, menuItem.%s from InventoryStock stock, InventoryLocation location, MenuItem menuItem where stock.%s=location.%s and stock.%s = menuItem.%s and (menuItem.%s is null)";
            hql2 = String.format(hql2, InventoryStock.PROP_ITEM_NAME, InventoryStock.PROP_SKU, InventoryStock.PROP_QUANTITY_IN_HAND, InventoryStock.PROP_UNIT, InventoryLocation.PROP_NAME, MenuItem.PROP_COST, InventoryStock.PROP_LOCATION_ID, InventoryLocation.PROP_ID, InventoryStock.PROP_MENU_ITEM_ID, MenuItem.PROP_ID, MenuItem.PROP_MENU_GROUP_ID);
            if (StringUtils.isNotEmpty((String)str)) {
                String name = nameOrSku.toLowerCase();
                String sku = nameOrSku;
                hql2 = hql2 + " and (LOWER( stock.itemName ) like '%" + name + "%' or stock.sku ='" + sku + "')";
            }
            if (location != null) {
                hql2 = hql2 + " and stock.locationId= '" + location.getId() + "'";
            }
            if (menuGroup != null) {
                hql2 = hql2 + " and " + MenuItem.PROP_MENU_GROUP_ID + "= '" + menuGroup.getId() + "'";
            }
            hql2 = hql2 + " order by menuItem." + MenuItem.PROP_NAME;
            Query query = session.createQuery(hql);
            Query query2 = session.createQuery(hql2);
            List listItemWithParent = query.list();
            List listItemsWithoutParernt = query2.list();
            if (listItemsWithoutParernt != null && !listItemsWithoutParernt.isEmpty()) {
                listItemWithParent.addAll(listItemsWithoutParernt);
            }
            ArrayList<InventoryStockData> inventoryStockDatas = new ArrayList<InventoryStockData>();
            for (Object[] obj : listItemWithParent) {
                InventoryStockData data = new InventoryStockData();
                data.setMenuItemName(obj[0] == null ? null : obj[0].toString());
                data.setSku(obj[1] == null ? null : obj[1].toString());
                data.setQuantityInHand(obj[2] == null ? 0.0 : new Double(obj[2].toString()));
                data.setUnit(obj[3] == null ? "" : obj[3].toString());
                data.setLocationName(obj[4] == null ? null : obj[4].toString());
                data.setMenuItemCost(obj[5] == null ? null : new Double(obj[5].toString()));
                data.setMenuGroup(obj.length <= 6 ? "No Group" : obj[6].toString());
                inventoryStockDatas.add(data);
            }
            ArrayList<InventoryStockData> arrayList = inventoryStockDatas;
            return arrayList;
        }
        finally {
            stockDAO.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryStockData> getInventoryOnhandReprotDataWithoutGroup(String nameOrSku, InventoryLocation location, MenuGroup menuGroup) {
        InventoryStockDAO stockDAO = InventoryStockDAO.getInstance();
        Session session = null;
        try {
            session = stockDAO.createNewSession();
            String hql = "select stock.%s, stock.%s, stock.%s, stock.%s, location.%s, menuItem.%s from InventoryStock stock, InventoryLocation location, MenuItem menuItem where stock.%s=location.%s and stock.%s = menuItem.%s";
            hql = String.format(hql, InventoryStock.PROP_ITEM_NAME, InventoryStock.PROP_SKU, InventoryStock.PROP_QUANTITY_IN_HAND, InventoryStock.PROP_UNIT, InventoryLocation.PROP_NAME, MenuItem.PROP_COST, InventoryStock.PROP_LOCATION_ID, InventoryLocation.PROP_ID, InventoryStock.PROP_MENU_ITEM_ID, MenuItem.PROP_ID, MenuItem.PROP_MENU_GROUP_ID);
            if (StringUtils.isNotEmpty((String)nameOrSku)) {
                String name = nameOrSku.toLowerCase();
                String sku = nameOrSku;
                hql = hql + " and (LOWER( stock.itemName ) like '%" + name + "%' or stock.sku ='" + sku + "')";
            }
            if (location != null) {
                hql = hql + " and stock.locationId= '" + location.getId() + "'";
            }
            if (menuGroup != null) {
                hql = hql + " and " + MenuItem.PROP_MENU_GROUP_ID + "= '" + menuGroup.getId() + "'";
            }
            hql = hql + " order by menuItem." + MenuItem.PROP_NAME;
            Query query = session.createQuery(hql);
            List listItemsWithoutParernt = query.list();
            ArrayList<InventoryStockData> inventoryStockDatas = new ArrayList<InventoryStockData>();
            for (Object[] obj : listItemsWithoutParernt) {
                InventoryStockData data = new InventoryStockData();
                data.setMenuItemName(obj[0] == null ? null : obj[0].toString());
                data.setSku(obj[1] == null ? null : obj[1].toString());
                data.setQuantityInHand(obj[2] == null ? 0.0 : new Double(obj[2].toString()));
                data.setUnit(obj[3] == null ? "" : obj[3].toString());
                data.setLocationName(obj[4] == null ? null : obj[4].toString());
                data.setMenuItemCost(obj[5] == null ? null : new Double(obj[5].toString()));
                inventoryStockDatas.add(data);
            }
            ArrayList<InventoryStockData> arrayList = inventoryStockDatas;
            return arrayList;
        }
        finally {
            stockDAO.closeSession(session);
        }
    }

    public List<InventoryStockData> getInventoryOnHandReportData(String nameOrSku, InventoryLocation location, MenuGroup menuGroup, Date toDate, boolean grouping) {
        return this.getInventoryOnHandReportData(nameOrSku, location, menuGroup, null, null, toDate, grouping);
    }

    public List<InventoryStockData> getInventoryOnHandReportData(String nameOrSku, InventoryLocation location, MenuGroup menuGroup, String unitId, InventoryVendor vendor, Date toDate, boolean grouping) {
        return this.getInventoryOnHandReportData(nameOrSku, location, menuGroup, null, null, toDate, grouping, true);
    }

    public List<InventoryStockData> getInventoryOnHandReportData(String nameOrSku, InventoryLocation location, MenuGroup menuGroup, String unitId, InventoryVendor vendor, Date toDate, boolean grouping, boolean isSummarizeVariant) {
        return this.getInventoryOnHandReportData(nameOrSku, location == null ? null : Arrays.asList(location), null, menuGroup == null ? null : Arrays.asList(menuGroup), unitId, vendor, toDate, grouping, isSummarizeVariant);
    }

    public List<InventoryStockData> getInventoryOnHandReportData(String nameOrSku, List<InventoryLocation> locations, List<MenuCategory> categories, List<MenuGroup> menuGroups, String unitId, InventoryVendor vendor, Date toDate, boolean grouping, boolean isSummarizeVariant) {
        try (Session session = InventoryStockDAO.getInstance().createNewSession();){
            Map<String, InventoryStockData> itemMap = this.getInventoryItems(nameOrSku, categories, menuGroups, unitId, vendor, session);
            ArrayList<String> menuItemsIds = new ArrayList<String>(itemMap.keySet());
            if (menuItemsIds.size() <= 0) {
                ArrayList<InventoryStockData> arrayList = new ArrayList<InventoryStockData>();
                return arrayList;
            }
            HashMap<String, InventoryStockData> dataMap = new HashMap<String, InventoryStockData>();
            Date lastClosingDate = InventoryClosingBalanceDAO.getInstance().getLastClosingDate(toDate);
            if (lastClosingDate != null) {
                lastClosingDate = DateUtil.startOfDay(lastClosingDate);
                Criteria criteria = session.createCriteria(InventoryClosingBalance.class);
                ProjectionList list = Projections.projectionList();
                list.add((Projection)Projections.property((String)InventoryClosingBalance.PROP_MENU_ITEM_ID), InventoryStockData.PROP_MENU_ITEM_ID);
                list.add((Projection)Projections.property((String)InventoryClosingBalance.PROP_UNIT), InventoryStockData.PROP_UNIT);
                list.add((Projection)Projections.property((String)InventoryClosingBalance.PROP_LOCATION_ID), InventoryStockData.PROP_LOCATION_ID);
                list.add((Projection)Projections.property((String)InventoryClosingBalance.PROP_BALANCE), InventoryStockData.PROP_QUANTITY_IN_HAND);
                criteria.setProjection((Projection)list);
                if (locations != null) {
                    List<String> stringIds = POSUtil.getStringIds(locations, InventoryLocation.class);
                    criteria.add(Restrictions.in((String)InventoryClosingBalance.PROP_LOCATION_ID, stringIds));
                }
                criteria.add(Restrictions.in((String)InventoryClosingBalance.PROP_MENU_ITEM_ID, menuItemsIds));
                if (lastClosingDate != null) {
                    criteria.add((Criterion)Restrictions.ge((String)InventoryClosingBalance.PROP_CLOSING_DATE, (Object)lastClosingDate));
                    criteria.add((Criterion)Restrictions.lt((String)InventoryClosingBalance.PROP_CLOSING_DATE, (Object)DateUtil.endOfDay(lastClosingDate)));
                }
                criteria.setResultTransformer(Transformers.aliasToBean(InventoryStockData.class));
                List dataList = criteria.list();
                if (dataList != null && dataList.size() > 0) {
                    for (InventoryStockData inventoryStockData : dataList) {
                        dataMap.put(this.generateKey(itemMap, inventoryStockData, isSummarizeVariant), inventoryStockData);
                    }
                }
            }
            Map<String, String> locationMap = this.populateInventoryTransactionsSummary(itemMap, menuItemsIds, locations, nameOrSku, toDate, session, dataMap, lastClosingDate, isSummarizeVariant);
            ArrayList<InventoryStockData> stockDataList = new ArrayList<InventoryStockData>(dataMap.values());
            Iterator iterator = stockDataList.iterator();
            while (iterator.hasNext()) {
                InventoryStockData data = (InventoryStockData)iterator.next();
                InventoryStockData itemData = itemMap.get(data.getMenuItemId());
                if (itemData == null || data.getQuantityInHand() == 0.0) {
                    iterator.remove();
                    continue;
                }
                data.setMenuItemName(itemData.getMenuItemName());
                data.setMenuGroup(itemData.getMenuGroup());
                data.setLocationName(locationMap.get(data.getLocationId()));
                data.setSku(itemData.getSku());
                if (!data.getVariant()) {
                    MenuItem menuItem = itemData.getMenuItem();
                    MenuItemDAO.getInstance().initialize(menuItem);
                    data.setMenuItemCost(menuItem.getCost());
                } else {
                    data.setMenuItemCost(itemData.getMenuItemCost());
                }
                data.setParentMenuItemId(itemData.getParentMenuItemId());
                data.setVariant(itemData.getVariant());
            }
            Collections.sort(stockDataList, new Comparator<InventoryStockData>(){

                @Override
                public int compare(InventoryStockData stockData1, InventoryStockData stockData2) {
                    if (stockData1.getLocationName() == null || stockData2.getLocationName() == null) {
                        return -1;
                    }
                    return stockData1.getLocationName().compareTo(stockData2.getLocationName());
                }
            });
            Collections.sort(stockDataList, new Comparator<InventoryStockData>(){

                @Override
                public int compare(InventoryStockData stockData1, InventoryStockData stockData2) {
                    if (stockData1.getUnit() == null || stockData2.getUnit() == null) {
                        return -1;
                    }
                    return stockData1.getUnit().compareTo(stockData2.getUnit());
                }
            });
            ArrayList<InventoryStockData> arrayList = stockDataList;
            return arrayList;
        }
    }

    private Map<String, String> populateInventoryTransactionsSummary(Map<String, InventoryStockData> itemMap, List<String> menuItemsIds, List<InventoryLocation> invLocations, String nameOrSku, Date transactionDate, Session session, Map<String, InventoryStockData> dataMap, Date lastClosingDate, boolean isSummarizeVariant) {
        List<InventoryLocation> locations = this.findLocations(invLocations, session);
        HashMap<String, String> locationMap = new HashMap<String, String>();
        if (locations == null || locations.isEmpty()) {
            return locationMap;
        }
        for (InventoryLocation locationObj : locations) {
            String locationId = locationObj.getId();
            locationMap.put(locationId, locationObj.getName());
            List<InventoryStockData> dataList = this.findStockDataList(locationId, menuItemsIds, transactionDate, lastClosingDate, session);
            this.calculateOnHandCount(itemMap, locationId, dataMap, dataList, isSummarizeVariant);
        }
        return locationMap;
    }

    private void calculateOnHandCount(Map<String, InventoryStockData> itemMap, String locationId, Map<String, InventoryStockData> dataMap, List<InventoryStockData> dataList, boolean isSummarizeVariant) {
        if (dataList == null || dataList.isEmpty()) {
            return;
        }
        for (InventoryStockData tData : dataList) {
            InventoryStockData stockData;
            String key;
            tData.setLocationId(locationId);
            if (tData.getVariant()) {
                key = this.generateKey(itemMap, tData, false);
                stockData = dataMap.get(key);
                if (stockData != null) {
                    stockData.setQuantityInHand(stockData.getQuantityInHand() + tData.getQuantityInHand());
                } else {
                    dataMap.put(key, tData);
                }
                if ((stockData = dataMap.get(key = this.generateKey(itemMap, tData, true))) == null) continue;
                stockData.setQuantityInHand(stockData.getQuantityInHand() + tData.getQuantityInHand());
                continue;
            }
            key = this.generateKey(itemMap, tData, true);
            stockData = dataMap.get(key);
            if (stockData != null) {
                stockData.setQuantityInHand(stockData.getQuantityInHand() + tData.getQuantityInHand());
                continue;
            }
            dataMap.put(key, tData);
        }
    }

    private List<InventoryStockData> findStockDataList(String locationId, List<String> menuItemsIds, Date transactionDate, Date lastClosingDate, Session session) {
        Criteria criteria = session.createCriteria(InventoryTransaction.class);
        criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "item");
        ProjectionList projections = Projections.projectionList();
        projections.add((Projection)Projections.property((String)"item.id"), InventoryStockData.PROP_MENU_ITEM_ID);
        projections.add((Projection)Projections.property((String)"item.name"), InventoryStockData.PROP_MENU_ITEM_NAME);
        projections.add((Projection)Projections.property((String)"item.variant"), MenuItem.PROP_VARIANT);
        projections.add((Projection)Projections.property((String)InventoryTransaction.PROP_UNIT), InventoryStockData.PROP_UNIT);
        projections.add(Projections.sqlProjection((String)("sum(quantity*tran_type) AS " + InventoryStockData.PROP_QUANTITY_IN_HAND), (String[])new String[]{InventoryStockData.PROP_QUANTITY_IN_HAND}, (Type[])new Type[]{new DoubleType()}));
        projections.add((Projection)Projections.groupProperty((String)InventoryTransaction.PROP_UNIT));
        projections.add((Projection)Projections.groupProperty((String)"item.id"));
        projections.add((Projection)Projections.groupProperty((String)"item.name"));
        criteria.setProjection((Projection)projections);
        criteria.add((Criterion)Restrictions.le((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)DateUtil.endOfDay(transactionDate)));
        if (lastClosingDate != null) {
            criteria.add((Criterion)Restrictions.ge((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)lastClosingDate));
        }
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TO_LOCATION_ID, (Object)locationId), (Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TYPE, (Object)InventoryTransactionType.IN.getType())), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_FROM_LOCATION_ID, (Object)locationId), (Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TYPE, (Object)InventoryTransactionType.OUT.getType()))));
        criteria.add(Restrictions.in((String)("item." + MenuItem.PROP_ID), menuItemsIds));
        criteria.addOrder(Order.asc((String)"item.name"));
        criteria.setResultTransformer(Transformers.aliasToBean(InventoryStockData.class));
        List dataList = criteria.list();
        return dataList;
    }

    private List<InventoryLocation> findLocations(List<InventoryLocation> invLocations, Session session) {
        Criteria criteria = session.createCriteria(InventoryLocation.class);
        ProjectionList projList = Projections.projectionList();
        projList.add((Projection)Projections.property((String)InventoryLocation.PROP_ID), InventoryLocation.PROP_ID);
        projList.add((Projection)Projections.property((String)InventoryLocation.PROP_NAME), InventoryLocation.PROP_NAME);
        criteria.setProjection((Projection)projList);
        criteria.setResultTransformer(Transformers.aliasToBean(InventoryLocation.class));
        if (invLocations != null) {
            List<String> stringIds = POSUtil.getStringIds(invLocations, InventoryLocation.class);
            criteria.add(Restrictions.in((String)InventoryLocation.PROP_ID, stringIds));
        }
        List locations = criteria.list();
        return locations;
    }

    private String generateKey(Map<String, InventoryStockData> itemMap, InventoryStockData tData, boolean isSummarizeVariant) {
        InventoryStockData inventoryStockData;
        if (isSummarizeVariant && (inventoryStockData = itemMap.get(tData.getMenuItemId())) != null && inventoryStockData.getVariant()) {
            return inventoryStockData.getParentMenuItemId() + tData.getUnit() + tData.getLocationId();
        }
        return tData.getMenuItemId() + tData.getUnit() + tData.getLocationId();
    }

    private Map<String, InventoryStockData> getInventoryItems(String nameOrSku, List<MenuCategory> menuCategories, List<MenuGroup> menuGroups, String unitId, InventoryVendor vendor, Session session) {
        List<String> stringIds;
        List commonMenuItemsId = null;
        Criteria criteria = null;
        if (vendor != null) {
            criteria = session.createCriteria(InventoryVendorItems.class);
            criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)vendor));
            criteria.createAlias(InventoryVendorItems.PROP_ITEM, "item");
            criteria.setProjection((Projection)Projections.property((String)"item.id"));
            commonMenuItemsId = criteria.list();
        }
        criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_DELETED), (Criterion)Restrictions.eq((String)MenuItem.PROP_DELETED, (Object)Boolean.FALSE)));
        ProjectionList list = Projections.projectionList();
        list.add((Projection)Projections.property((String)MenuItem.PROP_ID), InventoryStockData.PROP_MENU_ITEM_ID);
        list.add((Projection)Projections.property((String)MenuItem.PROP_NAME), InventoryStockData.PROP_MENU_ITEM_NAME);
        list.add((Projection)Projections.property((String)MenuItem.PROP_MENU_GROUP_NAME), InventoryStockData.PROP_MENU_GROUP);
        list.add((Projection)Projections.property((String)MenuItem.PROP_COST), InventoryStockData.PROP_MENU_ITEM_COST);
        list.add((Projection)Projections.property((String)MenuItem.PROP_UNIT_NAME), InventoryStockData.PROP_UNIT);
        list.add((Projection)Projections.property((String)MenuItem.PROP_SKU), InventoryStockData.PROP_SKU);
        list.add((Projection)Projections.property((String)MenuItem.PROP_PARENT_MENU_ITEM_ID), MenuItem.PROP_PARENT_MENU_ITEM_ID);
        list.add((Projection)Projections.property((String)MenuItem.PROP_VARIANT), MenuItem.PROP_VARIANT);
        criteria.setProjection((Projection)list);
        if (StringUtils.isNotEmpty((String)nameOrSku)) {
            Disjunction disjuction = Restrictions.disjunction();
            disjuction.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)nameOrSku, (MatchMode)MatchMode.START));
            disjuction.add(Restrictions.ilike((String)MenuItem.PROP_SKU, (String)nameOrSku, (MatchMode)MatchMode.EXACT));
            criteria.add((Criterion)disjuction);
        }
        if (StringUtils.isNotBlank((String)unitId)) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_UNIT_ID, (Object)unitId));
        }
        if (commonMenuItemsId != null && !commonMenuItemsId.isEmpty()) {
            criteria.add(Restrictions.in((String)MenuItem.PROP_ID, (Collection)commonMenuItemsId));
        }
        if (menuGroups != null) {
            stringIds = POSUtil.getStringIds(menuGroups, MenuGroup.class);
            criteria.add(Restrictions.in((String)MenuItem.PROP_MENU_GROUP_ID, stringIds));
        }
        if (menuCategories != null) {
            stringIds = POSUtil.getStringIds(menuCategories, MenuCategory.class);
            criteria.add(Restrictions.in((String)MenuItem.PROP_MENU_CATEGORY_ID, stringIds));
        }
        criteria.add(Restrictions.eqOrIsNull((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
        criteria.setResultTransformer(Transformers.aliasToBean(InventoryStockData.class));
        List dataList = criteria.list();
        HashMap<String, InventoryStockData> itemMap = new HashMap<String, InventoryStockData>();
        if (dataList != null && dataList.size() > 0) {
            for (InventoryStockData inventoryStockData : dataList) {
                itemMap.put(inventoryStockData.getMenuItemId(), inventoryStockData);
            }
        }
        return itemMap;
    }
}

