/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.main.Application;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import com.jidesoft.swing.TitledSeparator;
import com.orostock.inventory.InvMessages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.combobox.ListComboBoxModel;

public class InventoryConfiguration
extends TransparentPanel {
    private static final long serialVersionUID = 1L;
    private Store store;
    private JCheckBox chkUpdateOnHandBalanceOnSale;
    private JCheckBox chkUpdateAvailBalanceOnSale;
    private JCheckBox chkAllowNegetiveOnHandBalance;
    private JCheckBox chkAllowMemberbasedPOI;
    private JRadioButton btnUpdateAvailBalanceForPurchaseOrderCreated;
    private JRadioButton btnUpdateAvailBalanceForPurchaseOrderReceived;
    private JRadioButton btnLastPurchasePrice;
    private JRadioButton btnAvgPurchasePrice;
    private JComboBox<InventoryLocation> cbInLocation = new JComboBox();
    private JComboBox<InventoryLocation> cbOutLocation = new JComboBox();

    public InventoryConfiguration() {
        this.initComponents();
        this.updateView();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.chkUpdateOnHandBalanceOnSale = new JCheckBox(InvMessages.getString("IVC.0"));
        this.chkUpdateAvailBalanceOnSale = new JCheckBox(InvMessages.getString("IVC.1"));
        this.chkAllowNegetiveOnHandBalance = new JCheckBox(InvMessages.getString("IVC.2"));
        this.chkAllowMemberbasedPOI = new JCheckBox(InvMessages.getString("IVC.3"));
        this.chkUpdateOnHandBalanceOnSale.setSelected(true);
        this.chkUpdateAvailBalanceOnSale.setSelected(true);
        this.btnUpdateAvailBalanceForPurchaseOrderCreated = new JRadioButton(InvMessages.getString("IVC.4"));
        this.btnUpdateAvailBalanceForPurchaseOrderReceived = new JRadioButton(InvMessages.getString("IVC.5"));
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.btnUpdateAvailBalanceForPurchaseOrderCreated);
        btnGroup.add(this.btnUpdateAvailBalanceForPurchaseOrderReceived);
        this.btnUpdateAvailBalanceForPurchaseOrderReceived.setSelected(true);
        JLabel lblCostingRule = new JLabel(InvMessages.getString("IVC.6"));
        this.btnLastPurchasePrice = new JRadioButton(InvMessages.getString("IVC.7"));
        this.btnLastPurchasePrice.setSelected(true);
        this.btnAvgPurchasePrice = new JRadioButton(InvMessages.getString("IVC.8"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.btnAvgPurchasePrice);
        buttonGroup.add(this.btnLastPurchasePrice);
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout(""));
        topPanel.setBorder(new TitledBorder(null, InvMessages.getString("IVC.10"), 2, 2, null, null));
        topPanel.add((Component)this.chkUpdateOnHandBalanceOnSale, "grow, wrap");
        topPanel.add((Component)this.chkUpdateAvailBalanceOnSale, "grow, wrap");
        topPanel.add((Component)this.chkAllowNegetiveOnHandBalance, "grow, wrap");
        topPanel.add((Component)this.chkAllowMemberbasedPOI, "grow, wrap");
        JSeparator separator = new JSeparator();
        topPanel.add((Component)separator, "grow, wrap");
        topPanel.add((Component)this.btnUpdateAvailBalanceForPurchaseOrderCreated, "grow, wrap");
        topPanel.add((Component)this.btnUpdateAvailBalanceForPurchaseOrderReceived, "grow, wrap");
        TitledSeparator sep2 = new TitledSeparator((JComponent)lblCostingRule, 10);
        topPanel.add((Component)sep2, "grow, wrap");
        topPanel.add((Component)this.btnLastPurchasePrice, "grow, wrap");
        topPanel.add((Component)this.btnAvgPurchasePrice, "grow, wrap");
        topPanel.add((Component)new TitledSeparator(InvMessages.getString("IVC.21")), "growx");
        topPanel.add((Component)new JLabel(InvMessages.getString("IVC.23")), "newline, split 2, alignx trailing");
        topPanel.add(this.cbInLocation, "growx");
        topPanel.add((Component)new JLabel(InvMessages.getString("IVC.9")), "newline, split 2, alignx trailing");
        topPanel.add(this.cbOutLocation, "growx");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("center"));
        PosButton btnSave = new PosButton(InvMessages.getString("IVC.30"));
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InventoryConfiguration.this.updateModel()) {
                    Terminal currentTerminal = DataProvider.get().getCurrentTerminal();
                    TerminalDAO.getInstance().performBatchSave(InventoryConfiguration.this.store, currentTerminal);
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVC.31"));
                }
            }
        });
        buttonPanel.add(btnSave);
        this.add((Component)topPanel, "Center");
        this.add((Component)buttonPanel, "South");
    }

    private void updateView() {
        this.store = Application.getInstance().getStore();
        if (this.store.isAllwMemberbasedPOI()) {
            this.chkAllowMemberbasedPOI.setSelected(this.store.isAllwMemberbasedPOI());
        }
        if (this.store.isUpdateOnHandBlncForSale()) {
            this.chkUpdateOnHandBalanceOnSale.setSelected(this.store.isUpdateOnHandBlncForSale());
        }
        if (this.store.isUpdateAvlBlncForSale()) {
            this.chkUpdateAvailBalanceOnSale.setSelected(this.store.isUpdateAvlBlncForSale());
        }
        if (this.store.isUpdateAvlBlncForPOCreated()) {
            this.btnUpdateAvailBalanceForPurchaseOrderCreated.setSelected(this.store.isUpdateAvlBlncForPOCreated());
        }
        if (this.store.isUpdateOnHandBlncForPORec()) {
            this.btnUpdateAvailBalanceForPurchaseOrderReceived.setSelected(this.store.isUpdateOnHandBlncForPORec());
        }
        if (this.store.isAllwNegOnHandBlnce()) {
            this.chkAllowNegetiveOnHandBalance.setSelected(this.store.isAllwNegOnHandBlnce());
        }
        if (this.store.isInventoryAvgPricingMethod()) {
            this.btnAvgPurchasePrice.setSelected(true);
        } else {
            this.btnLastPurchasePrice.setSelected(true);
        }
        List<InventoryLocation> locations = InventoryLocationDAO.getInstance().findAll();
        ArrayList<InventoryLocation> inLocations = new ArrayList<InventoryLocation>();
        inLocations.add(null);
        inLocations.addAll(locations);
        ArrayList<InventoryLocation> outLocations = new ArrayList<InventoryLocation>();
        outLocations.add(null);
        outLocations.addAll(locations);
        this.cbInLocation.setModel((ComboBoxModel<InventoryLocation>)new ListComboBoxModel(inLocations));
        this.cbOutLocation.setModel((ComboBoxModel<InventoryLocation>)new ListComboBoxModel(inLocations));
        Terminal currentTerminal = DataProvider.get().getCurrentTerminal();
        PosGuiUtil.selectComboItemById(this.cbInLocation, currentTerminal.getInventoryInLocationId());
        PosGuiUtil.selectComboItemById(this.cbOutLocation, currentTerminal.getInventoryOutLocationId());
    }

    private boolean updateModel() {
        this.store = Application.getInstance().getStore();
        boolean isUpdateAvailBlncOnSaleSelected = this.chkUpdateAvailBalanceOnSale.isSelected();
        boolean isUpdateOnHandBlnceOnSaleSelected = this.chkUpdateOnHandBalanceOnSale.isSelected();
        boolean isUpdateAvailBlncePOCreatedSelected = this.btnUpdateAvailBalanceForPurchaseOrderCreated.isSelected();
        boolean isUpdateAvlBlnceForPOReceivedSelected = this.btnUpdateAvailBalanceForPurchaseOrderReceived.isSelected();
        boolean isAllowNegetiveOnHandBalance = this.chkAllowNegetiveOnHandBalance.isSelected();
        boolean memberBasedPurhcaseOrderItem = this.chkAllowMemberbasedPOI.isSelected();
        this.store.addProperty("inventory.updateAvlBlnceForSale", String.valueOf(isUpdateAvailBlncOnSaleSelected));
        this.store.addProperty("inventory.updateOnHandBlnceForSale", String.valueOf(isUpdateOnHandBlnceOnSaleSelected));
        this.store.addProperty("inventory.updateAvailBalanceForPurchaseOrderCreated", String.valueOf(isUpdateAvailBlncePOCreatedSelected));
        this.store.addProperty("inventory.updateOnHandBalanceForPurchaseOrderReceived", String.valueOf(isUpdateAvlBlnceForPOReceivedSelected));
        this.store.addProperty("inventory.allowNegetiveOnHandBalance", String.valueOf(isAllowNegetiveOnHandBalance));
        this.store.addProperty("inventory.allowMemberPOI", String.valueOf(memberBasedPurhcaseOrderItem));
        if (this.btnLastPurchasePrice.isSelected()) {
            this.store.addProperty("inventory.pricing.method", "last_purchase");
        } else {
            this.store.addProperty("inventory.pricing.method", "avg");
        }
        InventoryLocation inLocaton = (InventoryLocation)this.cbInLocation.getSelectedItem();
        InventoryLocation outLocaton = (InventoryLocation)this.cbOutLocation.getSelectedItem();
        Terminal currentTerminal = DataProvider.get().getCurrentTerminal();
        currentTerminal.setInventoryInLocationId(inLocaton == null ? null : inLocaton.getId());
        currentTerminal.setInventoryOutLocationId(outLocaton == null ? null : outLocaton.getId());
        return true;
    }
}

