/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.InventoryUnitGroupDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class InventoryUnitForm
extends BeanEditor<InventoryUnit> {
    private FixedLengthTextField tfName = new FixedLengthTextField(30);
    private FixedLengthTextField tfCode = new FixedLengthTextField(10);
    private DoubleTextField tfFactor = new DoubleTextField(10);
    private JComboBox cbUnitGroups = new JComboBox();
    private List<InventoryUnitGroup> groups;
    private JButton btnAddNew;
    private JCheckBox chkBaseUnit;

    public InventoryUnitForm() {
        this(new InventoryUnit());
    }

    public InventoryUnitForm(InventoryUnit unit) {
        this.createUI();
        this.setBean(unit);
        this.groups = InventoryUnitGroupDAO.getInstance().findAll();
        if (this.groups != null) {
            this.cbUnitGroups.setModel(new DefaultComboBoxModel<Object>(this.groups.toArray()));
        }
    }

    private void createUI() {
        this.setLayout((LayoutManager)new MigLayout("fillx"));
        this.add(new JLabel(InvMessages.getString("IVUF.1")));
        this.add((Component)this.tfCode, "grow, wrap");
        this.add(new JLabel(InvMessages.getString("IVUF.3")));
        this.add((Component)this.tfName, "grow, wrap");
        this.add(new JLabel(InvMessages.getString("IVUF.5")));
        this.add((Component)this.tfFactor, "wrap");
        this.add(new JLabel(InvMessages.getString("IVUF.7")));
        this.add((Component)this.cbUnitGroups, "split 2");
        this.btnAddNew = new JButton(InvMessages.getString("IVUF.9"));
        this.btnAddNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String groupName = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), (Object)InvMessages.getString("IVUF.10"));
                if (groupName == null) {
                    BOMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("IVUF.11"));
                    return;
                }
                if (groupName.length() > 30) {
                    BOMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("IVUF.12"));
                    return;
                }
                for (InventoryUnitGroup group : InventoryUnitForm.this.groups) {
                    if (!group.getName().equals(groupName)) continue;
                    BOMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("IVUF.13"));
                    return;
                }
                InventoryUnitGroup group = new InventoryUnitGroup();
                group.setName(groupName);
                InventoryUnitGroupDAO.getInstance().saveOrUpdate(group);
                InventoryUnitForm.this.groups.add(group);
                InventoryUnitForm.this.cbUnitGroups.setModel(new DefaultComboBoxModel<Object>(InventoryUnitForm.this.groups.toArray()));
                InventoryUnitForm.this.cbUnitGroups.setSelectedItem(group);
            }
        });
        this.add((Component)this.btnAddNew, "wrap");
        this.chkBaseUnit = new JCheckBox(InvMessages.getString("IVUF.15"));
        this.add((Component)this.chkBaseUnit, "skip 1,wrap");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            InventoryUnitDAO.getInstance().saveOrUpdate((InventoryUnit)this.getBean());
            return true;
        }
        catch (PosException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
            return false;
        }
        catch (IllegalModelStateException e) {
            POSMessageDialog.showError(this, e.getMessage());
            return false;
        }
    }

    @Override
    public void createNew() {
        this.setBean(new InventoryUnit());
        this.clearFields();
    }

    @Override
    public void setFieldsEnable(boolean enable) {
        this.tfName.setEnabled(enable);
        this.tfCode.setEnabled(enable);
        this.tfFactor.setEnabled(enable);
        this.cbUnitGroups.setEnabled(enable);
        this.btnAddNew.setEnabled(enable);
        this.chkBaseUnit.setEnabled(enable);
    }

    @Override
    public void clearFields() {
        this.tfName.setText("");
        this.tfCode.setText("");
        this.tfFactor.setText("");
    }

    @Override
    protected void updateView() {
        InventoryUnit inventoryUnit = (InventoryUnit)this.getBean();
        if (inventoryUnit == null) {
            return;
        }
        this.tfName.setText(inventoryUnit.getName());
        this.tfCode.setText(inventoryUnit.getCode());
        this.tfFactor.setText(inventoryUnit.getConversionRate() + "");
        this.cbUnitGroups.setSelectedItem(inventoryUnit.getUnitGroupId());
        this.chkBaseUnit.setSelected(inventoryUnit.isBaseUnit());
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        InventoryUnit inventoryUnit = (InventoryUnit)this.getBean();
        if (inventoryUnit == null) {
            return false;
        }
        String code = this.tfCode.getText();
        String name = this.tfName.getText();
        double conversionRate = this.tfFactor.getDouble();
        InventoryUnitGroup group = (InventoryUnitGroup)this.cbUnitGroups.getSelectedItem();
        if (StringUtils.isEmpty((String)code)) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), InvMessages.getString("IVUF.21"));
            return false;
        }
        if (Double.isNaN(conversionRate) || conversionRate <= 0.0) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), InvMessages.getString("IVUF.23"));
            return false;
        }
        if (group == null) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), InvMessages.getString("IVUF.24"));
            return false;
        }
        inventoryUnit.setName(name);
        inventoryUnit.setConversionRate(conversionRate);
        inventoryUnit.setUnitGroupId(group.getId());
        inventoryUnit.setBaseUnit(this.chkBaseUnit.isSelected());
        if (StringUtils.isEmpty((String)inventoryUnit.getCode())) {
            inventoryUnit.setCode(code.replaceAll("[^\\p{Alnum}]", "_"));
        }
        return true;
    }

    @Override
    public boolean delete() {
        try {
            InventoryUnit inventoryUnit = (InventoryUnit)this.getBean();
            if (inventoryUnit == null) {
                return false;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), InvMessages.getString("IVUF.27"), InvMessages.getString("IVUF.28"));
            if (option != 0) {
                return false;
            }
            InventoryUnitDAO.getInstance().delete(inventoryUnit);
            this.clearFields();
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        return InvMessages.getString("IVUF.29");
    }
}

