/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.PosException;
import com.floreantpos.model.InventoryWarehouse;
import com.floreantpos.model.dao.InventoryWarehouseDAO;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class InventoryWarehouseEntryForm
extends BeanEditor<InventoryWarehouse> {
    private JCheckBox chkVisible;
    private POSTextField tfName;

    public InventoryWarehouseEntryForm(InventoryWarehouse ig) {
        super(new BorderLayout());
        this.createUI();
        this.setBean(ig);
    }

    private void createUI() {
        JPanel panel = new JPanel();
        this.add((Component)panel, "Center");
        panel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][]"));
        JLabel lblName = new JLabel(InvMessages.getString("IVWEF.3"));
        panel.add((Component)lblName, "cell 0 0,alignx trailing");
        this.tfName = new POSTextField();
        panel.add((Component)this.tfName, "cell 1 0,growx");
        this.chkVisible = new JCheckBox(InvMessages.getString("IVWEF.6"));
        panel.add((Component)this.chkVisible, "cell 1 1");
    }

    @Override
    public void updateView() {
        InventoryWarehouse inventoryWarehouse = (InventoryWarehouse)this.getBean();
        if (inventoryWarehouse == null) {
            return;
        }
        this.tfName.setText(inventoryWarehouse.getName());
        this.chkVisible.setSelected(POSUtil.getBoolean(inventoryWarehouse.isVisible()));
    }

    @Override
    public boolean updateModel() {
        String nameString;
        InventoryWarehouse inventoryWarehouse = (InventoryWarehouse)this.getBean();
        if (inventoryWarehouse == null) {
            inventoryWarehouse = new InventoryWarehouse();
            this.setBean(inventoryWarehouse, false);
        }
        if (StringUtils.isEmpty((String)(nameString = this.tfName.getText()))) {
            throw new PosException(InvMessages.getString("IVWEF.8"));
        }
        inventoryWarehouse.setName(nameString);
        inventoryWarehouse.setVisible(this.chkVisible.isSelected());
        return true;
    }

    @Override
    public String getDisplayText() {
        return InvMessages.getString("IVWEF.9");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            InventoryWarehouse model = (InventoryWarehouse)this.getBean();
            InventoryWarehouseDAO.getInstance().saveOrUpdate(model);
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage());
            return false;
        }
    }
}

