/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.PosException;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.PackagingUnitDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.exception.ConstraintViolationException;

public class PackagingUnitForm
extends BeanEditor<PackagingUnit> {
    private FixedLengthTextField tfName = new FixedLengthTextField(30);
    private FixedLengthTextField tfShortName = new FixedLengthTextField(10);
    private boolean recipeUnit;

    public PackagingUnitForm() {
        this(false);
    }

    public PackagingUnitForm(boolean recipeUnit) {
        this(new PackagingUnit(), recipeUnit);
    }

    public PackagingUnitForm(PackagingUnit pu) {
        this(pu, false);
    }

    public PackagingUnitForm(PackagingUnit pu, boolean recipeUnit) {
        this.recipeUnit = recipeUnit;
        this.createUI();
        this.setBean(pu);
        if (pu.getId() != null) {
            this.tfShortName.setEnabled(false);
        }
    }

    private void createUI() {
        this.setLayout((LayoutManager)new MigLayout("fillx"));
        this.add(new JLabel(InvMessages.getString("IVPUF.1")));
        this.add((Component)this.tfShortName, "grow, wrap");
        this.add(new JLabel(InvMessages.getString("IVPUF.0")));
        this.add((Component)this.tfName, "grow, wrap");
    }

    @Override
    public boolean save() {
        String oldId = null;
        try {
            if (!this.updateModel()) {
                return false;
            }
            PackagingUnit packagingUnit = (PackagingUnit)this.getBean();
            oldId = packagingUnit.getId();
            PackagingUnitDAO.getInstance().saveOrUpdate(packagingUnit);
            return true;
        }
        catch (PosException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
        catch (ConstraintViolationException e) {
            PackagingUnit packagingUnit = (PackagingUnit)this.getBean();
            packagingUnit.setId(oldId);
            Exception cause = (Exception)e.getCause();
            String message = e.getMessage();
            if (cause.getMessage().contains(packagingUnit.getName())) {
                message = String.format(InvMessages.getString("PackagingUnitForm.0"), packagingUnit.getName());
            } else if (cause.getMessage().contains(packagingUnit.getCode())) {
                message = String.format(InvMessages.getString("PackagingUnitForm.1"), packagingUnit.getCode());
            }
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
        }
        catch (IllegalModelStateException e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
        return false;
    }

    @Override
    public void createNew() {
        this.setBean(new PackagingUnit());
        this.clearFields();
    }

    @Override
    public void setFieldsEnable(boolean enable) {
        this.tfName.setEnabled(enable);
        if (this.getBean() == null || ((PackagingUnit)this.getBean()).getId() == null) {
            this.tfShortName.setEnabled(enable);
        }
    }

    @Override
    public void setEnabledFalse() {
        this.tfName.setEnabled(true);
        this.tfShortName.setEnabled(false);
    }

    @Override
    public void clearFields() {
        this.tfName.setText("");
        this.tfShortName.setText("");
    }

    @Override
    protected void updateView() {
        PackagingUnit packagingUnit = (PackagingUnit)this.getBean();
        if (packagingUnit == null) {
            return;
        }
        this.tfName.setText(packagingUnit.getName());
        this.tfShortName.setText(packagingUnit.getCode());
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        PackagingUnit packagingUnit = (PackagingUnit)this.getBean();
        if (packagingUnit == null) {
            return false;
        }
        String name = this.tfName.getText().trim();
        String code = this.tfShortName.getText().trim();
        GenericDAO.getInstance().checkIdOrNameExists(packagingUnit.getId(), name, PackagingUnit.class);
        packagingUnit.setName(name);
        packagingUnit.setCode(code);
        if (StringUtils.isEmpty((String)packagingUnit.getCode())) {
            packagingUnit.setCode(code.replaceAll("[^\\p{Alnum}]", "_"));
        }
        packagingUnit.setRecipeUnit(this.recipeUnit);
        return true;
    }

    @Override
    public boolean delete() {
        try {
            PackagingUnit packagingUnit = (PackagingUnit)this.getBean();
            if (packagingUnit == null) {
                return false;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), InvMessages.getString("IVPUF.11"), InvMessages.getString("IVPUF.12"));
            if (option != 0) {
                return false;
            }
            PackagingUnitDAO.getInstance().delete(packagingUnit);
            this.clearFields();
            return true;
        }
        catch (PosException e) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(e.getMessage(), e.getDetails());
            detailsInfoDialog.open();
            return Boolean.FALSE;
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        if (this.recipeUnit) {
            return InvMessages.getString("IVPUF.13");
        }
        return InvMessages.getString("IVPUF.14");
    }
}

