/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.IconFactory;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.LabelItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Printer;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.commons.lang.StringUtils;

public class PrintLabelForm
extends TransparentPanel {
    private JButton addButton;
    private JButton deleteButton;
    private PosButton btnNext;
    private PosButton btnPrev;
    private PrintLabelTable table;
    private BeanTableModel tableModel;
    private JPanel bottomPanel;
    private JButton deleteAllButton;

    public PrintLabelForm() {
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        this.tableModel = new BeanTableModel(LabelItem.class, 10);
        this.tableModel.addColumn(InvMessages.getString("PrintLabelForm.0"), "barcode");
        this.tableModel.addColumn(InvMessages.getString("PrintLabelForm.2"), "name");
        this.tableModel.addColumn(InvMessages.getString("IVLEF.6"), "translatedName");
        this.tableModel.addColumn(InvMessages.getString("PrintLabelForm.4") + " (" + CurrencyUtil.getCurrencySymbol() + ")", "memberPrice", BeanTableModel.EditMode.NON_EDITABLE, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(InvMessages.getString("PrintLabelForm.8") + " (" + CurrencyUtil.getCurrencySymbol() + ")", "retailPrice", BeanTableModel.EditMode.NON_EDITABLE, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn(InvMessages.getString("PrintLabelForm.12"), "printQuantity", BeanTableModel.EditMode.EDITABLE, 11, BeanTableModel.DataType.NUMBER);
        this.table = new PrintLabelTable(this.tableModel);
        this.table.setRowHeight(PosUIManager.getSize(40));
        this.table.setAutoResizeMode(3);
        this.table.setGridColor(Color.LIGHT_GRAY);
        this.table.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        IntegerTextField tfEditField = new IntegerTextField();
        tfEditField.setHorizontalAlignment(11);
        DefaultCellEditor editor = new DefaultCellEditor(tfEditField);
        editor.setClickCountToStart(1);
        this.table.setDefaultEditor(this.table.getColumnClass(5), editor);
        PosScrollPane scrollPane = new PosScrollPane((Component)((Object)this.table), 20, 31);
        JScrollBar scrollBar = scrollPane.getVerticalScrollBar();
        scrollBar.setPreferredSize(PosUIManager.getSize(30, 60));
        centerPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        TitledBorder border = BorderFactory.createTitledBorder(null, InvMessages.getString("IVPLF.18"), 2, 0);
        this.addButton = new JButton(InvMessages.getString("IVPLF.19"));
        this.addButton.addActionListener(e -> this.doAddItems());
        this.deleteButton = new JButton(InvMessages.getString("IVPLF.20"));
        this.deleteButton.addActionListener(e -> this.doDeleteItems());
        this.deleteAllButton = new JButton(InvMessages.getString("IVPLF.21"));
        this.deleteAllButton.addActionListener(e -> this.doDeleteAllItems());
        this.btnPrev = new PosButton();
        this.btnPrev.setIcon(IconFactory.getIcon("/ui_icons/", "previous.png"));
        this.btnNext = new PosButton();
        this.btnNext.setIcon(IconFactory.getIcon("/ui_icons/", "next.png"));
        centerPanel.setBorder(border);
        centerPanel.add((Component)scrollPane, "span,grow, wrap");
        centerPanel.add((Component)this.addButton, "split 3");
        centerPanel.add(this.deleteButton);
        centerPanel.add(this.deleteAllButton);
        this.add((Component)centerPanel, "Center");
        this.bottomPanel = new JPanel();
        PosButton btnLabelPrint = new PosButton(InvMessages.getString("IVPLF.28"));
        btnLabelPrint.addActionListener(e -> this.doPrintItems());
        this.bottomPanel.add(btnLabelPrint);
        this.add((Component)this.bottomPanel, "South");
    }

    public JPanel getBottomPanel() {
        return this.bottomPanel;
    }

    public void setButtonVisibility(boolean isVisible) {
        this.addButton.setVisible(isVisible);
        this.deleteButton.setVisible(isVisible);
        this.deleteAllButton.setVisible(isVisible);
    }

    private void doPrintOnReport(List<LabelItem> items) {
        try {
            List<Printer> labelPrinters = DataProvider.get().getPrinters().getLabelPrinters();
            if (labelPrinters.size() == 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("IVPLF.29"));
                return;
            }
            for (Printer printer : labelPrinters) {
                JasperPrint jasperPrint = ReceiptPrintService.createPurchaseOrderItemsBarcodePrint(items);
                jasperPrint.setName(InvMessages.getString("IVPLF.30"));
                jasperPrint.setProperty("printerName", printer.getDeviceName());
                ReceiptPrintService.printQuitely(jasperPrint);
            }
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("PrintLabelForm.1"));
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doAddItems() {
        MenuItemSelectionDialog dialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>(), true);
        dialog.setSelectionMode(1);
        dialog.setSize(PosUIManager.getSize(600, 515));
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        List<MenuItem> menuItemList = dialog.getSelectedItems();
        this.doAddItems(menuItemList);
    }

    public void doAddItems(List<MenuItem> items) {
        List labelItemList = this.tableModel.getRows();
        if (labelItemList == null) {
            labelItemList = new ArrayList();
        }
        for (MenuItem menuItem : items) {
            LabelItem labelItem = new LabelItem();
            labelItem.setMenuItem(menuItem);
            labelItem.setPrintQuantity(1);
            labelItemList.add(labelItem);
        }
        this.tableModel.setRows(labelItemList);
        this.table.revalidate();
        this.table.repaint();
    }

    public void doAddLabelItems(List<LabelItem> items) {
        List labelItemList = this.tableModel.getRows();
        if (labelItemList == null) {
            labelItemList = new ArrayList();
        }
        labelItemList.addAll(items);
        this.tableModel.setRows(labelItemList);
        this.table.revalidate();
        this.table.repaint();
    }

    private void doDeleteItems() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), InvMessages.getString("IVPLF.31"), InvMessages.getString("IVPLF.32"));
            if (option != 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            this.tableModel.removeRow(index);
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doDeleteAllItems() {
        try {
            if (this.tableModel.getRows() == null || this.tableModel.getRows().size() <= 0) {
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), InvMessages.getString("IVPLF.33"), InvMessages.getString("IVPLF.34"));
            if (option != 0) {
                return;
            }
            this.tableModel.removeAll();
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doPrintItems() {
        try {
            this.clearTableEditingFocus();
            boolean isValid = true;
            List printLabelItems = this.tableModel.getRows();
            if (printLabelItems == null || printLabelItems.size() <= 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("IVPLF.35"));
                return;
            }
            ArrayList<LabelItem> labelItems = new ArrayList<LabelItem>();
            for (LabelItem labelItem : printLabelItems) {
                if (labelItem.getPrintQuantity() < 1) {
                    isValid = false;
                    break;
                }
                for (int i = 0; i < labelItem.getPrintQuantity(); ++i) {
                    labelItems.add(labelItem);
                }
            }
            if (!isValid) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("IVPLF.36"));
                return;
            }
            this.doPrintOnReport(labelItems);
        }
        catch (Exception e) {
            PosLog.error(PrintLabelForm.class, e.getMessage(), e);
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("IVPLF.37"));
        }
    }

    private void clearTableEditingFocus() {
        try {
            if (!this.table.isEditing()) {
                return;
            }
            this.table.editingStopped(null);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    private class PrintLabelTable
    extends PosTable {
        public PrintLabelTable(BeanTableModel<LabelItem> dm) {
            super(dm);
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex == 5) {
                LabelItem printLabeltem = (LabelItem)PrintLabelForm.this.tableModel.getRow(rowIndex);
                if (value instanceof String) {
                    String receiveStr = (String)value;
                    printLabeltem.setPrintQuantity(StringUtils.isEmpty((String)receiveStr) ? 0 : Integer.parseInt(receiveStr));
                } else if (value instanceof Integer) {
                    printLabeltem.setPrintQuantity((Integer)value);
                }
            }
        }
    }
}

