/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.config.AppProperties;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.PurchaseOrderItemDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import net.miginfocom.swing.MigLayout;

public class PurchaseOrderItemEntryDialog
extends OkCancelOptionDialog {
    private static final long serialVersionUID = 1L;
    private Component lblQuantity;
    private PurchaseOrderItem orderItem;
    private JLabel lblPurchaseOrderItemType;
    private JComboBox cbInventoryReasons;
    private JLabel lblUnitPrice;
    private DoubleTextField tfUnitPrice;
    private DoubleTextField tfQuantity;
    private POSTextField tfSku;
    private JButton btnSearchItem;
    private POSTextField tfSearchString;
    private JComboBox cbUnits;
    private JLabel lblOrderId;
    private JList<Customer> listCustomers;
    private DefaultListModel model;
    private MenuItem menuItem;
    private JLabel lblMemberCaption;
    private JButton btnMemberSelect;
    private JButton btnMemberRemove;
    private JScrollPane scrollPane;
    private JTextArea taNote;

    public PurchaseOrderItemEntryDialog(PurchaseOrderItem orderItem) {
        this.orderItem = orderItem;
        this.initComponents();
        this.initData();
        this.updateView();
    }

    private void initData() {
        ComboBoxModel aModel = new ComboBoxModel();
        this.cbUnits.setModel(aModel);
        this.loadUnits();
        this.cbUnits.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                PurchaseOrderItemEntryDialog.this.updatePrice();
            }
        });
    }

    private void setUnit(MenuItem menuItem) {
        ComboBoxModel aModel = (ComboBoxModel)this.cbUnits.getModel();
        if (menuItem != null) {
            MenuItemDAO.getInstance().initialize(menuItem);
            aModel.setDataList(menuItem.getUnits());
            InventoryUnit unit = menuItem.getUnit();
            if (unit != null) {
                for (IUnit iUnit : aModel.getDataList()) {
                    if (!iUnit.getUniqueCode().equals(unit.getUniqueCode())) continue;
                    this.cbUnits.setSelectedItem(iUnit);
                }
            } else {
                this.cbUnits.setSelectedItem(null);
            }
        }
        this.updatePrice();
    }

    private void updatePrice() {
        if (this.menuItem == null) {
            return;
        }
        IUnit selectedUnit = (IUnit)this.cbUnits.getSelectedItem();
        if (selectedUnit != null) {
            this.tfUnitPrice.setText(String.valueOf(this.menuItem.getCost(selectedUnit)));
        }
        this.tfQuantity.setText(String.valueOf(this.menuItem.getReplenishLevel() == 0.0 ? 1.0 : this.menuItem.getReplenishLevel()));
    }

    private void loadUnits() {
        if (this.menuItem == null) {
            return;
        }
        ComboBoxModel model = (ComboBoxModel)this.cbUnits.getModel();
        model.removeAllElements();
        model.setDataList(this.menuItem.getUnits());
    }

    private void initComponents() {
        this.setTitle(AppProperties.getAppName());
        this.setCaption(InvMessages.getString("IVPOIED.0"));
        JPanel itemInfoPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "[][grow][]", ""));
        this.lblOrderId = new JLabel(InvMessages.getString("IVPOIED.4"));
        itemInfoPanel.add((Component)this.lblOrderId, "alignx trailing");
        this.tfSearchString = new POSTextField();
        itemInfoPanel.add((Component)this.tfSearchString, "growx");
        this.tfSearchString.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PurchaseOrderItemEntryDialog.this.doSearchItem();
            }
        });
        this.btnSearchItem = new JButton(InvMessages.getString("IVIS.22"));
        itemInfoPanel.add((Component)this.btnSearchItem, "growx, wrap");
        this.btnSearchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PurchaseOrderItemEntryDialog.this.doSearchItem();
            }
        });
        this.lblPurchaseOrderItemType = new JLabel(InvMessages.getString("IVPOIED.9"));
        itemInfoPanel.add((Component)this.lblPurchaseOrderItemType, "alignx trailing");
        this.lblPurchaseOrderItemType.setVisible(false);
        this.cbInventoryReasons = new JComboBox();
        itemInfoPanel.add((Component)this.cbInventoryReasons, "growx, wrap");
        this.cbInventoryReasons.setVisible(false);
        JLabel lblUnit = new JLabel(InvMessages.getString("IVPOIED.12"));
        itemInfoPanel.add((Component)lblUnit, "alignx trailing");
        this.cbUnits = new JComboBox();
        this.cbUnits.setMinimumSize(PosUIManager.getSize(100, 0));
        itemInfoPanel.add((Component)this.cbUnits, "growx, wrap");
        this.lblUnitPrice = new JLabel(InvMessages.getString("IVPOIED.15") + " (" + CurrencyUtil.getCurrencySymbol() + ")");
        itemInfoPanel.add((Component)this.lblUnitPrice, "alignx trailing");
        this.tfUnitPrice = new DoubleTextField();
        itemInfoPanel.add((Component)this.tfUnitPrice, "growx, wrap");
        this.lblQuantity = new JLabel(InvMessages.getString("IVPOIED.20"));
        itemInfoPanel.add(this.lblQuantity, "alignx trailing");
        this.tfQuantity = new DoubleTextField();
        itemInfoPanel.add((Component)this.tfQuantity, "growx, wrap");
        JLabel lblNote = new JLabel(InvMessages.getString("IVPOIED.23"));
        lblNote.setHorizontalAlignment(11);
        itemInfoPanel.add((Component)lblNote, "growx, aligny top");
        this.taNote = new JTextArea();
        itemInfoPanel.add((Component)new JScrollPane(this.taNote), "h 100!, grow, wrap");
        this.lblMemberCaption = new JLabel(InvMessages.getString("IVPOIED.26"));
        this.listCustomers = new JList();
        this.listCustomers.setSelectionMode(0);
        this.model = new DefaultListModel();
        this.listCustomers.setModel(this.model);
        this.btnMemberSelect = new JButton(InvMessages.getString("IVPOIED.27"));
        this.btnMemberSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerSelectorDialog dialog = CustomerSelectorFactory.createCustomerSelectorDialog(Application.getInstance().getCurrentOrderType());
                dialog.setCreateNewTicket(false);
                dialog.updateView(true);
                dialog.setSize(PosUIManager.getSize(1020, 650));
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                Customer member = dialog.getSelectedCustomer();
                if (!PurchaseOrderItemEntryDialog.this.model.contains(member)) {
                    PurchaseOrderItemEntryDialog.this.model.addElement(member);
                }
            }
        });
        this.btnMemberRemove = new JButton(InvMessages.getString("IVPOIED.28"));
        this.btnMemberRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Customer customer = (Customer)PurchaseOrderItemEntryDialog.this.listCustomers.getSelectedValue();
                if (customer == null) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVPOIED.29"));
                    return;
                }
                PurchaseOrderItemEntryDialog.this.model.removeElement(customer);
            }
        });
        itemInfoPanel.add((Component)this.lblMemberCaption, "cell 0 10,alignx trailing");
        this.scrollPane = new JScrollPane(this.listCustomers);
        itemInfoPanel.add((Component)this.scrollPane, "cell 1 10, growx, span 0 2");
        itemInfoPanel.add((Component)this.btnMemberSelect, "growx, cell 2 10");
        itemInfoPanel.add((Component)this.btnMemberRemove, "growx, cell 2 11, aligny top");
        this.getContentPanel().add(new JScrollPane(itemInfoPanel));
    }

    private void doSearchItem() {
        MenuItemSelectionDialog dialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>(), true);
        dialog.setSelectionMode(0);
        dialog.setSize(PosUIManager.getSize(600, 515));
        dialog.doSearch(this.tfSearchString.getText());
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.menuItem = dialog.getSelectedRowData();
        if (this.menuItem != null) {
            this.tfSearchString.setText(this.menuItem.getName());
            this.setUnit(this.menuItem);
        }
    }

    public void updateView() {
        if (this.orderItem == null) {
            return;
        }
        this.menuItem = this.orderItem.getMenuItem();
        if (this.menuItem != null) {
            this.setUnit(this.menuItem);
            this.tfSearchString.setText(this.menuItem.getName());
        }
        this.tfQuantity.setText(String.valueOf(this.orderItem.getItemQuantity()));
        this.tfUnitPrice.setText(NumberUtil.formatNumber(this.orderItem.getUnitPrice()));
        if (this.orderItem.getCustomers() != null) {
            PurchaseOrderItemDAO.getInstance().initializeCustomers(this.orderItem);
            for (Customer customer : this.orderItem.getCustomers()) {
                this.model.addElement(customer);
            }
        }
        ComboBoxModel aModel = (ComboBoxModel)this.cbUnits.getModel();
        if (this.orderItem.getItemUnitName() != null) {
            for (IUnit iUnit : aModel.getDataList()) {
                if (iUnit.getUniqueCode() == null || !iUnit.getUniqueCode().equals(this.orderItem.getItemUnitName())) continue;
                this.cbUnits.setSelectedItem(iUnit);
            }
        } else if (aModel.getSize() > 0) {
            this.cbUnits.setSelectedIndex(0);
        }
        this.taNote.setText(this.orderItem.getNote());
        Store store = Application.getInstance().getStore();
        this.lblMemberCaption.setVisible(store.isAllwMemberbasedPOI());
        this.scrollPane.setVisible(store.isAllwMemberbasedPOI());
        this.btnMemberSelect.setVisible(store.isAllwMemberbasedPOI());
        this.btnMemberRemove.setVisible(store.isAllwMemberbasedPOI());
    }

    @Override
    public void doOk() {
        if (this.menuItem == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVPOIED.34"));
            return;
        }
        IUnit unit = (IUnit)this.cbUnits.getSelectedItem();
        if (unit == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVPOIED.35"));
            return;
        }
        double quantity = this.tfQuantity.getDoubleOrZero();
        if (quantity <= 0.0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVPOIED.36"));
            return;
        }
        double price = this.tfUnitPrice.getDoubleOrZero();
        this.orderItem.setSku(this.menuItem.getSku());
        this.orderItem.setMenuItem(this.menuItem);
        this.orderItem.setMenuItemId(this.menuItem.getId());
        this.orderItem.setItemUnitName(unit.getUniqueCode());
        this.orderItem.setItemQuantity(quantity);
        this.orderItem.setName(this.menuItem.getDisplayName());
        this.orderItem.setQuantityToReceive(quantity);
        this.orderItem.setUnitPrice(price);
        this.orderItem.calculatePrice();
        this.orderItem.setCustomers(this.getCustomers());
        this.orderItem.setNote(this.taNote.getText());
        if (this.menuItem.getCost() != 0.0 || price > 0.0) {
            // empty if block
        }
        PurchaseOrderItemDAO.getInstance().saveOrUpdate(this.orderItem);
        this.setCanceled(false);
        this.dispose();
    }

    public Set<Customer> getCustomers() {
        HashSet<Customer> customers = new HashSet<Customer>();
        ListModel<Customer> listModel = this.listCustomers.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            customers.add(listModel.getElementAt(i));
        }
        return customers;
    }
}

