/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.action.PurchaseOrderExplorerAction;
import com.orostock.inventory.ui.PurchaseOrderForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JasperPrint;
import org.jdesktop.swingx.JXTable;

public class ShoppingListExplorer
extends TransparentPanel {
    private JXTable table;
    private BeanTableModel<MenuItem> tableModel = new BeanTableModel(MenuItem.class);
    private JComboBox cbGroup;
    private JTextField tfName;
    private JLabel lblNumberOfItem;
    private JButton btnBack;
    private JButton btnForward;

    public ShoppingListExplorer() {
        this.tableModel.addColumn(POSConstants.SKU.toUpperCase(), "sku");
        this.tableModel.addColumn(InvMessages.getString("InventorySLE.0"), "displayName");
        this.tableModel.addColumn(InvMessages.getString("InventorySLE.1") + " (" + CurrencyUtil.getCurrencySymbol() + ")", "cost");
        this.tableModel.addColumn(InvMessages.getString("InventorySLE.3"), "availableUnit");
        this.tableModel.addColumn(InvMessages.getString("InventorySLE.5"), "unitOnHand");
        this.tableModel.addColumn(InvMessages.getString("ShoppingListExplorer.2"), MenuItem.PROP_UNIT_NAME);
        this.tableModel.addColumn(InvMessages.getString("InventorySLE.6"), "reorderLevel");
        this.tableModel.addColumn(InvMessages.getString("ShoppingListExplorer.4"), "replenishLevel");
        this.table = new PosTable(this.tableModel);
        this.setLayout(new BorderLayout(5, 5));
        this.btnBack = new JButton(InvMessages.getString("IVIE.30"));
        this.btnForward = new JButton(InvMessages.getString("IVIE.31"));
        this.lblNumberOfItem = new JLabel();
        this.add((Component)this.buildSearchForm(), "North");
        this.add(new JScrollPane((Component)this.table));
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("center"));
        PosButton createPurchaseOrder = new PosButton(InvMessages.getString("IVSLE.0"));
        this.add((Component)buttonPanel, "South");
        buttonPanel.add(createPurchaseOrder);
        createPurchaseOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShoppingListExplorer.this.doCreatePurchaseOrder();
            }
        });
        this.showMenuItems();
    }

    private void doCreatePurchaseOrder() {
        try {
            ArrayList<MenuItem> inventoryList = new ArrayList<MenuItem>();
            int[] selectedRows = this.table.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                selectedRows[i] = this.table.convertRowIndexToModel(selectedRows[i]);
            }
            PurchaseOrder newPurchaseOrder = new PurchaseOrder();
            if (selectedRows.length == 0) {
                if (this.tableModel.getRowCount() > 0) {
                    inventoryList.addAll(this.tableModel.getRows());
                }
            } else {
                for (int i = 0; i < selectedRows.length; ++i) {
                    MenuItem item = this.tableModel.getRow(selectedRows[i]);
                    inventoryList.add(item);
                }
                newPurchaseOrder.calculatePrice();
            }
            if (inventoryList.isEmpty()) {
                return;
            }
            for (MenuItem item : inventoryList) {
                PurchaseOrderItem orderItem = new PurchaseOrderItem();
                orderItem.setSku(item.getSku());
                orderItem.setMenuItemId(item.getId());
                orderItem.setName(item.getDisplayName());
                orderItem.setUnitPrice(item.getCost());
                MenuGroup parent = item.getParent();
                if (parent != null) {
                    orderItem.setGroupName(parent.getName());
                    orderItem.setCategoryName(parent.getParent().getName());
                }
                orderItem.setItemQuantity(item.getReplenishLevel() == 0.0 ? 1.0 : item.getReplenishLevel());
                InventoryUnit unit = item.getUnit();
                if (unit != null) {
                    orderItem.setItemUnitName(unit.getCode());
                }
                orderItem.calculatePrice();
                orderItem.setPurchaseOrder(newPurchaseOrder);
                newPurchaseOrder.addToorderItems(orderItem);
            }
            newPurchaseOrder.calculatePrice();
            PurchaseOrderForm editor = new PurchaseOrderForm(newPurchaseOrder);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.openWithScale(1024, 630);
            if (dialog.isCanceled()) {
                return;
            }
            PurchaseOrder purchaseOrder = (PurchaseOrder)editor.getBean();
            if (POSMessageDialog.showMessageAndPromtToPrint(POSUtil.getBackOfficeWindow(), InvMessages.getString("ShoppingListExplorer.7") + purchaseOrder.getOrderId() + InvMessages.getString("ShoppingListExplorer.8"))) {
                JasperPrint jasperPrint = ReceiptPrintService.createPurchaseOrderPrint(purchaseOrder);
                jasperPrint.setName("PURCHASE_ORDER_" + purchaseOrder.getOrderId());
                jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
                ReceiptPrintService.printQuitely(jasperPrint);
            }
            this.tableModel.setCurrentRowIndex(0);
            this.showMenuItems();
            new PurchaseOrderExplorerAction().actionPerformed(null);
        }
        catch (Exception ex) {
            BOMessageDialog.showError(ex);
        }
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "[][]15[][]15[][]15[]", "[]5[]"));
        JLabel lblName = new JLabel(InvMessages.getString("IVITB.0"));
        JLabel lblGroup = new JLabel(InvMessages.getString("IVUB.2"));
        this.cbGroup = new JComboBox();
        this.cbGroup.addItem(InvMessages.getString("IVCRV.21"));
        List<MenuGroup> groups = MenuGroupDAO.getInstance().findAll();
        for (MenuGroup group : groups) {
            this.cbGroup.addItem(group);
        }
        this.tfName = new JTextField(15);
        try {
            JButton searchBttn = new JButton(InvMessages.getString("IVIS.22"));
            panel.add((Component)lblName, "align label");
            panel.add(this.tfName);
            panel.add(lblGroup);
            panel.add(this.cbGroup);
            panel.add(searchBttn);
            Border loweredetched = BorderFactory.createEtchedBorder(1);
            TitledBorder title = BorderFactory.createTitledBorder(loweredetched, InvMessages.getString("IVIS.22"));
            title.setTitleJustification(1);
            panel.setBorder(title);
            searchBttn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ShoppingListExplorer.this.showMenuItems();
                }
            });
            this.tfName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ShoppingListExplorer.this.showMenuItems();
                }
            });
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
        return panel;
    }

    private void showMenuItems() {
        String txName = this.tfName.getText();
        MenuGroup group = null;
        Object selectedGroup = this.cbGroup.getSelectedItem();
        if (selectedGroup instanceof MenuGroup) {
            group = (MenuGroup)selectedGroup;
        }
        this.tableModel.setNumRows(MenuItemDAO.getInstance().rowReOrderedItemCount(group, txName, false, false));
        MenuItemDAO.getInstance().loadReorderedMenuItems(this.tableModel, group, txName, false, false);
        int startNumber = this.tableModel.getCurrentRowIndex() + 1;
        int endNumber = this.tableModel.getNextRowIndex();
        int totalNumber = this.tableModel.getNumRows();
        if (endNumber > totalNumber) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format(InvMessages.getString("ShoppingListExplorer.10"), startNumber, endNumber, totalNumber));
        this.btnBack.setEnabled(this.tableModel.hasPrevious());
        this.btnForward.setEnabled(this.tableModel.hasNext());
    }
}

