/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui.recepie;

import com.floreantpos.IconFactory;
import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class InventoryItemSelector
extends BeanEditorDialog {
    private JLabel lblPercentage = new JLabel(InvMessages.getString("IVIS.0"));
    private BeanTableModel<MenuItem> tableModel;
    private JXTable table;
    DoubleTextField tfPercentage = new DoubleTextField(5);
    MenuItem selectedItem;
    double percentage;
    JCheckBox cbInventoryDeductable = new JCheckBox(InvMessages.getString("IVIS.1"));
    boolean inventoryDeductable = true;
    boolean dataLoaded;
    private JLabel lblName;
    private JTextField tfName;
    private JButton searchBttn;
    private JPanel searchPanel;
    private JLabel lblNumberOfItem = new JLabel();
    private Component btnPrev;
    private Component btnNext;

    public InventoryItemSelector() {
        this.setBeanEditor(new InventoryItemSelectorView());
    }

    public MenuItem getSelectedItem() {
        return this.selectedItem;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public boolean isInventoryDeductable() {
        return this.inventoryDeductable;
    }

    public void loadData() {
        if (this.dataLoaded) {
            return;
        }
        this.tableModel.setNumRows(MenuItemDAO.getInstance().getRowCount(this.tfName.getText()));
        MenuItemDAO.getInstance().loadInventoryItems(this.tfName.getText(), this.tableModel);
        this.updateButton();
        this.dataLoaded = true;
    }

    @Override
    public void dispose() {
        BeanEditor editor = this.getBeanEditor();
        super.dispose();
        this.setBeanEditor(editor);
    }

    private void scrollDown() {
        this.tableModel.setCurrentRowIndex(this.tableModel.getNextRowIndex());
        this.searchItem();
    }

    private void scrollUp() {
        this.tableModel.setCurrentRowIndex(this.tableModel.getPreviousRowIndex());
        this.searchItem();
    }

    public JPanel buildSearchForm() {
        this.searchPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][grow]"));
        this.lblName = new JLabel(POSConstants.NAME);
        this.tfName = new JTextField();
        this.searchBttn = new JButton(POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        this.searchPanel.add(this.lblName);
        this.searchPanel.add((Component)this.tfName, "grow");
        JButton btnSearch = new JButton(InvMessages.getString("IVIS.22"));
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryItemSelector.this.tableModel.setCurrentRowIndex(0);
                InventoryItemSelector.this.searchItem();
            }
        });
        this.searchPanel.add((Component)btnSearch, "wrap");
        this.searchBttn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryItemSelector.this.tableModel.setCurrentRowIndex(0);
                InventoryItemSelector.this.searchItem();
            }
        });
        this.tfName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryItemSelector.this.tableModel.setCurrentRowIndex(0);
                InventoryItemSelector.this.searchItem();
            }
        });
        return this.searchPanel;
    }

    public void searchItem() {
        this.tableModel.setNumRows(MenuItemDAO.getInstance().getRowCount(this.tfName.getText()));
        MenuItemDAO.getInstance().loadInventoryItems(this.tfName.getText(), this.tableModel);
        this.updateButton();
        this.table.repaint();
    }

    private void updateButton() {
        int totalNumber;
        int startNumber = this.tableModel.getCurrentRowIndex() + 1;
        int endNumber = this.tableModel.getNextRowIndex();
        if (endNumber > (totalNumber = this.tableModel.getNumRows())) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format("Showing %s to %s of %s", startNumber, endNumber, totalNumber));
        this.btnPrev.setEnabled(this.tableModel.hasPrevious());
        this.btnNext.setEnabled(this.tableModel.hasNext());
        if (this.tableModel.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    public void setPercentage(double percentage) {
        this.tfPercentage.setText(String.valueOf(percentage));
    }

    public void setInventoryDeductable(boolean inventoryDeductable) {
        this.cbInventoryDeductable.isSelected();
    }

    class InventoryItemSelectorView
    extends BeanEditor<MenuItem> {
        public InventoryItemSelectorView() {
            this.setLayout(new BorderLayout(5, 5));
            InventoryItemSelector.this.tableModel = new BeanTableModel(MenuItem.class);
            InventoryItemSelector.this.tableModel.addColumn(InvMessages.getString("IVIS.2"), "name");
            InventoryItemSelector.this.tableModel.addColumn(InvMessages.getString("IVIS.4"), "cost", 11, BeanTableModel.DataType.MONEY);
            InventoryItemSelector.this.tableModel.setPageSize(10);
            InventoryItemSelector.this.table = new JXTable((TableModel)InventoryItemSelector.this.tableModel);
            InventoryItemSelector.this.table.setRowHeight(PosUIManager.getSize(40));
            JPanel contentPanel = new JPanel(new BorderLayout());
            contentPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
            JScrollPane scroll = new JScrollPane((Component)InventoryItemSelector.this.table);
            scroll.setPreferredSize(PosUIManager.getSize(500, 250));
            contentPanel.add(scroll);
            contentPanel.add((Component)InventoryItemSelector.this.buildSearchForm(), "North");
            this.add(contentPanel);
            JPanel paginationButtonPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][grow][]"));
            InventoryItemSelector.this.btnPrev = new PosButton();
            ((AbstractButton)InventoryItemSelector.this.btnPrev).setIcon(IconFactory.getIcon("/ui_icons/", "previous.png"));
            PosButton btnDot = new PosButton();
            btnDot.setBorder(null);
            btnDot.setOpaque(false);
            btnDot.setContentAreaFilled(false);
            btnDot.setIcon(IconFactory.getIcon("/ui_icons/", "dot.png"));
            InventoryItemSelector.this.btnNext = new PosButton();
            ((AbstractButton)InventoryItemSelector.this.btnNext).setIcon(IconFactory.getIcon("/ui_icons/", "next.png"));
            paginationButtonPanel.add((Component)InventoryItemSelector.this.lblNumberOfItem, "right");
            paginationButtonPanel.add(InventoryItemSelector.this.btnPrev, "right,split 2");
            paginationButtonPanel.add(InventoryItemSelector.this.btnNext, "");
            contentPanel.add((Component)paginationButtonPanel, "South");
            ActionListener action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Object source = e.getSource();
                        if (source == InventoryItemSelector.this.btnPrev) {
                            InventoryItemSelector.this.scrollUp();
                        } else if (source == InventoryItemSelector.this.btnNext) {
                            InventoryItemSelector.this.scrollDown();
                        }
                    }
                    catch (Exception e2) {
                        POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e2.getMessage(), e2);
                    }
                }
            };
            ((AbstractButton)InventoryItemSelector.this.btnPrev).addActionListener(action);
            ((AbstractButton)InventoryItemSelector.this.btnNext).addActionListener(action);
            InventoryItemSelector.this.btnNext.setEnabled(false);
            InventoryItemSelector.this.btnPrev.setEnabled(false);
            JPanel panel = new JPanel((LayoutManager)new MigLayout());
            panel.add((Component)contentPanel, "wrap,grow");
            panel.add((Component)InventoryItemSelector.this.lblPercentage, "gap left 8,split 3");
            panel.add((Component)InventoryItemSelector.this.tfPercentage, "grow");
            panel.add(InventoryItemSelector.this.cbInventoryDeductable);
            this.add(panel);
            InventoryItemSelector.this.tfPercentage.setText("100");
            InventoryItemSelector.this.cbInventoryDeductable.setSelected(true);
        }

        @Override
        public boolean save() {
            int index = InventoryItemSelector.this.table.getSelectedRow();
            InventoryItemSelector.this.selectedItem = (MenuItem)InventoryItemSelector.this.tableModel.getRow(index);
            InventoryItemSelector.this.percentage = (float)InventoryItemSelector.this.tfPercentage.getDouble();
            InventoryItemSelector.this.inventoryDeductable = InventoryItemSelector.this.cbInventoryDeductable.isSelected();
            return true;
        }

        @Override
        protected void updateView() {
        }

        @Override
        protected boolean updateModel() throws IllegalModelStateException {
            return true;
        }

        @Override
        public String getDisplayText() {
            return InvMessages.getString("IVIS.18");
        }
    }
}

