/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui.recepie;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.RecepieItem;
import com.floreantpos.model.RecipeTable;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.dao.RecipeTableDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.jidesoft.swing.TitledSeparator;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.ui.recepie.RecipeEntryForm;
import com.orostock.inventory.ui.recepie.RecipeItemTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class RecipeTableEntryForm
extends BeanEditor<RecipeTable> {
    private JComboBox cbRecipe = new JComboBox();
    private FixedLengthTextField tfMenuItemName = new FixedLengthTextField();
    private MenuItem selectedMenuItem;
    private RecipeItemTable table;
    private DoubleTextField tfTotalCost = new DoubleTextField(8);
    private DoubleTextField tfPortion = new DoubleTextField(8);
    private JLabel lblPortionUnit = new JLabel();

    public RecipeTableEntryForm(RecipeTable recepie) {
        this.initComponents();
        ArrayList<Recepie> recipeList = new ArrayList<Recepie>();
        recipeList.add(null);
        recipeList.addAll(RecepieDAO.getInstance().findAll());
        this.cbRecipe.setModel(new ComboBoxModel(recipeList));
        this.setBean(recepie);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JLabel lblRecipeTableName = new JLabel(InvMessages.getString("IVRTEF.0"));
        this.tfMenuItemName.setLength(128);
        this.tfMenuItemName.setEditable(false);
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout("fillx,wrap 3", "[][grow][sg,fill]", ""));
        topPanel.add((Component)lblRecipeTableName, "");
        topPanel.add((Component)this.tfMenuItemName, "growx");
        JButton btnAddMenuItem = new JButton(InvMessages.getString("IVRTEF.6"));
        btnAddMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemSelectionDialog dialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>());
                dialog.setSelectionMode(0);
                dialog.setSize(PosUIManager.getSize(600, 515));
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                RecipeTableEntryForm.this.selectedMenuItem = dialog.getSelectedRowData();
                RecipeTableEntryForm.this.tfMenuItemName.setText(RecipeTableEntryForm.this.selectedMenuItem.getName());
            }
        });
        topPanel.add((Component)btnAddMenuItem, "");
        topPanel.add((Component)new JLabel(InvMessages.getString("IVRTEF.8")), "");
        topPanel.add((Component)this.cbRecipe, "growx");
        this.cbRecipe.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Recepie recipe = (Recepie)RecipeTableEntryForm.this.cbRecipe.getSelectedItem();
                if (recipe == null) {
                    RecipeTableEntryForm.this.table.setItems(null);
                    return;
                }
                RecipeTableEntryForm.this.table.setItems(recipe.getRecepieItems());
                RecipeTableEntryForm.this.updateTotalCost();
            }
        });
        JButton btnAddRecipe = new JButton(InvMessages.getString("IVRTEF.11"));
        btnAddRecipe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RecipeEntryForm editor = new RecipeEntryForm(new Recepie());
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.openWithScale(700, 650);
                    if (dialog.isCanceled()) {
                        return;
                    }
                    Recepie recipe = (Recepie)editor.getBean();
                    ComboBoxModel model = (ComboBoxModel)RecipeTableEntryForm.this.cbRecipe.getModel();
                    model.addElement(recipe);
                    RecipeTableEntryForm.this.cbRecipe.setSelectedItem(recipe);
                    RecipeTableEntryForm.this.updateTotalCost();
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        topPanel.add((Component)btnAddRecipe, "");
        topPanel.add((Component)new JLabel(InvMessages.getString("IVRTEF.13")), "");
        topPanel.add((Component)this.tfPortion, "grow,split 2");
        topPanel.add(this.lblPortionUnit);
        this.add((Component)topPanel, "North");
        this.table = new RecipeItemTable(new ArrayList<RecepieItem>());
        this.table.setEnabled(false);
        JLabel lblRecipeItems = new JLabel(InvMessages.getString("IVRTEF.16"));
        Color fg = new Color(49, 106, 196);
        lblRecipeItems.setForeground(fg);
        JLabel lblSubRecipe = new JLabel(InvMessages.getString("IVRTEF.17"));
        lblSubRecipe.setForeground(fg);
        TitledSeparator sep1 = new TitledSeparator((JComponent)lblRecipeItems, 0);
        JPanel tablePanel = new JPanel((LayoutManager)new MigLayout("fill,wrap 1"));
        tablePanel.add((Component)sep1, "span,grow");
        tablePanel.add((Component)new JScrollPane(this.table), "span,grow");
        tablePanel.add((Component)new JLabel(InvMessages.getString("IVRTEF.21")), "right,split 2");
        tablePanel.add(this.tfTotalCost);
        this.tfTotalCost.setEditable(false);
        this.tfTotalCost.setHorizontalAlignment(4);
        this.add(tablePanel);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            RecipeTable bean = (RecipeTable)this.getBean();
            RecipeTableDAO.getInstance().saveOrUpdate(bean);
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage());
        }
        return true;
    }

    @Override
    protected void updateView() {
        RecipeTable bean = (RecipeTable)this.getBean();
        this.selectedMenuItem = bean.getMenuItem();
        if (this.selectedMenuItem != null) {
            this.tfMenuItemName.setText(this.selectedMenuItem.getName());
        }
        this.tfPortion.setText(String.valueOf(bean.getPortion() == 0.0 ? 1.0 : bean.getPortion()));
        this.updateTotalCost();
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        RecipeTable bean = (RecipeTable)this.getBean();
        String name = this.tfMenuItemName.getText();
        if (StringUtils.isEmpty((String)name)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVRTEF.23"));
            return false;
        }
        bean.setMenuItem(this.selectedMenuItem);
        double portion = this.tfPortion.getDoubleOrZero();
        bean.setPortion(portion <= 0.0 ? 1.0 : portion);
        return true;
    }

    @Override
    public String getDisplayText() {
        return ((RecipeTable)this.getBean()).getId() == null ? InvMessages.getString("IVRTEF.24") : InvMessages.getString("IVRTEF.25");
    }

    private void updateTotalCost() {
        double totalRecipeItemCost = 0.0;
        Collection<? extends RecepieItem> rows = this.table.getRows();
        if (rows != null) {
            for (RecepieItem recepieItem : rows) {
                MenuItemDAO.getInstance().initialize(recepieItem.getInventoryItem());
                recepieItem.calculatePercentage();
                totalRecipeItemCost += recepieItem.getCost();
            }
        }
        this.tfTotalCost.setText(NumberUtil.formatNumber(totalRecipeItemCost));
    }
}

