/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui.recepie.template;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Recepie;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.TransparentPanel;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.ui.recepie.RecipeSelectionDialog;
import com.orostock.inventory.ui.recepie.template.RecipePreparationTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

class RecipePreparationExplorer
extends TransparentPanel {
    private RecipePreparationTable table;
    private BeanTableModel<Recepie> tableModel;
    private JPanel buttonPanel;

    public RecipePreparationExplorer() {
        this.setLayout(new BorderLayout());
        this.table = new RecipePreparationTable();
        this.tableModel = this.table.getTableModel();
        this.add(new JScrollPane((Component)((Object)this.table)));
        this.buttonPanel = this.addButtonPanel();
        this.add((Component)this.buttonPanel, "South");
    }

    private JPanel addButtonPanel() {
        JButton btnSelectMenuItem = new JButton(InvMessages.getString("IVRPE.0"));
        btnSelectMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipePreparationExplorer.this.doAddRecipes();
            }
        });
        JButton deleteButton = new JButton(POSConstants.REMOVE);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = RecipePreparationExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        return;
                    }
                    index = RecipePreparationExplorer.this.table.convertRowIndexToModel(index);
                    RecipePreparationExplorer.this.tableModel.removeRow(index);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JButton btnClearItems = new JButton(POSConstants.CLEAR);
        btnClearItems.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RecipePreparationExplorer.this.tableModel.removeAll();
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.setLayout((LayoutManager)new MigLayout("left"));
        panel.add(btnSelectMenuItem);
        panel.add(deleteButton);
        panel.add(btnClearItems);
        return panel;
    }

    private void doAddRecipes() {
        try {
            RecipeSelectionDialog dialog = new RecipeSelectionDialog(new ArrayList<Recepie>());
            dialog.setSize(650, 550);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            List<Recepie> recepies = dialog.getSelectedItems();
            this.tableModel.addRows(recepies);
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public List<Recepie> getRows() {
        return this.tableModel.getRows();
    }

    public Container getButtonPanel() {
        return this.buttonPanel;
    }
}

