package com.orocube.licensemanager.core;

import java.util.Calendar;
import java.util.Date;

import javax.json.Json;
import javax.json.JsonObject;

import net.nicholaswilliams.java.licensing.License;
import net.nicholaswilliams.java.licensing.licensor.LicenseCreator;
import net.nicholaswilliams.java.licensing.licensor.LicenseCreatorProperties;

import com.orocube.licensemanager.DurationType;
import com.orocube.licensemanager.OroPasswordProvider;


public class LicenseGenerator {
	public static byte[] generate(String holderName, String holderEmail, String terminalKey, 
			String productName, String productVersion, DurationType durationType, int duration){
		LicenseCreatorProperties.setPrivateKeyDataProvider(new OroPrivateKeyDataProvider());
		LicenseCreatorProperties.setPrivateKeyPasswordProvider(new OroPasswordProvider());
		
		JsonObject holder = Json.createObjectBuilder()
				.add("name", holderName)
				.add("email", holderEmail)
				.build();
		JsonObject product = Json.createObjectBuilder()
				.add("name", productName)
				.add("version", productVersion)
				.build();

		LicenseCreator licenseCreator = LicenseCreator.getInstance();
		License license = new License.Builder()
			.withHolder(holder.toString())
			.withSubject(product.toString())
			.withProductKey(terminalKey)
			.withIssueDate(new Date().getTime())
			.withGoodBeforeDate(getExpiryTime(durationType, duration))
			.withIssuer("OROCUBE LLC")
			.withNumberOfLicenses(1)
			.build();

		byte[] licenseData = licenseCreator.signAndSerializeLicense(license);
		return licenseData;
	}
	
	private static long getExpiryTime(DurationType durationType, int duration) {
		Calendar c = Calendar.getInstance();
		switch(durationType) {
		case DAY:
			c.add(Calendar.DATE, duration);
			break;
			
		case MONTH:
			c.add(Calendar.MONTH, duration);
			break;
			
		case YEAR:
			c.add(Calendar.YEAR, duration);
			break;
		}
		
		return c.getTime().getTime();
	}
}
