/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.licensemanager.ui;

import com.orocube.licensemanager.OroLicense;
import com.orocube.licensemanager.ui.LicenseSelectionListener;
import com.orocube.licensemanager.ui.PluginFileChooser;
import com.orocube.licensemanager.ui.PluginMessageDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import net.miginfocom.swing.MigLayout;

public class PluginAboutDialog
extends JDialog {
    private Component parent;
    private OroLicense currentLicense;
    LicenseSelectionListener listener;

    public PluginAboutDialog(LicenseSelectionListener listener, OroLicense license, Component parent) throws HeadlessException {
        super((JFrame)parent);
        this.setSize(500, 400);
        this.listener = listener;
        this.currentLicense = license;
        this.parent = parent;
        JFrame parentC = (JFrame)parent;
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.setTitle("About");
        Image applicationImage = parentC.getIconImage();
        this.setIconImage(applicationImage);
        JPanel container = new JPanel(new BorderLayout());
        container.setBorder(new EmptyBorder(20, 20, 20, 20));
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("fillx,center,inset 20", "[][]", ""));
        contentPanel.setBorder(new LineBorder(Color.gray));
        contentPanel.setBackground(Color.white);
        JLabel l = new JLabel("License Information");
        l.setFont(new Font(l.getFont().getName(), 1, 24));
        l.setOpaque(true);
        JLabel iconLabel = new JLabel(new ImageIcon(applicationImage), 0);
        iconLabel.setBackground(Color.WHITE);
        iconLabel.setOpaque(true);
        topPanel.add((Component)iconLabel, "split 2");
        topPanel.add((Component)l, "h 40!,grow,center,wrap");
        topPanel.add((Component)new JSeparator(), "grow,span");
        container.add((Component)topPanel, "North");
        JLabel lblPluginName = new JLabel("Plugin Name");
        JLabel txtPluginName = new JLabel(license.getProductName());
        contentPanel.add(lblPluginName);
        contentPanel.add((Component)txtPluginName, "wrap");
        JLabel lblVersion = new JLabel("Version ");
        JLabel txtVersion = new JLabel(license.getProductVersion());
        contentPanel.add(lblVersion);
        contentPanel.add((Component)txtVersion, "wrap");
        JLabel lblIssuerName = new JLabel("Issuer Name");
        JLabel txtIssuerName = new JLabel(license.getIssuer());
        contentPanel.add(lblIssuerName);
        contentPanel.add((Component)txtIssuerName, "wrap");
        JLabel lblHolderName = new JLabel("Holder Name");
        JLabel txtHolderName = new JLabel(license.getHolderName());
        contentPanel.add(lblHolderName);
        contentPanel.add((Component)txtHolderName, "wrap");
        JLabel lblHolderEmail = new JLabel("Holder Email");
        JLabel txtHolderEmail = new JLabel(license.getHolderEmail());
        txtHolderEmail.setForeground(Color.blue);
        contentPanel.add(lblHolderEmail);
        contentPanel.add((Component)txtHolderEmail, "wrap");
        JLabel lblIssueDate = new JLabel("Issue Date");
        JLabel txtIssueDate = new JLabel(new SimpleDateFormat("dd MMM yyyy hh:mm a").format(license.getIssueDate()));
        contentPanel.add(lblIssueDate);
        contentPanel.add((Component)txtIssueDate, "wrap");
        JLabel lblExpiryDate = new JLabel("Expiry Date");
        long MILLIS_PER_DAY = 86400000L;
        long msDiff = license.getExpiryDate().getTime() - new Date().getTime();
        long daysDiff = Math.round((double)msDiff / (double)MILLIS_PER_DAY);
        JLabel txtExpiryDate = new JLabel(new SimpleDateFormat("dd MMM yyyy hh:mm a").format(license.getExpiryDate()) + " (" + daysDiff + (Math.abs(daysDiff) > 1L ? " days)" : " day)"));
        contentPanel.add(lblExpiryDate);
        contentPanel.add((Component)txtExpiryDate, "wrap");
        container.add(contentPanel);
        JButton btnOk = new JButton("Cancel");
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginAboutDialog.this.dispose();
            }
        });
        JButton btnUpgrade = new JButton("Update");
        btnUpgrade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginAboutDialog.this.doUpdateLicense();
            }
        });
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("center"));
        buttonPanel.add((Component)btnUpgrade, "h 40!,w 100!");
        buttonPanel.add((Component)btnOk, "h 40!,w 100!");
        container.add((Component)buttonPanel, "South");
        this.setContentPane(container);
    }

    private void doUpdateLicense() {
        File pluginFile = PluginFileChooser.selectPluginFile(this.parent);
        if (pluginFile == null) {
            return;
        }
        try {
            this.listener.licenseFileSelected(pluginFile);
            PluginMessageDialog.show(this.parent, this.listener, null, "Plugin Install", false);
        }
        catch (Exception e1) {
            PluginMessageDialog.show(this.parent, this.listener, e1.getMessage(), "Plugin Install", true);
        }
    }

    @Override
    public void setVisible(boolean b) {
        this.setLocationRelativeTo((JFrame)this.parent);
        super.setVisible(b);
    }
}

