/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.licensemanager;

import com.orocube.licensemanager.InvalidLicenseException;
import com.orocube.licensemanager.LicenseMode;
import com.orocube.licensemanager.LicenseNotFoundException;
import com.orocube.licensemanager.OroLicense;
import com.orocube.licensemanager.OroLicenseProvider;
import com.orocube.licensemanager.OroPasswordProvider;
import com.orocube.licensemanager.OroPublicKeyDataProvider;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import net.nicholaswilliams.java.licensing.License;
import net.nicholaswilliams.java.licensing.LicenseManager;
import net.nicholaswilliams.java.licensing.LicenseManagerProperties;
import net.nicholaswilliams.java.licensing.LicenseProvider;
import net.nicholaswilliams.java.licensing.encryption.PasswordProvider;
import net.nicholaswilliams.java.licensing.encryption.PublicKeyDataProvider;
import net.nicholaswilliams.java.licensing.immutable.ImmutableLinkedHashSet;
import org.apache.commons.io.FileUtils;

public class LicenseUtil {
    private static final File licenseDir = new File(System.getProperty("user.home") + "/.orocube");

    private static File getLicenseFromCurrentDiectory(String productName) {
        File licenseDir = new File(".");
        File licenseFile = new File(licenseDir, productName + ".lic");
        if (licenseFile.exists()) {
            return licenseFile;
        }
        return null;
    }

    private static File getLicenseFromHomeDiectory(String productName) {
        File licenseFile = new File(licenseDir, productName + ".lic");
        if (licenseFile.exists()) {
            return licenseFile;
        }
        return null;
    }

    public static OroLicense loadAndValidate(String productName, String productVersion, String terminalKey) throws InvalidLicenseException, Exception {
        File licenseFile = LicenseUtil.getLicenseFromCurrentDiectory(productName);
        if (licenseFile == null) {
            licenseFile = LicenseUtil.getLicenseFromHomeDiectory(productName);
        }
        if (licenseFile == null || !licenseFile.exists()) {
            throw new InvalidLicenseException(String.format("License for %s not found.", productName));
        }
        OroLicense oroLicense = LicenseUtil.loadLicense(licenseFile);
        LicenseUtil.validateLicense(oroLicense, productName, productVersion, terminalKey);
        return oroLicense;
    }

    public static OroLicense loadAndValidate(File licenseFile, String productName, String productVersion, String terminalKey) throws InvalidLicenseException, LicenseNotFoundException, Exception {
        OroLicense oroLicense = LicenseUtil.loadLicense(licenseFile);
        LicenseUtil.validateLicense(oroLicense, productName, productVersion, terminalKey);
        return oroLicense;
    }

    public static void validateLicense(OroLicense license, String productName, String productVersion, String terminalKey) throws InvalidLicenseException {
        license.setValid(false);
        if (license.getLicenseMode() == LicenseMode.TERMINAL_BASED && !license.isValidForTerminal(terminalKey)) {
            throw new InvalidLicenseException("License is not valid for this terminal.\nLicense is registered for terminal with key: " + license.getTerminalKey() + "\n" + "Where this terminal key is: " + terminalKey);
        }
        if (!license.isValidForProduct(productName, productVersion)) {
            throw new InvalidLicenseException("Invalid license.\nFound license is valid for version " + license.getProductVersion() + " of " + license.getProductName() + ".\nLicense is needed for version " + productVersion + " of " + productName);
        }
        Date currentDate = new Date();
        if (currentDate.after(license.getExpiryDate())) {
            throw new InvalidLicenseException("License expired on " + SimpleDateFormat.getDateInstance().format(license.getExpiryDate()));
        }
        license.setValid(true);
    }

    public static void copyLicenseFile(String productName, File fromFile) throws IOException {
        LicenseUtil.copyLicenseFile(fromFile, productName);
    }

    public static void copyLicenseFile(File fromFile, String toFileName) throws IOException {
        File licenseFromCurrentDiectory = LicenseUtil.getLicenseFromCurrentDiectory(toFileName);
        if (licenseFromCurrentDiectory != null) {
            licenseFromCurrentDiectory.delete();
        }
        File licenseFile = new File(licenseDir, toFileName + ".lic");
        FileUtils.copyFile((File)fromFile, (File)licenseFile);
    }

    public static OroLicense loadLicense(File licenseFile) throws Exception {
        OroLicense oroLicense = new OroLicense();
        if (!licenseFile.exists()) {
            return oroLicense;
        }
        LicenseManagerProperties.setPublicKeyDataProvider((PublicKeyDataProvider)new OroPublicKeyDataProvider());
        LicenseManagerProperties.setPublicKeyPasswordProvider((PasswordProvider)new OroPasswordProvider());
        OroLicenseProvider oroLicenseProvider = new OroLicenseProvider(licenseFile);
        LicenseManagerProperties.setLicenseProvider((LicenseProvider)oroLicenseProvider);
        LicenseManager licenseManager = LicenseManager.getInstance();
        License license = licenseManager.decryptAndVerifyLicense(oroLicenseProvider.getLicense(""));
        JsonReader holderReader = Json.createReader((Reader)new StringReader(license.getHolder()));
        JsonObject holder = holderReader.readObject();
        oroLicense.setHolderName(holder.getString("name"));
        oroLicense.setHolderEmail(holder.getString("email"));
        JsonReader productReader = Json.createReader((Reader)new StringReader(license.getSubject()));
        JsonObject product = productReader.readObject();
        oroLicense.setProductName(product.getString("name"));
        oroLicense.setProductVersion(product.getString("version"));
        oroLicense.setIssueDate(new Date(license.getIssueDate()));
        oroLicense.setExpiryDate(new Date(license.getGoodBeforeDate()));
        oroLicense.setIssuer(license.getIssuer());
        String productKey = license.getProductKey();
        oroLicense.setTerminalKey(productKey);
        ImmutableLinkedHashSet features = license.getFeatures();
        for (License.Feature feature : features) {
            String featureName = feature.getName();
            if (featureName == null || !featureName.startsWith("licenseMode:")) continue;
            String licenseModeString = featureName.split(":")[1].trim();
            LicenseMode licenseMode = LicenseMode.valueOf(licenseModeString);
            oroLicense.setLicenseMode(licenseMode);
            break;
        }
        return oroLicense;
    }
}

